/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.WhereClauseModel;
import com.ca.db2.editor.ui.model.WhereClauseUtils;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.QueryUtils;
import com.ca.db2.editor.ui.utils.WCLabelProvider;
import com.ca.db2.editor.ui.widgets.StyleModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WhereClauseGrid {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private TableViewer viewer;
    private List<WhereClauseModel> models = null;
    private String[] columnNames;
    private ColumnModel[] columnModels;
    private List<StyleModel> styleModels = new ArrayList<StyleModel>();
    private final String OPEN_BRACKET = "(";
    private final String CLOSE_BRACKET = ")";
    private TableViewerFocusCellManager focusCellManager;

    public WhereClauseGrid(Composite composite, ColumnModel[] columnModels, List<WhereClauseModel> whereClauseModels) {
        this.models = whereClauseModels;
        if (this.models == null) {
            this.models = new ArrayList<WhereClauseModel>();
        }
        this.viewer = new TableViewer(composite, 67584);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput(this.models);
        this.setColumnModels(columnModels);
        this.initializeMetaData();
        this.buildColumns(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WCLabelProvider(this));
        this.addNavigationStrategy();
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ViewerCell cell = WhereClauseGrid.this.viewer.getCell(new Point(e.x, e.y));
                WhereClauseGrid.this.addOrRemoveRow(cell);
            }
        });
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (WhereClauseGrid.this.isSpaceBar(e.character)) {
                    ViewerCell cell = WhereClauseGrid.this.focusCellManager.getFocusCell();
                    if (WhereClauseGrid.this.models.size() == 1) {
                        if (WhereClauseGrid.this.isExpressionComplete((WhereClauseModel)WhereClauseGrid.this.models.get(0))) {
                            WhereClauseGrid.this.addOrRemoveRow(cell);
                        }
                    } else {
                        WhereClauseGrid.this.addOrRemoveRow(cell);
                    }
                }
            }
        });
        if (whereClauseModels == null) {
            this.addNewModel();
        }
    }

    private boolean isSpaceBar(char ch) {
        return Character.isSpaceChar(ch);
    }

    private void addOrRemoveRow(ViewerCell cell) {
        if (cell != null && cell.getColumnIndex() == 6) {
            WhereClauseModel m = (WhereClauseModel)cell.getElement();
            if (this.isLastRow(m)) {
                if (this.isExpressionComplete(m)) {
                    this.addNewModel();
                }
            } else {
                this.removeModel((WhereClauseModel)cell.getElement());
                this.generateWhereClause();
            }
        }
    }

    private void initializeMetaData() {
        this.columnNames = new String[this.columnModels.length + 1];
        this.columnNames[0] = "<-- SELECT COLUMN -->";
        int i = 0;
        while (i < this.columnModels.length) {
            this.columnNames[i + 1] = this.columnModels[i].getName();
            ++i;
        }
    }

    private void buildColumns(TableViewer v) {
        TableViewerColumn column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText(DWBundle.START_BRACKET);
        column.setEditingSupport(this.getStartBracketEditingSupport(column));
        column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(DWBundle.COLUMN_NAME);
        column.setEditingSupport(this.getColumnNameEditingSupport(column));
        column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(100);
        column.getColumn().setText(DWBundle.OPERATOR);
        column.setEditingSupport(this.getOperatorEditingSupport(column));
        column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(DWBundle.VALUE);
        column.setEditingSupport(this.getValueEditingSupport(column));
        column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText(DWBundle.END_BRACKET);
        column.setEditingSupport(this.getEndBracketEditingSupport(column));
        column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText(DWBundle.CONJUNCTION);
        column.setEditingSupport(this.getConjuctionEditingSupport(column));
        column = new TableViewerColumn(v, 0);
        column.getColumn().setWidth(30);
    }

    public boolean isLastRow(WhereClauseModel model) {
        return model.getRowIndex() == this.getModels().size() - 1;
    }

    private EditingSupport getValueEditingSupport(TableViewerColumn column) {
        return new EditingSupport(column.getViewer()){

            protected void setValue(Object element, Object value) {
                WhereClauseModel model = (WhereClauseModel)element;
                model.setValue(value.toString());
                WhereClauseGrid.this.updateModelInViewer(model);
                WhereClauseGrid.this.generateWhereClause();
            }

            protected Object getValue(Object element) {
                WhereClauseModel model = (WhereClauseModel)element;
                return model.getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)WhereClauseGrid.this.viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                WhereClauseModel m = (WhereClauseModel)element;
                if (m.getColumnNameIndex() == 0) {
                    return false;
                }
                return !WhereClauseUtils.isNullOrIsNotNull(m.getOperator());
            }
        };
    }

    private EditingSupport getStartBracketEditingSupport(TableViewerColumn column) {
        return new EditingSupport(column.getViewer()){

            protected void setValue(Object element, Object value) {
                WhereClauseModel model = (WhereClauseModel)element;
                model.setStartBracketIndex((Integer)value);
                WhereClauseGrid.this.updateModelInViewer(model);
                WhereClauseGrid.this.generateWhereClause();
            }

            protected Object getValue(Object element) {
                WhereClauseModel model = (WhereClauseModel)element;
                return model.getStartBracketIndex();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)WhereClauseGrid.this.viewer.getTable(), new String[]{"", "("}){

                    protected Control createControl(Composite parent) {
                        CCombo combo = (CCombo)super.createControl(parent);
                        combo.setEditable(false);
                        return combo;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
    }

    private EditingSupport getEndBracketEditingSupport(TableViewerColumn column) {
        return new EditingSupport(column.getViewer()){

            protected void setValue(Object element, Object value) {
                WhereClauseModel model = (WhereClauseModel)element;
                model.setEndBracketIndex((Integer)value);
                WhereClauseGrid.this.updateModelInViewer(model);
                WhereClauseGrid.this.generateWhereClause();
            }

            protected Object getValue(Object element) {
                WhereClauseModel model = (WhereClauseModel)element;
                return model.getEndBracketIndex();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)WhereClauseGrid.this.viewer.getTable(), new String[]{"", ")"}){

                    protected Control createControl(Composite parent) {
                        CCombo combo = (CCombo)super.createControl(parent);
                        combo.setEditable(false);
                        return combo;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
    }

    private EditingSupport getColumnNameEditingSupport(TableViewerColumn column) {
        return new EditingSupport(column.getViewer()){
            private CCombo columnNamesCombo;

            protected void setValue(Object element, Object value) {
            }

            protected Object getValue(Object element) {
                return ((WhereClauseModel)element).getColumnNameIndex();
            }

            protected CellEditor getCellEditor(Object element) {
                final WhereClauseModel model = (WhereClauseModel)element;
                return new ComboBoxCellEditor((Composite)WhereClauseGrid.this.viewer.getTable(), WhereClauseGrid.this.columnNames){

                    protected Control createControl(Composite parent) {
                        columnNamesCombo = (CCombo)super.createControl(parent);
                        columnNamesCombo.select(0);
                        columnNamesCombo.setEditable(false);
                        columnNamesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                super.widgetSelected(e);
                                if (columnNamesCombo.getSelectionIndex() == 0) {
                                    model.setValue("");
                                }
                                WhereClauseGrid.this.onColumnNameChange(model, columnNamesCombo.getSelectionIndex());
                            }
                        });
                        return columnNamesCombo;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
    }

    private void onColumnNameChange(WhereClauseModel model, int selectedIndex) {
        model.setColumnNameIndex(selectedIndex);
        model.setOperatorIndex(0);
        model.setColumnName(this.columnNames[selectedIndex]);
        model.setColType(this.columnModels[selectedIndex == 0 ? 0 : selectedIndex - 1].getColType());
        this.updateModelInViewer(model);
        this.generateWhereClause();
    }

    private EditingSupport getOperatorEditingSupport(TableViewerColumn column) {
        return new EditingSupport(column.getViewer()){
            private CCombo operatorsCombo;

            protected void setValue(Object element, Object value) {
                WhereClauseModel model = (WhereClauseModel)element;
                model.setOperatorIndex((Integer)value);
                if (WhereClauseUtils.isLike(model.getOperator()) && model.getValue().trim().isEmpty()) {
                    model.setValue("%");
                } else if (model.getValue().trim().equals("%")) {
                    model.setValue("");
                }
                WhereClauseGrid.this.updateModelInViewer(model);
                WhereClauseGrid.this.generateWhereClause();
            }

            protected Object getValue(Object element) {
                return ((WhereClauseModel)element).getOperatorIndex();
            }

            protected CellEditor getCellEditor(Object element) {
                final WhereClauseModel m = (WhereClauseModel)element;
                final String[] operators = WhereClauseUtils.getOperators(m.getColType());
                return new ComboBoxCellEditor((Composite)WhereClauseGrid.this.viewer.getTable(), operators){

                    protected Control createControl(Composite parent) {
                        operatorsCombo = (CCombo)super.createControl(parent);
                        operatorsCombo.setEditable(false);
                        operatorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                super.widgetSelected(e);
                                String operator = operators[operatorsCombo.getSelectionIndex()];
                                if (WhereClauseUtils.isNullOrIsNotNull(operator)) {
                                    m.setValue("");
                                    WhereClauseGrid.this.updateModelInViewer(m);
                                }
                            }
                        });
                        return operatorsCombo;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                WhereClauseModel m = (WhereClauseModel)element;
                return m.getColumnNameIndex() != 0;
            }
        };
    }

    private EditingSupport getConjuctionEditingSupport(TableViewerColumn column) {
        return new EditingSupport(column.getViewer()){

            protected void setValue(Object element, Object value) {
                WhereClauseModel model = (WhereClauseModel)element;
                model.setConjuctionIndex((Integer)value);
                WhereClauseGrid.this.updateModelInViewer(model);
                WhereClauseGrid.this.generateWhereClause();
            }

            protected Object getValue(Object element) {
                return ((WhereClauseModel)element).getConjuctionIndex();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)WhereClauseGrid.this.viewer.getTable(), WhereClauseUtils.getConjunctions()){

                    public Control createControl(Composite parent) {
                        CCombo combo = (CCombo)super.createControl(parent);
                        combo.setEditable(false);
                        return combo;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                WhereClauseModel m = (WhereClauseModel)element;
                return WhereClauseGrid.this.isExpressionComplete(m);
            }
        };
    }

    public void addNewModel() {
        WhereClauseModel model = new WhereClauseModel(this.models.size(), this.columnNames[0], this.columnModels[0].getColType());
        this.models.add(model);
        this.resetIndicies();
        this.viewer.refresh();
        this.viewer.getTable().deselectAll();
    }

    private void removeModel(WhereClauseModel model) {
        this.models.remove(model);
        this.resetIndicies();
        this.viewer.refresh();
    }

    private void resetIndicies() {
        int i = 0;
        while (i < this.models.size()) {
            WhereClauseModel m = this.models.get(i);
            m.setRowIndex(i);
            if (this.models.get(i).getConjuctionIndex() == -1 && this.isExpressionComplete(m)) {
                this.models.get(i).setConjuctionIndex(0);
            }
            ++i;
        }
    }

    public String generateWhereClause() {
        StringBuffer sql = new StringBuffer();
        this.getStyleModels().clear();
        int i = 0;
        while (i < this.models.size()) {
            WhereClauseModel m = this.models.get(i);
            if (this.isExpressionComplete(m)) {
                if (i != 0) {
                    sql.append("\n");
                    this.getStyleModels().add(new StyleModel(sql.length(), this.models.get(i - 1).getConjuction().length(), true));
                    sql.append(this.models.get(i - 1).getConjuction());
                    sql.append(" ");
                }
                if (m.getStartBracketIndex() != -1) {
                    sql.append(m.getStartBracket());
                    sql.append(" ");
                }
                sql.append(QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(m.getColumnName())));
                sql.append(" ");
                this.getStyleModels().add(new StyleModel(sql.length(), m.getOperator().length(), true));
                sql.append(m.getOperator());
                sql.append(" ");
                String value = this.decorateValue(m);
                this.getStyleModels().add(new StyleModel(sql.length(), value.length(), false));
                sql.append(value);
                sql.append(" ");
                if (m.getEndBracketIndex() != -1) {
                    sql.append(m.getEndBracket());
                    sql.append(" ");
                }
            }
            ++i;
        }
        return sql.toString();
    }

    private void updateConjunctionIndex(WhereClauseModel m) {
        if (this.isExpressionComplete(m)) {
            if (m.getConjuctionIndex() == -1) {
                m.setConjuctionIndex(0);
            }
        } else {
            m.setConjuctionIndex(-1);
        }
    }

    public boolean isExpressionComplete(WhereClauseModel m) {
        if (m.getColumnNameIndex() != 0) {
            DataType dataType = DataType.value(m.getColType().trim());
            if (DataTypeUtils.isNumericDataType(dataType) || DataTypeUtils.isDateTimeDataType(dataType)) {
                if (WhereClauseUtils.isNullOrIsNotNull(m.getOperator())) {
                    return true;
                }
                return !m.getValue().trim().isEmpty();
            }
            return true;
        }
        return false;
    }

    private String decorateValue(WhereClauseModel m) {
        if (WhereClauseUtils.isNullOrIsNotNull(m.getOperator())) {
            return "";
        }
        if (DataTypeUtils.isNumericDataType(DataType.value(m.getColType().trim()))) {
            return WhereClauseUtils.isIN(m.getOperator()) || WhereClauseUtils.isNotIN(m.getOperator()) ? "(" + m.getValue() + ")" : m.getValue();
        }
        if (WhereClauseUtils.isIN(m.getOperator()) || WhereClauseUtils.isNotIN(m.getOperator())) {
            String s = m.getValue().replaceAll(",", "','");
            return "('" + s + "')";
        }
        return "'" + m.getValue() + "'";
    }

    public List<WhereClauseModel> getModels() {
        return (List)this.viewer.getInput();
    }

    private void addNavigationStrategy() {
        this.focusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && (event.keyCode == 0x100000B || WhereClauseGrid.this.isSpaceBar(event.character)) || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)this.focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    public void setColumnModels(ColumnModel[] columnModels) {
        this.columnModels = columnModels;
    }

    public ColumnModel[] getColumnModels() {
        return this.columnModels;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public List<StyleModel> getStyleModels() {
        return this.styleModels;
    }

    public void setStyleModels(List<StyleModel> styleModels) {
        this.styleModels = styleModels;
    }

    private void updateModelInViewer(WhereClauseModel m) {
        this.updateConjunctionIndex(m);
        this.viewer.update((Object)m, null);
    }

    public void dispose() {
        this.viewer.getTable().dispose();
        this.models = null;
        this.columnNames = null;
        this.columnModels = null;
        this.styleModels = null;
    }
}

