/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.i18n.LoginBundle;
import com.ca.db2.editor.ui.utils.LoginLogoutUtils;
import com.ca.db2.editor.ui.widgets.NumberField;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LoginDialog
extends TitleAreaDialog {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private PreferenceStore loginPrefStore = new PreferenceStore("fmdb2_login.pref");
    private PreferenceStore profilePrefStore = new PreferenceStore("fmdb2_profile.pref");
    private static final Logger logger = Logger.getLogger(LoginDialog.class);
    private Text textUserId;
    private Text textPassword;
    private Combo hostNamesCombo;
    private Text textPort;
    public static final String SpecialChars = "[`~!@#$%^&*()_+[\\]\\\\;',./{}|:\"<>?]-=";
    private final IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();

    public LoginDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(LoginBundle.DIALOG_TITLE);
    }

    public void create() {
        super.create();
        this.setTitle("Server Connection");
        this.setMessage(LoginBundle.CREDENTIAL_DETAILS, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createUI(container);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.bindLastLoginInfoToUI();
        control.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.db2.editor.login");
        return control;
    }

    private void createUI(Composite container) {
        Label userIdLabel = new Label(container, 0);
        userIdLabel.setText(LoginBundle.USER_NAME);
        this.textUserId = new Text(container, 2048);
        this.textUserId.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textUserId.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (LoginDialog.SpecialChars.indexOf(e.character) != -1) {
                    e.doit = false;
                    return;
                }
            }

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                LoginDialog.this.validateUI();
            }
        });
        Label passwordLabel = new Label(container, 0);
        passwordLabel.setText(LoginBundle.PASSWORD);
        this.textPassword = new Text(container, 0x400800);
        this.textPassword.setTextLimit(8);
        this.textPassword.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textPassword.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                LoginDialog.this.validateUI();
            }
        });
        Label hostNameLabel = new Label(container, 0);
        hostNameLabel.setText(LoginBundle.HOSTNAME);
        this.hostNamesCombo = new Combo(container, 2048);
        this.hostNamesCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hostNamesCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                LoginDialog.this.validateUI();
            }
        });
        Label portLabel = new Label(container, 0);
        portLabel.setText(LoginBundle.PORT);
        this.textPort = new NumberField(container, 2048).getWidget();
        this.textPort.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textPort.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                LoginDialog.this.validateUI();
            }
        });
        Link link = new Link(container, 0);
        link.setText(LoginBundle.LINK_DB2PREFERENCES);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LoginDialog.this.openDB2PreferencesPage();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, LoginBundle.BTN_LOGIN, true);
        Button resetBtn = this.createButton(parent, 99, LoginBundle.BTN_RESET, false);
        resetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LoginDialog.this.reset();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean authenticate() {
        String port;
        String hostname;
        String password;
        String userId;
        block4: {
            this.loadPreferenceValues();
            userId = this.textUserId.getText().trim();
            password = this.textPassword.getText().trim();
            hostname = this.hostNamesCombo.getText();
            port = this.textPort.getText().trim();
            if (this.validateValues(userId, password, hostname, port)) break block4;
            return false;
        }
        try {
            Context.getInstance().setUserId(userId);
            Context.getInstance().setPassword(password);
            Context.getInstance().setLpar(hostname);
            this.dataSourceHandler.login(userId, password, hostname, port);
        }
        catch (FMDB2Exception e) {
            this.setErrorMessage(e.getMessage());
            this.textUserId.setFocus();
            logger.error((Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
        return true;
    }

    private boolean validateValues(String userId, String password, String hostname, String port) {
        if (userId.isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_USER_ID);
            this.textUserId.setFocus();
            return false;
        }
        if (password.isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_PASSWORD);
            this.textPassword.setFocus();
            return false;
        }
        if (hostname.isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_HOSTNAME);
            this.hostNamesCombo.setFocus();
            return false;
        }
        if (port.isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_PORT);
            this.textPort.setFocus();
            return false;
        }
        return true;
    }

    private void validateUI() {
        if (this.textUserId.getText().trim().isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_USER_ID);
        } else if (this.textPassword.getText().trim().isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_PASSWORD);
        } else if (this.hostNamesCombo.getText().isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_HOSTNAME);
        } else if (this.textPort.getText().trim().isEmpty()) {
            this.setErrorMessage(LoginBundle.ERR_MSG_PORT);
        } else {
            this.setErrorMessage(null);
        }
    }

    public void reset() {
        this.textUserId.setText("");
        this.textPassword.setText("");
        this.hostNamesCombo.setText("");
        this.textPort.setText("");
        this.textUserId.setFocus();
    }

    protected void okPressed() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (LoginDialog.this.authenticate()) {
                    LoginDialog.this.saveLoginInfoToStore();
                    LoginLogoutUtils.onLogin();
                    LoginDialog.super.okPressed();
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    private void bindLastLoginInfoToUI() {
        try {
            this.loadPreferenceValues();
            this.loginPrefStore.load();
            this.hostNamesCombo.setText(this.loginPrefStore.getString("HOST_NAME_PREF_KEY"));
            this.textUserId.setText(this.loginPrefStore.getString("USER_ID_PREF_KEY"));
            this.textPort.setText(this.loginPrefStore.getString("PORT_NUM_PREF_KEY"));
            this.textPassword.setFocus();
        }
        catch (IOException iOException) {
            logger.debug((Object)"Logging for first time..");
        }
    }

    private boolean loadPreferenceValues() {
        try {
            this.profilePrefStore.load();
            Context.put(Context.Keys.OFA_AGENT, this.profilePrefStore.getString("OFA_AGENT_PREF_KEY"));
            Context.put(Context.Keys.XNET_AGENT, this.profilePrefStore.getString("XNET_AGENT_PREF_KEY"));
            if (this.textPort.getText().trim().isEmpty()) {
                String port = this.profilePrefStore.getString("PORT_NUM_PREF_KEY");
                this.textPort.setText(port);
            }
            String enteredHostName = this.hostNamesCombo.getText().trim();
            String hostNames = this.profilePrefStore.getString("HOST_NAMES_PREF_KEY");
            ArrayList<String> hostNameList = new ArrayList<String>();
            String[] stringArray = hostNames.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                hostNameList.add(s);
                ++n2;
            }
            if (!enteredHostName.isEmpty() && !hostNameList.contains(enteredHostName)) {
                hostNameList.add(enteredHostName);
            }
            this.hostNamesCombo.setItems(hostNameList.toArray(new String[hostNameList.size()]));
            this.hostNamesCombo.setText(enteredHostName);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void saveLoginInfoToStore() {
        try {
            this.loginPrefStore.putValue("HOST_NAME_PREF_KEY", this.hostNamesCombo.getText());
            this.loginPrefStore.putValue("USER_ID_PREF_KEY", this.textUserId.getText());
            this.loginPrefStore.putValue("PORT_NUM_PREF_KEY", this.textPort.getText());
            this.loginPrefStore.setValue("LAST_LOGIN_TIME_PREF_KEY", System.currentTimeMillis());
            this.loginPrefStore.save();
        }
        catch (IOException e) {
            logger.error((Object)"Error occured while saving Login info to store", (Throwable)e);
        }
    }

    protected Point getInitialSize() {
        Point shellSize = this.getShell().computeSize(-1, -1, true);
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(250), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(150), shellSize.y));
    }

    private void openDB2PreferencesPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
        try {
            handlerService.executeCommand("com.ca.db2.editor.DB2PreferencesCommand", null);
            this.loadPreferenceValues();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            logger.error((Object)"Error occured while executing openDB2PreferencesPage()", (Throwable)e);
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
            logger.error((Object)"Error occured while executing openDB2PreferencesPage()", (Throwable)e);
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
            logger.error((Object)"Error occured while executing openDB2PreferencesPage()", (Throwable)e);
        }
        catch (NotHandledException e) {
            e.printStackTrace();
            logger.error((Object)"Error occured while executing openDB2PreferencesPage()", (Throwable)e);
        }
    }
}

