/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.LayoutFilterObject;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.model.TableModel;
import com.ca.db2.editor.ui.model.WhereClauseModel;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.utils.SQLGenerator;
import com.ca.db2.editor.ui.widgets.DWLayoutFilterDialog;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowBuilder;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DWView;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DataWindowManager {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(DataWindowManager.class);
    private CTabFolder tabFolder;
    private final Image TABLE = Images.TABLE.createImage();
    private final Image VIEW = Images.VIEW.createImage();
    private final Image ALIAS = Images.ALIAS.createImage();
    private final Image SYNONYM = Images.SYNONYM.createImage();
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    private DWView dataWindowView;

    public DataWindowManager(Composite parent, DWView dataWindowView) {
        this.dataWindowView = dataWindowView;
        this.tabFolder = new CTabFolder(parent, 768);
        this.tabFolder.setLayout((Layout)new GridLayout());
        this.tabFolder.setUnselectedCloseVisible(false);
        this.tabFolder.setSimple(false);
        this.addListeners();
    }

    private boolean checkColExist(List<ColumnModel> colList, ColumnModel model) {
        for (ColumnModel lst : colList) {
            if (!lst.getName().equals(model.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkColExistInWhere(List<WhereClauseModel> colList, String sColName) {
        for (WhereClauseModel lst : colList) {
            if (!lst.getColumnName().equals(sColName)) continue;
            return true;
        }
        return false;
    }

    private void removeColsFromFullList(List<ColumnModel> dbColList, List<ColumnModel> queryColList, List<ColumnUpdateNode> arrColUpdateList) {
        ArrayList<ColumnModel> tempColList = new ArrayList<ColumnModel>(queryColList);
        for (ColumnModel col : tempColList) {
            if (this.checkColExist(dbColList, col)) continue;
            arrColUpdateList.add(new ColumnUpdateNode(col.getName()));
            queryColList.remove(col);
        }
    }

    private void removeColsFromStringList(List<String> colNameList, List<ColumnUpdateNode> arrColUpdateList, List<Boolean> sortOrderList, boolean bSelectList) {
        if (arrColUpdateList != null && colNameList != null) {
            ArrayList<String> tempColList = new ArrayList<String>(colNameList);
            block0: for (ColumnUpdateNode colNode : arrColUpdateList) {
                for (String col : tempColList) {
                    if (!col.equals(colNode.getColName())) continue;
                    if (sortOrderList != null) {
                        sortOrderList.remove(colNameList.indexOf(col));
                        if (sortOrderList.isEmpty()) {
                            sortOrderList = null;
                        }
                    }
                    if (bSelectList) {
                        colNode.setColInSelectList();
                    }
                    colNameList.remove(col);
                    continue block0;
                }
            }
            if (colNameList.isEmpty()) {
                colNameList = null;
            }
        }
    }

    private void genColsInfoMessages(List<ColumnUpdateNode> arrColRemovedList, List<ColumnUpdateNode> arrColAttribChg, List<WhereClauseModel> arrWhereClause) {
        String sColumnsRemoved = "";
        String sColsWhere = "";
        String sColRemovedMsg = "";
        String sColWhereMsg = "";
        if (arrColRemovedList != null && !arrColRemovedList.isEmpty()) {
            for (ColumnUpdateNode colNode : arrColRemovedList) {
                if (colNode.isColInSelectList()) {
                    if (sColumnsRemoved.length() > 0) {
                        sColumnsRemoved = sColumnsRemoved.concat(", ");
                    }
                    sColumnsRemoved = sColumnsRemoved.concat(colNode.getColName());
                }
                if (arrWhereClause == null || arrWhereClause.isEmpty() || !this.checkColExistInWhere(arrWhereClause, colNode.getColName())) continue;
                if (sColsWhere.length() > 0) {
                    sColsWhere = sColsWhere.concat(", ");
                }
                sColsWhere = sColsWhere.concat(colNode.getColName());
            }
        }
        if (arrColAttribChg != null && !arrColAttribChg.isEmpty()) {
            Iterator<ColumnUpdateNode> iterator = arrColAttribChg.iterator();
            boolean bFirst = true;
            while (iterator.hasNext()) {
                ColumnUpdateNode colNode = iterator.next();
                if (!this.checkColExistInWhere(arrWhereClause, colNode.getColName())) continue;
                if (bFirst) {
                    if (sColsWhere.length() > 0) {
                        sColsWhere = sColsWhere.concat(", ");
                    }
                    bFirst = false;
                }
                sColsWhere = sColsWhere.concat(colNode.getColName());
                if (!iterator.hasNext()) continue;
                sColsWhere = sColsWhere.concat(", ");
            }
        }
        if (sColumnsRemoved.length() > 0) {
            sColRemovedMsg = sColRemovedMsg.concat(DWBundle.INFO_MSG_COLUMNS_MISSING).concat(sColumnsRemoved);
        }
        if (sColsWhere.length() > 0) {
            sColWhereMsg = sColWhereMsg.concat(DWBundle.WRN_MSG_WHERE_CLAUSE).concat(sColsWhere);
        }
        if (sColRemovedMsg.length() > 0 && sColWhereMsg.length() > 0) {
            MsgDialog.showWarningDialog(null, DWBundle.WARNING, "-".concat(sColRemovedMsg).concat("\n\n").concat("- ").concat(sColWhereMsg));
        } else if (sColRemovedMsg.length() > 0) {
            MsgDialog.showInfoDialog(null, DWBundle.INFORMATION, sColRemovedMsg);
        } else if (sColWhereMsg.length() > 0) {
            MsgDialog.showWarningDialog(null, DWBundle.WARNING, sColWhereMsg);
        }
    }

    public List<String> checkAlteredColumns(List<ColumnModel> filterCols, List<ColumnModel> tableCols) {
        ArrayList<String> alteredColNames = new ArrayList<String>(tableCols.size());
        for (ColumnModel testCol : filterCols) {
            if (testCol.getColType().equals(DataType.ROWID.toString()) || !DWUtils.supportedDatatypes.contains(testCol.getColType().trim().toUpperCase()) || this.compareCols(testCol, tableCols)) continue;
            alteredColNames.add(testCol.getName());
        }
        return alteredColNames;
    }

    private boolean compareCols(ColumnModel testCol, List<ColumnModel> testList) {
        for (ColumnModel compCol : testList) {
            if (!testCol.getName().equals(compCol.getName()) || !compCol.compareColumnModels(testCol)) continue;
            return true;
        }
        return false;
    }

    public void openObject(ObjectIdentity objIdentity, boolean showFilterDialog) {
        block17: {
            try {
                CTabItem tabItem = this.getTabItem(objIdentity);
                if (tabItem == null) {
                    StringBuffer filepath = new StringBuffer("filters").append("\\").append(objIdentity.getSsid()).append("\\").append(objIdentity.getCreator()).append("\\").append(objIdentity.getObjectName()).append(".xml");
                    List<ColumnModel> columnModels = null;
                    LayoutFilterObject filterObj = null;
                    try {
                        File file;
                        Context context = Context.getInstance();
                        Unmarshaller unmarshaller = context.getUnmarshaller();
                        if (unmarshaller == null) {
                            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{LayoutFilterObject.class});
                            unmarshaller = ctx.createUnmarshaller();
                            context.setUnmarshaller(unmarshaller);
                        }
                        if ((file = new File(filepath.toString())).exists()) {
                            filterObj = (LayoutFilterObject)unmarshaller.unmarshal(file);
                            List<ColumnModel> filterColumns = filterObj.getAllColumns();
                            List<ColumnModel> sourceColumns = this.dataSourceHandler.getColumnModels(objIdentity);
                            String filterAddedCols = "";
                            List<Object> alteredDefCols = new ArrayList(filterColumns.size());
                            List<String> filterSelectedColumnNames = filterObj.getSelectClauseModel().getSelectedColumns();
                            ArrayList<String> addedColumnNames = new ArrayList<String>(filterColumns.size());
                            ArrayList<ColumnUpdateNode> colAlteredArr = new ArrayList<ColumnUpdateNode>();
                            ArrayList<ColumnUpdateNode> colRemovedArr = new ArrayList<ColumnUpdateNode>();
                            this.removeColsFromFullList(sourceColumns, filterColumns, colRemovedArr);
                            if (!colRemovedArr.isEmpty()) {
                                this.removeColsFromStringList(filterObj.getSelectClauseModel().getSelectedColumns(), colRemovedArr, null, true);
                                this.removeColsFromStringList(filterObj.getSelectClauseModel().getAvailableColumns(), colRemovedArr, null, false);
                                this.removeColsFromStringList(filterObj.getOrderByModel().getSelectedColumns(), colRemovedArr, filterObj.getOrderByModel().getOrderByAscs(), false);
                                this.removeColsFromStringList(filterObj.getOrderByModel().getAvailableColumns(), colRemovedArr, null, false);
                            }
                            for (ColumnModel model : sourceColumns) {
                                if (this.checkColExist(filterColumns, model) || !DWUtils.supportedDatatypes.contains(model.getColType().trim().toUpperCase()) || filterSelectedColumnNames.contains(model.getName().trim())) continue;
                                filterAddedCols = String.valueOf(filterAddedCols) + "\n" + model.getName();
                                addedColumnNames.add(model.getName());
                            }
                            ArrayList<String> addedColsForOrderBy = new ArrayList<String>(addedColumnNames);
                            if (!addedColumnNames.isEmpty()) {
                                addedColumnNames.addAll(filterObj.getSelectClauseModel().getAvailableColumns());
                                filterObj.getSelectClauseModel().setAvailableColumns(addedColumnNames);
                                addedColsForOrderBy.addAll(filterObj.getOrderByModel().getAvailableColumns());
                                filterObj.getOrderByModel().setAvailableColumns(addedColsForOrderBy);
                            }
                            alteredDefCols = this.checkAlteredColumns(filterColumns, sourceColumns);
                            for (String string : alteredDefCols) {
                                if (addedColumnNames.contains(string)) continue;
                                colAlteredArr.add(new ColumnUpdateNode(string));
                            }
                            this.genColsInfoMessages(colRemovedArr, colAlteredArr, filterObj.getWhereClauseModels());
                        }
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Problem while loading Layout-Filter" + e));
                    }
                    if (columnModels == null) {
                        columnModels = this.fetchColumnModels(objIdentity);
                        if (columnModels == null) {
                            return;
                        }
                        if (columnModels.isEmpty() && CommonUtils.isAlias(objIdentity)) {
                            throw new FMDB2Exception("Alias referenced Table/View does not exists.");
                        }
                    }
                    String sql = this.prepareSelectQuery(objIdentity, columnModels, showFilterDialog, filterObj);
                    filterObj = (LayoutFilterObject)this.tabFolder.getData(this.getTabFolderDataKey(objIdentity));
                    if (sql == null) {
                        return;
                    }
                    List<RowModel> rowModels = this.dataSourceHandler.getRuntimeData(objIdentity, columnModels, sql);
                    columnModels = this.dataSourceHandler.updateColumnModelsWithXnetData(objIdentity, columnModels);
                    DataWindow dataWindow = this.buildDataWindow(objIdentity, columnModels, rowModels);
                    dataWindow.setData("QUERY", sql);
                    dataWindow.setData("FILTER", filterObj);
                    tabItem = this.createTabItem(objIdentity);
                    tabItem.setControl((Control)dataWindow);
                    dataWindow.setEditable(true);
                    boolean noRecordsExists = rowModels.isEmpty();
                    this.tabFolder.setSelection(tabItem);
                    this.dataWindowView.triggerUpdateforActions();
                    if (noRecordsExists) {
                        MsgDialog.showInfoDialog(null, DWBundle.INFORMATION, DWBundle.NO_RECORDS_EXISTS);
                    }
                    this.tabFolder.setData(this.getTabFolderDataKey(objIdentity), null);
                    logger.info((Object)("Data Window opened for " + objIdentity));
                    break block17;
                }
                this.tabFolder.setSelection(tabItem);
                this.dataWindowView.triggerUpdateforActions();
            }
            catch (FMDB2Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
            }
        }
    }

    public String getTabFolderDataKey(ObjectIdentity objIdentity) {
        return String.valueOf(objIdentity.getFQN()) + ":" + "FILTER";
    }

    public void refreshDataWindow() throws FMDB2Exception {
        try {
            DataWindow dataWindow = this.getSelectedDataWindow();
            String query = (String)dataWindow.getData("QUERY");
            List<ColumnModel> columnModels = dataWindow.getResultSetGrid().getTableModel().getColumnModels();
            List<RowModel> rowModels = this.dataSourceHandler.getRuntimeData(dataWindow.getIdentity(), columnModels, query);
            TableModel tableModel = new TableModel(columnModels, rowModels);
            this.updateDataWindow(dataWindow, tableModel);
        }
        catch (FMDB2Exception e) {
            logger.error((Object)"Problem while refreshing Data Window", (Throwable)e);
            throw e;
        }
    }

    public void updateDataWindow(DataWindow dataWindow, TableModel tableModel) {
        boolean isEditMode = dataWindow.isEditMode();
        boolean isEditable = dataWindow.isEditable();
        CTabItem tabItem = this.getTabItem(dataWindow.getIdentity());
        LayoutFilterObject filterObj = (LayoutFilterObject)dataWindow.getData("FILTER");
        String query = (String)dataWindow.getData("QUERY");
        DataWindowBuilder builder = new DataWindowBuilder(this.tabFolder, dataWindow.getIdentity());
        dataWindow = builder.buildDataWindow(tableModel);
        dataWindow.setData("QUERY", query);
        dataWindow.setData("FILTER", filterObj);
        dataWindow.setEditMode(isEditMode);
        dataWindow.setEditable(isEditable);
        tabItem.setControl((Control)dataWindow);
        dataWindow.setDirty(false);
        boolean noRecordsExists = tableModel.getRowModels().isEmpty();
        if (noRecordsExists) {
            MsgDialog.showInfoDialog(null, DWBundle.INFORMATION, DWBundle.NO_RECORDS_EXISTS);
        }
        if (isEditMode) {
            dataWindow.getResultSetGrid().appendAddableRow(true);
        }
        dataWindow.getResultSetGrid().refreshUI();
        logger.info((Object)("Data Window refreshed for " + dataWindow.getIdentity()));
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
        }
        catch (PartInitException e) {
            logger.error((Object)"Problem while restoring the focus to Console", (Throwable)e);
        }
    }

    private List<ColumnModel> fetchColumnModels(ObjectIdentity identity) throws FMDB2Exception {
        List<ColumnModel> columnModels = this.dataSourceHandler.getColumnModels(identity);
        if (this.discardUnsupportedDataTypes(columnModels) == 0) {
            return columnModels;
        }
        return null;
    }

    private String prepareSelectQuery(ObjectIdentity objIdentity, List<ColumnModel> columnModels, boolean showFilterDialog, LayoutFilterObject filterObj) {
        String sql = null;
        if (showFilterDialog) {
            DWLayoutFilterDialog dialog = new DWLayoutFilterDialog(null, objIdentity, columnModels);
            if (filterObj != null) {
                dialog.setFilterObj(filterObj);
            }
            dialog.create();
            if (dialog.open() == 0) {
                sql = dialog.getSql();
                filterObj = dialog.getFilterObj();
                this.tabFolder.setData(this.getTabFolderDataKey(objIdentity), (Object)filterObj);
                Context.getInstance().setSQLID(objIdentity.getFQN(), dialog.getSQLID());
                Context.getInstance().setActiveSQLID(dialog.getSQLID());
            }
        } else {
            sql = SQLGenerator.generateSelectQuery(objIdentity, columnModels);
        }
        return sql;
    }

    public CTabItem getTabItem(ObjectIdentity identity) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData().equals(identity)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private DataWindow buildDataWindow(ObjectIdentity objIdentity, List<ColumnModel> columnModels, List<RowModel> rowModels) {
        TableModel tableModel = new TableModel(columnModels, rowModels);
        DataWindowBuilder builder = new DataWindowBuilder(this.tabFolder, objIdentity);
        return builder.buildDataWindow(tableModel);
    }

    private CTabItem createTabItem(ObjectIdentity identity) {
        CTabItem item = new CTabItem(this.tabFolder, 2112);
        item.setText(identity.getSimpleName());
        item.setData((Object)identity);
        item.setToolTipText(identity.getFQN());
        if (CommonUtils.isView(identity)) {
            item.setImage(this.VIEW);
        } else if (CommonUtils.isAlias(identity)) {
            item.setImage(this.ALIAS);
        } else if (CommonUtils.isSynonym(identity)) {
            item.setImage(this.SYNONYM);
        } else {
            item.setImage(this.TABLE);
        }
        return item;
    }

    private int discardUnsupportedDataTypes(List<ColumnModel> columnModels) throws FMDB2Exception {
        StringBuilder colsDiscarded = new StringBuilder();
        Iterator<ColumnModel> iterator = columnModels.iterator();
        while (iterator.hasNext()) {
            ColumnModel model = iterator.next();
            if (DWUtils.supportedDatatypes.contains(model.getColType().trim().toUpperCase())) continue;
            if (model.getColType().trim().equalsIgnoreCase(DataType.ROWID.name().trim())) {
                iterator.remove();
                continue;
            }
            colsDiscarded.append(model.getName());
            colsDiscarded.append(" of type ");
            colsDiscarded.append(model.getColType().trim());
            colsDiscarded.append(", ");
            colsDiscarded.append('\n');
            iterator.remove();
        }
        if (colsDiscarded.length() > 0 && !columnModels.isEmpty()) {
            colsDiscarded.delete(colsDiscarded.length() - 3, colsDiscarded.length() - 1);
            colsDiscarded.insert(0, String.valueOf(DWBundle.MESSAGE_UNSUPPORTED_DATATYPES_DISCARDED) + '\n');
            if (!colsDiscarded.toString().isEmpty() && MsgDialog.showWarningDialogWithCancel(null, DWBundle.WARNING, colsDiscarded.toString(), 0) != 0) {
                return 1;
            }
            logger.info((Object)colsDiscarded);
        } else if (colsDiscarded.length() > 0 && columnModels.isEmpty()) {
            MsgDialog.showErrorDialog(null, DWBundle.ERROR, DWBundle.MESSAGE_HAS_ONLY_UNSUPPORTED_DATATYPES);
            return 1;
        }
        return 0;
    }

    private void checkUnsupportedDataTypes(List<ColumnModel> columnModels) throws FMDB2Exception {
        for (ColumnModel model : columnModels) {
            if (DWUtils.supportedDatatypes.contains(model.getColType().trim().toUpperCase())) continue;
            throw new FMDB2Exception("Unsupported Datatype. Column '" + model.getName() + "' is of type " + model.getTypename() + ".");
        }
    }

    public DataWindow getSelectedDataWindow() {
        CTabItem item = this.tabFolder.getSelection();
        return item == null ? null : (DataWindow)item.getControl();
    }

    private void postInitialization(DataWindow dataWindow) {
        try {
            ObjectIdentity identity = dataWindow.getIdentity();
            boolean isDependentOnSingleTable = true;
            if (CommonUtils.isAlias(identity) || CommonUtils.isView(identity) || CommonUtils.isSynonym(identity)) {
                List<String> srcTableInfo = this.dataSourceHandler.getDependencyOnSingleTable(identity);
                boolean bl = CommonUtils.isView(identity) ? srcTableInfo != null : (isDependentOnSingleTable = srcTableInfo != null && srcTableInfo.isEmpty());
                if (CommonUtils.isView(identity) && isDependentOnSingleTable) {
                    identity.setTbname(srcTableInfo.get(1));
                    identity.setTbcreator(srcTableInfo.get(2));
                }
                if (!isDependentOnSingleTable) {
                    dataWindow.showMessage(null, DWBundle.VIEW_CREATED_FROM_MULTIPLE_SOURCES);
                }
            }
            dataWindow.setEditable(isDependentOnSingleTable);
        }
        catch (FMDB2Exception e) {
            e.printStackTrace();
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
    }

    public DataWindow getDataWindow(ObjectIdentity identity) {
        return (DataWindow)this.getTabItem(identity).getControl();
    }

    private void addListeners() {
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataWindowManager.this.dataWindowView.triggerUpdateforActions();
                super.widgetSelected(e);
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (!DataWindowManager.this.getSelectedDataWindow().canBeClosedOrRefreshed()) {
                    event.doit = false;
                    return;
                }
                logger.info((Object)(DataWindowManager.this.getSelectedDataWindow().getIdentity() + " is closed."));
                try {
                    DataWindowManager.this.dataSourceHandler.closeCachedRowSet(DataWindowManager.this.getSelectedDataWindow().getIdentity());
                }
                catch (FMDB2Exception e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (DataWindowManager.this.tabFolder.getItems().length == 1) {
                    DataWindowManager.this.dataWindowView.disableAllActions();
                    DataWindowManager.this.dataSourceHandler.releaseConnections();
                }
                super.close(event);
            }
        });
    }

    public boolean canUserLogout() {
        boolean canUserLogout = true;
        try {
            CTabItem[] itemArr = this.tabFolder.getItems();
            int i = 0;
            while (i < itemArr.length) {
                CTabItem tabItem = itemArr[i];
                DataWindow dataWindow = (DataWindow)tabItem.getControl();
                if (!dataWindow.canBeClosedOrRefreshed()) {
                    canUserLogout = false;
                    break;
                }
                tabItem.dispose();
                ++i;
            }
        }
        catch (Exception e) {
            canUserLogout = false;
            logger.error((Object)"Problem while finding if Data Window can be closed:", (Throwable)e);
        }
        return canUserLogout;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    private class ColumnUpdateNode {
        private String sColName;
        private int fAttribChange;
        private boolean bSelected;

        public ColumnUpdateNode(String sColName) {
            this.sColName = sColName;
            this.fAttribChange = 0;
            this.bSelected = false;
        }

        public String getColName() {
            return this.sColName;
        }

        public boolean isColInSelectList() {
            return this.bSelected;
        }

        public int getAttribFlag() {
            return this.fAttribChange;
        }

        public void setColName(String val) {
            this.sColName = val;
        }

        public void setColInSelectList() {
            this.bSelected = true;
        }

        public void setAttribFlag(int val) {
            this.fAttribChange |= val;
        }
    }
}

