/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.CreatorNode;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.DSEInput;
import com.ca.db2.editor.ui.model.GroupNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.utils.DSEContentProvider;
import com.ca.db2.editor.ui.utils.DSELabelProvider;
import com.ca.db2.editor.ui.utils.DSEPatternFilter;
import com.ca.db2.editor.ui.utils.DSESorter;
import com.ca.db2.editor.ui.widgets.DSEContextMenu;
import com.ca.db2.editor.ui.widgets.ExtendedFilteredTree;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DSEView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;

public class DataSourceExplorer {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private FilteredTree tree = null;
    private int TREE_STYLE = 0x10300 | Window.getDefaultOrientation();
    private DSEPatternFilter patternFilter;
    private TreeViewer viewer;
    private DSEContentProvider contentProvider;
    private DSELabelProvider labelProvider;
    private DSEInput root;
    private ITreeNode selectedObject;
    private DSESorter sorter;
    private DSEView dseView;
    private DSEContextMenu contextMenu;
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    private static final Logger logger = Logger.getLogger(DataSourceExplorer.class);

    public DataSourceExplorer(DSEView dseView) {
        this.setDseView(dseView);
        this.patternFilter = new DSEPatternFilter();
        this.tree = new ExtendedFilteredTree(dseView.getParent(), this.TREE_STYLE, this.patternFilter, true);
        this.tree.setInitialText(DSEBundle.INITIAL_TEXT_IN_FILTER);
        this.initializeProviders();
        this.initializeLayout();
        this.createContextMenu();
        this.attachListeners();
        this.root = new DSEInput();
        this.viewer.setInput((Object)this.root);
        logger.debug((Object)"DataSourceExplorer initiated");
    }

    private void initializeProviders() {
        this.viewer = this.tree.getViewer();
        this.viewer.setAutoExpandLevel(2);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.contentProvider = new DSEContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new DSELabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setUseHashlookup(false);
        this.sorter = new DSESorter();
        this.sorter.setSortOrder(DSESorter.SortOrder.ASC);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.addOrRemoveSortBy(DSESorter.SortBy.NAME, true);
    }

    private void initializeLayout() {
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)layoutData);
    }

    public FilteredTree getTree() {
        return this.tree;
    }

    private void createContextMenu() {
        this.contextMenu = new DSEContextMenu(this);
        this.viewer.getControl().setMenu(this.contextMenu.createContextMenu(this.viewer.getControl()));
    }

    private void attachListeners() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeNode o = (ITreeNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                DataSourceExplorer.this.executeAction(o);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeNode o = (ITreeNode)((TreeSelection)event.getSelection()).getFirstElement();
                DataSourceExplorer.this.setSelectedObject(o);
                DataSourceExplorer.this.updateContext();
            }
        });
    }

    public void loadData() {
        try {
            if (this.root == null) {
                this.root = new DSEInput();
                this.viewer.setInput((Object)this.root);
            }
            this.root.getLparNodes().addAll(this.dataSourceHandler.getLpars());
            for (LparNode lpar : this.root.getLparNodes()) {
                lpar.addChildren(this.dataSourceHandler.getSubsystems(lpar, false));
                Collections.sort(lpar.getChildren());
            }
        }
        catch (Exception e) {
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
        this.viewer.refresh();
        this.viewer.expandAll();
    }

    public void loadData(List<SubsystemNode> subsystemNodes) {
        try {
            if (this.root == null) {
                this.root = new DSEInput();
                this.viewer.setInput((Object)this.root);
            }
            this.root.getLparNodes().addAll(this.dataSourceHandler.getLpars());
            for (LparNode lpar : this.root.getLparNodes()) {
                lpar.addChildren(this.dataSourceHandler.getSubsystems(lpar, false));
                lpar.getChildren().retainAll(subsystemNodes);
                Collections.sort(lpar.getChildren());
            }
        }
        catch (Exception e) {
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
        this.viewer.refresh();
        this.viewer.expandAll();
    }

    /*
     * WARNING - void declaration
     */
    private void addDBObjectsToSubsystem(SubsystemNode subsystem, List<? extends DBObject> dbObjects) {
        Object[] expandedElements = this.viewer.getExpandedElements();
        ArrayList<CreatorNode> nodesToBeExpanded = new ArrayList<CreatorNode>();
        List<CreatorNode> originalList = subsystem.getChildren();
        Map<String, List<DBObject>> map = DSEUtils.categorizeByCreator(dbObjects);
        for (CreatorNode creatorNode : originalList) {
            List<DBObject> o = map.get(creatorNode.getName());
            if (o == null) continue;
            for (DBObject dbObject : o) {
                creatorNode.addChild((ITreeNode)((Object)dbObject));
            }
            map.remove(creatorNode.getName());
            nodesToBeExpanded.add(creatorNode);
        }
        for (Map.Entry entry : map.entrySet()) {
            CreatorNode node = new CreatorNode((String)entry.getKey(), subsystem);
            for (DBObject dbObject : (List)entry.getValue()) {
                node.addChild((ITreeNode)((Object)dbObject));
            }
            originalList.add(node);
            nodesToBeExpanded.add(node);
        }
        Collections.sort(originalList);
        this.refresh();
        this.viewer.setExpandedState((Object)subsystem, true);
        this.viewer.setExpandedElements(expandedElements);
        if (originalList.size() > 5) {
            void var7_12;
            boolean bl = false;
            while (var7_12 < 5) {
                this.viewer.expandToLevel((Object)originalList.get((int)var7_12), 4);
                ++var7_12;
            }
        } else {
            for (CreatorNode creatorNode : originalList) {
                this.viewer.expandToLevel((Object)creatorNode, 4);
            }
        }
        this.selectNode(subsystem.getChildren().get(0).getChildren().get(0));
    }

    public void addDBObjects(ITreeNode node, List<? extends DBObject> dbObjects) {
        if (DSEUtils.isGroup(node)) {
            ((GroupNode)node).addChildren(dbObjects);
            this.refresh();
            this.viewer.expandToLevel((Object)node, 5);
            this.selectNode((ITreeNode)((Object)dbObjects.get(0)));
        } else if (DSEUtils.isCreator(node)) {
            for (DBObject dBObject : dbObjects) {
                node.addChild((ITreeNode)((Object)dBObject));
            }
            this.refresh();
            this.viewer.expandToLevel((Object)node, 4);
            this.selectNode((GroupNode)node.getChildren().get(0));
        } else if (DSEUtils.isSubsystem(node)) {
            this.addDBObjectsToSubsystem((SubsystemNode)node, dbObjects);
        }
    }

    public void setSelectedObject(ITreeNode selectedObject) {
        this.selectedObject = selectedObject;
    }

    public ITreeNode getSelectedObject() {
        return this.selectedObject;
    }

    public DSEInput getRoot() {
        return this.root;
    }

    private void executeAction(ITreeNode node) {
        if (DSEUtils.isLpar(node)) {
            this.executeAction(DSEContextMenu.ACTION.ADD_SUBSYSTEMS);
        } else if (node.isLeafNode()) {
            this.executeAction(DSEContextMenu.ACTION.BROWSE);
        } else if (DSEUtils.isSubsystem(node) || DSEUtils.isCreator(node) || DSEUtils.isGroup(node)) {
            this.executeAction(DSEContextMenu.ACTION.LOAD_OBJECTS);
        }
    }

    private void executeAction(DSEContextMenu.ACTION action) {
        BaseAction[] baseActionArray = this.contextMenu.getActions();
        int n = baseActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseAction o = baseActionArray[n2];
            if (action.toString().equals(o.getId())) {
                o.run();
                break;
            }
            ++n2;
        }
    }

    public void collapseAll() {
        this.viewer.collapseAll();
    }

    public void addOrRemoveSortBy(DSESorter.SortBy sortBy, boolean addSortBy) {
        if (addSortBy) {
            this.sorter.addSortBy(sortBy);
        } else {
            this.sorter.removeSortBy(sortBy);
        }
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.refresh();
    }

    public void setSortOrder(DSESorter.SortOrder sortOrder) {
        this.sorter.setSortOrder(sortOrder);
        this.viewer.setSorter((ViewerSorter)this.sorter);
        this.refresh();
    }

    private void updateContext() {
        ITreeNode o = this.getSelectedObject();
        if (o == null) {
            return;
        }
        if (DSEUtils.isLpar(o)) {
            Context.getInstance().setLpar(o.getName());
            Context.getInstance().setSystem(o.getName());
        } else if (DSEUtils.isSubsystem(o)) {
            Context.getInstance().setSSID(o.getName());
            Context.getInstance().setSystem(o.getParent().getName());
        } else if (DSEUtils.isGroup(o)) {
            Context.getInstance().setSSID(o.getParent().getName());
            Context.getInstance().setSystem(o.getParent().getParent().getName());
        } else if (o.isLeafNode()) {
            String ssid = o.getParent().getParent().getParent().getName();
            String system = o.getParent().getParent().getParent().getParent().getName();
            Context.getInstance().setSSID(ssid);
            Context.getInstance().setSystem(system);
        }
    }

    public void setDseView(DSEView dseView) {
        this.dseView = dseView;
    }

    public DSEView getDseView() {
        return this.dseView;
    }

    public DSESorter getSorter() {
        return this.sorter;
    }

    public void refreshOnProfileLoad(LparNode lpar, List<SubsystemNode> subsystems) {
        List<LparNode> lpars;
        if (subsystems != null && !subsystems.isEmpty() && !(lpars = ((DSEInput)this.viewer.getInput()).getLparNodes()).isEmpty()) {
            for (SubsystemNode subsystem : subsystems) {
                subsystem.setLpar(lpars.get(0));
            }
            lpars.get(0).getChildren().retainAll(subsystems);
            subsystems.removeAll(lpars.get(0).getChildren());
            lpars.get(0).addChildren(subsystems);
            Collections.sort(lpars.get(0).getChildren());
            this.refresh();
        }
    }

    public void releaseResources() {
        try {
            this.root = null;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void dispose() {
        try {
            this.contextMenu.dispose();
            this.tree.dispose();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void selectNode(ITreeNode node) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
    }

    public void selectTreeItem(TreeItem item) {
        this.viewer.getTree().select(item);
    }

    public TreeItem getSelectedItem() {
        TreeItem[] items = this.viewer.getTree().getSelection();
        return items == null || items.length == 0 ? null : items[0];
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setRoot(DSEInput root) {
        this.root = root;
    }
}

