/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.AbstractCellEditor;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.NumericValidator;
import java.math.BigDecimal;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;

public class NumericCellEditor
extends AbstractCellEditor {
    private DataType dataType;
    private String value;
    private NumericValidator validator;
    private final char MINUS_SIGN = (char)45;
    private final char PLUS_SIGN = (char)43;
    private final char DOT = (char)46;

    public NumericCellEditor(Composite parent, ObjectIdentity identity, ColumnModel columnModel) {
        super(parent, identity, columnModel);
        this.dataType = DataType.value(columnModel.getColType().trim());
        this.validator = new NumericValidator(columnModel, this.dataType);
    }

    @Override
    public boolean onKeyPressValidation(KeyEvent keyEvent) {
        char ch = keyEvent.character;
        this.value = this.text.getText();
        boolean isValid = Character.isDigit(ch) ? this.isDigitEnteredAtValidPostion() : false;
        boolean bl = isValid = isValid || this.isSign(ch) && this.isSignEnteredAtValidPosition();
        if (DataTypeUtils.isFloatingPointDataType(this.dataType)) {
            boolean bl2 = isValid = isValid || this.isDot(ch) && this.isDotEnteredAtValidPosition();
            if (this.isE(ch) && (DataTypeUtils.isSinglePrecisionFP(this.dataType) || DataTypeUtils.isDoublePrecisionFP(this.dataType))) {
                isValid = true;
            }
            if (isValid && !DataTypeUtils.isSinglePrecisionFP(this.dataType) && !DataTypeUtils.isDoublePrecisionFP(this.dataType)) {
                isValid = this.handleScale();
            }
        }
        if (Character.isDigit(ch) && this.isPrecisionReached(keyEvent)) {
            return false;
        }
        return isValid;
    }

    private boolean isDigitEnteredAtValidPostion() {
        if (!this.value.isEmpty() && !this.isEntireTextSelected()) {
            return this.hasSign() ? this.text.getCaretPosition() != 0 : true;
        }
        return true;
    }

    private boolean hasSign() {
        return this.value.indexOf(45) != -1 || this.value.indexOf(43) != -1;
    }

    private boolean isSignEnteredAtValidPosition() {
        if (DataTypeUtils.isSinglePrecisionFP(this.dataType) || DataTypeUtils.isDoublePrecisionFP(this.dataType)) {
            return true;
        }
        if (!this.value.isEmpty() && this.text.getSelectionText().isEmpty()) {
            return !this.hasSign() && this.text.getCaretPosition() == 0;
        }
        return true;
    }

    private boolean isDotEnteredAtValidPosition() {
        if (this.value.indexOf(46) != -1) {
            return this.text.getSelectionText().indexOf(46) != -1;
        }
        return !this.hasSign() || this.text.getCaretPosition() != 0;
    }

    private boolean handleScale() {
        int index = this.value.lastIndexOf(46);
        if (!this.isEntireTextSelected() && index != -1 && this.text.getCaretPosition() > index) {
            return this.getColumnModel().getScale() - (this.value.length() - index) >= 0;
        }
        return true;
    }

    @Override
    public String validate(Object value) {
        return this.validator.isValid(value);
    }

    private boolean isEntireTextSelected() {
        return this.text.getSelectionCount() == this.value.length();
    }

    private boolean isSign(char ch) {
        return ch == '-' || ch == '+';
    }

    private boolean isDot(char ch) {
        return ch == '.';
    }

    private boolean isE(char ch) {
        return ch == 'E' || ch == 'e';
    }

    @Override
    public Object formatValue(Object value) {
        String s;
        String string = s = value == null ? null : value.toString().trim();
        if (this.getColumnModel().isAutoGeneratedColumn() && "default".equals(s)) {
            return s;
        }
        if (s != null && !s.trim().isEmpty()) {
            boolean hasPlusSign = s.charAt(0) == '+';
            switch (this.dataType) {
                case INTEGER: 
                case INT: {
                    s = Integer.valueOf(s).toString();
                    return hasPlusSign ? String.valueOf('+') + s : s;
                }
                case SMALLINT: {
                    return Short.valueOf(s).toString();
                }
                case BIGINT: {
                    return Long.valueOf(s).toString();
                }
                case DECIMAL: {
                    return new BigDecimal(s).toString();
                }
            }
        }
        return s != null && s.isEmpty() ? null : s;
    }

    private boolean isPrecisionReached(KeyEvent e) {
        if (this.value == null || this.value.isEmpty() || this.text.getSelectionCount() > 0) {
            return false;
        }
        int length = this.value.length();
        char c = this.value.charAt(0);
        if (c == '-' || c == '+') {
            --length;
        }
        if (this.dataType == DataType.DECIMAL) {
            String s = this.value;
            int indexOfDot = this.value.indexOf(46);
            if (indexOfDot != -1) {
                s = s.substring(0, indexOfDot);
            }
            return s.length() <= this.getColumnModel().getLength() - this.getColumnModel().getScale();
        }
        return length > this.getColumnModel().getPrecision();
    }

    @Override
    protected void doSetValue(Object value) {
        String s;
        String string = value instanceof String ? (String)value : (s = value != null ? value.toString() : "");
        if (s != null) {
            super.doSetValue(s);
        }
    }
}

