/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.RowModel;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class DWRowFilter
extends ViewerFilter {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private String searchString;
    private String originalString;
    private List<ColumnModel> columnModels;
    private boolean caseSensitive;

    private DWRowFilter() {
    }

    public DWRowFilter(List<ColumnModel> columnModels) {
        this();
        this.columnModels = columnModels;
    }

    public void setSearchText(String s) {
        this.searchString = ".*" + s + ".*";
        this.originalString = s;
        Object o = Context.get(Context.Keys.CASE_INSENSITIVE);
        this.caseSensitive = o != null ? (Boolean)o : false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        RowModel row = (RowModel)element;
        if (this.searchString == null || this.searchString.length() == 0) {
            return true;
        }
        int index = 0;
        while (index < row.getData().length) {
            if (this.columnModels.get(index).isVisible()) {
                String value;
                Object o = row.getData()[index];
                String string = value = o != null ? o.toString() : null;
                if (value != null && this.matches(value)) {
                    return true;
                }
                if (value == null && DWBundle.NULL_VALUE_TEXT.contains(this.originalString)) {
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    private boolean matches(String value) {
        if (!this.caseSensitive) {
            return value.toLowerCase().matches(this.searchString.toLowerCase());
        }
        return value.matches(this.searchString);
    }
}

