/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.utils.DataTypeUtils;

public class WhereClauseUtils {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String[] conjunctions = new String[]{"AND", "OR "};
    private static final String IS_NULL = "IS NULL";
    private static final String IS_NOT_NULL = "IS NOT NULL";
    private static final String IN = "IN";
    private static final String LIKE = "LIKE";
    private static final String NOT_IN = "NOT IN";
    private static final String[] characterOperators = new String[]{"=", "<>", ">", "<", "<=", ">=", "LIKE", "IN", "NOT IN", "IS NULL", "IS NOT NULL"};
    private static final String[] numericOperators = new String[]{"=", "<>", ">", "<", "<=", ">=", "IN", "NOT IN", "IS NULL", "IS NOT NULL"};

    public static String[] getConjunctions() {
        return conjunctions;
    }

    public static String[] getOperators(String colType) {
        DataType dataType = DataType.value(colType.trim());
        if (DataTypeUtils.isNumericDataType(dataType) || DataTypeUtils.isDateTimeDataType(dataType)) {
            return numericOperators;
        }
        return characterOperators;
    }

    public static boolean isNullOrIsNotNull(String operator) {
        return WhereClauseUtils.isNull(operator) || WhereClauseUtils.isNotNull(operator);
    }

    public static boolean isNull(String operator) {
        return IS_NULL.equals(operator);
    }

    public static boolean isNotNull(String operator) {
        return IS_NOT_NULL.equals(operator);
    }

    public static boolean isIN(String operator) {
        return IN.equals(operator);
    }

    public static boolean isNotIN(String operator) {
        return NOT_IN.equals(operator);
    }

    public static boolean isKeyWord(String s) {
        return IN.equals(s) || NOT_IN.equals(s) || LIKE.equals(s) || IS_NULL.equals(s) || IS_NOT_NULL.equals(s);
    }

    public static boolean isLike(String operator) {
        return LIKE.equals(operator);
    }
}

