/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.AliasNode;
import com.ca.db2.editor.ui.model.BaseModel;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.GroupNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.model.SynonymNode;
import com.ca.db2.editor.ui.model.TableNode;
import com.ca.db2.editor.ui.model.ViewNode;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.utils.Images;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class CreatorNode
extends BaseModel
implements ITreeNode,
Comparable<CreatorNode> {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final long serialVersionUID = -320349453874945297L;
    private final Image CREATOR = Images.CREATOR.createImage();
    private SubsystemNode subsystem;
    private final List<GroupNode<? extends DBObject>> children = new ArrayList<GroupNode<? extends DBObject>>(5);
    private GroupNode<TableNode> tables = new GroupNode(DSEBundle.TABLES, this, DBObjectType.TABLE);
    private GroupNode<ViewNode> views;
    private GroupNode<AliasNode> aliases;
    private GroupNode<SynonymNode> synonyms;

    private CreatorNode() {
        this.children.add(this.tables);
        this.views = new GroupNode(DSEBundle.VIEWS, this, DBObjectType.VIEW);
        this.children.add(this.views);
        this.aliases = new GroupNode(DSEBundle.ALIASES, this, DBObjectType.ALIAS);
        this.children.add(this.aliases);
        this.synonyms = new GroupNode(DSEBundle.SYNONYMS, this, DBObjectType.SYNONYM);
        this.children.add(this.synonyms);
    }

    public CreatorNode(String name, SubsystemNode subsystem) {
        this();
        this.setName(name);
        this.setSubsystem(subsystem);
        this.setTooltip(DSEBundle.bind((String)DSEBundle.TOOLTIP_CREATOR, (Object)this.getName()));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(CreatorNode o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public DBObjectType getObjectType() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public Image getImage() {
        return this.CREATOR;
    }

    @Override
    public int getSortingCategory() {
        return 0;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    @Override
    public boolean removeChild(ITreeNode node) {
        node.removeChildren();
        return this.children.remove(node);
    }

    @Override
    public ITreeNode getParent() {
        return this.subsystem;
    }

    public void setSubsystem(SubsystemNode subsystem) {
        this.subsystem = subsystem;
    }

    public SubsystemNode getSubsystem() {
        return this.subsystem;
    }

    @Override
    public void removeChildren() {
        this.children.clear();
    }

    public List<GroupNode<? extends DBObject>> getChildren() {
        this.children.clear();
        if (this.tables.hasChildren()) {
            this.children.add(this.tables);
        }
        if (this.views.hasChildren()) {
            this.children.add(this.views);
        }
        if (this.aliases.hasChildren()) {
            this.children.add(this.aliases);
        }
        if (this.synonyms.hasChildren()) {
            this.children.add(this.synonyms);
        }
        return this.children;
    }

    @Override
    public void addChildren(List<? extends ITreeNode> nodes) {
        for (ITreeNode iTreeNode : nodes) {
            this.addChild(iTreeNode);
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.synonyms == null ? 0 : this.synonyms.hashCode());
        result = 31 * result + (this.tables == null ? 0 : this.tables.hashCode());
        result = 31 * result + (this.views == null ? 0 : this.views.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreatorNode other = (CreatorNode)obj;
        if (!this.getPath().equals(other.getParent().getPath())) {
            return false;
        }
        if (this.aliases == null ? other.aliases != null : !this.aliases.equals(other.aliases)) {
            return false;
        }
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (this.synonyms == null ? other.synonyms != null : !this.synonyms.equals(other.synonyms)) {
            return false;
        }
        if (this.tables == null ? other.tables != null : !this.tables.equals(other.tables)) {
            return false;
        }
        return !(this.views == null ? other.views != null : !this.views.equals(other.views));
    }

    @Override
    public <U extends ITreeNode> void addChild(U node) {
        if (DSEUtils.isTable(node)) {
            this.tables.addChild((ITreeNode)node);
        } else if (DSEUtils.isView(node)) {
            this.views.addChild((ITreeNode)node);
        } else if (DSEUtils.isAlias(node)) {
            this.aliases.addChild((ITreeNode)node);
        } else if (DSEUtils.isSynonym(node)) {
            this.synonyms.addChild((ITreeNode)node);
        }
    }

    @Override
    public String getPath() {
        return String.valueOf(this.getParent().getPath()) + "." + this.getName();
    }
}

