/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.DB2Preferences;
import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.service.SessionSourceProvider;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.widgets.LoginDialog;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.ISourceProviderService;

public class LoginHandler
extends AbstractHandler
implements IElementUpdater {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(LoginHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LoginDialog dialog = new LoginDialog(Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
                    SessionSourceProvider sessionSourceProvider = (SessionSourceProvider)service.getSourceProvider("com.ca.db2.editor.service.sessionState");
                    sessionSourceProvider.setLoggedIn(true);
                    LoginHandler.this.postLogin();
                }
            });
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private void postLogin() {
        try {
            PreferenceStore store = new PreferenceStore("fmdb2_profile.pref");
            store.load();
            Context.put(Context.Keys.SQLID, store.getString("SQLID_PREF_KEY"));
            Context.getInstance().setSQLID("DSE", store.getString("SQLID_PREF_KEY"));
            Context.put(Context.Keys.PAGINATION_COUNT, Integer.parseInt(store.getString("SQL_PAGINATION_COUNT_PREF_KEY")));
            if (!store.getString("SELECTED_SUBSYSTEMS_PREF_KEY").isEmpty()) {
                String[] subsystems = store.getString("SELECTED_SUBSYSTEMS_PREF_KEY").split(",");
                LparNode lpar = new LparNode(Context.getInstance().getLpar());
                ArrayList<SubsystemNode> subsystemNodes = new ArrayList<SubsystemNode>(subsystems.length);
                String[] stringArray = subsystems;
                int n = subsystems.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    subsystemNodes.add(new SubsystemNode(s, lpar));
                    ++n2;
                }
                Context.put(Context.Keys.SELECTED_SUBSYSTEMS, subsystemNodes);
            }
        }
        catch (Exception exception) {
            Context.put(Context.Keys.PAGINATION_COUNT, DB2Preferences.DEFAULT_PAGINATION_COUNT);
        }
    }
}

