/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.views.DWView;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;

public class DWSetNullAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private DataWindowManager manager;
    private String commandId = "com.ca.db2.editor.ui.actions.DWSetNullAction";

    public DWSetNullAction(DataWindowManager manager) {
        super(DWBundle.SET_NULL, 1);
        this.setToolTipText(DWBundle.SET_NULL);
        this.manager = manager;
        this.setId(DWView.ACTION.SET_NULL.toString());
        this.registerKeyBinding(this.commandId, 65610);
    }

    @Override
    public void execute() {
        TableViewerFocusCellManager cellManager = this.getDataWindow().getResultSetGrid().getCellManager();
        ViewerCell cell = cellManager.getFocusCell();
        int colIndex = cell.getColumnIndex();
        ColumnModel colModel = this.getDataWindow().getResultSetGrid().getTableModel().getColumnModels().get(colIndex);
        RowModel rowModel = (RowModel)cell.getElement();
        this.getDataWindow().addColChangeEvent(rowModel, colModel, colIndex, DWBundle.NULL_VALUE_TEXT);
        rowModel.getData()[colIndex] = null;
        this.getDataWindow().getResultSetGrid().getViewer().update(rowModel, null);
        this.getDataWindow().getResultSetGrid().refreshUI();
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    @Override
    protected boolean checkPreConditions() {
        boolean enable = this.getDataWindow().isEditMode() && this.getDataWindow().isEditable();
        enable = enable && this.getDataWindow().getResultSetGrid().getRightMouseClickedColumn() == null;
        enable = enable && this.getDataWindow().getResultSetGrid().getSelectedRows() != null;
        ViewerCell cell = this.getDataWindow().getResultSetGrid().getCellManager().getFocusCell();
        if (cell != null) {
            int colIndex = cell.getColumnIndex();
            ColumnModel colModel = this.getDataWindow().getResultSetGrid().getTableModel().getColumnModels().get(colIndex);
            enable = enable && colModel.isNullable();
            enable = enable && !cell.getText().equals(DWBundle.NULL_VALUE_TEXT);
            enable = enable && !((RowModel)cell.getElement()).isAddableRow();
        }
        return enable;
    }

    private DataWindow getDataWindow() {
        return this.manager.getSelectedDataWindow();
    }
}

