/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Grid;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DWView;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;

public class DWEditAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(DWEditAction.class);
    private DataWindowManager manager;
    private ImageDescriptor EDIT_MODE = Images.DW_EDITMODE;
    private boolean isContextMenuItem = false;
    private String commandId = "com.ca.db2.editor.ui.actions.DWEditAction";

    public DWEditAction(DataWindowManager manager) {
        super(DWBundle.EDIT_MODE);
        this.setId(DWView.ACTION.EDIT_MODE.toString());
        this.setImageDescriptor(this.EDIT_MODE);
        this.setToolTipText(DWBundle.EDIT_MODE);
        this.manager = manager;
        this.registerKeyBinding(this.commandId, 65609);
    }

    @Override
    public void execute() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                DWEditAction.this.executeAction();
            }
        });
    }

    private void setLabels(boolean isChecked) {
        if (!isChecked) {
            this.setToolTipText(DWBundle.EDIT_MODE);
            this.setText(DWBundle.EDIT_MODE);
        } else {
            this.setToolTipText(DWBundle.READONLY_MODE);
            this.setText(DWBundle.READONLY_MODE);
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.manager.getSelectedDataWindow().isEditable());
        this.setChecked(this.manager.getSelectedDataWindow().isEditMode());
        this.setLabels(this.isChecked());
    }

    private void executeAction() {
        boolean isChecked = this.isChecked();
        try {
            if (CommonUtils.isCatalogObject(this.manager.getSelectedDataWindow().getIdentity())) {
                this.setChecked(false);
                MsgDialog.showInfoDialog(null, DWBundle.INFORMATION, DWBundle.CATALOGTABLE);
            } else {
                DataWindow dataWindow = this.manager.getSelectedDataWindow();
                Grid resultGrid = dataWindow.getResultSetGrid();
                if (isChecked) {
                    boolean hasUniqueConstraints = dataWindow.hasUniqueConstraints();
                    dataWindow.setEditMode(isChecked);
                    this.setLabels(isChecked);
                    if (!hasUniqueConstraints) {
                        dataWindow.showMessage(DataWindow.MsgType.WARN, DWBundle.MESSAGE_NO_UNIQUE_CONSTRAINTS);
                        int returnCode = MsgDialog.showWarningDialogWithCancel(null, DWBundle.WARNING, DWBundle.MESSAGE_NO_UNIQUE_CONSTRAINTS, 0);
                        if (returnCode != 0) {
                            this.setChecked(false);
                            return;
                        }
                    }
                    if (resultGrid.getTableModel().getRowModels() == null || resultGrid.getTableModel().getRowModels().isEmpty()) {
                        resultGrid.appendAddableRow(true);
                        dataWindow.addRows();
                        this.setChecked(isChecked);
                    } else {
                        resultGrid.appendAddableRow(true);
                    }
                } else {
                    dataWindow.setEditMode(isChecked);
                    this.setLabels(isChecked);
                    resultGrid.removeAddableRow(true);
                }
                resultGrid.refreshUI();
                if (this.isContextMenuItem()) {
                    DWUtils.getView().triggerUpdateforActions();
                }
                logger.info((Object)(String.valueOf(isChecked ? "Edit mode activated" : "Read-only mode activated") + " for " + this.manager.getSelectedDataWindow().getIdentity()));
            }
        }
        catch (FMDB2Exception e) {
            this.setChecked(!isChecked);
            this.setLabels(!isChecked);
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
        catch (Exception e) {
            this.setChecked(!isChecked);
            this.setLabels(!isChecked);
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
    }

    public boolean isContextMenuItem() {
        return this.isContextMenuItem;
    }

    public void setContextMenuItem(boolean isContextMenuItem) {
        this.isContextMenuItem = isContextMenuItem;
    }
}

