/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DSEContextMenu;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.TreeItem;

class DSERemoveAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static Logger logger = Logger.getLogger(DSERemoveAction.class);
    private String commandId = "com.ca.db2.editor.ui.actions.DSERemoveAction";
    private DataSourceExplorer explorer;

    public DSERemoveAction(DataSourceExplorer explorer) {
        super(DSEBundle.REMOVE);
        this.explorer = explorer;
        this.setImageDescriptor(Images.DESC_REMOVE);
        this.setId(DSEContextMenu.ACTION.REMOVE.toString());
        this.registerKeyBinding(this.commandId, 65606);
    }

    @Override
    public void execute() {
        String msg = DSEBundle.bind((String)DSEBundle.CONFIRM_DIALOG_MSG, (Object)this.explorer.getSelectedObject().getName());
        if (MsgDialog.showQuestionDialog(null, DSEBundle.CONFIRM_DIALOG_TITLE, msg)) {
            TreeItem parent = this.explorer.getSelectedItem().getParentItem();
            ITreeNode node = this.explorer.getSelectedObject();
            node.getParent().removeChild(this.explorer.getSelectedObject());
            this.explorer.refresh();
            logger.info((Object)(String.valueOf(node.getName()) + " removed from the Data Source Explorer"));
            this.selectSibilingOrParent(node, parent);
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    private void selectSibilingOrParent(ITreeNode node, TreeItem parentItem) {
        if (!parentItem.isDisposed()) {
            if (parentItem.getItemCount() != 0) {
                this.explorer.selectTreeItem(parentItem.getItem(0));
            } else {
                this.explorer.selectNode(node.getParent());
            }
        } else {
            ITreeNode grandParent = node.getParent().getParent().getParent();
            if (grandParent.hasChildren()) {
                this.explorer.selectNode(grandParent.getChildren().get(0));
            } else {
                this.explorer.selectNode(grandParent);
            }
        }
    }

    @Override
    public boolean checkPreConditions() {
        ITreeNode node = this.explorer.getSelectedObject();
        boolean isEmpty = this.explorer.getRoot().getLparNodes().isEmpty();
        return !isEmpty && node.getObjectType() != DBObjectType.LPAR;
    }
}

