/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.CMBundle;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.CMUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.ChangeManager;
import java.util.ArrayList;
import org.eclipse.swt.custom.BusyIndicator;

public class CMCommitAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private ChangeManager changeManager;
    private String commandId = "com.ca.db2.editor.ui.actions.CMCommitAction";

    public CMCommitAction(ChangeManager changeManager) {
        super(CMBundle.COMMIT);
        this.setImageDescriptor(Images.DW_COMMIT);
        this.setChangeManager(changeManager);
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    public void setChangeManager(ChangeManager changeManager) {
        this.changeManager = changeManager;
    }

    public ChangeManager getChangeManager() {
        return this.changeManager;
    }

    @Override
    public void execute() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] items = CMCommitAction.this.changeManager.getSelectedItems();
                ArrayList<ChangeEntrySet> entries = new ArrayList<ChangeEntrySet>();
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof ChangeEntrySet) {
                        entries.add((ChangeEntrySet)o);
                    }
                    ++n2;
                }
                CMCommitAction.this.changeManager.commitChanges(entries);
                CMCommitAction.this.postCommit(((ChangeEntrySet)entries.get(0)).getIdentity());
            }
        });
    }

    private void postCommit(ObjectIdentity identity) {
        if (!CMUtils.containsChangeSets(identity)) {
            DWUtils.getDataWindowManager().getDataWindow(identity).setDirty(false);
        }
        DWUtils.getView().triggerUpdateforActions();
    }

    @Override
    protected boolean checkPreConditions() {
        return this.changeManager.enableContextMenuActions();
    }
}

