/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.service;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.core.WebServer;
import com.ca.db2.editor.core.WebServerCommand;
import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.i18n.WebServerBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ConstraintModel;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.QueryUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.CachedRowSet;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;

public class WebServerDataSourceHandler
implements IDataSourceHandler {
    private static final Logger logger = Logger.getLogger(WebServerDataSourceHandler.class);
    Map<String, Map<String, String>> ssidCache = new HashMap<String, Map<String, String>>();
    private WebServer server = null;

    @Override
    public void login(String userId, String password, String hostname, String port) throws FMDB2Exception {
        long t1 = System.currentTimeMillis();
        Context.getInstance().setDefaultSQLID(userId.trim());
        this.server = new WebServer(userId, password, hostname, Integer.parseInt(port));
        if (this.server.authenticate()) {
            this.server.initializeSession();
        }
        CommonUtils.printExecutionTime("TIME TAKEN TO LOGIN IS : ", System.currentTimeMillis() - t1);
    }

    @Override
    public boolean logout() throws FMDB2Exception {
        if (this.server != null) {
            return this.server.destroySession();
        }
        return true;
    }

    @Override
    public List<ColumnModel> getColumnModels(ObjectIdentity identity) throws FMDB2Exception {
        return this.getColumns(identity);
    }

    @Override
    public void closeCachedRowSet(final ObjectIdentity identity) throws FMDB2Exception {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Map inputs = WebServerDataSourceHandler.this.getInputParams(WebServerDataSourceHandler.this.ssidCache.get(identity.getSsid()));
                    inputs.put("SSID", identity.getSsid());
                    inputs.put("UUID", identity.getFQN());
                    String closeCrs = (String)WebServerDataSourceHandler.this.server.execute(WebServerCommand.CLOSE_CRS, inputs);
                    logger.debug((Object)closeCrs);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        });
    }

    @Override
    public List<RowModel> getRuntimeData(ObjectIdentity identity, List<ColumnModel> columnModels, String query) throws FMDB2Exception {
        return this.getRowData(WebServerCommand.FETCH_DATA, identity, columnModels, query);
    }

    @Override
    public List<RowModel> paginate(ObjectIdentity identity, List<ColumnModel> columnModels) throws FMDB2Exception {
        try {
            StringBuilder message = new StringBuilder();
            List<RowModel> models = this.fetchNext(identity, columnModels);
            if (!models.isEmpty()) {
                message.append("Pagination has fetched " + models.size() + " rows for " + identity.getFQN());
            } else {
                message.append(WebServerBundle.INFO_NOMORE_FETCHDATA);
            }
            logger.info((Object)message);
            return models;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new FMDB2Exception(WebServerBundle.ERROR_FETCH_ROWSET_FAILED, e);
        }
    }

    private List<RowModel> fetchNext(ObjectIdentity identity, List<ColumnModel> columnModels) throws FMDB2Exception {
        return this.getRowData(WebServerCommand.FETCH_NEXT, identity, columnModels, null);
    }

    private List<RowModel> getRowData(WebServerCommand cmd, ObjectIdentity identity, List<ColumnModel> columnModels, String query) throws FMDB2Exception {
        ArrayList<RowModel> models = new ArrayList<RowModel>();
        CachedRowSet crs = null;
        try {
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            inputs.put("PAGE_SIZE", (Integer)Context.get(Context.Keys.PAGINATION_COUNT));
            inputs.put("SSID", identity.getSsid());
            inputs.put("UUID", identity.getFQN());
            if (cmd.equals((Object)WebServerCommand.FETCH_DATA)) {
                inputs.put("SQL", query);
            }
            if ((crs = (CachedRowSet)this.server.execute(cmd, inputs)) != null) {
                ResultSetMetaData metaData = crs.getMetaData();
                ResultSet resultSet = crs.getOriginal();
                if (resultSet != null) {
                    int idx = 1;
                    while (resultSet.next()) {
                        ArrayList<Object> data = new ArrayList<Object>();
                        int i = 1;
                        while (i <= metaData.getColumnCount()) {
                            String colType = columnModels.get(i - 1).getColType();
                            Object o = resultSet.getObject(i);
                            if (DataTypeUtils.isDate(colType) || DataTypeUtils.isTime(colType) || DataTypeUtils.isTimestamp(colType) || DataTypeUtils.isTimeSTZ(colType)) {
                                o = resultSet.getString(i);
                                o = o != null ? o.toString().trim() : o;
                            }
                            data.add(o);
                            ++i;
                        }
                        models.add(new RowModel(idx++, data.toArray()));
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(identity + " : fetched " + models.size() + " rows"));
            }
            this.closeCachedRowSet(identity, models);
            return models;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new FMDB2Exception(WebServerBundle.ERROR_FETCH_ROWSET_FAILED, e);
        }
    }

    private String convertTimeStampformat(Object o) {
        if (o != null) {
            String s = o.toString().replace(':', '.').replace(' ', '-');
            return s;
        }
        return null;
    }

    @Override
    public List<ColumnModel> updateColumnModelsWithXnetData(ObjectIdentity identity, List<ColumnModel> columnModels) {
        return columnModels;
    }

    @Override
    public Map<Integer, List<Object>> fetchUniqueConstraints(ObjectIdentity identity) throws FMDB2Exception {
        HashMap<Integer, List<Object>> cons = new HashMap<Integer, List<Object>>();
        try {
            String creator = CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity) || CommonUtils.isView(identity) ? identity.getTbcreator() : identity.getCreator();
            String objectName = CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity) || CommonUtils.isView(identity) ? identity.getTbname() : identity.getObjectName();
            objectName = CommonUtils.escapeSpecialCharacters(objectName);
            String sql = "SELECT CONSTNAME,TYPE FROM SYSIBM.SYSTABCONST where TBNAME='" + objectName + "' and TBCREATOR='" + creator + "'";
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            logger.info((Object)sql);
            inputs.put("SQL", sql);
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.FETCH_UNIQUE_CONST, inputs);
            ArrayList<ConstraintModel> models = new ArrayList<ConstraintModel>();
            int index = 1;
            while (crs.next()) {
                ConstraintModel model = new ConstraintModel();
                model.setName(crs.getString(index++));
                model.setType(crs.getString(index++));
                models.add(model);
                index = 1;
            }
            if (!models.isEmpty()) {
                cons.put(new Integer(1), models);
            }
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FMDB2Exception(WebServerBundle.ERROR_QUERY_UNIQUE_CONSTRAINTS_FAILED, e);
        }
        return cons;
    }

    @Override
    public boolean releaseConnections() {
        return false;
    }

    @Override
    public Map<String, Integer> insert(ObjectIdentity identity, String sql) throws FMDB2Exception {
        try {
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            LinkedHashMap<String, Integer> generatedKeys = new LinkedHashMap<String, Integer>();
            logger.info((Object)sql);
            inputs.put("SQL", sql);
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.INSERT_ROWS, inputs);
            if (crs != null) {
                ResultSetMetaData metaData = crs.getMetaData();
                ResultSet resultSet = crs.getOriginal();
                String[] columnNames = new String[metaData.getColumnCount()];
                int i = 0;
                while (i < metaData.getColumnCount()) {
                    columnNames[i] = metaData.getColumnName(i + 1);
                    ++i;
                }
                if (resultSet != null) {
                    while (resultSet.next()) {
                        String[] stringArray = columnNames;
                        int n = columnNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String column = stringArray[n2];
                            Object o = resultSet.getObject(column);
                            if (o != null) {
                                generatedKeys.put(column, (Integer)o);
                            }
                            ++n2;
                        }
                    }
                }
            }
            return generatedKeys;
        }
        catch (Exception e) {
            logger.error((Object)("Insert operation failed for " + identity), (Throwable)e);
            throw new FMDB2Exception(e.getMessage());
        }
    }

    @Override
    public void update(ObjectIdentity identity, String sql) throws FMDB2Exception {
        try {
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            logger.info((Object)sql);
            inputs.put("SQL", sql);
            Object returnValue = this.server.execute(WebServerCommand.UPDATE_ROWS, inputs);
            logger.debug((Object)("RETURN_VALUE for UPDATE : " + returnValue));
            if ((Integer)returnValue == 0) {
                throw new FMDB2Exception("Update Failed. Data out of Sync with DB2.");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Update operation failed for " + identity), (Throwable)e);
            throw new FMDB2Exception(e.getMessage());
        }
    }

    @Override
    public boolean delete(ObjectIdentity identity, String sql) throws FMDB2Exception {
        try {
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            logger.info((Object)sql);
            inputs.put("SQL", sql);
            Object returnValue = this.server.execute(WebServerCommand.DELETE_ROWS, inputs);
            logger.debug((Object)("RETURN_VALUE for DELETE : " + returnValue));
            if ((Integer)returnValue == 0) {
                throw new FMDB2Exception("Delete failed. Data out of Sync with DB2.");
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Delete operation failed for " + identity), (Throwable)e);
            throw new FMDB2Exception(e.getMessage());
        }
    }

    @Override
    public Object execute(ObjectIdentity identity, String sql, boolean isSelect, Integer paginationCount) throws Exception {
        return null;
    }

    @Override
    public List<SubsystemNode> getSubsystems(LparNode lpar, boolean onDemandLoading) throws FMDB2Exception {
        try {
            ArrayList<SubsystemNode> subsystems = new ArrayList<SubsystemNode>();
            List subsystemNames = (List)this.server.execute(WebServerCommand.FETCH_SUBSYSTEMS, null);
            Context.put(Context.Keys.ACTIVE_SUBSYSTEMS, subsystemNames.toArray(new String[subsystemNames.size()]));
            for (String s : subsystemNames) {
                if (s == null) continue;
                subsystems.add(new SubsystemNode(s, lpar));
            }
            return subsystems;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new FMDB2Exception(e.getMessage());
        }
    }

    @Override
    public List<LparNode> getLpars() {
        ArrayList<LparNode> lparNodes = new ArrayList<LparNode>();
        LparNode node = new LparNode(Context.getInstance().getLpar());
        lparNodes.add(node);
        return lparNodes;
    }

    @Override
    public List<DBObject> getDBObjects(SubsystemNode subsystem, String condition, ArrayList<DBObjectType> objectTypes) throws FMDB2Exception {
        ArrayList<DBObject> dbObjects = new ArrayList(1000);
        try {
            if (!this.ssidCache.containsKey(subsystem.getName())) {
                this.executeDDF(subsystem.getName());
            }
            StringBuffer sql = new StringBuffer();
            StringBuffer objTypes = new StringBuffer();
            if (objectTypes.contains((Object)DBObjectType.TABLE)) {
                objTypes.append("'T'");
            }
            if (objectTypes.contains((Object)DBObjectType.TABLE) && objectTypes.contains((Object)DBObjectType.VIEW)) {
                objTypes.append(",");
                objTypes.append("'V'");
            } else if (objectTypes.contains((Object)DBObjectType.VIEW)) {
                objTypes.append("'V'");
            }
            if ((objectTypes.contains((Object)DBObjectType.TABLE) || objectTypes.contains((Object)DBObjectType.VIEW)) && objectTypes.contains((Object)DBObjectType.ALIAS)) {
                objTypes.append(",");
                objTypes.append("'A'");
            } else if (objectTypes.contains((Object)DBObjectType.ALIAS)) {
                objTypes.append("'A'");
            }
            sql.append("(SELECT  NAME, CREATOR, TYPE, TBCREATOR, TBNAME, LOCATION FROM SYSIBM.SYSTABLES WHERE TYPE IN (##N##) AND ##CONDITION##)".replace("##CONDITION##", condition).replace("##N##", objTypes));
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(subsystem.getName()));
            logger.info((Object)sql.toString());
            inputs.put("SQL", sql.toString());
            inputs.put("SSID", subsystem.getName());
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.GET_DBOBJECTS, inputs);
            int Objsize = crs.size();
            logger.debug((Object)("Objects size is" + Objsize));
            dbObjects = DSEUtils.prepareDBObjects(subsystem.getLpar().getName(), subsystem.getName(), crs);
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)WebServerBundle.ERROR_QUERY_OBJECT_FAILED, (Throwable)e);
            throw new FMDB2Exception(e.getMessage(), e);
        }
        return dbObjects;
    }

    @Override
    public List<String> getDependencyOnSingleTable(ObjectIdentity identity) throws FMDB2Exception {
        try {
            String creator = CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity) ? identity.getTbcreator() : identity.getCreator();
            String objectName = CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity) ? identity.getTbname() : identity.getObjectName();
            String CHECK_SYSVIEW_DEP = "SELECT BTYPE,BNAME,BCREATOR FROM SYSIBM.SYSVIEWDEP WHERE DCREATOR = '" + creator + "' AND DNAME = '" + objectName + "'";
            logger.info((Object)CHECK_SYSVIEW_DEP);
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            inputs.put("SQL", CHECK_SYSVIEW_DEP);
            inputs.put("SSID", identity.getSsid());
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.DEPENDENCY_ON_SINGLE_TABLE, inputs);
            ResultSetMetaData metaData = crs.getMetaData();
            ResultSet resultSet = crs.getOriginal();
            if ((CommonUtils.isAlias(identity) || CommonUtils.isSynonym(identity)) && crs == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> viewDeps = new ArrayList<String>();
            if (crs != null && resultSet != null && metaData != null) {
                while (resultSet.next()) {
                    int i = 0;
                    while (i < metaData.getColumnCount()) {
                        String column = metaData.getColumnName(i + 1);
                        viewDeps.add(resultSet.getString(column));
                        ++i;
                    }
                }
            }
            if (viewDeps != null && !viewDeps.isEmpty() && ((String)viewDeps.get(0)).equals(DBObjectType.TABLE.getType().toString())) {
                return viewDeps;
            }
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FMDB2Exception(WebServerBundle.ERROR_QUERY_DEPENDENT_ON_SINGLETABLE_FAILED, e);
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties(ObjectIdentity identity) throws FMDB2Exception {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer = CommonUtils.isView(identity) ? new StringBuffer("SELECT NAME,CREATOR,SEQNO,CHECK,IBMREQD,TEXT,PATHSCHEMAS,RELCREATED,TYPE,REFRESH,ENABLE,MAINTENANCE,REFRESH_TIME,ISOLATION,SIGNATURE,APP_ENCODING_CCSID,OWNER,OWNERTYPE,ENVID FROM ").append(this.getCatalogTable(identity.getObjectType())) : new StringBuffer("SELECT * FROM ").append(this.getCatalogTable(identity.getObjectType()));
            buffer.append(" WHERE ");
            buffer.append("NAME").append("=").append(QueryUtils.encloseInSingleQuotes(identity.getObjectName()));
            buffer.append(" AND ");
            buffer.append("CREATOR").append("=").append(QueryUtils.encloseInSingleQuotes(identity.getCreator()));
            if (!CommonUtils.isSynonym(identity)) {
                buffer.append(" AND ");
                buffer.append("TYPE").append("=").append(QueryUtils.encloseInSingleQuotes(identity.getObjectType().getType()));
            }
            String sql = buffer.toString();
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            inputs.put("SQL", sql);
            inputs.put("SSID", identity.getSsid());
            logger.info((Object)sql);
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.GET_PROPERTIES, inputs);
            ResultSetMetaData metaData = crs.getMetaData();
            ResultSet resultSet = crs.getOriginal();
            if (crs != null && resultSet != null && metaData != null) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                while (resultSet.next()) {
                    int i = 0;
                    while (i < metaData.getColumnCount()) {
                        String column = metaData.getColumnName(i + 1);
                        if (!this.isOfTypeBitData(metaData.getColumnTypeName(i + 1))) {
                            map.put(column, resultSet.getString(column));
                        }
                        ++i;
                    }
                }
                return map;
            }
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new FMDB2Exception(WebServerBundle.ERROR_OBJECT_PROPERTIES_FAILED, e);
        }
        return Collections.emptyMap();
    }

    private boolean isOfTypeBitData(String dataType) {
        return "CHAR FOR BIT DATA".equals(dataType) || "VARCHAR FOR BIT DATA".equals(dataType);
    }

    @Override
    public boolean isLicensed() {
        return false;
    }

    @Override
    public Map<String, Object> getColumnProperties(ObjectIdentity identity, String columnName) throws FMDB2Exception {
        try {
            StringBuffer buffer = new StringBuffer("SELECT * FROM ").append("SYSIBM.SYSCOLUMNS");
            buffer.append(" WHERE ");
            buffer.append("NAME").append("=").append(QueryUtils.encloseInSingleQuotes(columnName));
            buffer.append(" AND ");
            buffer.append("TBNAME").append("=").append(QueryUtils.encloseInSingleQuotes(CommonUtils.getObjectName(identity)));
            buffer.append(" AND ");
            buffer.append("TBCREATOR").append("=").append(QueryUtils.encloseInSingleQuotes(CommonUtils.getCreator(identity)));
            String sql = buffer.toString();
            logger.info((Object)sql);
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            inputs.put("SQL", sql);
            inputs.put("SSID", identity.getSsid());
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.GET_COLUMN_PROPERTIES, inputs);
            ResultSetMetaData metaData = crs.getMetaData();
            ResultSet resultSet = crs.getOriginal();
            if (crs != null && resultSet != null && metaData != null) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                while (resultSet.next()) {
                    int i = 0;
                    while (i < metaData.getColumnCount()) {
                        String column = metaData.getColumnName(i + 1);
                        if (!this.isOfTypeBitData(metaData.getColumnTypeName(i + 1))) {
                            map.put(column, resultSet.getString(column));
                        }
                        ++i;
                    }
                }
                return map;
            }
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)WebServerBundle.ERROR_COLUMN_PROPERTIES_FAILED, (Throwable)e);
            throw new FMDB2Exception(WebServerBundle.ERROR_COLUMN_PROPERTIES_FAILED, e);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<ColumnModel> getColumns(ObjectIdentity identity) throws FMDB2Exception {
        try {
            String sql = "SELECT  NAME, COLNO, COLTYPE, LENGTH, SCALE, NULLS, DEFAULTVALUE, FOREIGNKEY, DATATYPEID, TYPENAME, DEFAULT, UPDATES  FROM  SYSIBM.SYSCOLUMNS";
            StringBuffer buffer = new StringBuffer(sql).append(" WHERE ");
            buffer.append("TBNAME").append("=").append(QueryUtils.encloseInSingleQuotes(CommonUtils.getObjectName(identity)));
            buffer.append(" AND ");
            buffer.append("TBCREATOR").append("=").append(QueryUtils.encloseInSingleQuotes(CommonUtils.getCreator(identity)));
            buffer.append(" ").append("ORDER BY").append(" COLNO");
            sql = buffer.toString();
            logger.info((Object)sql);
            Map<String, Object> inputs = this.getInputParams(this.ssidCache.get(identity.getSsid()));
            inputs.put("SQL", sql);
            inputs.put("SSID", identity.getSsid());
            CachedRowSet crs = (CachedRowSet)this.server.execute(WebServerCommand.GET_COLUMNS, inputs);
            if (crs == null) {
                String msg = CommonUtils.isAlias(identity) ? "Underlying object " : "Object ";
                String objectName = CommonUtils.isAlias(identity) ? identity.getTbname() : identity.getObjectName();
                throw new FMDB2Exception(String.valueOf(msg) + objectName + " doesn't exist.");
            }
            ArrayList<ColumnModel> models = new ArrayList<ColumnModel>();
            int index = 1;
            while (crs.next()) {
                ColumnModel model = new ColumnModel();
                model.setName(crs.getString(index++));
                model.setColNo(crs.getShort(index++));
                model.setColType(crs.getString(index++).trim());
                model.setLength(crs.getShort(index++));
                model.setScale(crs.getShort(index++));
                model.setNulls(crs.getString(index++));
                model.setDefaultValue(crs.getString(index++));
                model.setForeignKey(crs.getString(index++));
                model.setDataTypeId(crs.getInt(index++));
                model.setTypename(crs.getString(index++));
                model.setDefault(crs.getString(index++));
                model.setUpdates(crs.getString(index++));
                models.add(model);
                index = 1;
            }
            return models;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Problem while to identify the columns of " + identity), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public HashMap<Integer, List<Object>> fetchMore(ObjectIdentity identity) throws FMDB2Exception {
        return null;
    }

    @Override
    public void loadDECPProperties(String ssid) throws FMDB2Exception {
        block6: {
            try {
                if (Context.getDECPPropertiesCache().containsKey(ssid)) break block6;
                logger.debug((Object)("ssid : " + ssid));
                try {
                    HashMap<String, Object> inputs = new HashMap<String, Object>();
                    inputs.put("SSID", ssid);
                    Map decpProps = (Map)this.server.execute(WebServerCommand.GET_DECP, inputs);
                    if (decpProps.isEmpty()) {
                        throw new FMDB2Exception(WebServerBundle.ERROR_SUBSYSTEM_DECP_FAILED);
                    }
                    Context.getDECPPropertiesCache().put(ssid, decpProps);
                }
                catch (FMDB2Exception e) {
                    logger.error((Object)e);
                    throw e;
                }
            }
            catch (FMDB2Exception e) {
                logger.error((Object)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new FMDB2Exception(WebServerBundle.ERROR_LOADING_DECP_FAILED, e);
            }
        }
    }

    private String getCatalogTable(DBObjectType objectType) {
        switch (objectType) {
            case TABLE: 
            case ALIAS: {
                return "SYSIBM.SYSTABLES";
            }
            case VIEW: {
                return "SYSIBM.SYSVIEWS";
            }
            case SYNONYM: {
                return "SYSIBM.SYSSYNONYMS";
            }
        }
        return "SYSIBM.SYSTABLES";
    }

    private void printResultSet(CachedRowSet rs) {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String> columns = new ArrayList<String>();
            int i = 0;
            while (i < columnCount) {
                columns.add(metaData.getColumnName(i + 1));
                ++i;
            }
            System.out.println(columns);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> executeDDF(String ssid) throws FMDB2Exception {
        try {
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("SSID", ssid);
            Map ssidProps = (Map)this.server.execute(WebServerCommand.EXECUTE_DDF, inputs);
            if (ssidProps.isEmpty()) {
                throw new FMDB2Exception(WebServerBundle.ERROR_DDFREPORT_FAILED);
            }
            this.ssidCache.put(ssid, ssidProps);
            return ssidProps;
        }
        catch (FMDB2Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Map<String, Object> getInputParams(Map<String, String> ssidProps) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("SSID_LOCATION", ssidProps.get("SSID_LOCATION"));
        inputs.put("SSID_PORT", ssidProps.get("SSID_PORT"));
        inputs.put("HOST_NAME", ssidProps.get("HOST_NAME"));
        inputs.put("SQLID", Context.getInstance().getActiveSQLID());
        Context.getInstance().setActiveSQLID(null);
        return inputs;
    }

    private void closeCachedRowSet(ObjectIdentity identity, List<RowModel> rowModels) {
        if (rowModels.size() < (Integer)Context.get(Context.Keys.PAGINATION_COUNT)) {
            try {
                this.closeCachedRowSet(identity);
                logger.info((Object)"No more data in the Object");
            }
            catch (FMDB2Exception e) {
                logger.error((Object)WebServerBundle.ERROR_CLOSE_ROWSET_FAILED);
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

