/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.core;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.core.WebServerCommand;
import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.i18n.WebServerBundle;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.testingtools.common.FMDB2ServerException;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.FMDB2ServerConnect;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebServer {
    private static final Logger logger = Logger.getLogger(WebServer.class);
    private static final String SERVICE_VALIDATE_CREDENTIALS = "testingtools/validate";
    private static final String SERVICE_FMDB2 = "filemaster/fmp";
    private static final String PRODUCT = "product";
    private static final String FMDB2 = "fmdb2";
    private static final String _UUID = "uuid";
    private static final String USER = "user";
    private static final String EPASSW = "epassw";
    private static final String TT_SERVER_NAME = "FMDB2";
    private String host;
    private int port;
    private String userId;
    private String password;
    private String sessionId;

    private WebServer() {
    }

    public WebServer(String userId, String password, String host, int port) {
        this();
        this.host = host;
        this.port = port;
        this.userId = userId;
        this.password = password;
    }

    public boolean authenticate() throws FMDB2Exception {
        long startTime = System.currentTimeMillis();
        try {
            try {
                TTServer server = this.getTTServer();
                HashMap<String, Object> inputs = new HashMap<String, Object>();
                inputs.put(USER, this.userId);
                inputs.put(EPASSW, HexUtil.encryptPassword((String)this.userId, (String)this.password));
                XMLRequest response = this.execute(server, SERVICE_VALIDATE_CREDENTIALS, WebServerCommand.CHECK, inputs, false);
                this.checkErrorDuringAuthentication(this.getNodeList(response, "Signon"));
                logger.info((Object)WebServerBundle.INFO_AUTHENTICATION_SUCCESSFUL);
            }
            catch (FMDB2Exception e) {
                throw e;
            }
            catch (Exception e) {
                throw new FMDB2Exception(WebServerBundle.ERROR_AUTHENTICATION_FAILED, e);
            }
        }
        finally {
            CommonUtils.printExecutionTime(" Athentication completed in : ", System.currentTimeMillis() - startTime);
        }
        return true;
    }

    private TTServer getTTServer() {
        String _UUID = UUID.randomUUID().toString();
        TTServer ttServer = new TTServer(TT_SERVER_NAME, this.host, String.valueOf(this.port), _UUID);
        return ttServer;
    }

    private XMLRequest execute(TTServer ttServer, String service, WebServerCommand command, Map<String, Object> inputs, boolean doSignon) throws FMDB2Exception {
        try {
            ServerConnect serverConnect = new ServerConnect(ttServer, service);
            inputs.put(PRODUCT, FMDB2);
            XMLRequest response = serverConnect.connect(command.value(), inputs, false);
            return response;
        }
        catch (TTException tte) {
            throw new FMDB2Exception(tte.getMessage(), tte);
        }
        catch (Exception e) {
            throw new FMDB2Exception(e);
        }
    }

    private void checkErrorDuringAuthentication(NodeList elements) throws FMDB2Exception {
        int index = 0;
        while (index < elements.getLength()) {
            Element element = (Element)elements.item(index);
            String value = element.getAttribute("errorlevel");
            int error = 0;
            try {
                error = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
            if (error > 0) {
                String errorMessage = element.getAttribute("msg");
                logger.error((Object)(String.valueOf(error) + " - " + errorMessage));
                throw new FMDB2Exception(WebServerBundle.ERROR_AUTHENTICATION_FAILED);
            }
            ++index;
        }
    }

    private NodeList getNodeList(XMLRequest response, String tagName) throws FMDB2Exception {
        try {
            return response.getCommand().getElementsByTagName(tagName);
        }
        catch (Exception e) {
            throw new FMDB2Exception("Error while parsing Response XML", e);
        }
    }

    public boolean initializeSession() throws FMDB2Exception {
        long startTime = System.currentTimeMillis();
        try {
            TTServer server = this.getTTServer();
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put(USER, this.userId);
            inputs.put(EPASSW, HexUtil.encryptPassword((String)this.userId, (String)this.password));
            XMLRequest response = this.execute(server, SERVICE_FMDB2, WebServerCommand.SESSION, inputs, false);
            this.setSessionId(response.getCommand().getAttribute(_UUID));
            logger.info((Object)WebServerBundle.bind((String)WebServerBundle.INFO_SESSION_INITIALIZED, (Object)this.sessionId));
            return true;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new FMDB2Exception("Unable to establish session. Kindly check log for more details.", e);
        }
        finally {
            CommonUtils.printExecutionTime(" Session established in : ", System.currentTimeMillis() - startTime);
        }
    }

    public boolean destroySession() throws FMDB2Exception {
        long startTime = System.currentTimeMillis();
        try {
            TTServer server = this.getTTServer();
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put(_UUID, this.sessionId);
            this.execute(server, SERVICE_FMDB2, WebServerCommand.CANCEL, inputs, false);
            return true;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new FMDB2Exception(e.getMessage());
        }
        finally {
            CommonUtils.printExecutionTime(" Logout executed in : ", System.currentTimeMillis() - startTime);
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Object execute(WebServerCommand command, Map<String, Object> inputs) throws FMDB2Exception {
        long startTime = System.currentTimeMillis();
        try {
            TTServer server = this.getTTServer();
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put(USER, this.userId);
            requestParams.put(EPASSW, HexUtil.encryptPassword((String)this.userId, (String)this.password));
            requestParams.put(_UUID, this.sessionId);
            FMDB2ServerConnect fmdb2ServerConnect = new FMDB2ServerConnect(server, SERVICE_FMDB2);
            requestParams.put(PRODUCT, FMDB2);
            Object object = fmdb2ServerConnect.connect(command.value(), requestParams, inputs);
            return object;
        }
        catch (FMDB2ServerException e) {
            String errMsg = e.getMessage();
            if (errMsg.startsWith("Invalid Session")) {
                errMsg = CommonBundle.INVALID_SEESION;
            }
            throw new FMDB2Exception(errMsg);
        }
        catch (Exception e) {
            throw new FMDB2Exception(e.getMessage());
        }
        finally {
            CommonUtils.printExecutionTime((Object)((Object)command) + " executed in : ", System.currentTimeMillis() - startTime);
        }
    }
}

