/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor;

import com.ca.db2.editor.DPAAbstractSessionHandler;
import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.views.DSEView;
import com.ca.db2.editor.views.DWView;
import com.ca.db2.editor.views.PropertiesView;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class DPASessionHandler
extends DPAAbstractSessionHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(DPASessionHandler.class);
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();

    @Override
    public void dpaLogin(String string) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DPASessionHandler.this.clearConsole();
                    DPASessionHandler.this.postLogin();
                }
                catch (Exception e) {
                    logger.error((Object)"Problem while login:", (Throwable)e);
                }
            }
        });
    }

    @Override
    public boolean dpaLogout() {
        DSEView dseView;
        block5: {
            DWView dwView;
            block4: {
                dwView = DWUtils.getView();
                dseView = DSEUtils.getView();
                if (dwView != null && dseView != null) break block4;
                return true;
            }
            boolean canUserLogout = dwView.canLogout();
            if (canUserLogout) break block5;
            return false;
        }
        try {
            dseView.onLogout();
            this.dataSourceHandler.logout();
            CommonUtils.hideView("ChangeManagerView");
            CommonUtils.hideView(PropertiesView.ID);
        }
        catch (Exception e) {
            logger.error((Object)"Problem while logout:", (Throwable)e);
        }
        return true;
    }

    private void clearConsole() {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = consolePlugin.getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if ("".equals(consoles[i].getName())) {
                ((MessageConsole)consoles[i]).clearConsole();
            }
            ++i;
        }
    }

    private void postLogin() {
        DSEUtils.getView().onLogin();
    }
}

