/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.common;

import com.ca.fmp.ims.common.Activator;
import com.ca.fmp.ims.common.FMXMLProfile;
import com.ca.fmp.ims.common.FileMasterPreferences;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FMServerTreeModel
extends PropertyChangeManager
implements IPropertyChangeListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected static final String NAME = "name";
    protected static final String TREE_FILE = "com.ca.testingtools.TREE_FILE";
    private static FMServerTreeModel model = null;
    private ArrayList<String> order = new ArrayList();
    private HashMap<String, IConfigurationElement> elementlist;
    private final ArrayList<TT_TreeItem> servers = new ArrayList();
    protected FMXMLProfile profiles;
    protected String XMLPathName;
    private static final int MOVEUP = 0;
    private static final int MOVEDOWN = 1;
    public HashMap<Integer, TT_TreeItem> dlistMap = new HashMap();

    public FMServerTreeModel() {
        this.loadPlugins();
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getString(TREE_FILE);
        if (filename == null || filename.isEmpty()) {
            filename = FMServerTreeModel.setFileName();
        }
        IPath propertyPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        this.XMLPathName = propertyPath.append(filename).toOSString();
        File pFile = new File(this.XMLPathName);
        if (pFile.exists()) {
            try {
                this.profiles = new FMXMLProfile(pFile);
                Element[] elementArray = this.profiles.getServers();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element server = elementArray[n2];
                    try {
                        this.insertServer(server);
                    }
                    catch (IOException e) {
                        this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
                    }
                    ++n2;
                }
            }
            catch (TTException e) {
                String newFileName = String.valueOf(filename) + ".bad";
                String newXMLPathName = propertyPath.append(newFileName).toOSString();
                File newFile = new File(newXMLPathName);
                pFile.renameTo(newFile);
                this.log.log(Level.WARNING, e.getErrorMessage());
                this.profiles = new FMXMLProfile();
            }
        } else {
            this.profiles = new FMXMLProfile();
        }
    }

    public static String setFileName() {
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getDefaultString("DEFAULT_FM_FILE_NAME");
        SimpleDateFormat dflocaltime = new SimpleDateFormat("yyyyMMddHHmmss");
        String ts = dflocaltime.format(new Date());
        filename = filename.replace(".", "." + ts + ".");
        store.setValue(TREE_FILE, filename);
        try {
            store.save();
        }
        catch (IOException iOException) {}
        return filename;
    }

    protected void loadPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("com.ca.testingtools.profile");
        this.elementlist = new HashMap(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (name.equals("seperator")) {
                this.locate(element);
            } else {
                this.elementlist.put(element.getAttribute("id"), element);
            }
            ++n2;
        }
        for (IConfigurationElement element : this.elementlist.values()) {
            this.locate(element);
        }
        Iterator<String> iterator = this.order.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (this.elementlist.containsKey(key)) continue;
            iterator.remove();
        }
    }

    public void save() {
        File backUppFile = null;
        try {
            backUppFile = new File(this.XMLPathName);
            this.profiles.toFile(this.XMLPathName);
            new File(this.XMLPathName);
        }
        catch (TTException e) {
            try {
                this.profiles = new FMXMLProfile(backUppFile);
                this.profiles.toFile(this.XMLPathName);
            }
            catch (TTException e1) {
                e1.printStackTrace();
            }
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public void dispose() {
        for (TT_TreeItem item : this.servers) {
            item.removeListener((IPropertyChangeListener)this);
        }
        this.save();
        model = null;
    }

    public TT_TreeItem insertServer(Element serverElement) throws IOException {
        FileMasterServer server = new FileMasterServer(serverElement);
        server.addPropertyChangeListener(this);
        TT_TreeItem serverItem = new TT_TreeItem(serverElement, (ITreeWrappedItem)server, server.getName());
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "com.ca.testingtools.server", null, (Object)serverItem);
        this.updateModelPrefs(serverElement, server);
        this.servers.add(serverItem);
        this.dlistMap.put(server.getUUIDString().hashCode(), serverItem);
        this.firePropertyChange(event);
        return serverItem;
    }

    protected void insertProfiles(Element serverElement, TT_TreeItem parent) {
        Element[] profileList;
        Element[] elementArray = profileList = this.profiles.getProfiles(serverElement);
        int n = profileList.length;
        int n2 = 0;
        while (n2 < n) {
            Element profile = elementArray[n2];
            this.insertProfile(parent, profile);
            ++n2;
        }
    }

    public TT_TreeItem insertProfile(TT_TreeItem parent, Element profile) {
        FileMasterServer server = (FileMasterServer)parent.getValue();
        String name = profile.getAttribute(NAME);
        Profile profileObject = new Profile();
        TT_TreeItem profileItem = new TT_TreeItem(profile, (ITreeWrappedItem)profileObject, name);
        parent.addChild(profileItem);
        for (String key : this.order) {
            IConfigurationElement nodeConfig = this.elementlist.get(key);
            ProfileNode node = null;
            try {
                node = (ProfileNode)nodeConfig.createExecutableExtension("class");
                node.setInitializationData(nodeConfig, "config", (Object)node);
                node.setInitializationData(nodeConfig, "server", (Object)server);
                String id = nodeConfig.getAttribute("id");
                Element profileNodeElement = this.profiles.getProfileNode(profile, id);
                if (profileNodeElement == null) {
                    profileNodeElement = this.createElement("profilenode");
                    profile.appendChild(profileNodeElement);
                }
                node.setInitializationData(nodeConfig, "settings", (Object)profileNodeElement);
                TT_TreeItem nodeItem = new TT_TreeItem(profileNodeElement, (ITreeWrappedItem)node, node.getName());
                node.setParent(nodeItem);
                profileItem.addChild(nodeItem);
                NodeList nodeChildren = profileNodeElement.getElementsByTagName("nodechild");
                int ix = 0;
                while (ix < nodeChildren.getLength()) {
                    this.insertNodeChild(nodeItem, (Element)nodeChildren.item(ix));
                    ++ix;
                }
            }
            catch (CoreException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return profileItem;
    }

    public TT_TreeItem insertNodeChild(TT_TreeItem parent, Element nodechild) {
        ProfileNode profileNode = (ProfileNode)parent.getValue();
        String name = nodechild.getAttribute(NAME);
        NodeChild nodechildObject = profileNode.buildChild();
        TT_TreeItem nodechildItem = new TT_TreeItem(nodechild, (ITreeWrappedItem)nodechildObject, name);
        parent.addChild(nodechildItem);
        return nodechildItem;
    }

    public TT_TreeItem findObject(Object object) {
        TT_TreeItem result = null;
        for (TT_TreeItem node : this.servers) {
            result = node.findValue(object);
            if (result != null) break;
        }
        return result;
    }

    public TT_TreeItem findObjectInTree(Object object, TT_TreeItem treeItem) {
        TT_TreeItem result = null;
        result = this.findObject(treeItem).findValue(object);
        return result;
    }

    public Element addServer(String name, String hostname, int port, String uuidString, String PreferenceIsSet) throws Exception {
        Element top = this.profiles.getTop();
        Element serverElement = FMServerTreeModel.BuildElement(name, hostname, port, uuidString, PreferenceIsSet);
        top.appendChild(serverElement);
        return serverElement;
    }

    public Element addProfile(Element serverElement, String name) {
        Element profile = this.createElement("profile");
        profile.setAttribute(NAME, name);
        profile.setAttribute("UUID", UUID.randomUUID().toString());
        serverElement.appendChild(profile);
        return profile;
    }

    public Element addNodeChild(Element profileNodeElement, String name) {
        Element nodechild = this.createElement("nodechild");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        profileNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addSession(Element profileNodeElement, String uuid, String type, String user) {
        Element nodechild = this.createElement("session");
        nodechild.setAttribute("uuid", uuid);
        nodechild.setAttribute("type", type);
        nodechild.setAttribute("user", user);
        profileNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public TT_TreeItem updateModelPrefs(Element serverElement, FileMasterServer server) {
        String dsnLists = serverElement.getAttribute("DsnLists");
        String selCriteria = serverElement.getAttribute("SelCriteria");
        String custRecLay = serverElement.getAttribute("CustRecLay");
        String segmentXref = serverElement.getAttribute("SegmentXref");
        String environs = serverElement.getAttribute("Environs");
        FileMasterPreferences fmPrefs = new FileMasterPreferences(dsnLists, selCriteria, custRecLay, segmentXref, environs);
        server.setFmpPreferences(fmPrefs);
        return this.findObject((Object)server);
    }

    public Element updatePrefs(Element serverElement, String dsnLists, String selCriteria, String custRecLay, String segmentXref, String environs) {
        serverElement.setAttribute("DsnLists", dsnLists);
        serverElement.setAttribute("SelCriteria", selCriteria);
        serverElement.setAttribute("CustRecLay", custRecLay);
        serverElement.setAttribute("SegmentXref", segmentXref);
        serverElement.setAttribute("Environs", environs);
        return serverElement;
    }

    public static Element BuildElement(String name, String hostname, int port, String uuidString, String PreferenceIsSet) {
        Element element = FMServerTreeModel.getInstance().createElement("com.ca.testingtools.server");
        if (uuidString == null || uuidString.length() == 0) {
            uuidString = UUID.randomUUID().toString();
        }
        element.setAttribute("Name", name);
        element.setAttribute("Host", hostname);
        element.setAttribute("Port", String.valueOf(port));
        element.setAttribute("UUID", uuidString);
        element.setAttribute("PreferenceIsSet", PreferenceIsSet);
        return element;
    }

    public TT_TreeItem removeItem(Object element) {
        TT_TreeItem item = this.findObject(element);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.servers.size() > 0) {
                return this.servers.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public TT_TreeItem removeItem(Object element, TT_TreeItem elementParent) {
        TT_TreeItem item = this.findObjectInTree(element, elementParent);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.servers.size() > 0) {
                return this.servers.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.firePropertyChange(event);
    }

    public static synchronized FMServerTreeModel getInstance() {
        if (model == null) {
            model = new FMServerTreeModel();
        }
        return model;
    }

    public FileMasterServer getServer(String name) {
        for (TT_TreeItem item : this.servers) {
            FileMasterServer server = (FileMasterServer)item.getValue();
            if (server.getUUIDString().equals(name)) {
                return server;
            }
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return server;
        }
        return null;
    }

    private void locate(IConfigurationElement element) {
        Position position;
        String name = element.getName();
        boolean seperator = "seperator".equals(name);
        String ID = element.getAttribute(seperator ? NAME : "id");
        String menuid = element.getAttribute("menuid");
        try {
            position = Position.valueOf(element.getAttribute("menulocation"));
        }
        catch (Exception exception) {
            position = Position.last;
        }
        switch (position) {
            case first: {
                this.order.add(0, ID);
                break;
            }
            case last: {
                this.order.add(ID);
                break;
            }
            case before: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix > this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix, ID);
                break;
            }
            case after: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix >= this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix + 1, ID);
            }
        }
    }

    public FMXMLProfile getProfiles() {
        return this.profiles;
    }

    public Element createElement(String name) {
        return this.profiles.createElement(name);
    }

    public TT_TreeItem[] getServers() {
        return this.servers.toArray(new TT_TreeItem[this.servers.size()]);
    }

    public String getXMLPathName() {
        return this.XMLPathName;
    }

    public int indexOf(TT_TreeItem item) {
        TT_TreeItem parent = item.getParent();
        if (parent == null) {
            return this.servers.indexOf(item);
        }
        TT_TreeItem[] childs = (TT_TreeItem[])parent.getChildren();
        int i = 0;
        while (i < childs.length) {
            if (childs[i].equals((Object)item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TT_TreeItem reposition(Object element, int direction) {
        TT_TreeItem item = this.findObject(element);
        int totalItems = item.getParent().getChildren().length;
        int index = this.indexOf(item);
        if (direction == 0 && index > 0 || direction == 1 && index < totalItems - 1) {
            TT_TreeItem newItem;
            TT_TreeItem oldItem;
            TT_TreeItem parent = item.getParent();
            TT_TreeItem[] children = new TT_TreeItem[parent.getChildren().length];
            int i = 0;
            while (i < parent.getChildren().length) {
                children[i].setName(((TT_TreeItem)parent.getChildren()[i]).getName());
                children[i].setValue(((TT_TreeItem)parent.getChildren()[i]).getValue());
                ++i;
            }
            if (direction == 0) {
                oldItem = children[index - 1];
                children[index - 1] = newItem = children[index];
                children[index] = oldItem;
            } else {
                oldItem = children[index + 1];
                children[index + 1] = newItem = children[index];
                children[index] = oldItem;
            }
            int dsnCount = 0;
            while (dsnCount < children.length) {
                this.removeItem(children[dsnCount].getValue(), parent);
                ++dsnCount;
            }
            this.save();
        }
        return item;
    }

    public boolean isActiveView(IWorkbenchPage activePage, IViewPart view) {
        IWorkbenchPart activeView = activePage.getActivePart();
        return activeView == null ? false : activeView.equals(view);
    }

    public ArrayList<FileMasterSession> getSessions(FileMasterServer server) {
        ArrayList<FileMasterSession> fmSessions = new ArrayList<FileMasterSession>();
        int count = 0;
        while (count < this.profiles.getSessions(server.getElement()).length) {
            FileMasterSession fmSession = new FileMasterSession(this.profiles.getSessions(server.getElement())[count].getAttribute("uuid"), this.profiles.getSessions(server.getElement())[count].getAttribute("type"), this.profiles.getSessions(server.getElement())[count].getAttribute("user"));
            fmSessions.add(fmSession);
            ++count;
        }
        return fmSessions;
    }

    public Element updateserver(Element serverElement, TTServer server, String PreferenceIsSet) {
        serverElement.setAttribute("PreferenceIsSet", PreferenceIsSet);
        return serverElement;
    }

    protected static enum Position {
        first,
        last,
        before,
        after;

    }
}

