/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.wizards;

import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyDigit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class ServerWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private Text name;
    private Text host;
    private Text port;
    private TTServer server = null;
    private ServerTreeModel model = ServerTreeModel.getInstance();
    private boolean newserver = true;
    private boolean changed = false;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.testingtools.help.serverWizardPageNew";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.testingtools.help.serverWizardPageOld";

    public ServerWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription("Specify Server Details");
    }

    public void SetServer(TTServer server) {
        this.server = server;
        this.newserver = server == null;
    }

    public void createControl(Composite parent) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.testingtools");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(two_col, 0);
        label.setText("Name");
        label.setAlignment(131072);
        GridData data = new GridData(32);
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        this.name = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.name.setLayoutData((Object)data);
        label = new Label(two_col, 0);
        label.setText("Host");
        label.setAlignment(131072);
        data = new GridData(32);
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        this.host = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.host.setLayoutData((Object)data);
        label = new Label(two_col, 0);
        label.setText("Port");
        label.setAlignment(131072);
        data = new GridData(32);
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        this.port = new Text(two_col, 2048);
        this.port.setTextLimit(5);
        this.port.setToolTipText(String.format("Port must be number not greater than %d", 65535));
        data = new GridData(768);
        GC gc = new GC((Drawable)this.port);
        try {
            Point extent = gc.textExtent("0");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.port.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.port.setLayoutData((Object)data);
        this.port.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ServerWizardPage.this.port.setSelection(0, ServerWizardPage.this.port.getText().length());
            }

            public void focusLost(FocusEvent e) {
            }
        });
        if (this.newserver) {
            this.name.setText("");
            this.host.setText("");
            this.port.setText(store.getString("DEFAULT_SERVER_PORT"));
        } else {
            this.name.setText(this.server.getName());
            this.host.setText(this.server.getHostname());
            this.port.setText(Integer.toString(this.server.getPort()));
        }
        this.name.addModifyListener((ModifyListener)this);
        this.port.addModifyListener((ModifyListener)this);
        this.host.addModifyListener((ModifyListener)this);
        TextUtil.setWidth(this.name, 30);
        TextUtil.setWidth(this.host, 20);
        if (this.newserver) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.serverWizardPageNew");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.serverWizardPageOld");
        }
        this.setControl((Control)top);
    }

    public void modifyText(ModifyEvent event) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }

    public boolean performUpdate() {
        if (this.newserver) {
            try {
                Element serverElement = this.model.addServer(this.name.getText(), this.host.getText(), Integer.parseInt(this.port.getText()), null);
                TT_TreeItem result = this.model.insertServer(serverElement);
                if (result != null) {
                    this.server = (TTServer)result.getValue();
                }
            }
            catch (NumberFormatException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        } else {
            this.server.setName(this.name.getText());
            this.server.setPort(Integer.parseInt(this.port.getText()));
            this.server.setHostname(this.host.getText());
        }
        if (this.server == null) {
            return false;
        }
        this.model.save();
        return true;
    }

    public boolean isNewserver() {
        return this.newserver;
    }

    public void setNewserver(boolean newserver) {
        this.newserver = newserver;
    }

    public boolean isPageComplete() {
        String connection = this.name.getText().trim();
        if (connection.length() == 0) {
            this.setErrorMessage("Missing Name");
            return false;
        }
        if (this.host.getText().trim().length() == 0) {
            this.setErrorMessage("Missing Host");
            return false;
        }
        String portStr = this.port.getText().trim();
        if (portStr.length() == 0) {
            this.setErrorMessage("Missing Port");
            return false;
        }
        try {
            int port = Integer.parseInt(portStr);
            if (port < 0 || port > 65535) {
                this.setErrorMessage(String.format("Port must be number not greater than %d", 65535));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Port entry must be a number");
            return false;
        }
        TTServer checkit = this.model.getServer(connection);
        if (checkit != null && (this.newserver || checkit != this.server)) {
            this.setErrorMessage("Duplicate Server Name");
            return false;
        }
        this.setErrorMessage(null);
        return this.changed;
    }

    public void widgetSelected(SelectionEvent e) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public TTServer getServer() {
        return this.server;
    }
}

