/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.views.profile;

import com.ca.testingtools.core.ServerStatusJob;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.views.profile.ProfileCheckStateListener;
import com.ca.testingtools.ui.views.profile.ProfileCheckStateProvider;
import com.ca.testingtools.ui.views.profile.ProfileContentProvider;
import com.ca.testingtools.ui.views.profile.ProfileDoubleClickListener;
import com.ca.testingtools.ui.views.profile.ProfileLabelProvider;
import com.ca.testingtools.ui.views.profile.ProfileSorter;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProfileView
extends ViewPart
implements IPropertyChangeListener {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String DESCRIPTION_TEXT = "Use the Refresh Server button\nto update servers' status";
    public static final String ID = "com.ca.testingtools.ui.views.profileview";
    public static final String CONTEXT_HELP_ID = "com.ca.testingtools.help.profileview";
    private CheckboxTreeViewer viewer;
    private ServerTreeModel model = ServerTreeModel.getInstance();

    public void createPartControl(Composite parent) {
        this.viewer = new CheckboxTreeViewer(parent, 68354);
        ProfileCheckStateProvider checkstate = new ProfileCheckStateProvider();
        ProfileContentProvider contentprovider = new ProfileContentProvider(this);
        ProfileLabelProvider labelProvider = new ProfileLabelProvider();
        ProfileCheckStateListener statelistener = new ProfileCheckStateListener();
        ProfileDoubleClickListener doubleClickListener = new ProfileDoubleClickListener();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.viewer.setContentProvider((IContentProvider)contentprovider);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setCheckStateProvider((ICheckStateProvider)checkstate);
        this.viewer.addCheckStateListener((ICheckStateListener)statelistener);
        this.viewer.setSorter((ViewerSorter)new ProfileSorter());
        this.viewer.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        ServerTreeModel.getInstance().addPropertyChangeListener(this);
        control.setMenu(menu);
        menu.addMenuListener(new MenuListener(){
            private boolean buttonShown = true;

            public void menuShown(MenuEvent e) {
                if (this.buttonShown) {
                    Menu menu = (Menu)e.getSource();
                    MenuItem[] menuItems = menu.getItems();
                    String firstMenuItemText = menuItems[0].getText();
                    int once = 1;
                    int i = 1;
                    while (i < menuItems.length) {
                        if (firstMenuItemText.equalsIgnoreCase(menuItems[i].getText())) {
                            int j = i;
                            while (j < menuItems.length) {
                                if (menuItems.length == 3) {
                                    menu.getItem(j).dispose();
                                    menu.getItem(j - 1).dispose();
                                } else {
                                    int k = 1;
                                    MenuItem[] menuItemArray = menu.getItems();
                                    int n = menuItemArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        MenuItem item = menuItemArray[n2];
                                        if (k >= j + 1) {
                                            item.dispose();
                                        } else if (item.getText().equalsIgnoreCase("Add Symbolic") && once == 1) {
                                            item.dispose();
                                            ++once;
                                        }
                                        ++k;
                                        ++n2;
                                    }
                                }
                                ++j;
                            }
                            break;
                        }
                        ++i;
                    }
                    this.buttonShown = false;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.setTitleToolTip(DESCRIPTION_TEXT);
        this.setContentDescription(DESCRIPTION_TEXT);
        TT_TreeItem[] servers = this.model.getServers();
        this.viewer.setInput((Object)servers);
        this.viewer.expandToLevel(2);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        TT_TreeItem[] tT_TreeItemArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem item = tT_TreeItemArray[n2];
            ServerStatusJob job = new ServerStatusJob(item);
            job.schedule();
            ++n2;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        TT_TreeItem obj = this.model.findObject(source);
        final TT_TreeItem item = obj == null ? this.model.findObject(event.getOldValue()) : obj;
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        boolean isServerChange = false;
        if (newValue instanceof TT_TreeItem) {
            boolean bl = isServerChange = ((TT_TreeItem)newValue).getParent() == null;
        }
        if (!isServerChange && oldValue instanceof TT_TreeItem) {
            isServerChange = ((TT_TreeItem)oldValue).getParent() == null;
        }
        final boolean refreshAll = isServerChange;
        Display display = Display.getDefault();
        if (display != null && !this.viewer.getControl().isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (item == null) {
                        if (refreshAll) {
                            ProfileView.this.viewer.setInput((Object)ProfileView.this.model.getServers());
                        } else {
                            ProfileView.this.viewer.refresh(true);
                        }
                    } else {
                        ProfileView.this.viewer.refresh((Object)item, true);
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        TT_TreeItem[] tT_TreeItemArray = this.model.getServers();
        int n = tT_TreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem server = tT_TreeItemArray[n2];
            server.removeListener(this);
            ++n2;
        }
    }
}

