/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.handlers;

import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TT_TreeItemPropertyTester
extends PropertyTester {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final ServerTreeModel model = ServerTreeModel.getInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        TT_TreeItem treeitem = null;
        if (!(receiver instanceof TT_TreeItem)) return false;
        treeitem = (TT_TreeItem)receiver;
        boolean getParent = false;
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj.toString().equalsIgnoreCase("getparent")) {
                getParent = true;
                break;
            }
            ++n2;
        }
        TT_TreeItem result = null;
        if ("isServer".equals(property)) {
            result = treeitem.getParent(TTServer.class);
            if (getParent) {
                if (result == null) return false;
                return true;
            }
            if (result != treeitem) return false;
            return true;
        }
        if ("isProfile".equals(property)) {
            result = treeitem.getParent(Profile.class);
            if (getParent) {
                if (result == null) return false;
                return true;
            }
            if (result != treeitem) return false;
            return true;
        }
        if ("isProfileNode".equals(property)) {
            result = treeitem.getParent(ProfileNode.class);
            if (getParent) {
                if (result == null) return false;
                return true;
            }
            if (result != treeitem) return false;
            return true;
        }
        if ("hasPassword".equals(property)) {
            TTServer server = treeitem.getServer();
            if (server == null) return false;
            if (server.getEPassword().isEmpty()) return false;
            return true;
        }
        if ("isBatchProfileNode".equals(property)) {
            if (!treeitem.getValue().getClass().getName().matches("com.ca.symdump.batch.BatchProfileNode")) return false;
            return true;
        }
        if ("isSystemProfileNode".equals(property)) {
            if (!treeitem.getValue().getClass().getName().matches("com.ca.symdump.system.SystemProfileNode")) return false;
            return true;
        }
        if ("isClass".equals(property)) {
            try {
                String classname = treeitem.getValue().getClass().getName();
                Object[] objectArray2 = args;
                int n3 = args.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        return false;
                    }
                    Object obj = objectArray2[n4];
                    if (obj.toString().equals(classname)) {
                        return true;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {}
            return false;
        }
        if ("isProfileNodeChild".equals(property)) {
            result = treeitem.getParent(NodeChild.class);
            if (getParent) {
                if (result == null) return false;
                return true;
            }
            if (result != treeitem) return false;
            return true;
        }
        if ("isDSN".equals(property)) {
            result = treeitem.getParent(Dataset.class);
            if (getParent) {
                if (result == null) return false;
                return true;
            }
            if (result != treeitem) return false;
            return true;
        }
        if ("isChecked".equals(property)) {
            return treeitem.isChecked();
        }
        if ("isGrayed".equals(property)) {
            return treeitem.isGrayed();
        }
        if ("isTicked".equals(property)) {
            if (treeitem.isGrayed()) return true;
            if (treeitem.isChecked()) return true;
            return false;
        }
        if ("isEmpty".equals(property)) {
            if (model.getServers().length != 0) return false;
            return true;
        }
        if (!"isSiblings".equals(property)) {
            this.log.log(Level.FINE, "Failed test {0} {1}", new Object[]{receiver, property});
            return false;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        ISelection selection = page.getSelection();
        result = treeitem.getParent();
        if (!(selection instanceof TreeSelection)) return false;
        TreeSelection sel = (TreeSelection)selection;
        for (Object obj : sel) {
            if (!(obj instanceof TT_TreeItem)) return false;
            TT_TreeItem next = (TT_TreeItem)obj;
            TT_TreeItem parent = next.getParent();
            if (parent == result) continue;
            return false;
        }
        return true;
    }
}

