/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.Numbers;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IVariable;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.TreeObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.w3c.dom.Element;

public abstract class Variable
extends TreeObject
implements IVariable,
IWatchData {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static final int MAX_OCCURS_DEPTH = 7;
    protected MFAddress backingdataAddress = MFAddress.ZERO_ADDR;
    protected ByteBuffer backingdata = null;
    protected MFAddress address = MFAddress.ZERO_ADDR;
    private String picture = null;
    protected boolean dataClone = false;
    protected Variable baseVariable = null;
    protected int[] levels = new int[7];
    protected int[] gt_incr = new int[7];
    protected int[] index_off = new int[7];
    private Integer datasize;
    protected DataType datatype;
    protected int decimalpoint;
    protected int length;
    protected int level;
    protected int offset;
    protected int baseoffset;
    protected int baselength;
    protected StorageType storagetype;
    protected boolean isVarying;
    protected int stride;
    protected int cell;
    private boolean clean;
    protected IMemoryManager memoryManager;
    protected String programName;
    private int stopStatement;

    public Variable(Element element) throws TTException {
        super(element);
        Arrays.fill(this.levels, 0);
        Arrays.fill(this.gt_incr, 0);
        Arrays.fill(this.index_off, 1);
        this.datasize = null;
        this.datatype = DataType.UNKNOWN;
        this.decimalpoint = new Integer(0);
        this.length = 0;
        this.level = 0;
        this.offset = 0;
        this.baseoffset = 0;
        this.baselength = 0;
        this.storagetype = StorageType.UNKNOWN;
        this.isVarying = false;
        this.stride = 0;
        this.cell = 0;
        this.clean = true;
        this.memoryManager = null;
        this.programName = null;
        if (this.getType() != TreeObject.ObjectType.VARIABLE) {
            throw new TTException("Not a Variable Element");
        }
        this.length = (Integer)Attribute.getValue((String)"length", (Element)element);
        this.baseoffset = (Integer)Attribute.getValue((String)"offset", (Element)element);
        this.offset = (Integer)Attribute.getValue((String)"structureoffset", (Element)element);
        this.level = (Integer)Attribute.getValue((String)"level", (Element)element);
        this.setDatatype();
    }

    public int getDatasize() {
        if (this.datasize == null) {
            this.setDatasize();
        }
        return this.datasize;
    }

    public int getEditSize() {
        int size = this.getDatasize();
        switch (this.datatype) {
            case SIGNED: 
            case UNSIGNED: {
                return size + 2;
            }
        }
        return size;
    }

    public DataType getDatatype() {
        return this.datatype;
    }

    public int getDecimalpoint() {
        return this.decimalpoint;
    }

    public String getValue(byte[] ebytes) {
        this.setDatasize();
        if (ebytes == null) {
            return "";
        }
        try {
            switch (this.datatype) {
                case SIGNED: 
                case UNSIGNED: {
                    BigDecimal decimal;
                    switch (this.storagetype) {
                        case PACK: {
                            decimal = new BigDecimal(Numbers.unpack((byte[])ebytes));
                            break;
                        }
                        case DISPLAY: 
                        case DISPLAY_SIGNED_LEFT: 
                        case DISPLAY_SIGNED_SEPARATE: 
                        case DISPLAY_SIGNED_SEPARATE_LEFT: {
                            decimal = Numbers.formatDisplayNumber((byte[])ebytes);
                            break;
                        }
                        default: {
                            decimal = new BigDecimal(new BigInteger(ebytes));
                        }
                    }
                    if (this.decimalpoint != 0) {
                        decimal = decimal.movePointLeft(this.decimalpoint);
                    }
                    String result = decimal.toPlainString();
                    if (this.datatype == DataType.SIGNED && decimal.signum() == 1) {
                        return "+" + result;
                    }
                    return result;
                }
                case INDEX: {
                    BigDecimal idxDecimal = new BigDecimal(new BigInteger(ebytes));
                    int denominator = (Integer)Attribute.getValue((String)"gt_fsiz", (Properties)this.attributes) + 1;
                    Integer val = idxDecimal.intValue() / denominator + 1;
                    return val.toString();
                }
            }
            if (this.decimalpoint != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(HexUtil.toString((byte[])ebytes, (boolean)true));
                sb.insert(sb.length() - this.decimalpoint, '.');
                return sb.toString();
            }
            String value = this.varyCheck(HexUtil.toString((byte[])ebytes, (boolean)true), true);
            return value;
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, e.getClass().getSimpleName(), e);
            return "";
        }
    }

    public abstract String varyCheck(String var1, boolean var2);

    public String getEditValue() throws Exception {
        return this.getValue(this.getData());
    }

    public String getHexValue(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        return this.length < 9 ? HexUtil.toHex((byte[])bytes, (int)this.length, (char)' ') : HexUtil.toHex((byte[])bytes);
    }

    protected String getHexValue() {
        return this.getHexValue(this.getData());
    }

    public Variable getBaseVariable() {
        if (this.baseVariable == null) {
            this.baseVariable = !(this.parent instanceof Variable) ? this : ((Variable)this.parent).getBaseVariable();
        }
        return this.baseVariable;
    }

    public byte[] getData() {
        this.getBackingdata();
        if (this.backingdata != null) {
            int capacity = this.backingdata.capacity();
            if (capacity == 0 || capacity < this.offset) {
                return null;
            }
            try {
                this.backingdata.position(this.offset);
                int bblength = this.length;
                if (bblength > this.backingdata.remaining()) {
                    bblength = this.backingdata.remaining();
                    this.log.log(Level.WARNING, String.format("Incomplete data available for %1$s", this.getName()));
                }
                byte[] bytes = new byte[bblength];
                this.backingdata.get(bytes);
                return bytes;
            }
            catch (Exception e) {
                this.log.log(Level.FINE, e.getClass().getSimpleName(), e);
                return null;
            }
        }
        return null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public String getPicture() {
        if (this.picture == null) {
            this.picture = this.getAttribute("gt_pic").toUpperCase();
        }
        return this.picture;
    }

    public StorageType getStoragetype() {
        return this.storagetype;
    }

    public abstract boolean canEditDisplay();

    public abstract boolean canEditHex();

    public boolean updateHexValue(String hexvalue) {
        try {
            byte[] newvalue;
            if (this.validateHexValue(hexvalue) && (newvalue = HexUtil.HextoBytes((String)hexvalue)).length < this.length) {
                newvalue = HexUtil.sizeBytes((byte[])newvalue, (int)this.length);
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINE, e.getClass().getSimpleName(), e);
        }
        return true;
    }

    public boolean validateHexValue(String hexvalue) throws Exception {
        byte[] bytes = HexUtil.HextoBytes((String)hexvalue);
        if (bytes != null && bytes.length <= this.length) {
            return true;
        }
        throw new TTException("Invalid Hex String");
    }

    public boolean validateValue(String value) throws Exception {
        String str;
        if (value == null) {
            throw new TTException("NULL String");
        }
        try {
            str = this.getValue();
        }
        catch (Exception exception) {
            str = "";
        }
        if (value.equals(str)) {
            return true;
        }
        switch (this.datatype) {
            case SIGNED: 
            case UNSIGNED: {
                BigDecimal result = Numbers.formatNumber((String)value);
                boolean valid = Numbers.validateNumber((BigDecimal)result, (int)this.decimalpoint, (int)this.getDatasize(), (this.datatype == DataType.SIGNED ? 1 : 0) != 0);
                if (valid && this.storagetype == StorageType.BIN) {
                    result = new BigDecimal(result.unscaledValue());
                    switch (this.length) {
                        case 1: {
                            result.byteValueExact();
                            break;
                        }
                        case 2: {
                            result.shortValueExact();
                            break;
                        }
                        case 4: {
                            result.intValueExact();
                            break;
                        }
                        default: {
                            result.longValueExact();
                        }
                    }
                }
                return valid;
            }
        }
        if (HexUtil.rightTrim((String)value).length() > this.getDatasize()) {
            throw new TTException("Value too Large");
        }
        return true;
    }

    public byte[] getBytesFromString(String value, byte[] inbytes) throws Exception {
        byte[] bytes = null;
        this.validateValue(value);
        boolean signed = this.datatype == DataType.SIGNED;
        block0 : switch (this.datatype) {
            case INDEX: {
                int multiplier = (Integer)Attribute.getValue((String)"gt_fsiz", (Properties)this.attributes) + 1;
                Integer idx = Integer.valueOf(value) - 1;
                idx = idx * multiplier;
                bytes = HexUtil.HextoBytes((String)HexUtil.toHex((int)idx));
                break;
            }
            case SIGNED: 
            case UNSIGNED: {
                BigDecimal result = Numbers.formatNumber((String)value);
                result = result.setScale(this.decimalpoint);
                result.setScale(this.decimalpoint);
                BigInteger integer = result.unscaledValue();
                switch (this.storagetype) {
                    case PACK: {
                        bytes = Numbers.pack((BigInteger)integer, (int)this.length, (boolean)signed);
                        break block0;
                    }
                    case DISPLAY: {
                        bytes = Numbers.buildDisplayNumber((BigInteger)integer, (int)this.length, (boolean)true);
                        break block0;
                    }
                    case DISPLAY_SIGNED_LEFT: {
                        bytes = Numbers.buildDisplayNumber((BigInteger)integer, (int)this.length, (boolean)false);
                        break block0;
                    }
                    case DISPLAY_SIGNED_SEPARATE: {
                        bytes = Numbers.buildDisplayNumberSeparate((BigInteger)integer, (int)(this.length - 1), (boolean)true);
                        break block0;
                    }
                    case DISPLAY_SIGNED_SEPARATE_LEFT: {
                        bytes = Numbers.buildDisplayNumberSeparate((BigInteger)integer, (int)(this.length - 1), (boolean)false);
                        break block0;
                    }
                    case BIN: {
                        String hexstr;
                        String str = HexUtil.toHex((byte[])integer.toByteArray());
                        char ch = value.charAt(0);
                        int lth = str.length() / 2;
                        String pad = "00";
                        if (ch == '-') {
                            pad = "FF";
                        }
                        if (lth < inbytes.length) {
                            StringBuffer sb = new StringBuffer();
                            int i = inbytes.length;
                            while (i > lth) {
                                sb.append(pad);
                                --i;
                            }
                            hexstr = String.valueOf(sb.toString()) + str;
                        } else {
                            hexstr = str;
                        }
                        bytes = HexUtil.HextoBytes((String)hexstr);
                        break block0;
                    }
                }
                bytes = HexUtil.sizeBytes((byte[])integer.toByteArray(), (int)this.length);
                break;
            }
            default: {
                String string = !this.isVarying ? HexUtil.spaceFill((String)value, (int)this.length) : this.varyCheck(value, false);
                if (inbytes == null) {
                    inbytes = this.getData();
                }
                HexUtil.StringtoBytes((String)string, (byte[])inbytes);
                bytes = inbytes;
            }
        }
        return bytes;
    }

    public int getOffset() {
        return this.offset < 0 ? 0 : this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    protected void setDatasize() {
        if (this.datatype == null) {
            this.levels = null;
            this.setDatatype();
        }
        this.decimalpoint = new Integer(0);
        switch (this.datatype) {
            case ALPHA: {
                this.decimalpoint = this.getDecimalPoint();
            }
            default: {
                this.datasize = new Integer(this.length);
                break;
            }
            case INDEX: 
            case POINTER: {
                this.datasize = Numbers.IntSize;
                break;
            }
            case SIGNED: 
            case UNSIGNED: {
                block5 : switch (this.storagetype) {
                    case BIN: {
                        switch (this.length) {
                            case 1: {
                                this.datasize = Numbers.ByteSize;
                                break block5;
                            }
                            case 2: {
                                this.datasize = Numbers.ShortSize;
                                break block5;
                            }
                            case 4: {
                                this.datasize = Numbers.IntSize;
                                break block5;
                            }
                        }
                        this.datasize = Numbers.LongSize;
                        break;
                    }
                    case PACK: {
                        this.datasize = this.length * 2 - 1;
                        break;
                    }
                    case DISPLAY_SIGNED_SEPARATE: 
                    case DISPLAY_SIGNED_SEPARATE_LEFT: {
                        this.datasize = this.length - 1;
                        break;
                    }
                    default: {
                        this.datasize = this.length;
                    }
                }
                this.decimalpoint = this.getDecimalPoint();
            }
        }
    }

    protected abstract int getDecimalPoint();

    protected abstract void setDatatype();

    @Override
    public Object clone() throws CloneNotSupportedException {
        Variable clone = (Variable)super.clone();
        clone.backingdata = null;
        clone.backingdataAddress = MFAddress.ZERO_ADDR;
        clone.address = MFAddress.ZERO_ADDR;
        clone.setBaseVariable(this.getBaseVariable());
        return clone;
    }

    @Override
    public void setParent(TreeObject parent) {
        super.setParent(parent);
        if (parent != null) {
            int level = (Integer)Attribute.getValue((String)"level", (Properties)this.attributes);
            int length = (Integer)Attribute.getValue((String)"length", (Properties)this.attributes);
            if (parent instanceof Variable) {
                ByteBuffer tbuff;
                int evel = (Integer)Attribute.getValue((String)"gt_evel", (Properties)this.attributes);
                if (level > 1 && length > 0 && evel != 88 && evel != 66 && (tbuff = ((Variable)parent).getBackingdata()) != null) {
                    int offset = (Integer)Attribute.getValue((String)"structureoffset", (Properties)this.attributes);
                    offset -= ((Integer)Attribute.getValue((String)"structureoffset", (Properties)parent.getAttributes())).intValue();
                    try {
                        this.backingdata = ByteBuffer.wrap(tbuff.array(), offset, length);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.backingdata = null;
                    }
                }
            }
        }
    }

    @Override
    public MFAddress getAddress() {
        if (this.hasBackingData()) {
            MFAddress addr = this.getBackingdataAddress().add((long)this.offset);
            return addr;
        }
        return this.address;
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }

    public MFAddress getBackingdataAddress() {
        return this.backingdataAddress;
    }

    public void setBackingdataAddress(MFAddress backingdataAddress) {
        this.backingdataAddress = backingdataAddress;
    }

    public String getHexString() {
        ByteBuffer bb = this.getBackingdata();
        if (bb != null) {
            byte[] ebytes = new byte[bb.limit()];
            bb.position(0);
            bb.get(ebytes);
            String str = HexUtil.toHex((byte[])ebytes);
            return str;
        }
        return "";
    }

    public ByteBuffer getBackingdata() {
        this.getMemoryManager();
        if (this.backingdata == null && this.memoryManager != null) {
            this.setBackingdata(this.memoryManager.getMemory(this));
        }
        return this.backingdata;
    }

    public boolean hasBackingData() {
        return this.backingdata != null && this.backingdata.capacity() > 0;
    }

    public void setBackingdata(ByteBuffer buffer, MFAddress address) {
        this.backingdata = buffer;
        this.backingdataAddress = address;
        TreeObject[] treeObjectArray = this.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject child = treeObjectArray[n2];
            ((Variable)child).setBackingdata(buffer, address);
            ++n2;
        }
    }

    public void setBackingdata(Data data) {
        if (data == null) {
            this.setBackingdata(ByteBuffer.allocate(0), MFAddress.ZERO_ADDR);
        } else {
            this.setBackingdata(ByteBuffer.wrap(data.getData()), data.getAddress());
        }
    }

    public void nullBackingdata() {
        this.setBackingdata(null);
        this.clean = true;
        for (TreeObject element : this.children) {
            ((Variable)element).nullBackingdata();
        }
    }

    protected ByteBuffer reorderBackingdata(ByteBuffer bdata) {
        int lth = 128;
        int jHigh = 0;
        byte[] bytes = new byte[4];
        ByteBuffer newBackingdata = ByteBuffer.wrap(new byte[lth]);
        int i = 0;
        while (i < lth / 2) {
            jHigh = i + lth / 2;
            newBackingdata.position(i * 2);
            bdata.position(jHigh);
            bdata.get(bytes);
            newBackingdata.put(bytes);
            newBackingdata.position(i * 2 + 4);
            bdata.position(i);
            bdata.get(bytes);
            newBackingdata.put(bytes);
            i += 4;
        }
        return newBackingdata;
    }

    protected ByteBuffer restoreBackingdata(ByteBuffer bdata) {
        int lth = 128;
        int jHigh = 0;
        byte[] bytes = new byte[4];
        ByteBuffer oldBackingdata = ByteBuffer.wrap(new byte[lth]);
        int i = 0;
        while (i < lth / 2) {
            jHigh = i + lth / 2;
            oldBackingdata.position(i);
            bdata.position(i * 2 + 4);
            bdata.get(bytes);
            oldBackingdata.put(bytes);
            oldBackingdata.position(jHigh);
            bdata.position(i * 2);
            bdata.get(bytes);
            oldBackingdata.put(bytes);
            i += 4;
        }
        return oldBackingdata;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public boolean hasStructure() {
        switch (this.datatype) {
            case DUMP: 
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    @Override
    public IMemoryManager getMemoryManager() {
        if (this.memoryManager == null) {
            Variable root = this.getBaseVariable();
            this.memoryManager = root.memoryManager;
        }
        return this.memoryManager;
    }

    @Override
    public void setMemoryManager(IMemoryManager memoryManager) {
        Variable root = this.getBaseVariable();
        root.memoryManager = memoryManager;
    }

    public abstract String getDataRequestName();

    public void adjustOffset(int increment) {
        this.offset -= increment;
        for (TreeObject child : this.children) {
            ((Variable)child).adjustOffset(increment);
        }
    }

    public boolean isDataClone() {
        return this.dataClone;
    }

    public void setDataClone(boolean dataClone) {
        this.dataClone = dataClone;
    }

    public void generateDataClones() {
    }

    public void removeDataClone() {
    }

    public int[] getLevels() {
        return Arrays.copyOf(this.levels, 7);
    }

    public void setLevels(int[] levels) {
        this.levels = levels;
    }

    public boolean isOccurs() {
        return this.levels[0] > 0;
    }

    public Variable cloneforWatch(int stopStatement, IMemoryManager memoryManager, String programName) throws CloneNotSupportedException {
        Variable clone = (Variable)this.clone();
        clone.setMemoryManager(memoryManager);
        clone.setStopStatement(stopStatement);
        clone.setProgramName(programName);
        return clone;
    }

    private void setStopStatement(int stopStatement) {
        this.stopStatement = stopStatement;
    }

    @Override
    public boolean isEmpty() {
        return (this.backingdata == null || this.getLength() == 0) && this.children.size() == 0;
    }

    public int getBaseoffset() {
        return this.baseoffset;
    }

    public int[] getArraySizes() {
        return Arrays.copyOf(this.levels, 7);
    }

    public int[] getArrayStrides() {
        return Arrays.copyOf(this.gt_incr, 7);
    }

    public static int getItemOffset(Variable variable, int[] indexes) {
        int itemOffset = 0;
        int[] levels = variable.getArrayStrides();
        int offset = (Integer)Attribute.getValue((String)"structureoffset", (Properties)variable.getAttributes());
        int parentoffset = variable.getOffset();
        itemOffset = offset - parentoffset;
        int index = 0;
        while (index < levels.length) {
            itemOffset += levels[index] * indexes[index];
            ++index;
        }
        return itemOffset;
    }

    public static Integer[] getIndexBase(Variable variable, int lang, int length) {
        Object[] idxbase = new Integer[length];
        if (lang == 128) {
            String format = "pl1arlb%d";
            int i = 0;
            while (i < length) {
                String key = String.format(format, i + 1);
                String str = variable.getAttribute(key);
                idxbase[i] = str.length() > 0 ? Integer.valueOf(str) : Integer.valueOf(1);
                ++i;
            }
        } else {
            Arrays.fill(idxbase, new Integer(1));
        }
        return idxbase;
    }

    public int[] getIndexOffset() {
        return Arrays.copyOf(this.index_off, 7);
    }

    public void setBaseVariable(Variable baseVariable) {
        this.baseVariable = baseVariable;
        for (TreeObject child : this.children) {
            ((Variable)child).setBaseVariable(baseVariable);
        }
    }

    public String getProgramName() {
        return this.programName;
    }

    @Override
    public void dispose() {
        this.backingdata = null;
        this.baseVariable = null;
        this.memoryManager = null;
        super.dispose();
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    @Override
    public String getTitleTooltipText() {
        MFAddress address = this.getAddress();
        if (address != null && !MFAddress.ZERO_ADDR.equals((Object)address)) {
            return String.format("Address=%s", address.getText(false));
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.name.equals(other.name) && this.getStatementNumber() == other.getStatementNumber()) {
            return this.programName != null && this.programName.equals(other.programName);
        }
        return false;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    public int getStopStatement() {
        return this.stopStatement;
    }

    public static enum DataType {
        ALPHA,
        ARRAY,
        GROUP,
        INDEX,
        POINTER,
        SIGNED,
        UNSIGNED,
        FLOAT,
        GRAPHIC,
        BIT,
        DUMP,
        UNKNOWN;

    }

    public static enum StorageType {
        CHAR,
        BIN,
        PACK,
        HEX,
        INTERNAL,
        EXTERNAL,
        DISPLAY,
        DISPLAY_SIGNED_LEFT,
        DISPLAY_SIGNED_SEPARATE,
        DISPLAY_SIGNED_SEPARATE_LEFT,
        UNKNOWN;

    }
}

