/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public abstract class NodeChild
implements ITreeWrappedItem {
    static String cacopyright = "Copyright (c) 2016 CA";
    private String name = "";
    private ArrayList<Object> list = new ArrayList();
    private TT_TreeItem parent = null;

    @Override
    public void setParent(TT_TreeItem parent) {
        if (parent != null) {
            this.parent = parent;
            Element element = parent.getElement();
            this.name = element == null ? this.getClass().getSimpleName() : XMLDocument.getName((Element)element);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        XMLDocument.setName((Element)this.parent.getElement(), (String)name);
    }

    public Object[] getList() {
        return this.list.toArray(new Object[this.list.size()]);
    }

    public void setList(ArrayList<Object> list) {
        list.clear();
        list.addAll(list);
    }

    @Override
    public TT_TreeItem getParent() {
        return this.parent;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public String getText() {
        String text = this.getName();
        if (this.list.size() > 0) {
            text = String.format("%s (%d)", this.list.size());
        }
        return text;
    }

    public void clearContents() {
        this.list.clear();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeChild)) {
            return false;
        }
        NodeChild other = (NodeChild)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : this.parent != other.parent);
    }
}

