/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.logging.Logging;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TestingToolsActivator
extends AbstractUIPlugin {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final String PLUGIN_ID = "com.ca.testingtools";
    public static final String CONTEXT_ID = "com.ca.testingtools.context";
    public static TestingToolsActivator plugin;
    private Logger log;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Logging.setLogging(context.getBundle(), false);
        this.log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        plugin = this;
        this.checkJRE();
    }

    private void checkJRE() {
        if (!Charset.isSupported("IBM1047")) {
            final String msg = "The Java runtime is not configured with Support for Additional Languages" + HexUtil.LF + "Please install this feature" + HexUtil.LF + "Refer to the install of your Java runtime";
            this.log.severe(msg);
            final Display display = Display.getDefault();
            if (display != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TT_ErrorDialog.openError(display.getActiveShell(), "CA Testing Tools", msg, new Throwable("Install the proper Java runtime"));
                    }
                });
            }
            plugin.getWorkbench().close();
        }
    }

    public void stop(BundleContext context) throws Exception {
        Job.getJobManager().cancel((Object)PLUGIN_ID);
        ServerTreeModel.getInstance().dispose();
        super.stop(context);
        plugin = null;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        Bundle bundle = this.getBundle();
        Path path = new Path("icons/collapseall.png");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("COLLAPSE_ICON", desc);
        path = new Path("icons/expandall.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("EXPAND_ICON", desc);
        path = new Path("icons/png/edit_configuration_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("UPDATE_ICON", desc);
        path = new Path("icons/png/cobol_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("COB_ICON", desc);
        path = new Path("icons/png/assembler_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("ASM_ICON", desc);
        path = new Path("icons/png/PL-I_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("PLI_ICON", desc);
        path = new Path("icons/png/generic_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("GENERIC_ICON", desc);
        path = new Path("icons/CA_logo 16x16.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("CA_LOGO_ICON", desc);
        path = new Path("icons/refresh.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("REFRESH_ICON", desc);
        path = new Path("icons/warning.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("WARNING_ICON", desc);
        path = new Path("icons/png/download_list_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_IMPORT_LIST", desc);
        path = new Path("icons/png/import_list_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_LOAD_PROTSYM", desc);
        path = new Path("icons/png/mainframe_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SERVER", desc);
        path = new Path("icons/png/export_server_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SERVER_EXPORT", desc);
        path = new Path("icons/png/import_server_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SERVER_IMPORT", desc);
        path = new Path("icons/eclipse_folder.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("PROFILE_ICON", desc);
        path = new Path("icons/eclipse_fldr_protsym.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("PROTSYM_ICON", desc);
    }
}

