/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.cics.Activator;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ASMVariable;
import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.protsym.Outline;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class Keywords {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    static Keywords keywords = null;
    static Logger log = Logger.getLogger(Keywords.class.getName());
    protected HashMap<String, HashMap<String, IMemento>> versionsmap;
    protected Bundle bundle;

    private Keywords() throws TTException {
        URL urlEntry = null;
        InputStreamReader urlReader = null;
        InputStream urlStream = null;
        String name = this.getClass().getSimpleName();
        String format = "%s:%s";
        try {
            this.bundle = Activator.getDefault().getBundle();
            if (this.bundle == null) {
                throw new TTException(String.format(format, name, "Missing Bundle"));
            }
            urlEntry = this.bundle.getEntry("keywords.xml");
            if (urlEntry == null) {
                throw new TTException(String.format(format, name, "Missing keywords.xml"));
            }
            urlStream = urlEntry.openStream();
            urlReader = new InputStreamReader(urlStream);
            XMLMemento memento = XMLMemento.createReadRoot((Reader)urlReader);
            IMemento[] major = memento.getChildren("keywords");
            this.versionsmap = new HashMap(major.length);
            IMemento[] iMementoArray = major;
            int n = major.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento item = iMementoArray[n2];
                String type = item.getString("type");
                String version = item.getString("version");
                if (type == null || version == null) {
                    throw new TTException(String.format(format, name, "Missing Keys:" + item.toString()));
                }
                IMemento[] minor = item.getChildren("keyword");
                HashMap<String, IMemento> map = new HashMap<String, IMemento>(minor.length);
                IMemento[] iMementoArray2 = minor;
                int n3 = minor.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento word = iMementoArray2[n4];
                    String key = word.getString("name");
                    if (map.containsKey(key)) {
                        String error = String.format("Duplicate Name:%s in %s%s", key, type, version);
                        throw new TTException(String.format(format, name, error));
                    }
                    map.put(key, word);
                    ++n4;
                }
                if (this.versionsmap.containsKey(String.valueOf(type) + version)) {
                    String error = String.format("Duplicate Version:%s%s", type, version);
                    throw new TTException(String.format(format, name, error));
                }
                this.versionsmap.put(String.valueOf(type) + version, map);
                ++n2;
            }
        }
        catch (IOException e) {
            throw new TTException((Throwable)e);
        }
        catch (WorkbenchException e) {
            throw new TTException((Throwable)e);
        }
    }

    private ASMVariable _getTree(String name, String version) throws TTException {
        HashMap<String, IMemento> map = this.versionsmap.get("cics" + version);
        if (map == null) {
            throw new TTException(String.format("Missing Keywords in %s", version));
        }
        IMemento item = map.get(name);
        if (item == null) {
            throw new TTException(String.format("Missing Keyword:%s in %s", name, version));
        }
        String protsym = item.getString("member");
        if (protsym == null) {
            throw new TTException(String.format("No Member for Keyword:%s in %s", name, version));
        }
        String DSECT = item.getString("DSECT");
        if (DSECT == null) {
            throw new TTException(String.format("No DSECT for Keyword:%s in %s", name, version));
        }
        protsym = String.format("keyword_metadata/%s.xml", protsym);
        URL urlEntry = null;
        InputStream urlStream = null;
        urlEntry = this.bundle.getEntry(protsym);
        if (urlEntry == null) {
            throw new TTException(String.format("missing %s", protsym));
        }
        try {
            urlStream = urlEntry.openStream();
        }
        catch (IOException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
            return null;
        }
        Outline outline = Outline.getInstance((InputStream)urlStream, (String)urlEntry.getFile(), (int)16);
        TreeObject[] variable = outline.getQualifiedObjects(DSECT);
        return (ASMVariable)(variable.length == 1 ? variable[0] : null);
    }

    public static Keywords getInstance() throws TTException {
        if (keywords == null) {
            keywords = new Keywords();
        }
        return keywords;
    }

    public static ASMVariable getTree(String name, String version) throws TTException {
        return Keywords.getInstance()._getTree(name, version);
    }
}

