/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.common.scanSource;

public class scanCOBOL
extends scanSource
implements IScanSource {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private String[] titles = new String[]{"5648-", "5668-", "5740-", "5688-", "5655-", "LineID"};
    private Integer version;
    private String regex5 = "[0-9]{5}";
    private String regex6 = "[0-9]{6}";
    private String regex;

    public scanCOBOL(String version) {
        this.version = (Integer)Attribute.getValue("gt_m_cty", version);
        this.setValues();
    }

    @Override
    public boolean isCandidate(String line) {
        if (line.length() < this.stmtStart) {
            return false;
        }
        int i = 0;
        while (i < this.titles.length) {
            int index = line.indexOf(this.titles[i]);
            if (index >= 0 && index < 10) {
                return false;
            }
            ++i;
        }
        String token = line.substring(this.seqStart, this.seqEnd);
        boolean numeric = token.matches(this.regex);
        if (numeric) {
            return line.substring(this.seqEnd, this.stmtStart).trim().length() == 0;
        }
        return false;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    protected void setValues() {
        if (this.version != null) {
            switch (this.version) {
                case 1: {
                    this.seqStart = 0;
                    this.seqEnd = this.seqStart + 5;
                    this.stmtStart = 7;
                    this.stmtComment = this.stmtStart + 6;
                    this.regex = this.regex5;
                    this.lineRegex = "[\\w\\+\\-*=()]+|('[\\w\\s,.+-=()#@;:?%!&<>\"*!/$]+')";
                    break;
                }
                default: {
                    this.seqStart = 2;
                    this.seqEnd = this.seqStart + 6;
                    this.stmtStart = 17;
                    this.stmtComment = this.stmtStart + 6;
                    this.regex = this.regex6;
                    this.lineRegex = "[\\w\\+\\-*=()]+|('[\\w\\s,.+-=()#@;:?%!&<>\"*!/$]+')";
                }
            }
        }
    }

    @Override
    public int getStatement(String line) {
        int statement = -1;
        if (this.isCandidate(line) && (statement = this.getSeqNumber(line, false, this.seqStart, this.seqEnd - this.seqStart)) == -1) {
            statement = 0;
        }
        return statement;
    }
}

