/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.Abend;
import com.ca.symdump.cics.SymCicsAbend;
import com.ca.symdump.cics.SymCicsDataset;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymCicsListJob
extends Job {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = SymCicsListJob.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    protected final TTServer server;
    private final SymCicsDataset dataset;
    private IProfileSetContent container;
    private static final String REFRESHING = "Getting index list for %1$s @ %2$s";

    public SymCicsListJob(SymCicsDataset dataset, TTServer server, IProfileSetContent container) {
        super(String.format(REFRESHING, new Object[]{dataset, server.getName()}));
        this.server = server;
        this.dataset = dataset;
        this.container = container;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ServerConnect connection = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("indx", this.dataset.getName());
        map.put("symd", "cic");
        ArrayList<SymCicsAbend> list = null;
        XMLRequest xml = null;
        try {
            xml = connection.connect("init", map, true);
            if (xml.getErrorLevel() == 0) {
                Element command = xml.getCommand();
                NodeList lines = command.getElementsByTagName("Line");
                list = new ArrayList<SymCicsAbend>(lines.getLength());
                int index = 0;
                while (index < lines.getLength()) {
                    Element element = (Element)lines.item(index);
                    String recstring = XMLFile.getStr((Element)element);
                    if (recstring != null && recstring.length() > 0) {
                        char rectype = recstring.charAt(0);
                        switch (rectype) {
                            case 'H': {
                                this.dataset.setHeaderMap(recstring);
                                break;
                            }
                            case 'D': {
                                SymCicsAbend abend = new SymCicsAbend(element, this.dataset.getHeaderMap());
                                abend.setDataset(this.dataset);
                                abend.setServer(this.server);
                                list.add(abend);
                                break;
                            }
                        }
                    }
                    ++index;
                }
            } else {
                this.log.log(Level.WARNING, "ErrorLevel={0} Text={1}", new Object[]{xml.getErrorLevel(), xml.getErrorMessage()});
                this.log.log(Level.FINE, "", xml);
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        if (list != null) {
            if (list.size() > 0) {
                final Abend[] abendlist = list.toArray(new Abend[list.size()]);
                UIJob job = new UIJob("job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SymCicsListJob.this.container.addContent((Object[])abendlist, true);
                        return new Status(0, "com.ca.symdump.cics", 0, "done", null);
                    }
                };
                job.schedule();
            } else {
                UIJob job = new UIJob("job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SymCicsListJob.this.container.removeContent(new NodeChild[]{SymCicsListJob.this.dataset});
                        return new Status(0, "com.ca.symdump.cics", 0, "done", null);
                    }
                };
                job.schedule();
            }
        }
        return Status.OK_STATUS;
    }
}

