/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.views.report;

import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.runners.RunGetCancelEdit;
import com.ca.filemaster.runners.RunGetDelete;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportView
extends ViewPart
implements ISelectionListener,
IPropertyListener,
IPropertyChangeListener,
ISelectionChangedListener,
ISaveablePart,
ISaveablePart2 {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = ReportView.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static final String ID = "com.ca.filemaster.views.reportsview";
    private static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.reportView";
    private TextViewer reportViewer;
    private String secondary;
    private String Content = "";
    private Action syslistAction;
    private IToolBarManager toolbarManager;
    private String editorId = "";
    private static final String SYS_TOOLBAR_BUTTON_ID = "editor.syslistAction";
    private boolean showMessage = true;
    public static Button EditorClosed;
    private StringBuilder sb;
    public String sysDSN = "";
    public static boolean hasSyslist;
    private boolean skipPrompt = false;
    private FileMasterDataset dataset;
    private FileMasterServer server;
    private String uuid;

    static {
        hasSyslist = false;
    }

    public String getSysDSN() {
        return this.sysDSN;
    }

    public void setSysDSN(String sysDSN) {
        this.sysDSN = sysDSN;
    }

    public FileMasterServer getServer() {
        return this.server;
    }

    public void setServer(FileMasterServer server) {
        this.server = server;
    }

    public void createPartControl(Composite parent) {
        this.addPropertyListener(this);
        this.addPartPropertyListener(this);
        this.secondary = this.getViewSite().getSecondaryId();
        this.buildReportViewer(parent);
        this.log.log(Level.FINE, "view {0}:{1} created", new Object[]{ID, this.secondary});
        EditorClosed = new Button((Composite)new Shell(), 0);
        EditorClosed.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ReportView.this.getView().getToolBarAction(ReportView.SYS_TOOLBAR_BUTTON_ID) != null) {
                    ReportView.this.getView().getToolBarAction(ReportView.SYS_TOOLBAR_BUTTON_ID).setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private ReportView getView() {
        return this;
    }

    public FileMasterDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(FileMasterDataset dataset) {
        this.dataset = dataset;
    }

    private void buildReportViewer(Composite parent) {
        this.reportViewer = new TextViewer(parent, 2818);
        this.reportViewer.setEditable(false);
        this.reportViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
        this.reportViewer.canDoOperation(4);
        this.reportViewer.canDoOperation(5);
        this.reportViewer.enableOperation(4, true);
        this.reportViewer.enableOperation(10, true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.reportViewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.reportViewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.reportViewer);
        Control control = this.reportViewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.reportViewer.getControl().setFont(JFaceResources.getTextFont());
        this.reportViewer.setInput((Object)new Document(this.Content));
        this.createActions();
        this.initializeToolBar();
        this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(false);
        this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setToolTipText("View Detailed Report");
    }

    private void createActions() {
        Bundle bundle = Platform.getBundle((String)"com.ca.filemaster.editor");
        ImageDescriptor sysImage = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path("icons/editor-open-browse-16.png"), null));
        final Command command = ((ICommandService)this.getSite().getService(ICommandService.class)).getCommand("com.ca.filemaster.editor.commands.syslist");
        Event trigger = new Event();
        final ExecutionEvent executionEvent = ((IHandlerService)this.getSite().getService(IHandlerService.class)).createExecutionEvent(command, trigger);
        this.syslistAction = new Action("Browse Syslist"){

            public void run() {
                try {
                    command.executeWithChecks(executionEvent);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
                catch (NotEnabledException e) {
                    e.printStackTrace();
                }
                catch (NotHandledException e) {
                    e.printStackTrace();
                }
                ReportView.this.getToolBarAction(ReportView.SYS_TOOLBAR_BUTTON_ID).setEnabled(true);
            }
        };
        this.syslistAction.setImageDescriptor(sysImage);
        this.syslistAction.setId(SYS_TOOLBAR_BUTTON_ID);
    }

    private void initializeToolBar() {
        this.toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.toolbarManager.add((IAction)this.syslistAction);
    }

    private IAction getToolBarAction(String actionId) {
        if ((ActionContributionItem)this.toolbarManager.find(actionId) != null) {
            return ((ActionContributionItem)this.toolbarManager.find(actionId)).getAction();
        }
        return null;
    }

    public void updateReportViewer(String[] content) {
        this.sb = new StringBuilder(content.length * 80);
        int lineCount = 0;
        while (lineCount < content.length) {
            this.sb.append(String.valueOf(content[lineCount]) + "\r\n");
            ++lineCount;
        }
        this.reportViewer.setInput((Object)new Document(this.sb.toString()));
        if (this.sb.toString().contains("COMPREPORT")) {
            this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(true);
            if (this.getSysDSN().isEmpty()) {
                this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(false);
            }
        }
        this.reportViewer.refresh();
    }

    public void setFocus() {
        this.reportViewer.getControl().setFocus();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            DirectoryListView DirectoryView = (DirectoryListView)page.findView("com.ca.filemaster.views.directorylist");
            DirectoryView.getViewer().setSelection((ISelection)new StructuredSelection(), true);
            if (this.sb != null) {
                if (this.getEditorId().isEmpty()) {
                    if (this.sb.toString().contains("COMPREPORT")) {
                        this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(true);
                        hasSyslist = true;
                    }
                } else {
                    this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(false);
                }
            } else {
                this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(false);
            }
        }
        if (this.getSysDSN().isEmpty()) {
            this.getToolBarAction(SYS_TOOLBAR_BUTTON_ID).setEnabled(false);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.removePropertyListener(this);
        this.removePartPropertyListener(this);
        super.dispose();
    }

    public String getSecondary() {
        return this.secondary;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void propertyChanged(Object source, int propId) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public int promptToSaveOnClose() {
        boolean result = true;
        if (this.dataset == null) {
            return 0;
        }
        this.showMessage = this.showMessage();
        if (this.showMessage) {
            result = MessageDialog.openQuestion((Shell)new Shell(), (String)"Delete DSN", (String)("Closing the reports view will also close and delete the following syslist: " + this.dataset.getName() + "\nAre you sure you want to close the reports view?"));
        }
        if (result && !this.skipPrompt) {
            FileMasterDataset[] datasets = new FileMasterDataset[]{this.dataset, new FileMasterDataset(null)};
            this.closeOpenedEditor();
            if (this.uuid != null && !this.uuid.isEmpty()) {
                RunGetCancelEdit runnerCancel = new RunGetCancelEdit(this.server, this.uuid, "C", "N");
                BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runnerCancel);
            }
            RunGetDelete runner = new RunGetDelete(this.dataset, this.server, false);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xml = runner.getXml();
            if (xml != null) {
                Element element = xml.getRoot();
                NodeList retCode = element.getElementsByTagName("DSNUtilityResponse");
                String pgmRetCode = ((Element)retCode.item(0)).getAttribute("programReturnCode");
                String message = "";
                NodeList messages = element.getElementsByTagName("Message");
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    Element msgElement = (Element)msgNode;
                    NodeList msgList = msgElement.getChildNodes();
                    Node msgValue = msgList.item(0);
                    message = String.valueOf(message) + msgValue.getNodeValue();
                    ++i;
                }
                if (message.contains("CAWA014E")) {
                    return 0;
                }
                if (!pgmRetCode.equals("0")) {
                    MessageDialog.openError((Shell)new Shell(), (String)"Delete DSN", (String)message);
                    return 0;
                }
                return 0;
            }
        }
        return 2;
    }

    private boolean showMessage() {
        Command command = ((ICommandService)this.getSite().getService(ICommandService.class)).getCommand("com.ca.filemaster.editor.commands.checkEditorOpen");
        Event trigger = new Event();
        ExecutionEvent executionEvent = ((IHandlerService)this.getSite().getService(IHandlerService.class)).createExecutionEvent(command, trigger);
        try {
            return command.executeWithChecks(executionEvent) != null;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
        }
        catch (NotHandledException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void closeOpenedEditor() {
        Command command = ((ICommandService)this.getSite().getService(ICommandService.class)).getCommand("com.ca.filemaster.editor.commands.closeeditor");
        Event trigger = new Event();
        ExecutionEvent executionEvent = ((IHandlerService)this.getSite().getService(IHandlerService.class)).createExecutionEvent(command, trigger);
        try {
            command.executeWithChecks(executionEvent);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
        }
        catch (NotHandledException e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public String getEditorId() {
        return this.editorId;
    }

    public boolean syslist() {
        return hasSyslist;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }
}

