/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.views.properties;

import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.views.properties.IFMFile;
import com.ca.filemaster.views.properties.Parameter;
import com.ca.filemaster.views.properties.ParametersCategory;
import java.util.ArrayList;
import java.util.Iterator;

public class FMVSAM
implements IFMFile {
    private FMPVSAMDataset dataSet;
    private String allocUnit = "";

    public FMVSAM(FMPVSAMDataset dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Object[] buildParametersForDisplay() {
        ArrayList<ParametersCategory> categories = new ArrayList<ParametersCategory>();
        ParametersCategory category = new ParametersCategory("Data Set Definition");
        categories.add(category);
        category.getParameters().add(new Parameter("Cluster name", this.dataSet.getCluster()));
        if (!this.dataSet.getBaseDsn().isEmpty()) {
            category.getParameters().add(new Parameter("AIX for cluster", this.dataSet.getBaseDsn()));
        }
        if (this.dataSet.getDsType().equals("K")) {
            if (this.dataSet.getKeypositionText().equalsIgnoreCase("Key Position")) {
                category.getParameters().add(new Parameter("Key position", this.dataSet.getOffset()));
            } else if (this.dataSet.getKeypositionText().equalsIgnoreCase("Alternate Key Pos")) {
                category.getParameters().add(new Parameter("Alternate key position", this.dataSet.getOffset()));
            }
            if (this.dataSet.getKeylengthText().equalsIgnoreCase("Key Length")) {
                category.getParameters().add(new Parameter("Key length", this.dataSet.getLength()));
            } else if (this.dataSet.getKeylengthText().equalsIgnoreCase("Alternate Key Len")) {
                category.getParameters().add(new Parameter("Alternate key length", this.dataSet.getLength()));
            }
        }
        if (!this.dataSet.getDsType().equals("N")) {
            category.getParameters().add(new Parameter("Average record size", this.dataSet.getAverage()));
            if (!this.dataSet.getDsType().equals("R")) {
                category.getParameters().add(new Parameter("Maximum record size", this.dataSet.getMaximum()));
            }
        }
        category.getParameters().add(new Parameter("Share options", String.valueOf(this.dataSet.getCrossregion()) + ',' + this.dataSet.getCrosssystem()));
        category.getParameters().add(new Parameter("Buffer space", this.dataSet.getBufferSpace()));
        category.getParameters().add(new Parameter("Data set organization", this.dataSet.getDsOrg()));
        if (this.dataSet.getDsType().equals("K")) {
            category.getParameters().add(new Parameter("Data set type", "KSDS (Key Sequence Data Set)"));
        } else if (this.dataSet.getDsType().equals("E")) {
            category.getParameters().add(new Parameter("Data set type", "ESDS (Entry Sequence Data Set)"));
        } else if (this.dataSet.getDsType().equals("R")) {
            category.getParameters().add(new Parameter("Data set type", "RRDS (Relative Record Data Set)"));
        } else if (this.dataSet.getDsType().equals("N")) {
            category.getParameters().add(new Parameter("Data set type", "LDS (Linear Data Set)"));
        } else if (this.dataSet.getDsType().equals("Y")) {
            category.getParameters().add(new Parameter("Data set type", "VRRDS (Variable-Length Relative Record Data Set)"));
        }
        category = new ParametersCategory("SMS Information");
        categories.add(category);
        category.getParameters().add(new Parameter("Storage class", this.dataSet.getSmsStorage()));
        category.getParameters().add(new Parameter("Data class", this.dataSet.getSmsData()));
        category.getParameters().add(new Parameter("Management class", this.dataSet.getSmsManagement()));
        category = new ParametersCategory("Component Allocation");
        categories.add(category);
        ParametersCategory subCategory = new ParametersCategory("Data");
        category.getCategories().add(subCategory);
        subCategory.getParameters().add(new Parameter("Name", this.dataSet.getData()));
        subCategory.getParameters().add(new Parameter("Volume", this.getVolumes(this.dataSet.getDataVolumes())));
        subCategory.getParameters().add(new Parameter("Control interval size", this.dataSet.getDataControlIntervalSize()));
        this.allocUnit = this.dataSet.getDataUnits();
        if (this.dataSet.getDataUnits().equalsIgnoreCase("TRKS")) {
            this.allocUnit = "Tracks";
        } else if (this.dataSet.getDataUnits().equalsIgnoreCase("CYLS")) {
            this.allocUnit = "Cylinders";
        }
        subCategory.getParameters().add(new Parameter("Allocation unit", this.allocUnit));
        subCategory.getParameters().add(new Parameter("Primary", this.dataSet.getDataPrimary()));
        subCategory.getParameters().add(new Parameter("Secondary", this.dataSet.getDataSecondary()));
        subCategory.getParameters().add(new Parameter("Extents used", this.dataSet.getDataExtentsUsed()));
        if (this.dataSet.getDsType().equals("K") || this.dataSet.getDsType().equals("Y")) {
            subCategory = new ParametersCategory("Index");
            category.getCategories().add(subCategory);
            subCategory.getParameters().add(new Parameter("Name", this.dataSet.getIndex()));
            subCategory.getParameters().add(new Parameter("Volume", this.getVolumes(this.dataSet.getIndexVolumes())));
            subCategory.getParameters().add(new Parameter("Control interval size", this.dataSet.getIndexControlIntervalSize()));
            this.allocUnit = this.dataSet.getIndexUnits();
            if (this.dataSet.getIndexUnits().equalsIgnoreCase("TRKS")) {
                this.allocUnit = "Tracks";
            } else if (this.dataSet.getIndexUnits().equalsIgnoreCase("CYLS")) {
                this.allocUnit = "Cylinders";
            }
            subCategory.getParameters().add(new Parameter("Allocation unit", this.allocUnit));
            subCategory.getParameters().add(new Parameter("Primary", this.dataSet.getIndexPrimary()));
            subCategory.getParameters().add(new Parameter("Secondary", this.dataSet.getIndexSecondary()));
            subCategory.getParameters().add(new Parameter("Extents used", this.dataSet.getIndexExtentsUsed()));
        }
        category = new ParametersCategory("Component Statistics");
        categories.add(category);
        subCategory = new ParametersCategory("Data");
        category.getCategories().add(subCategory);
        subCategory.getParameters().add(new Parameter("Control intervals per control area", this.dataSet.getDataCiPerca()));
        if (this.dataSet.getDsType().equals("K") || this.dataSet.getDsType().equals("Y")) {
            subCategory.getParameters().add(new Parameter("Control interval splits", this.dataSet.getDataCiSplits()));
            subCategory.getParameters().add(new Parameter("Control area splits", this.dataSet.getDataCaSplits()));
            subCategory.getParameters().add(new Parameter("Freespace percent - control interval", this.dataSet.getDataCIpercent()));
            subCategory.getParameters().add(new Parameter("Freespace percent - control area", this.dataSet.getDataCApercent()));
        }
        subCategory.getParameters().add(new Parameter("Total freespace", this.dataSet.getDataFreespaceTotal()));
        subCategory.getParameters().add(new Parameter("High allocated relative byte address", this.dataSet.getDataHighAllocatedRBA()));
        subCategory.getParameters().add(new Parameter("High used relative byte address", this.dataSet.getDataHighUsedRBA()));
        subCategory.getParameters().add(new Parameter("Percent free", this.dataSet.getDataPercentFree()));
        subCategory.getParameters().add(new Parameter("Physical record size", this.dataSet.getDataPhyRecordSize()));
        subCategory.getParameters().add(new Parameter("Physical record per track", this.dataSet.getDataPhyRecordTrk()));
        subCategory.getParameters().add(new Parameter("Tracks per control area", this.dataSet.getDataTrksCA()));
        if (this.dataSet.getDsType().equals("K") || this.dataSet.getDsType().equals("Y")) {
            subCategory = new ParametersCategory("Index");
            category.getCategories().add(subCategory);
            subCategory.getParameters().add(new Parameter("Control intervals per control area", this.dataSet.getIndexCiPerca()));
            subCategory.getParameters().add(new Parameter("Control interval splits", this.dataSet.getIndexCiSplits()));
            subCategory.getParameters().add(new Parameter("Control area splits", this.dataSet.getIndexCaSplits()));
            subCategory.getParameters().add(new Parameter("Freespace percent - control interval", this.dataSet.getIndexCIpercent()));
            subCategory.getParameters().add(new Parameter("Freespace percent - control area", this.dataSet.getIndexCApercent()));
            subCategory.getParameters().add(new Parameter("Total freespace", this.dataSet.getIndexFreespaceTotal()));
            subCategory.getParameters().add(new Parameter("High allocated relative byte address", this.dataSet.getIndexHighAllocatedRBA()));
            subCategory.getParameters().add(new Parameter("High used relative byte address", this.dataSet.getIndexHighUsedRBA()));
            subCategory.getParameters().add(new Parameter("Percent free", this.dataSet.getIndexPercentFree()));
            subCategory.getParameters().add(new Parameter("Physical record size", this.dataSet.getIndexPhyRecordSize()));
            subCategory.getParameters().add(new Parameter("Physical record per track", this.dataSet.getIndexPhyRecordTrk()));
            subCategory.getParameters().add(new Parameter("Tracks per control area", this.dataSet.getIndexTrksCA()));
        }
        category = new ParametersCategory("Allocation Parameters");
        categories.add(category);
        category.getParameters().add(new Parameter("Load restartable", this.dataSet.getLoadRestartable()));
        category.getParameters().add(new Parameter("Write check", this.dataSet.getWriteCheck()));
        category.getParameters().add(new Parameter("Erase on delete", this.dataSet.getErase()));
        if (this.dataSet.getDsType().equals("K")) {
            category.getParameters().add(new Parameter("Replicated index", this.dataSet.getReplicateIndex()));
        }
        category.getParameters().add(new Parameter("Reuse option", this.dataSet.getReuse()));
        if (!this.dataSet.getDsType().equals("N")) {
            category.getParameters().add(new Parameter("Spanned records", this.dataSet.getSpanned()));
        }
        category = new ParametersCategory("Activity Dates");
        categories.add(category);
        category.getParameters().add(new Parameter("Creation date", this.dataSet.getDateCreated()));
        category.getParameters().add(new Parameter("Expiration date", this.dataSet.getExpirationDate()));
        category = new ParametersCategory("Record Statistics");
        categories.add(category);
        category.getParameters().add(new Parameter("Total", this.dataSet.getTotal()));
        if (this.dataSet.getDsType().equals("R")) {
            category.getParameters().add(new Parameter("Actual", this.dataSet.getActual()));
        }
        category.getParameters().add(new Parameter("Deleted", this.dataSet.getDeleted()));
        category.getParameters().add(new Parameter("Inserted", this.dataSet.getInserted()));
        category.getParameters().add(new Parameter("Updated", this.dataSet.getUpdated()));
        category.getParameters().add(new Parameter("Retrieved", this.dataSet.getRetrieved()));
        return categories.toArray();
    }

    private String getVolumes(ArrayList<String> volumes) {
        String volume = "";
        Iterator<String> iterator = volumes.iterator();
        while (iterator.hasNext()) {
            volume = String.valueOf(volume) + iterator.next();
            if (!iterator.hasNext()) continue;
            volume = String.valueOf(volume) + ", ";
        }
        return volume;
    }
}

