/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.utility.compare;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMMembersTable;
import com.ca.filemaster.common.FMPreferences;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.ui.wizards.MemberWizardPage;
import com.ca.filemaster.utilities.CompareGenericWizard;
import com.ca.filemaster.utility.compare.CompareWizard;
import com.ca.filemaster.utility.compare.CompareWizardPage2;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class CompareWizardPage1
extends FileMasterWizard {
    protected final String CONTEXT_HELP_ID = "com.ca.filemaster.help.compareWizardPage";
    protected final String CONTEXT_HELP_ID_PGM = "com.ca.filemaster.help.compareProgramWizardPage";
    private FileMasterServer server;
    private FileMasterDataset dataSet;
    private Label serverNameLabel;
    private Text serverNameCombo;
    private Text dataSetCombo;
    private Label memberLabel;
    private Combo memberNameCombo;
    private Button selectMemberButton;
    private String dataSetType;
    private String memberName;
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    private FMMembersTable table;
    private boolean pendingMessage = false;
    private String newDatasetName;
    private boolean showDialog = false;
    protected int returnDDCM;
    protected boolean msgDisplayed;
    protected FileMasterMember member;
    private boolean isGenericOpen;
    private Button DirListInsert;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();

    public CompareWizardPage1(String pageName, FileMasterServer server, FileMasterDataset dataSet, FileMasterMember member, String dataSetType) {
        super(pageName, "", server);
        this.setTitle(pageName);
        this.server = server;
        this.dataSetType = dataSetType;
        this.dataSet = dataSet;
        if (dataSet != null) {
            this.dataSetName = dataSet.getName();
        }
        if (member != null) {
            this.memberName = member.getName();
        }
        this.fmdataset = dataSet;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        GridData data = new GridData(4, 0, true, true, 1, 1);
        if (this.getWizard().getWindowTitle().contains("Program")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareProgramWizardPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareWizardPage");
        }
        this.data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        this.serverNameLabel = new Label(this.dataSetComposite, 0);
        this.serverNameLabel.setText("Se&rver:");
        this.serverNameCombo = new Text(this.dataSetComposite, 2056);
        this.serverNameCombo.setLayoutData((Object)data);
        this.serverNameCombo.setText(this.server.getText());
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.dataSetCombo = new Text(this.dataSetComposite, 2056);
        this.dataSetCombo.addModifyListener((ModifyListener)this);
        this.dataSetCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.dataSetCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.dataSetCombo, (int)37);
        this.dataSetCombo.setTextLimit(44);
        if (!this.dataSetName.isEmpty()) {
            this.dataSetCombo.setText(this.dataSetName);
        }
        this.dataSetCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!CompareWizardPage1.this.msgDisplayed) {
                    CompareWizardPage1.this.dataSetName = CompareWizardPage1.this.dataSetCombo.getText();
                }
                CompareWizardPage1.this.msgDisplayed = false;
            }
        });
        this.dataSetCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompareWizardPage1.this.dataSetCombo.setText(CompareWizardPage1.this.dataSetName);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.memberLabel = new Label(this.dataSetComposite, 0);
        this.memberLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 0);
        this.memberNameCombo.setLayoutData((Object)data);
        this.memberNameCombo.setTextLimit(8);
        GridData gd_toMemberComboo = new GridData(4, 4, false, false, 1, 1);
        gd_toMemberComboo.widthHint = 107;
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.memberNameCombo, "MemberNameComboCompareWizardPage1");
        this.selectMemberButton = new Button(this.dataSetComposite, 0);
        this.selectMemberButton.setText("S&elect...");
        this.selectMemberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareWizardPage1.this.returnDDCM = CompareWizardPage1.this.displayDatasetChangedMsg();
                if (CompareWizardPage1.this.returnDDCM == 2 || CompareWizardPage1.this.returnDDCM == -1) {
                    CompareWizardPage1.this.member = new FileMasterMember(null);
                    CompareWizardPage1.this.member.setName(CompareWizardPage1.this.memberNameCombo.getText());
                    CompareWizardPage1.this.fmdataset = CommonMFCalls.getFQDSN(CompareWizardPage1.this.dataSetCombo.getText(), "", CompareWizardPage1.this.server);
                    if (!CompareWizardPage1.this.fmdataset.getName().isEmpty()) {
                        WizardDialog dialog = new WizardDialog(CompareWizardPage1.this.getShell(), (IWizard)new MemberWizard(CompareWizardPage1.this.member, CompareWizardPage1.this.fmdataset, CompareWizardPage1.this.server, false, CompareWizardPage1.this.table.getPrintTblMembers()));
                        dialog.create();
                        dialog.open();
                        List<FileMasterMember> memberList = ((MemberWizardPage)dialog.getCurrentPage()).getMembersList();
                        if (memberList != null && memberList.size() > 1) {
                            CompareWizardPage1.this.table.insertMembersToTable(((MemberWizardPage)dialog.getCurrentPage()).getMembersList());
                        }
                    }
                } else if (CompareWizardPage1.this.returnDDCM == 3) {
                    CompareWizardPage1.this.dataSetCombo.setFocus();
                }
                CompareWizardPage1.this.setPageComplete(CompareWizardPage1.this.isPageComplete());
            }
        });
        new Label(this.dataSetComposite, 0);
        if (!(this.dataSetType.equals("PDS") || this.dataSetType.equals("Member") || this.dataSetType.equals(""))) {
            this.memberNameCombo.setEnabled(false);
            this.selectMemberButton.setEnabled(false);
        }
        if (this.memberName != null) {
            this.memberNameCombo.setText(this.memberName);
        }
        this.createMembersTable();
        this.table.getClearSelBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompareWizardPage1.this.table.getClearSelBtn().getText() == "Select &All") {
                    CompareWizardPage1.this.table.getViewer().setAllChecked(true);
                    CompareWizardPage1.this.table.getClearSelBtn().setText("&Clear Selections");
                } else {
                    CompareWizardPage1.this.table.getClearSelBtn().setText("Select &All");
                    CompareWizardPage1.this.table.getViewer().setAllChecked(false);
                }
                CompareWizardPage1.this.setPageComplete(CompareWizardPage1.this.isPageComplete());
            }
        });
        this.table.getDeleteListBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareWizardPage1.this.returnDDCM = CompareWizardPage1.this.displayDatasetChangedMsg();
                if (CompareWizardPage1.this.returnDDCM == -1) {
                    String message = "Are you sure you want to delete the existing member list? Clicking Yes will delete the existing member list";
                    boolean result = MessageDialog.openQuestion(null, (String)"Warning", (String)message);
                    if (result) {
                        CompareWizardPage1.this.table.getViewer().getTable().removeAll();
                        CompareWizardPage1.this.table.getClearSelBtn().setEnabled(false);
                        CompareWizardPage1.this.table.getDeleteListBtn().setEnabled(false);
                        CompareWizardPage1.this.setPageComplete(CompareWizardPage1.this.isPageComplete());
                    }
                } else if (CompareWizardPage1.this.returnDDCM == 3) {
                    CompareWizardPage1.this.dataSetCombo.setFocus();
                }
            }
        });
        this.table.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (CompareWizardPage1.this.table.getViewer().getCheckedElements().length >= 1) {
                    CompareWizardPage1.this.table.getClearSelBtn().setText("&Clear Selections");
                } else {
                    CompareWizardPage1.this.table.getClearSelBtn().setText("Select &All");
                }
                if (CompareWizardPage1.this.table.getViewer().getCheckedElements().length == 0) {
                    CompareWizardPage1.this.table.getClearSelBtn().setText("Select &All");
                }
                CompareWizardPage1.this.setPageComplete(CompareWizardPage1.this.isPageComplete());
            }
        });
        this.setControl((Control)this.container);
        if (!FMPreferences.disabledPreview()) {
            ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setText("&Preview");
        }
        if (this.getWizard().getPageCount() == 8) {
            this.isGenericOpen = true;
            if (this.isGenericOpen) {
                this.DirListInsert = new Button(this.container, 32);
                this.DirListInsert.setText("Add to Director&y List view");
            }
        }
    }

    private void createMembersTable() {
        this.table = new FMMembersTable(this.container);
        this.table.createTable();
    }

    public int displayDatasetChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.table.getViewer().getTable().getItemCount() > 0 || !this.newDatasetName.equals(this.dataSetName)) {
                String question = "Are you sure you want to change the data set? Clicking Yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.dataSetName = this.newDatasetName;
                    this.dataSet = new FileMasterDataset(null);
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.showDialog = false;
                    }
                    this.table.getViewer().getTable().removeAll();
                    this.table.getViewer().setInput(null);
                    this.memberNameCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.showDialog = false;
                    }
                    this.dataSetCombo.setText(this.dataSetName);
                    this.newDatasetName = this.dataSetName;
                }
            }
        }
        if (this.dataSet == null) {
            this.dataSet = new FileMasterDataset(null);
        }
        this.dataSet.setName(this.newDatasetName);
        return returncode;
    }

    @Override
    public boolean isPageComplete() {
        if (this.table == null || this.table.getViewer() == null || this.memberNameCombo == null) {
            return false;
        }
        this.newDatasetName = this.dataSetCombo.getText().trim();
        boolean bl = this.showDialog = !this.store.getBoolean("CLOSE_VALUE");
        if (super.isPageComplete()) {
            if (!(!this.showDialog || this.getErrorMessage() != null || this.table.getViewer().getTable().getItemCount() <= 1 && this.memberNameCombo.getText().isEmpty() || this.dataSetName.equalsIgnoreCase(this.newDatasetName))) {
                this.pendingMessage = true;
            } else {
                this.pendingMessage = false;
                if (!this.dataSetName.equalsIgnoreCase(this.newDatasetName)) {
                    this.dataSetName = this.newDatasetName;
                    this.table.getViewer().getTable().removeAll();
                    this.table.getViewer().setInput(null);
                    this.memberNameCombo.setText("");
                }
            }
            this.displayDatasetChangedMsg();
            if (this.dataSetType.equals("PDS") || this.dataSetType.equals("PDSE") || this.dataSetType.equals("Member")) {
                this.error = Validator.validateMember(this.memberNameCombo, this.selectMemberButton, this.error);
                if ((this.error.equals(String.valueOf(Validator.errorMsg[5]) + "\n") || this.error.equals(String.valueOf(Validator.errorMsg[7]) + "\n")) && this.table.getViewer().getCheckedElements().length != 0) {
                    this.error = "";
                }
                if (this.error.equals(String.valueOf(Validator.errorMsg[7]) + "\n") && this.memberNameCombo.getText().length() == 1) {
                    this.error = "";
                }
            }
            if (this.error.isEmpty()) {
                this.setErrorMessage(null);
                return true;
            }
            this.setErrorMessage(this.error);
            return false;
        }
        return false;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() instanceof CompareGenericWizard) {
            CompareWizardPage2 cp2 = (CompareWizardPage2)((CompareGenericWizard)this.getWizard()).getPage("New Data Set");
            return cp2;
        }
        CompareWizardPage2 cp2 = (CompareWizardPage2)((CompareWizard)this.getWizard()).getPage("New Data Set");
        return cp2;
    }

    @Override
    public String getDataSetName() {
        return this.dataSetCombo.getText().trim();
    }

    public Combo getMemberNameCombo() {
        return this.memberNameCombo;
    }

    public String getMembersName() {
        String members = "";
        Object[] obj = this.table.getViewer().getCheckedElements();
        if (obj.length > 0) {
            int i = 0;
            while (i < obj.length) {
                members = String.valueOf(members) + ((FileMasterMember)((Object)obj[i])).getName() + " ";
                ++i;
            }
            return members;
        }
        return this.memberNameCombo.getText();
    }

    public Object[] getSelectedMembers() {
        return this.table.getViewer().getCheckedElements();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.memberNameCombo.setFocus();
        if (this.getWizard().getWindowTitle().contains("Program")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareProgramWizardPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ca.filemaster.help.compareWizardPage");
        }
    }

    public void setDatasetCombo(String datasetName) {
        this.dataSetCombo.setText(datasetName);
    }

    public void setMemberCombo(String memberName) {
        this.memberNameCombo.setText(memberName);
    }

    public FileMasterDataset getOldDataset() {
        if (this.fmdataset == null) {
            this.fmdataset = CommonMFCalls.getFQDSN(this.dataSetCombo.getText(), "", this.server);
        } else if (!this.fmdataset.getName().equalsIgnoreCase(this.dataSetCombo.getText())) {
            this.fmdataset = CommonMFCalls.getFQDSN(this.dataSetCombo.getText(), "", this.server);
        }
        return this.fmdataset;
    }

    public void setDatasetType(String datasetType) {
        this.dataSetType = datasetType;
        if (this.dataSetType.equals("PDS") || this.dataSetType.equals("PDSE") || this.dataSetType.equals("Member") || this.dataSetType.equals("")) {
            this.memberNameCombo.setEnabled(true);
            this.selectMemberButton.setEnabled(true);
        } else {
            this.memberNameCombo.setEnabled(false);
            this.selectMemberButton.setEnabled(false);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public void insertDSNToField(String value) {
        this.dataSetCombo.setText(value);
    }

    public void insertIntoDirecotryList() {
        if (this.DirListInsert.getSelection()) {
            int numCheckedMembers;
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.dataSetCombo.getText());
            fmdataset.setDsOrg(this.dataSetType);
            TT_TreeItem dsItem = null;
            int index = 0;
            int i = 0;
            while (i < this.model.getServers().length) {
                if (this.model.getServers()[i].getName().equals(this.server.getName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
            if (dsItem == null) {
                Element dsElement = this.model.addDataset(this.server.getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
                dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            }
            if ((numCheckedMembers = this.table.getViewer().getCheckedElements().length) > 0) {
                int i2 = 0;
                while (i2 < numCheckedMembers) {
                    this.insertMemberToTree(dsItem, ((FileMasterMember)((Object)this.table.getViewer().getCheckedElements()[i2])).getName().trim());
                    ++i2;
                }
            } else {
                this.insertMemberToTree(dsItem, this.memberNameCombo.getText().trim());
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = window.getShell();
            shell.setMinimized(false);
            shell.forceActive();
            shell.forceFocus();
            try {
                TreeViewer viewer;
                IWorkbenchPage page = window.getActivePage();
                IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                    viewer.refresh(true);
                    view = page.showView("com.ca.filemaster.views.directorylist");
                    page.activate((IWorkbenchPart)view);
                    page.bringToTop((IWorkbenchPart)view);
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {}
            this.model.save();
        }
    }

    private void insertMemberToTree(TT_TreeItem dsItem, String name) {
        boolean isDuplicatedMember = false;
        FileMasterMember fmmember = new FileMasterMember(null);
        if (name.length() != 0) {
            fmmember.setName(name.trim());
            fmmember.setType("MEMBER");
            if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                isDuplicatedMember = true;
            }
            if (!isDuplicatedMember) {
                Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                this.model.insertMember(dsItem, memItem);
            }
        }
    }

    public void insertMemberToField(String value) {
        this.memberNameCombo.setText(value);
    }
}

