/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetSelectionMem;
import com.ca.filemaster.runners.RunGetWCMEM;
import com.ca.filemaster.ui.wizards.DatasetWizard;
import com.ca.filemaster.ui.wizards.DatasetWizardPage;
import com.ca.filemaster.ui.wizards.DescriptionLabelProvider;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPageSorter;
import com.ca.filemaster.ui.wizards.NameLabelProvider;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportSelCritWizardPage
extends FileMasterWizard
implements ModifyListener,
SelectionListener,
Listener,
ICheckStateListener {
    protected FileMasterServer server;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private FMSelectionTreeModel fmstModel = FMSelectionTreeModel.getInstance();
    private FileMasterMember member;
    protected Label labelServer;
    private Label selectMemberLabel;
    protected Combo servername;
    Combo selectViewCombo;
    Combo selectdsnCombo;
    Combo selectMemberCombo;
    private Button selectAll;
    private Button btnMemberSelect;
    protected Button seldsnBtn;
    protected Button selView;
    String newServer;
    String oldServer;
    boolean pendingMessage = false;
    boolean msgDisplayed;
    private String newDatasetName;
    private String oldDatasetName;
    private Text numberOfMem;
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    private Boolean ShowDialog = false;
    private static String[] SelConds;
    private static ArrayList<String> contentSelRec;
    protected CheckboxTableViewer viewer;
    private static final int NAME = 0;
    private static final int DESCRIPTION = 1;
    private Listener sortListener;
    public static Button saveSelCrit;
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.importSelCrit";
    protected String missingDSandMem;
    private ArrayList<FileMasterMember> memberList = new ArrayList();
    private String selDataSetName;
    private String selMemberName;
    public static String conditions;
    private static String layDsname;
    private static String LayMem;
    private ArrayList<String> TempmembersList = new ArrayList();

    static {
        contentSelRec = new ArrayList();
        conditions = "";
    }

    public ImportSelCritWizardPage(String pageName, FileMasterServer server, String[] SelConds) {
        super(pageName, "", server);
        this.setTitle(pageName);
        this.server = server;
        ImportSelCritWizardPage.SelConds = SelConds;
        this.missingDSandMem = "Please select a Selection data set and member\n ";
    }

    public ImportSelCritWizardPage(String pageName, FileMasterServer server) {
        super(pageName, "", server);
        this.setTitle(pageName);
        this.server = server;
        this.missingDSandMem = "Please select a DSN List data set and member\n ";
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.importSelCrit");
        saveSelCrit = new Button(parent, 0);
        saveSelCrit.setEnabled(false);
        this.labelServer = new Label(this.dataSetComposite, 16385);
        this.labelServer.setText("Se&rver:");
        GridData gd_labelServer = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_labelServer.horizontalIndent = 16;
        this.labelServer.setLayoutData((Object)gd_labelServer);
        this.servername = new Combo(this.dataSetComposite, 2056);
        this.servername.setItems(this.getServers());
        this.servername.setText(this.server.getText());
        TextUtil.setWidth((Combo)this.servername, (int)37);
        this.servername.addListener(13, (Listener)this);
        if (this.servername.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer("ServerAddSelcritWizardPage");
            int count = 0;
            while (count < this.servername.getItemCount()) {
                if (this.servername.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.servername.setText(this.servername.getItem(count).toString());
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.servername.setText(this.servername.getItem(0));
            }
        }
        this.servername.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!ImportSelCritWizardPage.this.msgDisplayed) {
                    ImportSelCritWizardPage.this.oldServer = ImportSelCritWizardPage.this.servername.getText();
                }
                ImportSelCritWizardPage.this.msgDisplayed = false;
            }
        });
        this.servername.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportSelCritWizardPage.this.newServer = ImportSelCritWizardPage.this.servername.getText().trim();
                ImportSelCritWizardPage.this.server = FMServerTreeModel.getInstance().getServer(ImportSelCritWizardPage.this.newServer.split("\\(")[0]);
                ImportSelCritWizardPage.this.pendingMessage = true;
                if (ImportSelCritWizardPage.this.oldServer != null) {
                    ImportSelCritWizardPage.this.displayServerChangedMsg();
                }
                ImportSelCritWizardPage.this.changeServer();
                ImportSelCritWizardPage.this.setPageComplete(ImportSelCritWizardPage.this.canFlipToNextPage());
            }
        });
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.selView = new Button(this.dataSetComposite, 16);
        this.selView.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportSelCritWizardPage.this.selectdsnCombo.setEnabled(false);
                ImportSelCritWizardPage.this.dataSetDSNListBtn.setEnabled(false);
                ImportSelCritWizardPage.this.selectMemberCombo.setEnabled(false);
                ImportSelCritWizardPage.this.selectViewCombo.setEnabled(true);
                ImportSelCritWizardPage.this.setPageComplete(ImportSelCritWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selView.setSelection(true);
        this.selView.setText("Selec&tion view:");
        this.selectViewCombo = new Combo(this.dataSetComposite, 8);
        TextUtil.setWidth((Combo)this.selectViewCombo, (int)37);
        this.selectViewCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        this.selectViewCombo.setEnabled(true);
        this.selectViewCombo.setVisibleItemCount(10);
        ArrayList<String> SelectViewDS = new ArrayList<String>();
        SelectViewDS.add("(none)");
        int count = 0;
        while (count < this.fmstModel.getDatasets().length) {
            int childCount = 0;
            while (childCount < this.fmstModel.getDatasets()[count].getChildren().length) {
                SelectViewDS.add(String.valueOf(this.fmstModel.getDatasets()[count].getName()) + "(" + ((TT_TreeItem)this.fmstModel.getDatasets()[count].getChildren()[childCount]).getName() + ")");
                ++childCount;
            }
            ++count;
        }
        this.selectViewCombo.setItems(SelectViewDS.toArray(new String[SelectViewDS.size()]));
        this.selectViewCombo.select(0);
        this.selectViewCombo.addModifyListener((ModifyListener)this);
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
        this.seldsnBtn = new Button(this.dataSetComposite, 16);
        this.seldsnBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportSelCritWizardPage.this.selectdsnCombo.setEnabled(true);
                ImportSelCritWizardPage.this.dataSetDSNListBtn.setEnabled(true);
                ImportSelCritWizardPage.this.selectMemberCombo.setEnabled(true);
                ImportSelCritWizardPage.this.selectViewCombo.setEnabled(false);
                ImportSelCritWizardPage.this.setPageComplete(ImportSelCritWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.seldsnBtn.setSelection(false);
        this.seldsnBtn.setText("Select &data set:");
        this.selectdsnCombo = new Combo(this.dataSetComposite, 2048);
        this.selectdsnCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (!ImportSelCritWizardPage.this.msgDisplayed) {
                    ImportSelCritWizardPage.this.oldDatasetName = ImportSelCritWizardPage.this.selectdsnCombo.getText();
                }
                ImportSelCritWizardPage.this.msgDisplayed = false;
            }
        });
        this.selectdsnCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                boolean datasetError;
                ImportSelCritWizardPage.this.newDatasetName = ImportSelCritWizardPage.this.selectdsnCombo.getText().trim();
                ImportSelCritWizardPage.this.ShowDialog = !ImportSelCritWizardPage.this.store.getBoolean("CLOSE_VALUE");
                boolean bl = datasetError = Validator.dataset(ImportSelCritWizardPage.this.selectdsnCombo.getText(), true) != 0 && Validator.dataset(ImportSelCritWizardPage.this.selectdsnCombo.getText(), true) != 3 && Validator.dataset(ImportSelCritWizardPage.this.selectdsnCombo.getText(), true) != 1;
                if (!(!ImportSelCritWizardPage.this.ShowDialog.booleanValue() || datasetError || ImportSelCritWizardPage.this.viewer.getTable().getItemCount() <= 1 && ImportSelCritWizardPage.this.selectMemberCombo.getText().isEmpty() || ImportSelCritWizardPage.this.oldDatasetName.equalsIgnoreCase(ImportSelCritWizardPage.this.newDatasetName))) {
                    ImportSelCritWizardPage.this.pendingMessage = true;
                } else {
                    ImportSelCritWizardPage.this.pendingMessage = false;
                    if (!ImportSelCritWizardPage.this.oldDatasetName.equalsIgnoreCase(ImportSelCritWizardPage.this.newDatasetName)) {
                        ImportSelCritWizardPage.this.oldDatasetName = ImportSelCritWizardPage.this.newDatasetName;
                        ImportSelCritWizardPage.this.viewer.getTable().removeAll();
                        ImportSelCritWizardPage.this.viewer.setInput(null);
                        ImportSelCritWizardPage.this.selectMemberCombo.setText("");
                    }
                }
                ImportSelCritWizardPage.this.displayDatasetChangedMsg();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.selectdsnCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean datasetError;
                ImportSelCritWizardPage.this.newDatasetName = ImportSelCritWizardPage.this.selectdsnCombo.getText().trim();
                ImportSelCritWizardPage.this.ShowDialog = !ImportSelCritWizardPage.this.store.getBoolean("CLOSE_VALUE");
                boolean bl = datasetError = Validator.dataset(ImportSelCritWizardPage.this.selectdsnCombo.getText(), true) != 0 && Validator.dataset(ImportSelCritWizardPage.this.selectdsnCombo.getText(), true) != 3 && Validator.dataset(ImportSelCritWizardPage.this.selectdsnCombo.getText(), true) != 1;
                if (!(!ImportSelCritWizardPage.this.ShowDialog.booleanValue() || datasetError || ImportSelCritWizardPage.this.viewer.getTable().getItemCount() <= 1 && ImportSelCritWizardPage.this.selectMemberCombo.getText().isEmpty() || ImportSelCritWizardPage.this.oldDatasetName.equalsIgnoreCase(ImportSelCritWizardPage.this.newDatasetName))) {
                    ImportSelCritWizardPage.this.pendingMessage = true;
                } else {
                    ImportSelCritWizardPage.this.pendingMessage = false;
                    if (!ImportSelCritWizardPage.this.oldDatasetName.equalsIgnoreCase(ImportSelCritWizardPage.this.newDatasetName)) {
                        ImportSelCritWizardPage.this.oldDatasetName = ImportSelCritWizardPage.this.newDatasetName;
                        ImportSelCritWizardPage.this.viewer.getTable().removeAll();
                        ImportSelCritWizardPage.this.viewer.setInput(null);
                        ImportSelCritWizardPage.this.selectMemberCombo.setText("");
                    }
                }
                ImportSelCritWizardPage.this.displayDatasetChangedMsg();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectdsnCombo.addModifyListener((ModifyListener)this);
        this.selectdsnCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.selectdsnCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.selectdsnCombo, (int)35);
        this.selectdsnCombo.setTextLimit(44);
        FMHistory.intializeComboBoxes(this.selectdsnCombo, "ImportSelCritSelectDSN");
        this.selectdsnCombo.setEnabled(false);
        this.dataSetSelectBtn = new Button(this.dataSetComposite, 0);
        this.dataSetSelectBtn.setEnabled(false);
        this.dataSetSelectBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportSelCritWizardPage.this.FMWWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataSetSelectBtn.setText("&Select...");
        this.dataSetDSNListBtn = new Button(this.dataSetComposite, 0);
        this.dataSetDSNListBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportSelCritWizardPage.this.FMWWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataSetDSNListBtn.setText("DSN &List...");
        this.dataSetDSNListBtn.setEnabled(false);
        this.dataSetDSNListBtn.setVisible(false);
        this.selectMemberLabel = new Label(this.dataSetComposite, 0);
        GridData gd_selectMemberLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectMemberLabel.horizontalIndent = 16;
        this.selectMemberLabel.setLayoutData((Object)gd_selectMemberLabel);
        this.selectMemberLabel.setText("&Member name:");
        this.selectMemberCombo = new Combo(this.dataSetComposite, 0);
        this.selectMemberCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        this.selectMemberCombo.setTextLimit(8);
        GridData gd_layoutMemberCombo = new GridData(4, 4, false, false, 1, 1);
        gd_layoutMemberCombo.widthHint = 107;
        this.selectMemberCombo.addModifyListener((ModifyListener)this);
        this.selectMemberCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        FMHistory.intializeComboBoxes(this.selectMemberCombo, "ImportSelCritSelectMember");
        this.selectMemberCombo.setEnabled(false);
        this.btnMemberSelect = new Button(this.dataSetComposite, 0);
        this.btnMemberSelect.setText("S&elect");
        this.btnMemberSelect.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnMemberSelect.setEnabled(false);
        new Label(this.dataSetComposite, 0);
        this.btnMemberSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSelCritWizardPage.this.member = new FileMasterMember(null);
                ImportSelCritWizardPage.this.member.setName(ImportSelCritWizardPage.this.selectMemberCombo.getText());
                if (ImportSelCritWizardPage.this.fmdataset == null) {
                    ImportSelCritWizardPage.this.fmdataset = CommonMFCalls.getFQDSN(ImportSelCritWizardPage.this.selectdsnCombo.getText(), "", ImportSelCritWizardPage.this.server);
                }
                ImportSelCritWizardPage.this.doSelect();
            }
        });
        this.dataSetComposite.setTabList(new Control[]{this.servername, this.selView, this.selectViewCombo, this.seldsnBtn, this.selectdsnCombo, this.dataSetSelectBtn, this.dataSetDSNListBtn, this.selectMemberCombo, this.btnMemberSelect});
        Composite memberTbl = new Composite(this.container, 0);
        memberTbl.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout memberTbl_layout = new GridLayout(2, false);
        memberTbl.setLayout((Layout)memberTbl_layout);
        this.createViewer(memberTbl);
        this.selectAll = new Button(memberTbl, 8);
        this.selectAll.setText("Select &All");
        GridData gd_selectAll = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAll.widthHint = 120;
        this.selectAll.setLayoutData((Object)gd_selectAll);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportSelCritWizardPage.this.viewer.getTable().getItems().length > 0) {
                    if (ImportSelCritWizardPage.this.selectAll.getText().toString().equalsIgnoreCase("Select &All")) {
                        int i = 0;
                        while (i < ImportSelCritWizardPage.this.viewer.getTable().getItems().length) {
                            ImportSelCritWizardPage.this.viewer.getTable().getItem(i).setChecked(true);
                            ++i;
                        }
                        ImportSelCritWizardPage.this.selectAll.setText("&Clear Selections");
                    } else {
                        ImportSelCritWizardPage.this.selectAll.setText("Select &All");
                        int i = 0;
                        while (i < ImportSelCritWizardPage.this.viewer.getTable().getItems().length) {
                            ImportSelCritWizardPage.this.viewer.getTable().getItem(i).setChecked(false);
                            ++i;
                        }
                    }
                }
                ImportSelCritWizardPage.this.setPageComplete(ImportSelCritWizardPage.this.isPageComplete());
            }
        });
        this.numberOfMem = new Text(memberTbl, 8);
        this.numberOfMem.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.numberOfMem, (int)12);
        this.numberOfMem.setEnabled(false);
        this.getShell().getDefaultButton().setText("OK");
        this.setControl((Control)this.container);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.setPageComplete(this.isPageComplete());
    }

    private void createViewer(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        gd_table.heightHint = 130;
        gd_table.widthHint = 534;
        this.viewer.getTable().setLayoutData((Object)gd_table);
        this.setupColumnListener();
        this.createColumns(parent, (TableViewer)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(null);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                event.getCheckable().setChecked(event.getElement(), event.getChecked());
                ImportSelCritWizardPage.this.setPageComplete(ImportSelCritWizardPage.this.isPageComplete());
            }
        });
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.model.getServers().length) {
            TestServer = this.model.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.servername.getText())) {
                this.server = (FileMasterServer)((Object)this.model.getServers()[servers].getAdapter(FileMasterServer.class));
                this.serverChanged(this.server);
                break;
            }
            ++servers;
        }
    }

    private int displayServerChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newServer != null && !this.newServer.equals(this.oldServer)) {
                String question = "Are you sure you want to change the server? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Server Change", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldServer = this.newServer;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.viewer.getTable().removeAll();
                    this.viewer.setInput(null);
                    this.selectMemberCombo.setText("");
                    this.selectdsnCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.servername.setText(this.oldServer);
                    this.newServer = this.oldServer;
                }
            }
        }
        return returncode;
    }

    private int displayDatasetChangedMsg() {
        this.msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (this.pendingMessage) {
            this.pendingMessage = false;
            if (this.newDatasetName != null && !this.newDatasetName.equals(this.oldDatasetName)) {
                String question = "Are you sure you want to change the data set? Clicking yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)this.store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    this.oldDatasetName = this.newDatasetName;
                    this.store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.viewer.getTable().removeAll();
                    this.viewer.setInput(null);
                    this.selectMemberCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        this.ShowDialog = false;
                    }
                    this.selectdsnCombo.setText(this.oldDatasetName);
                    this.newDatasetName = this.oldDatasetName;
                }
            }
        }
        return returncode;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Name", "Description"};
        int[] bounds = new int[]{100, 300};
        Table table = viewer.getTable();
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableColumn = new TableViewerColumn(viewer, bounds[i]);
            switch (i) {
                case 0: {
                    tableColumn.setLabelProvider((CellLabelProvider)new NameLabelProvider());
                    break;
                }
                case 1: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DescriptionLabelProvider());
                }
            }
            tableColumn.getColumn().setText(titles[i]);
            tableColumn.getColumn().setWidth(bounds[i]);
            tableColumn.getColumn().addListener(13, this.sortListener);
            ++i;
        }
        viewer.setSorter((ViewerSorter)new ImportSelCritWizardPageSorter());
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
    }

    private void setupColumnListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = ImportSelCritWizardPage.this.viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                ImportSelCritWizardPage.this.viewer.refresh();
            }
        };
    }

    public void handleEvent(Event event) {
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (((Button)source).getText().equals("&Select...")) {
            DatasetWizard wizard = new DatasetWizard(true);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        } else if (this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"DSN lists PDS in preferences is undefined. No DSN lists found");
        } else if (this.selectdsnCombo.getText().isEmpty() || Validator.dataset(this.selectdsnCombo.getText(), true) == 3) {
            GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
            this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
            this.dialog.open();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.model.getServers().length];
        int serverCount = 0;
        while (serverCount < this.model.getServers().length) {
            listOfServers[serverCount] = this.model.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        return listOfServers;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isPageComplete() {
        if (this.viewer != null && this.selectAll != null) {
            if (this.viewer.getTable().getItemCount() == 0) {
                this.selectAll.setEnabled(false);
            } else {
                this.selectAll.setEnabled(true);
            }
        }
        if (this.selectMemberCombo != null && this.dataSetSelectBtn != null && this.btnMemberSelect != null && this.selectViewCombo != null) {
            if (this.error.length() == 0 && !this.seldsnBtn.getSelection() && this.selectViewCombo.getText().equalsIgnoreCase("(none)")) {
                this.error = String.valueOf(this.error) + this.missingDSandMem;
            }
            if (this.error.length() == 0 && this.seldsnBtn.getSelection()) {
                switch (Validator.dataset(this.selectdsnCombo.getText(), true)) {
                    case 3: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[3] + "\n";
                        this.dataSetSelectBtn.setEnabled(true);
                        this.dataSetDSNListBtn.setEnabled(true);
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.selectdsnCombo.getText(), true)] + "\n ";
                        this.dataSetSelectBtn.setEnabled(false);
                        this.dataSetDSNListBtn.setEnabled(false);
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 1: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[1] + "\n";
                        break;
                    }
                    case 0: {
                        this.dataSetSelectBtn.setEnabled(false);
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                }
            }
            if (this.error.length() == 0 && this.seldsnBtn.getSelection()) {
                switch (Validator.member(this.selectMemberCombo.getText(), false)) {
                    case 7: {
                        if (Validator.dataset(this.selectdsnCombo.getText(), true) != 1) {
                            this.btnMemberSelect.setEnabled(true);
                            if (this.viewer.getCheckedElements().length != 0) break;
                            this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.selectMemberCombo.getText(), true)] + "\n ";
                            break;
                        }
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.selectdsnCombo.getText(), true)] + "\n ";
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 6: {
                        if (Validator.dataset(this.selectdsnCombo.getText(), true) != 1) {
                            if (this.viewer.getCheckedElements().length == 0) {
                                this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.selectMemberCombo.getText(), false)] + "\n ";
                            }
                        } else {
                            this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.selectdsnCombo.getText(), true)] + "\n ";
                        }
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 0: {
                        if (Validator.member(this.selectMemberCombo.getText(), true) != 5) {
                            if (Validator.dataset(this.selectdsnCombo.getText(), true) == 1) {
                                this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.dataset(this.selectdsnCombo.getText(), true)] + "\n ";
                            }
                            this.btnMemberSelect.setEnabled(false);
                            break;
                        }
                        if (Validator.dataset(this.selectdsnCombo.getText(), true) == 1 || this.viewer.getCheckedElements().length != 0) break;
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.selectMemberCombo.getText(), true)] + "\n ";
                        break;
                    }
                }
                if (this.selectMemberCombo.getText().trim().length() == 0 && Validator.dataset(this.selectdsnCombo.getText(), true) == 0) {
                    this.btnMemberSelect.setEnabled(true);
                }
            }
        }
        if (this.error.length() <= 0) {
            this.setErrorMessage(null);
            return true;
        }
        if (this.getErrorMessage() == null) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        if (!this.getErrorMessage().equalsIgnoreCase(this.error)) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        this.error = new String();
        return false;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.viewer.getCheckedElements().length >= 1) {
            this.selectAll.setText("&Clear Selections");
        } else {
            this.selectAll.setText("Select &All");
        }
        if (this.viewer.getCheckedElements().length == 0) {
            this.selectAll.setText("Select &All");
        }
        this.setPageComplete(this.canFlipToNextPage());
    }

    protected boolean ValidateMember() {
        if (this.selectMemberCombo != null && this.btnMemberSelect != null) {
            if (Validator.member(this.selectMemberCombo.getText(), true) == 0) {
                this.btnMemberSelect.setEnabled(false);
                return true;
            }
            if (this.btnMemberSelect != null && this.viewer != null) {
                switch (Validator.member(this.selectMemberCombo.getText(), true)) {
                    case 0: 
                    case 7: {
                        this.btnMemberSelect.setEnabled(true);
                        break;
                    }
                    case 6: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.selectMemberCombo.getText(), true)] + "\n";
                        this.btnMemberSelect.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member(this.selectMemberCombo.getText(), true)] + "\n";
                        if (this.viewer.getCheckedElements().length <= 0) break;
                        this.error = new String();
                    }
                }
                if (this.error.length() > 0) {
                    this.setErrorMessage(this.error);
                    return this.viewer.getCheckedElements().length > 0;
                }
                this.setErrorMessage(null);
                return this.viewer.getCheckedElements().length > 0;
            }
        }
        return false;
    }

    private void doSelect() {
        int oldSelectedMember = this.viewer.getCheckedElements().length;
        this.memberList.clear();
        int i = 0;
        while (i < oldSelectedMember) {
            this.memberList.add((FileMasterMember)((Object)this.viewer.getCheckedElements()[i]));
            ++i;
        }
        FileMasterMember member = new FileMasterMember(null);
        FileMasterDataset dataset = new FileMasterDataset(null);
        member.setName(this.selectMemberCombo.getText());
        dataset.setName(this.selectdsnCombo.getText());
        RunGetWCMEM runner = new RunGetWCMEM(dataset, this.server, member, true, "L");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                this.numberOfMem.setText("No members returned.");
                this.numberOfMem.setEnabled(true);
            } else {
                NodeList nodes = element.getElementsByTagName("MemberInfo");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i2 = 0;
                    while (i2 < messages.getLength()) {
                        Node msgNode = messages.item(i2);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + this.getTagValue("Message", msgElement);
                        ++i2;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = this.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    this.numberOfMem.setText("No members returned.");
                    this.numberOfMem.setEnabled(true);
                } else {
                    int i3 = 0;
                    while (i3 < nodes.getLength()) {
                        Element memElement = (Element)nodes.item(i3);
                        FileMasterMember wcMember = new FileMasterMember(null);
                        if (memElement.getAttribute("fmfiletype").equalsIgnoreCase("S")) {
                            wcMember.setName(memElement.getAttribute("name"));
                            wcMember.setRecordCount(memElement.getAttribute("recordCount"));
                            wcMember.setDateCreated(memElement.getAttribute("dateCreated"));
                            wcMember.setDateChanged(memElement.getAttribute("dateChanged"));
                            wcMember.setID(memElement.getAttribute("userID"));
                            wcMember.setCLDescription(memElement.getAttribute("description"));
                            if (!this.memberList.contains((Object)wcMember)) {
                                this.memberList.add(wcMember);
                            }
                        }
                        this.viewer.setInput((Object)this.memberList.toArray(new FileMasterMember[this.memberList.size()]));
                        this.viewer.refresh();
                        if (this.memberList.size() == 1) {
                            this.numberOfMem.setText(String.valueOf(this.memberList.size()) + " member returned.");
                        } else {
                            this.numberOfMem.setText(String.valueOf(this.memberList.size()) + " members returned.");
                        }
                        this.numberOfMem.setEnabled(true);
                        ++i3;
                    }
                }
                if (this.memberList.size() > 0) {
                    this.selectAll.setEnabled(true);
                } else {
                    this.selectAll.setEnabled(false);
                }
            }
        }
    }

    private String getTagValue(String sTag, Element msgElement) {
        NodeList nlList = msgElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    @Override
    public void FMWWidgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (source instanceof Button) {
            if (((Button)source).getText().equals("&Select...")) {
                DatasetWizard wizard = new DatasetWizard(true, this.selectdsnCombo.getText(), "", this.server.getName());
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                this.dialog.create();
                DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ImportSelCritWizardPage.this.fmdataset = DatasetWizardPage.getSelectedDSN();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.dialog.open();
            } else if (this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)Validator.errorMsg[20]);
            } else if (this.selectdsnCombo.getText().isEmpty() || Validator.dataset(this.selectdsnCombo.getText(), true) == 3) {
                GenericImportWizard wizard = new GenericImportWizard("Select DSN List", this.server, false);
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                this.dialog.open();
            } else {
                DatasetWizard wizard = new DatasetWizard(false);
                this.dialog = new TestingToolsWizardDialog(this.getShell(), (IWizard)wizard);
                this.dialog.open();
            }
        }
    }

    public void insertMembersToTable(List<FileMasterMember> members) {
        ArrayList<FileMasterMember> oldMembers = new ArrayList<FileMasterMember>();
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            if (this.viewer.getTable().getItem(i).getChecked()) {
                oldMembers.add((FileMasterMember)((Object)this.viewer.getElementAt(i)));
            }
            ++i;
        }
        i = 0;
        while (i < members.size()) {
            oldMembers.add(members.get(i));
            ++i;
        }
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)oldMembers.toArray());
        this.viewer.setAllChecked(true);
        if (this.viewer.getTable().getItemCount() == 0) {
            this.selectAll.setEnabled(false);
        }
        if (this.viewer.getCheckedElements().length == this.viewer.getTable().getItemCount()) {
            this.selectAll.setText("&Clear Selections");
        } else {
            this.selectAll.setText("Select &All");
        }
        if (members.size() > 0) {
            i = 0;
            while (i < this.viewer.getTable().getItemCount()) {
                ((FileMasterMember)((Object)this.viewer.getTable().getItems()[i].getData())).setChecked(true);
                ++i;
            }
            this.setPageComplete(this.isPageComplete());
            this.selectAll.setEnabled(true);
        }
    }

    public boolean doFinish() {
        FMHistory.insertHistory(this.selectdsnCombo, "ImportSelCritSelectDSN");
        FMHistory.insertHistory(this.selectMemberCombo, "ImportSelCritSelectMember");
        this.TempmembersList = new ArrayList();
        if (this.selView.getSelection()) {
            this.selDataSetName = this.selectViewCombo.getText().split("\\(.+?\\)")[0];
            this.selMemberName = this.selectViewCombo.getText().split(".+?\\(")[1];
            this.selMemberName = this.selMemberName.substring(0, this.selMemberName.length() - 1);
            this.TempmembersList.add(this.selMemberName);
        } else {
            this.selDataSetName = this.selectdsnCombo.getText().trim();
            int numCheckedMembers = this.viewer.getCheckedElements().length;
            if (numCheckedMembers > 0) {
                int i = 0;
                while (i < numCheckedMembers) {
                    this.TempmembersList.add(((FileMasterMember)((Object)this.viewer.getCheckedElements()[i])).getName());
                    ++i;
                }
            } else {
                this.selMemberName = this.selectMemberCombo.getText().trim();
                this.TempmembersList.add(this.selMemberName);
            }
        }
        int i = 0;
        while (i < this.TempmembersList.size()) {
            this.selMemberName = this.TempmembersList.get(i);
            XMLRequest xml = this.getSelectionMem();
            this.handleResponse(xml);
            ++i;
        }
        saveSelCrit.notifyListeners(13, new Event());
        return true;
    }

    private void handleResponse(XMLRequest xml) {
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList dsLayNodeList = element.getElementsByTagName("DataSetName");
                NodeList memLayNodeList = element.getElementsByTagName("MemberName");
                NodeList nodes = element.getElementsByTagName("FMProcessingParmMbrRecord");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + this.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = this.getTagValue("ReturnCode", rcElement);
                    if (message.length() > 0) {
                        TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    }
                } else {
                    Node dsLayNode = dsLayNodeList.item(0);
                    Node memLayNode = memLayNodeList.item(0);
                    if (dsLayNode != null) {
                        Element dsLayElement = (Element)dsLayNode;
                        layDsname = this.getTagValue("DataSetName", dsLayElement);
                        Element memLayElement = (Element)memLayNode;
                        LayMem = this.getTagValue("MemberName", memLayElement);
                    }
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element lineElement = (Element)nodes.item(i);
                        String line = new String();
                        line = this.getTagValue("FMProcessingParmMbrRecord", lineElement);
                        contentSelRec.add(line);
                        ++i;
                    }
                }
            }
        }
    }

    public static String getLayDsname() {
        return layDsname;
    }

    public void setLayDsname(String layDsname) {
        ImportSelCritWizardPage.layDsname = layDsname;
    }

    public static String getLayMem() {
        return LayMem;
    }

    public void setLayMem(String layMem) {
        LayMem = layMem;
    }

    private XMLRequest getSelectionMem() {
        RunGetSelectionMem runner = new RunGetSelectionMem(this.server, this.selDataSetName, this.selMemberName);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        return runner.getXml();
    }

    public static String getNewCondition() {
        int i = 0;
        while (i < contentSelRec.size()) {
            if (!contentSelRec.isEmpty()) {
                conditions = String.valueOf(conditions) + contentSelRec.get(i) + "\r\n";
            }
            ++i;
        }
        contentSelRec.clear();
        return conditions;
    }

    public static void setConditions(String conditions) {
        ImportSelCritWizardPage.conditions = "";
    }

    public void setDSNCombo(String selDSNString) {
        this.selectdsnCombo.setText(selDSNString);
    }
}

