/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.LineRange;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunGetUppercase
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String displayMode;
    private String uuid;
    private boolean canRetry = true;
    private static final String SERVICE = "filemaster/fmp";
    private String hexMode = "N";
    private ArrayList<LineRange> ranges;

    public RunGetUppercase(FileMasterServer server, String uuid, String displayMode, String hexMode, ArrayList<LineRange> ranges) {
        this.displayMode = displayMode;
        this.server = server;
        this.hexMode = hexMode;
        this.uuid = uuid;
        this.ranges = ranges;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = connection.connect("lupcase", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                this.xml.getRoot();
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">" + "<ProcessLines>" + "<SimpleCommand operation=\"UPPERCASE\" />";
        int i = 0;
        while (i < this.ranges.size()) {
            command = String.valueOf(command) + "<LineRange start=\"" + this.ranges.get(i).getStart() + "\" end=\"" + this.ranges.get(i).getEnd() + "\" />";
            ++i;
        }
        command = String.valueOf(command) + "</ProcessLines></Edit></GUIRequest>";
        return CommonMFCalls.createXMLDoc(command);
    }
}

