/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunGetFindExclude
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String displayMode;
    private String uuid;
    private boolean canRetry = true;
    private static final String SERVICE = "filemaster/fmp";
    private String hexMode = "N";
    private int findlim;
    private String findString;
    private String changeString;
    private FMPCursor cursor;
    private FMPRange colsRange;
    private String occurence;
    private String location;
    private String excludeOption;
    private String commandType;
    private String padCharecter;
    private boolean isFind;

    public RunGetFindExclude(String commandType, FileMasterServer server, String uuid, String displayMode, String hexMode, int findlim, String findString, String changeString, String padCharecter, FMPCursor cursorRange, FMPRange colsRange, String occurence, String location, String excludeOption) {
        this.commandType = commandType;
        this.isFind = !commandType.equalsIgnoreCase("Exclude");
        this.server = server;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
        this.findlim = findlim;
        this.findString = findString.replace("&", "&amp;");
        this.findString = this.findString.replace(">", "&gt;");
        this.findString = this.findString.replace("<", "&lt;");
        this.findString = this.findString.replace("\"", "&quot;");
        this.changeString = changeString.replace("&", "&amp;");
        this.changeString = this.changeString.replace(">", "&gt;");
        this.changeString = this.changeString.replace("<", "&lt;");
        this.changeString = this.changeString.replace("\"", "&quot;");
        this.cursor = cursorRange;
        this.colsRange = colsRange;
        this.occurence = occurence;
        this.location = location;
        this.excludeOption = excludeOption;
        this.padCharecter = padCharecter;
        if (cursorRange.getCursorOffset() < 0) {
            this.log.log(Level.INFO, "invalid cursor offset value");
        }
        if (cursorRange.getRecordNumber() < 0) {
            this.log.log(Level.INFO, "invalid cursor record number value");
        }
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            this.xml = this.isFind ? (this.commandType.equalsIgnoreCase("FIND") || this.commandType.equalsIgnoreCase("Change") ? connection.connect("Find", map, false, this.createXml()) : connection.connect("Find", map, false, this.createXmlRFIND())) : connection.connect("exclude", map, false, this.createXml());
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                this.xml.getRoot();
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    private XMLDocument createXmlRFIND() {
        String action = "Find";
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = String.valueOf(command) + "<" + action + ">";
        command = String.valueOf(command) + "<FindParameters findlim=\"" + this.findlim + "\"" + "/>";
        command = String.valueOf(command) + "</" + action + ">";
        command = String.valueOf(command) + "</Edit></GUIRequest>";
        return CommonMFCalls.createXMLDoc(command);
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        String action = this.commandType;
        String actionParms = this.isFind ? "FindParameters" : "ExcludeParameters";
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = action.equalsIgnoreCase("Change") ? String.valueOf(command) + "<Change padCharacter=\"" + this.padCharecter + "\">" : String.valueOf(command) + "<" + action + ">";
        command = String.valueOf(command) + "<FindString>" + this.findString + "</FindString>" + "<" + actionParms + this.getFindlimte() + ">" + this.getCursorType() + this.getColsRange() + this.getOccurrence() + this.getLocation() + this.getLabelPair() + this.getExcludeOption() + "</" + actionParms + ">";
        if (action.equalsIgnoreCase("Change")) {
            command = String.valueOf(command) + "<ChangeString>" + this.changeString + "</ChangeString>";
        }
        command = String.valueOf(command) + "</" + action + ">" + "</Edit>" + "</GUIRequest>";
        return CommonMFCalls.createXMLDoc(command);
    }

    private String getFindlimte() {
        return " findlim=\"" + this.findlim + "\" ";
    }

    private String getCursorType() {
        String cursorParameters = "<Cursor recordNumber=\"" + this.cursor.getRecordNumber() + "\"";
        cursorParameters = String.valueOf(cursorParameters) + " cursorOffset=\"" + this.cursor.getCursorOffset() + "\"";
        cursorParameters = String.valueOf(cursorParameters) + " fieldId=\"" + this.cursor.getFieldId() + "\"";
        cursorParameters = String.valueOf(cursorParameters) + "/>";
        return cursorParameters;
    }

    private String getColsRange() {
        if (this.colsRange != null) {
            if (!this.colsRange.getStart().isEmpty() && !this.colsRange.getEnd().isEmpty()) {
                return "<ColsRange start=\"" + this.colsRange.getStart() + "\" end=\"" + this.colsRange.getEnd() + "\"/>";
            }
            if (!this.colsRange.getStart().isEmpty() && this.colsRange.getEnd().isEmpty()) {
                return "<ColsRange start=\"" + this.colsRange.getStart() + "\" end=\"0\"/>";
            }
        }
        return "";
    }

    private String getOccurrence() {
        if (!this.occurence.trim().isEmpty()) {
            return "<Occurrence>" + this.occurence + "</Occurrence>";
        }
        return "";
    }

    private String getLocation() {
        if (!this.location.trim().isEmpty()) {
            return "<Location>" + this.location + "</Location>";
        }
        return "";
    }

    private String getLabelPair() {
        return "";
    }

    private String getExcludeOption() {
        if (this.isFind && !this.excludeOption.trim().isEmpty()) {
            return "<ExcludeOption>" + this.excludeOption + "</ExcludeOption>";
        }
        return "";
    }
}

