/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.GenericLayoutBox;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetViewLayout;
import com.ca.filemaster.runners.RunValidateSelCriteria;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.ImportSelCritWizardPage;
import com.ca.filemaster.ui.wizards.MemberWizardOptionsPage;
import com.ca.filemaster.ui.wizards.MemberWizardPage;
import com.ca.filemaster.ui.wizards.SelWithLayout;
import com.ca.filemaster.ui.wizards.SelWithLayoutPage;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericSelectionCriteriaBox
implements SelectionListener,
ModifyListener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private GenericLayoutBox genericLayout;
    private FileMasterServer server;
    private Object wizard;
    private Shell parentShell;
    private Text selConditionText;
    private Button layoutBtn;
    private boolean isNewSelCrit = false;
    private String datasetName;
    private String memberName;
    private FileMasterDataset layoutDataset;
    private FileMasterMember layoutMember;
    private FMSelectionTreeModel fmselModel = FMSelectionTreeModel.getInstance();
    private GenericSelectionCriteriaBox thisBox = this;
    public Button validateButton;
    public Composite laySelBtns;
    public Element returnCode;
    public Element messages;
    public Group selConditionGroup;
    public boolean displayMessage = true;
    private static ArrayList<String> content = new ArrayList();
    private static ArrayList<String> contentErrorMsg = new ArrayList();
    private static final String NONE = "(none)";
    boolean displayValidationErrors = true;
    SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String[] selCriteriaLines = GenericSelectionCriteriaBox.this.selConditionText.getText().split("\r\n");
            int count = 0;
            while (count < selCriteriaLines.length) {
                if (selCriteriaLines[count].trim().length() > 74) {
                    MessageDialog.openError(null, (String)"Selection Criteria Validation Error", (String)"Exceeded maximum number of characters per line. Only 74 is allowed.");
                    return;
                }
                ++count;
            }
            GenericSelectionCriteriaBox.this.layoutDataset = new FileMasterDataset(null);
            GenericSelectionCriteriaBox.this.layoutMember = new FileMasterMember(null);
            if (GenericSelectionCriteriaBox.this.genericLayout.isLayoutViewSelected()) {
                String[] dataSetAndMember = GenericSelectionCriteriaBox.this.genericLayout.getLayoutViewComboString().split("[\\(\\)]");
                GenericSelectionCriteriaBox.this.layoutDataset.setName(dataSetAndMember[0]);
                GenericSelectionCriteriaBox.this.layoutMember.setName(dataSetAndMember[1]);
            } else {
                GenericSelectionCriteriaBox.this.layoutDataset.setName(GenericSelectionCriteriaBox.this.genericLayout.getLayoutDataSetName());
                GenericSelectionCriteriaBox.this.layoutMember.setName(GenericSelectionCriteriaBox.this.genericLayout.getLayoutMemberName());
            }
            GenericSelectionCriteriaBox.this.ValidateSelCriteria(GenericSelectionCriteriaBox.this.server, GenericSelectionCriteriaBox.this.layoutDataset, GenericSelectionCriteriaBox.this.layoutMember, GenericSelectionCriteriaBox.this.selConditionText.getText());
            if (GenericSelectionCriteriaBox.this.returnCode != null && GenericSelectionCriteriaBox.this.returnCode.getFirstChild().getNodeValue().equals("0") && GenericSelectionCriteriaBox.this.displayMessage) {
                MessageDialog.openInformation(null, (String)"Selection Criteria Validation", (String)"No error was found.");
            }
        }
    };

    public GenericSelectionCriteriaBox(String serverName, Object wizard, GenericLayoutBox layout) {
        this.server = FMServerTreeModel.getInstance().getServer(serverName);
        this.wizard = wizard;
        this.genericLayout = layout;
        if (wizard instanceof WizardPage) {
            this.parentShell = ((WizardPage)wizard).getShell();
        } else if (wizard instanceof FileMasterWizard) {
            this.parentShell = ((FileMasterWizard)((Object)wizard)).getShell();
        }
    }

    public GenericSelectionCriteriaBox(String serverName, Object wizard, GenericLayoutBox layout, boolean isNewSelCrit, String DatasetName, String MemberName) {
        this.server = FMServerTreeModel.getInstance().getServer(serverName);
        this.wizard = wizard;
        this.genericLayout = layout;
        this.isNewSelCrit = isNewSelCrit;
        this.datasetName = DatasetName;
        this.memberName = MemberName;
        if (wizard instanceof WizardPage) {
            this.parentShell = ((WizardPage)wizard).getShell();
        } else if (wizard instanceof FileMasterWizard) {
            this.parentShell = ((FileMasterWizard)((Object)wizard)).getShell();
        }
    }

    public void createConditionBoxContent(Composite parent) {
        this.createConditionBoxContent(parent, "La&yout...", "&Validate", "Impo&rt...");
    }

    public void createConditionBoxContent(Composite parent, String layoutBtnLabel, String validateBtnLabel, String importBtnLabel) {
        Label selectionCreteriaLabel = new Label(parent, 0);
        GridData gd_selectionCreteriaLabel = new GridData(16384, 128, false, false, 1, 1);
        gd_selectionCreteriaLabel.horizontalIndent = 16;
        gd_selectionCreteriaLabel.verticalIndent = 4;
        selectionCreteriaLabel.setLayoutData((Object)gd_selectionCreteriaLabel);
        selectionCreteriaLabel.setText("Record selection &criteria:");
        this.selConditionText = new Text(parent, 578);
        this.selConditionText.setEditable(true);
        GridData data = new GridData(4, 4, true, true, 1, 1);
        this.selConditionText.setLayoutData((Object)data);
        this.selConditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GenericSelectionCriteriaBox.this.selConditionText.getText().isEmpty()) {
                    GenericSelectionCriteriaBox.this.setValidateButtonEnabled(false);
                } else {
                    GenericSelectionCriteriaBox.this.setValidateButtonEnabled(true);
                }
            }
        });
        this.setWidth(this.selConditionText, 35, 65);
        if (!this.isNewSelCrit) {
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.datasetName.trim());
            fmdataset.setDsOrg("PDS");
            FileMasterMember fmmember = new FileMasterMember(null);
            TT_TreeItem memItem = null;
            fmmember.setName(this.memberName.trim());
            fmmember.setType("SELECT");
            memItem = this.fmselModel.findObjectInTree((Object)fmmember, this.fmselModel.findObject((Object)fmdataset));
            if (memItem != null) {
                int countCond = 0;
                while (countCond < memItem.getChildren().length) {
                    this.selConditionText.setText(String.valueOf(this.selConditionText.getText()) + memItem.getChildren()[countCond].toString() + "\r\n");
                    ++countCond;
                }
            }
        }
        this.laySelBtns = new Composite(parent, 0);
        GridLayout laySelBtns_layout = new GridLayout(1, false);
        laySelBtns_layout.marginHeight = 0;
        laySelBtns_layout.marginWidth = 0;
        this.laySelBtns.setLayout((Layout)laySelBtns_layout);
        this.laySelBtns.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.layoutBtn = new Button(this.laySelBtns, 0);
        this.layoutBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.layoutBtn.setText(layoutBtnLabel);
        this.layoutBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String layoutInfo = "";
                if (GenericSelectionCriteriaBox.this.genericLayout.isLayoutViewSelected()) {
                    layoutInfo = GenericSelectionCriteriaBox.this.genericLayout.getLayoutViewComboString();
                    if (layoutInfo.equals(GenericSelectionCriteriaBox.NONE)) {
                        MessageDialog.openError((Shell)new Shell(), (String)"Layout error", (String)"You must specify a layout to perform this action.");
                        return;
                    }
                } else {
                    layoutInfo = String.valueOf(GenericSelectionCriteriaBox.this.genericLayout.getLayoutDataSetName()) + "(" + GenericSelectionCriteriaBox.this.genericLayout.getLayoutMemberName() + ")";
                    if (GenericSelectionCriteriaBox.this.genericLayout.getLayoutDataSetName().isEmpty() || GenericSelectionCriteriaBox.this.genericLayout.getLayoutMemberName().isEmpty()) {
                        MessageDialog.openError((Shell)new Shell(), (String)"Layout error", (String)"You must specify a layout to perform this action.");
                        return;
                    }
                }
                String[] selConds = GenericSelectionCriteriaBox.this.selConditionText.getText().trim().split("\\r\\n");
                CRLClass crl = GenericSelectionCriteriaBox.this.createDummyDRL(layoutInfo);
                if (crl == null) {
                    return;
                }
                if (crl.hasMultiple01Levels()) {
                    MessageDialog.openError((Shell)new Shell(), (String)"Layout error", (String)("Member " + layoutInfo.split("[(*)]")[1] + " contains multiple 01 level definitions which are not supported in this function.  Define a Custom Record Layout member for this copybook which can be used in this function."));
                    return;
                }
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(GenericSelectionCriteriaBox.this.parentShell, (IWizard)new SelWithLayout("Selection Criteria Member", "Layout", crl, 0, layoutInfo, selConds, GenericSelectionCriteriaBox.this.thisBox, GenericSelectionCriteriaBox.this.server));
                dialog.create();
                SelWithLayoutPage.saveSelCrit.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GenericSelectionCriteriaBox.this.AddLayoutSelCondition(SelWithLayoutPage.getNewCondition());
                        if (ImportSelCritWizardPage.getLayDsname() != null) {
                            GenericSelectionCriteriaBox.this.AddLayoutDatasetMember(ImportSelCritWizardPage.getLayDsname(), ImportSelCritWizardPage.getLayMem());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (GenericSelectionCriteriaBox.this.canTheDialogBeDisplayed(selConds)) {
                    dialog.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validateButton = new Button(this.laySelBtns, 0);
        this.validateButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.validateButton.setText(validateBtnLabel);
        this.validateButton.setEnabled(false);
        this.validateButton.addSelectionListener(this.listener);
        Button importBtn = new Button(this.laySelBtns, 0);
        importBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        importBtn.setText(importBtnLabel);
        importBtn.setEnabled(true);
        importBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String[] selConds = GenericSelectionCriteriaBox.this.selConditionText.getText().trim().split("\\r\\n");
                GenericImportWizard Wiz = new GenericImportWizard("Import Selection Criteria", GenericSelectionCriteriaBox.this.server, selConds, true);
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(GenericSelectionCriteriaBox.this.parentShell, (IWizard)Wiz);
                dialog.create();
                ImportSelCritWizardPage.saveSelCrit.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GenericSelectionCriteriaBox.this.AddLayoutSelCondition(ImportSelCritWizardPage.getNewCondition());
                        if (ImportSelCritWizardPage.getLayDsname() != null) {
                            GenericSelectionCriteriaBox.this.AddLayoutDatasetMember(ImportSelCritWizardPage.getLayDsname(), ImportSelCritWizardPage.getLayMem());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                dialog.open();
                GenericSelectionCriteriaBox.this.selConditionText.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.callParentComplete();
    }

    public void createConditionBox(Composite parent) {
        this.createConditionBox(parent, "La&yout...", "&Validate", "Impo&rt...");
    }

    public void createConditionBox(Composite parent, String layoutBtnLabel, String validateBtnLabel, String importBtnLabel) {
        this.selConditionGroup = new Group(parent, 0);
        this.selConditionGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selConditionGroup.setText("Record selection criteria");
        this.selConditionGroup.setLayout((Layout)new GridLayout(5, false));
        this.selConditionGroup.setSize(this.selConditionGroup.computeSize(-1, -1));
        this.selConditionText = new Text((Composite)this.selConditionGroup, 578);
        this.selConditionText.setEditable(true);
        this.selConditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GenericSelectionCriteriaBox.this.selConditionText.getText().isEmpty()) {
                    GenericSelectionCriteriaBox.this.setValidateButtonEnabled(false);
                } else {
                    GenericSelectionCriteriaBox.this.setValidateButtonEnabled(true);
                }
                ImportSelCritWizardPage.conditions = GenericSelectionCriteriaBox.this.selConditionText.getText().trim().isEmpty() ? "" : String.valueOf(GenericSelectionCriteriaBox.this.selConditionText.getText().trim()) + "\r\n";
            }
        });
        GridData selConditionTextGridData = new GridData(4, 4, false, true, 1, 1);
        selConditionTextGridData.horizontalIndent = 6;
        this.selConditionText.setLayoutData((Object)selConditionTextGridData);
        TextUtil.setWidth((Text)this.selConditionText, (int)47);
        if (!this.isNewSelCrit) {
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.datasetName.trim());
            fmdataset.setDsOrg("PDS");
            FileMasterMember fmmember = new FileMasterMember(null);
            TT_TreeItem memItem = null;
            fmmember.setName(this.memberName.trim());
            fmmember.setType("SELECT");
            if (this.fmselModel.findObject((Object)fmdataset) != null && (memItem = this.fmselModel.findObjectInTree((Object)fmmember, this.fmselModel.findObject((Object)fmdataset))) != null) {
                int countCond = 0;
                while (countCond < memItem.getChildren().length) {
                    this.selConditionText.setText(String.valueOf(this.selConditionText.getText()) + memItem.getChildren()[countCond].toString() + "\r\n");
                    ++countCond;
                }
            }
        }
        Composite laySelBtns = new Composite((Composite)this.selConditionGroup, 0);
        GridLayout laySelBtns_layout = new GridLayout(1, false);
        laySelBtns_layout.marginHeight = 0;
        laySelBtns_layout.marginWidth = 0;
        laySelBtns.setLayout((Layout)laySelBtns_layout);
        laySelBtns.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.layoutBtn = new Button(laySelBtns, 0);
        this.layoutBtn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.layoutBtn.setText(layoutBtnLabel);
        this.layoutBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String layoutInfo = "";
                if (GenericSelectionCriteriaBox.this.genericLayout.isLayoutViewSelected()) {
                    layoutInfo = GenericSelectionCriteriaBox.this.genericLayout.getLayoutViewComboString();
                    if (layoutInfo.equals(GenericSelectionCriteriaBox.NONE)) {
                        MessageDialog.openError((Shell)new Shell(), (String)"Layout error", (String)"You must specify a layout to perform this action.");
                        return;
                    }
                } else {
                    layoutInfo = String.valueOf(GenericSelectionCriteriaBox.this.genericLayout.getLayoutDataSetName()) + "(" + GenericSelectionCriteriaBox.this.genericLayout.getLayoutMemberName() + ")";
                    if (GenericSelectionCriteriaBox.this.genericLayout.getLayoutDataSetName().isEmpty() || GenericSelectionCriteriaBox.this.genericLayout.getLayoutMemberName().isEmpty()) {
                        MessageDialog.openError((Shell)new Shell(), (String)"Layout error", (String)"You must specify a layout to perform this action.");
                        return;
                    }
                }
                String[] selConds = GenericSelectionCriteriaBox.this.selConditionText.getText().trim().split("\\r\\n");
                CRLClass crl = GenericSelectionCriteriaBox.this.createDummyDRL(layoutInfo);
                if (crl == null) {
                    return;
                }
                if (crl.hasMultiple01Levels()) {
                    MessageDialog.openError((Shell)new Shell(), (String)"Layout error", (String)("Member " + layoutInfo.split("[(*)]")[1] + " contains multiple 01 level definitions which are not supported in this function.  Define a Custom Record Layout member for this copybook which can be used in this function."));
                    return;
                }
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(GenericSelectionCriteriaBox.this.parentShell, (IWizard)new SelWithLayout("Selection Criteria Member", "Layout", crl, 0, layoutInfo, selConds, GenericSelectionCriteriaBox.this.thisBox, GenericSelectionCriteriaBox.this.server));
                dialog.create();
                SelWithLayoutPage.saveSelCrit.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GenericSelectionCriteriaBox.this.AddLayoutSelCondition(SelWithLayoutPage.getNewCondition());
                        if (ImportSelCritWizardPage.getLayDsname() != null) {
                            GenericSelectionCriteriaBox.this.AddLayoutDatasetMember(GenericSelectionCriteriaBox.this.genericLayout.getLayoutDataSetName(), GenericSelectionCriteriaBox.this.genericLayout.getLayoutMemberName());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (GenericSelectionCriteriaBox.this.canTheDialogBeDisplayed(selConds)) {
                    dialog.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validateButton = new Button(laySelBtns, 0);
        this.validateButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.validateButton.setText(validateBtnLabel);
        this.validateButton.setEnabled(false);
        this.validateButton.addSelectionListener(this.listener);
        Button importBtn = new Button(laySelBtns, 0);
        importBtn.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        importBtn.setText(importBtnLabel);
        importBtn.setEnabled(true);
        importBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String[] selConds = GenericSelectionCriteriaBox.this.selConditionText.getText().trim().split("\\r\\n");
                GenericImportWizard Wiz = new GenericImportWizard("Import Selection Criteria", GenericSelectionCriteriaBox.this.server, selConds, true);
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(GenericSelectionCriteriaBox.this.parentShell, (IWizard)Wiz);
                dialog.create();
                ImportSelCritWizardPage.saveSelCrit.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GenericSelectionCriteriaBox.this.AddLayoutSelCondition(ImportSelCritWizardPage.getNewCondition());
                        if (ImportSelCritWizardPage.getLayDsname() != null) {
                            GenericSelectionCriteriaBox.this.AddLayoutDatasetMember(ImportSelCritWizardPage.getLayDsname(), ImportSelCritWizardPage.getLayMem());
                        }
                        GenericSelectionCriteriaBox.this.selConditionText.setFocus();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (parent.getShell().getParent().getData() instanceof WizardDialog) {
            IWizardPage page = ((WizardDialog)parent.getShell().getParent().getData()).getCurrentPage();
            if (page instanceof MemberWizardPage) {
                Button clearBtn = new Button(laySelBtns, 0);
                GridData gd_btnClear = new GridData(16384, 16384, false, false, 1, 1);
                gd_btnClear.widthHint = 67;
                clearBtn.setLayoutData((Object)gd_btnClear);
                clearBtn.setText("&Clear");
                clearBtn.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        GenericSelectionCriteriaBox.this.selConditionText.setText("");
                        MemberWizardOptionsPage.store.setValue("SELMEMCRIT", "");
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            this.callParentComplete();
        }
    }

    private boolean canTheDialogBeDisplayed(String[] selConds) {
        String[] sC = (String[])selConds.clone();
        boolean error = false;
        int i = 0;
        while (i < sC.length) {
            sC[i] = sC[i].trim();
            ++i;
        }
        int i2 = 0;
        while (i2 < sC.length) {
            int pAND;
            int pOR;
            String modifyedCondition = "";
            int j = 0;
            while (j < sC[i2].length()) {
                if (sC[i2].charAt(j) == '\"') {
                    modifyedCondition = String.valueOf(modifyedCondition) + sC[i2].charAt(j);
                    if (j + 1 >= sC[i2].length()) break;
                    j = sC[i2].indexOf("\"", j + 1);
                    modifyedCondition = String.valueOf(modifyedCondition) + sC[i2].charAt(j);
                } else if (sC[i2].charAt(j) == '\'') {
                    modifyedCondition = String.valueOf(modifyedCondition) + sC[i2].charAt(j);
                    if (j + 1 >= sC[i2].length()) break;
                    j = sC[i2].indexOf("'", j + 1);
                    modifyedCondition = String.valueOf(modifyedCondition) + sC[i2].charAt(j);
                } else {
                    modifyedCondition = String.valueOf(modifyedCondition) + sC[i2].charAt(j);
                }
                ++j;
            }
            if ((pOR = modifyedCondition.indexOf(" OR")) != -1 && modifyedCondition.length() > pOR + 3) {
                error = true;
            }
            if ((pAND = modifyedCondition.indexOf(" AND")) != -1 && modifyedCondition.length() > pAND + 4) {
                error = true;
            }
            if ((pOR = modifyedCondition.indexOf(" |")) != -1 && modifyedCondition.length() > pOR + 2) {
                error = true;
            }
            if ((pAND = modifyedCondition.indexOf(" &")) != -1 && modifyedCondition.length() > pAND + 2) {
                error = true;
            }
            if (error) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)"Layout dialog cannot be displayed", (Throwable)new Throwable("Only one command per line is allowed. You must break compound statements into separate lines in order for them to display in the Layout dialog."));
                return false;
            }
            ++i2;
        }
        return true;
    }

    public String getText() {
        return this.selConditionText.getText();
    }

    public void setText(String conditions) {
        this.selConditionText.setText(conditions);
    }

    public void setLayoutButtonEnabled(boolean enabled) {
        if (this.layoutBtn != null) {
            this.layoutBtn.setEnabled(enabled);
        }
    }

    public void setValidateButtonEnabled(boolean enabled) {
        if (this.validateButton != null) {
            this.validateButton.setEnabled(enabled);
        }
    }

    private void callParentComplete() {
        if (this.wizard instanceof WizardPage) {
            ((WizardPage)this.wizard).setPageComplete(((WizardPage)this.wizard).isPageComplete());
        } else if (this.wizard instanceof FileMasterWizard) {
            ((FileMasterWizard)((Object)this.wizard)).setPageComplete(((FileMasterWizard)((Object)this.wizard)).isPageComplete());
        }
    }

    public void enableSelCrtButton(boolean value) {
        this.selConditionText.setEnabled(value);
        if (!this.selConditionText.getText().isEmpty()) {
            this.setValidateButtonEnabled(value);
        }
    }

    public String validateCriteriaBox() {
        String error = "";
        if (this.genericLayout.isLayoutViewSelected() && this.genericLayout.getLayoutViewComboString().equalsIgnoreCase(NONE) || !this.genericLayout.isLayoutSet()) {
            this.setLayoutButtonEnabled(false);
        } else {
            this.setLayoutButtonEnabled(true);
            if (!this.selConditionText.getText().isEmpty()) {
                this.setValidateButtonEnabled(true);
            }
        }
        return error;
    }

    public void modifyText(ModifyEvent e) {
        this.callParentComplete();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private CRLClass createDummyDRL(String layoutInfo) {
        CRLClass crl = new CRLClass();
        RunGetViewLayout runner = new RunGetViewLayout(layoutInfo.split("[*(]")[0], layoutInfo.split("[(*)]")[1], this.server, true);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
            } else {
                NodeList nodes = element.getElementsByTagName("Field");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + GenericSelectionCriteriaBox.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = GenericSelectionCriteriaBox.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    return null;
                }
                CRLClass.Layout layouttoAdd = this.genericLayout.isLayoutViewSelected() ? crl.addLayout(this.genericLayout.getLayoutViewComboString().split("[*(]")[0], this.genericLayout.getLayoutViewComboString().split("[(*)]")[1]) : crl.addLayout(this.genericLayout.getLayoutDataSetName(), this.genericLayout.getLayoutMemberName());
                boolean has01Level = false;
                int i = 0;
                while (i < nodes.getLength()) {
                    Element layoutElement = (Element)nodes.item(i);
                    Element NameElement = (Element)layoutElement.getElementsByTagName("Name").item(0);
                    Element levelElement = (Element)layoutElement.getElementsByTagName("Level").item(0);
                    Element IntegerLenElement = (Element)layoutElement.getElementsByTagName("IntegerLength").item(0);
                    Element FractionLenElement = (Element)layoutElement.getElementsByTagName("FractionLength").item(0);
                    Element LenElement = (Element)layoutElement.getElementsByTagName("Length").item(0);
                    Element positionElement = (Element)layoutElement.getElementsByTagName("Position").item(0);
                    Element signedElement = (Element)layoutElement.getElementsByTagName("Signed").item(0);
                    String formatChar = layoutElement.getElementsByTagName("FormatChar").getLength() > 0 ? GenericSelectionCriteriaBox.getTagValue("FormatChar", (Element)layoutElement.getElementsByTagName("FormatChar").item(0)) : "";
                    if (GenericSelectionCriteriaBox.getTagValue("Level", levelElement).equalsIgnoreCase("01")) {
                        if (has01Level) {
                            crl.setMultiple01Levels(true);
                        } else {
                            has01Level = true;
                        }
                    }
                    layouttoAdd.addField(GenericSelectionCriteriaBox.getTagValue("Name", NameElement), Integer.parseInt(GenericSelectionCriteriaBox.getTagValue("Level", levelElement)), GenericSelectionCriteriaBox.getTagValue("Level", levelElement).equalsIgnoreCase("01"), true, Integer.parseInt(GenericSelectionCriteriaBox.getTagValue("Position", positionElement)), signedElement != null && GenericSelectionCriteriaBox.getTagValue("Signed", signedElement).equalsIgnoreCase("Y") ? String.valueOf(formatChar) + "S" : formatChar, Integer.parseInt(GenericSelectionCriteriaBox.getTagValue("IntegerLength", IntegerLenElement)), Integer.parseInt(GenericSelectionCriteriaBox.getTagValue("FractionLength", FractionLenElement)), Integer.parseInt(GenericSelectionCriteriaBox.getTagValue("Length", LenElement)), 0, 0, "");
                    ++i;
                }
                return crl;
            }
        }
        return null;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue != null) {
            return nValue.getNodeValue();
        }
        return "";
    }

    public String getSelCriteriaBoxText() {
        if (this.selConditionText == null) {
            return "";
        }
        return this.selConditionText.getText();
    }

    public void AddLayoutSelCondition(String layoutSelCondition) {
        this.selConditionText.setText(layoutSelCondition);
    }

    public void AddLayoutDatasetMember(String datasetLay, String memberlay) {
        this.genericLayout.setLayoutDataSetName(datasetLay);
        this.genericLayout.setLayoutMemberName(memberlay);
        this.genericLayout.setDsnActive();
    }

    private void setWidth(Text text, int minimum, int maximum) {
        GridData data = (GridData)text.getLayoutData();
        if (data == null) {
            data = new GridData();
            text.setLayoutData((Object)data);
        }
        GC gc = new GC((Drawable)text);
        try {
            int minwidth;
            Point extent = gc.textExtent("W");
            if (maximum < 1) {
                maximum = Text.LIMIT;
            }
            int maxwidth = Math.min(extent.x * maximum, gc.textExtent((String)text.getText()).x);
            data.minimumWidth = minwidth = extent.x * minimum + 10;
            data.widthHint = Math.max(minwidth, maxwidth);
        }
        finally {
            gc.dispose();
        }
    }

    public XMLRequest ValidateSelCriteria(FileMasterServer server, FileMasterDataset layoutDataset, FileMasterMember layoutMember, String selCondition) {
        RunValidateSelCriteria runner = new RunValidateSelCriteria(server, layoutDataset, layoutMember, selCondition);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element rootElement = xml.getRoot();
            content.clear();
            if (rootElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + rootElement.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(rootElement.getAttribute("msg").replace("+", " ")) + ". " + rootElement.getAttribute("reason").replace("+", " ")));
            } else {
                String outputMessage = "";
                contentErrorMsg = new ArrayList();
                String title = "Selection Criteria Validation";
                this.returnCode = (Element)rootElement.getElementsByTagName("ReturnCode").item(0);
                if (this.returnCode.getFirstChild().getNodeValue().equals("16")) {
                    this.messages = (Element)rootElement.getElementsByTagName("Messages").item(0);
                    if (this.messages == null) {
                        outputMessage = String.valueOf(outputMessage) + Validator.errorMsg[52];
                        contentErrorMsg.add(Validator.errorMsg[52]);
                    } else {
                        NodeList message = this.messages.getElementsByTagName("Message");
                        int count = 0;
                        while (count < message.getLength()) {
                            outputMessage = String.valueOf(outputMessage) + ((Element)message.item(count)).getTextContent().replaceAll("CAWA[0-9A-Z]{0,5}", "") + "\n";
                            contentErrorMsg.add(String.valueOf(((Element)message.item(count)).getTextContent().replaceAll("CAWA[0-9A-Z]{0,5}", "")) + "\n");
                            ++count;
                        }
                    }
                    if (this.displayValidationErrors) {
                        TT_ErrorDialog.openError(null, (String)"Error", (String)title, (Throwable)new Throwable(" An error was detected "), contentErrorMsg);
                    }
                }
                NodeList nodeListSelValidation = rootElement.getElementsByTagName("SelectionValidationRecord");
                int i = 0;
                while (i < nodeListSelValidation.getLength()) {
                    Element selValiRcElement = (Element)nodeListSelValidation.item(i);
                    String SelValidationRecord = new String();
                    SelValidationRecord = GenericSelectionCriteriaBox.getTagValue("SelectionValidationRecord", selValiRcElement);
                    content.add(SelValidationRecord);
                    ++i;
                }
                this.validateButton.setEnabled(false);
            }
        }
        return runner.getXml();
    }

    public void setDisplayValidationErrors(boolean displayValidationErrors) {
        this.displayValidationErrors = displayValidationErrors;
    }

    public boolean getDisplayValidationErrors() {
        return this.displayValidationErrors;
    }

    public String getSelConditionText() {
        return this.selConditionText.getText();
    }

    public ArrayList<String> getContent() {
        return content;
    }

    public void setContent(ArrayList<String> content) {
        GenericSelectionCriteriaBox.content = content;
    }

    public void setServer(FileMasterServer server) {
        this.server = server;
    }

    public void setFocus() {
        this.selConditionText.setFocus();
    }
}

