/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FMValidateCredentials {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private String userId;
    private String ePassword;
    private FileMasterServer server;
    private FileMasterDataset[] datasets = new FileMasterDataset[0];
    private String errorMessage;
    private int errorLevel;
    private int errorCount;
    private ArrayList<Element> errorElements = new ArrayList();
    private String errorCause;
    private static final String SERVICE = "testingtools/validate";

    public FMValidateCredentials(FileMasterServer server) {
        this.server = server;
        this.userId = server.getUser();
        this.ePassword = server.getEPassword();
    }

    public FMValidateCredentials(FileMasterServer server, FileMasterDataset[] datasets) {
        this(server);
        this.datasets = datasets;
    }

    public FileMasterDataset[] getDatasets() {
        return this.datasets;
    }

    public void setDatasets(FileMasterDataset[] datasets) {
        this.datasets = datasets;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public int run(boolean credentials) {
        this.errorElements.clear();
        ServerConnect connect = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, Object> map = new HashMap<String, Object>(2 + this.datasets.length);
        this.errorCount = 0;
        if (credentials) {
            map.put("user", this.userId);
            map.put("epassw", this.ePassword);
        }
        if (this.datasets.length > 0) {
            map.put("dsn", this.datasets);
        }
        FileMasterDataset[] fileMasterDatasetArray = this.datasets;
        int n = this.datasets.length;
        int n2 = 0;
        while (n2 < n) {
            FileMasterDataset dsn = fileMasterDatasetArray[n2];
            if (dsn != null) {
                dsn.setFileNotfound(false);
            }
            ++n2;
        }
        try {
            this.errorCause = "";
            XMLRequest xml = connect.connect("check", map, true);
            Element command = xml.getCommand();
            FileMasterDataset[] fileMasterDatasetArray2 = this.datasets;
            int n3 = this.datasets.length;
            int n4 = 0;
            while (n4 < n3) {
                FileMasterDataset dsn = fileMasterDatasetArray2[n4];
                if (dsn != null) {
                    dsn.setFileNotfound(false);
                }
                ++n4;
            }
            if (credentials) {
                this.checkError(command.getElementsByTagName("Signon"), false);
            }
            this.checkError(command.getElementsByTagName("DSN"), true);
        }
        catch (Exception e) {
            this.errorLevel = 32;
            this.errorMessage = HexUtil.getErrorText((Throwable)e);
            this.errorCause = "Error attempting to connect to server";
        }
        return this.errorLevel;
    }

    private void checkError(NodeList elements, boolean isDSN) {
        int index = 0;
        while (index < elements.getLength()) {
            Element element = (Element)elements.item(index);
            String value = element.getAttribute("errorlevel");
            int error = 0;
            try {
                error = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
            if (error > 0) {
                if (error > this.errorLevel) {
                    this.errorLevel = error;
                    this.errorMessage = element.getAttribute("msg");
                }
                this.errorElements.add(element);
                if (isDSN) {
                    String name = element.getAttribute("name");
                    FileMasterDataset[] fileMasterDatasetArray = this.datasets;
                    int n = this.datasets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileMasterDataset dataset = fileMasterDatasetArray[n2];
                        if (dataset != null && name.equals(dataset.getName())) {
                            dataset.setFileNotfound(true);
                            dataset.setList(new ArrayList(0));
                            dataset.getParent().setChecked(false);
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage page = window.getActivePage();
                            try {
                                TreeViewer viewer;
                                IViewPart view = page.showView("com.ca.filemaster.views.directorylist");
                                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                                    TT_TreeItem selection = FMServerTreeModel.getInstance().findObject((Object)dataset);
                                    viewer.refresh((Object)selection, true);
                                    viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                                }
                            }
                            catch (PartInitException partInitException) {}
                        }
                        ++n2;
                    }
                }
            }
            ++index;
        }
    }

    public FMValidateCredentials(FileMasterServer server, String userId, String password) {
        this(server);
        this.userId = userId;
        this.ePassword = password;
    }

    public void setServer(FileMasterServer server) {
        this.server = server;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ArrayList<Element> getErrorElements() {
        return this.errorElements;
    }

    public String getErrorCause() {
        return this.errorCause;
    }
}

