/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.common;

import com.ca.filemaster.Activator;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FMXMLProfile;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterSelection;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.TT_TreeItem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class FMSelectionTreeModel
extends PropertyChangeManager
implements IPropertyChangeListener {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static FMSelectionTreeModel model = null;
    protected static final String NAME = "name";
    protected static final String LEVEL = "level";
    protected FMXMLProfile selectionXML;
    protected static final String TREE_FILE_SELECT = "com.ca.testingtools.TREE_FILE_SELECT";
    protected String XMLPathName;
    private ArrayList<String> order = new ArrayList();
    private HashMap<String, IConfigurationElement> elementlist;
    private final ArrayList<TT_TreeItem> servers = new ArrayList();
    private final ArrayList<TT_TreeItem> datasets = new ArrayList();
    private static final int MOVEUP = 0;
    private static final int MOVEDOWN = 1;

    public FMSelectionTreeModel() {
        this.loadPlugins();
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getString(TREE_FILE_SELECT);
        if (filename == null || filename.isEmpty()) {
            filename = FMSelectionTreeModel.setFileName();
        }
        IPath propertyPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        this.XMLPathName = propertyPath.append(filename).toOSString();
        File pFile = new File(this.XMLPathName);
        if (pFile.exists()) {
            try {
                this.selectionXML = new FMXMLProfile(pFile);
                Element[] elementArray = this.selectionXML.getSelectionDatasets();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element dataset = elementArray[n2];
                    this.insertDataset(dataset);
                    ++n2;
                }
            }
            catch (TTException tTException) {
                this.selectionXML = new FMXMLProfile();
            }
        } else {
            this.selectionXML = new FMXMLProfile();
        }
    }

    public static synchronized FMSelectionTreeModel getInstance() {
        if (model == null) {
            model = new FMSelectionTreeModel();
        }
        return model;
    }

    protected void loadPlugins() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("com.ca.testingtools.profile");
        this.elementlist = new HashMap(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (name.equals("seperator")) {
                this.locate(element);
            } else {
                this.elementlist.put(element.getAttribute("id"), element);
            }
            ++n2;
        }
        for (IConfigurationElement element : this.elementlist.values()) {
            this.locate(element);
        }
        Iterator<String> iterator = this.order.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (this.elementlist.containsKey(key)) continue;
            iterator.remove();
        }
    }

    private void locate(IConfigurationElement element) {
        Position position;
        String name = element.getName();
        boolean seperator = "seperator".equals(name);
        String ID = element.getAttribute(seperator ? NAME : "id");
        String menuid = element.getAttribute("menuid");
        try {
            position = Position.valueOf(element.getAttribute("menulocation"));
        }
        catch (Exception exception) {
            position = Position.last;
        }
        switch (position) {
            case first: {
                this.order.add(0, ID);
                break;
            }
            case last: {
                this.order.add(ID);
                break;
            }
            case before: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix > this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix, ID);
                break;
            }
            case after: {
                int ix = this.order.indexOf(menuid);
                if (ix == -1 || ix >= this.order.size()) {
                    this.order.add(ID);
                    break;
                }
                this.order.add(ix + 1, ID);
            }
        }
    }

    public static String setFileName() {
        ScopedPreferenceStore store = (ScopedPreferenceStore)Activator.plugin.getPreferenceStore();
        String filename = store.getDefaultString("DEFAULT_FM_SELECTION_TREE");
        SimpleDateFormat dflocaltime = new SimpleDateFormat("yyyyMMddHHmmss");
        String ts = dflocaltime.format(new Date());
        filename = filename.replace(".", "." + ts + ".");
        store.setValue(TREE_FILE_SELECT, filename);
        try {
            store.save();
        }
        catch (IOException iOException) {}
        return filename;
    }

    public void save() {
        File backUppFile = null;
        try {
            backUppFile = new File(this.XMLPathName);
            this.selectionXML.toFile(this.XMLPathName);
            new File(this.XMLPathName);
        }
        catch (TTException e) {
            try {
                this.selectionXML = new FMXMLProfile(backUppFile);
                this.selectionXML.toFile(this.XMLPathName);
            }
            catch (TTException e1) {
                e1.printStackTrace();
            }
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public TT_TreeItem insertDataset(Element dataset) {
        String name = dataset.getAttribute(NAME);
        name = name.replace("%23", "#");
        name = name.replace("%24", "$");
        name = name.replace("%40", "@");
        String DSLength = dataset.getAttribute("DSLENGTH");
        String DSorg = dataset.getAttribute("DSORG");
        String FileType = dataset.getAttribute("FILETYPE");
        String Volume = dataset.getAttribute("VOLUME");
        String blkSize = dataset.getAttribute("BLKSIZE");
        FileMasterDataset datasetObject = new FileMasterDataset(null);
        TT_TreeItem datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)datasetObject);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setName(name);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setFileType(FileType);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setVolume(Volume);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDsOrg(DSorg);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDSLength(DSLength);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setBlksize(blkSize);
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setLrecl(dataset.getAttribute("LRECL"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setExtents(dataset.getAttribute("EXTENTS"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDateCreated(dataset.getAttribute("DATECREATED"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDateReferenced(dataset.getAttribute("DATEREFERENCED"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setDSLength(dataset.getAttribute("DSLENGTH"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setRecfm(dataset.getAttribute("RECFM"));
        ((FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class))).setTracks(dataset.getAttribute("TRACKS"));
        this.datasets.add(datasetItem);
        this.insertMembers(dataset, datasetItem);
        return datasetItem;
    }

    protected void insertMembers(Element datasetElement, TT_TreeItem parent) {
        Element[] memberList;
        Element[] elementArray = memberList = this.selectionXML.getMembers(datasetElement);
        int n = memberList.length;
        int n2 = 0;
        while (n2 < n) {
            Element member = elementArray[n2];
            this.insertMember(parent, member);
            ++n2;
        }
    }

    public TT_TreeItem insertMember(TT_TreeItem parent, Element member) {
        String name = member.getAttribute(NAME);
        String type = member.getAttribute("type");
        String description = member.getAttribute("description");
        FileMasterMember memberObject = new FileMasterMember(parent);
        TT_TreeItem memberItem = new TT_TreeItem(member, (ITreeWrappedItem)memberObject, name);
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setType(type);
        ((FileMasterMember)((Object)memberItem.getAdapter(FileMasterMember.class))).setCLDescription(description);
        parent.addChild(memberItem);
        this.insertSelections(member, memberItem);
        return memberItem;
    }

    protected void insertSelections(Element selectionElement, TT_TreeItem parent) {
        Element[] selectionList;
        Element[] elementArray = selectionList = this.selectionXML.getSelection(selectionElement);
        int n = selectionList.length;
        int n2 = 0;
        while (n2 < n) {
            Element select = elementArray[n2];
            this.insertSelection(parent, select);
            ++n2;
        }
    }

    public TT_TreeItem insertSelection(TT_TreeItem parent, Element select) {
        String name = select.getAttribute(NAME);
        FileMasterSelection selectObject = new FileMasterSelection(parent);
        if (select.getAttribute(NAME) != null) {
            select.setAttribute(NAME, select.getAttribute(NAME).replace("%", "<percent>"));
            select.setAttribute(NAME, select.getAttribute(NAME).replace("+", "<plus>"));
        }
        TT_TreeItem selectItem = new TT_TreeItem(select, (ITreeWrappedItem)selectObject, name);
        parent.addChild(selectItem);
        ((FileMasterSelection)((Object)selectItem.getAdapter(FileMasterSelection.class))).setName(((FileMasterSelection)((Object)selectItem.getAdapter(FileMasterSelection.class))).getName().replace("<plus>", "+"));
        ((FileMasterSelection)((Object)selectItem.getAdapter(FileMasterSelection.class))).setName(((FileMasterSelection)((Object)selectItem.getAdapter(FileMasterSelection.class))).getName().replace("<percent>", "%"));
        return selectItem;
    }

    public Element addDataset(Element datasetNodeElement, FileMasterDataset dataSet) {
        Element top = this.selectionXML.getTop();
        Element nodechild = this.createElement("datasetnode");
        nodechild.setAttribute(NAME, dataSet.getName());
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        nodechild.setAttribute("VOLUME", dataSet.getVolume());
        nodechild.setAttribute("FILETYPE", dataSet.getFileType());
        nodechild.setAttribute("DSLENGTH", dataSet.getDSLength());
        nodechild.setAttribute("DSORG", dataSet.getDsOrg());
        nodechild.setAttribute("DSLENGTH", dataSet.getDSLength());
        nodechild.setAttribute("BLKSIZE", dataSet.getBlksize());
        nodechild.setAttribute("DATECREATED", dataSet.getDateCreated());
        nodechild.setAttribute("DATEREFERENCED", dataSet.getDateReferenced());
        nodechild.setAttribute("EXTENTS", dataSet.getExtents());
        nodechild.setAttribute("LRECL", dataSet.getLrecl());
        nodechild.setAttribute("RECFM", dataSet.getRecfm());
        nodechild.setAttribute("TRACKS", dataSet.getTracks());
        top.appendChild(nodechild);
        return nodechild;
    }

    public Element addMember(Element memberNodeElement, String name, String type, String description, String layDataset, String layMember) {
        Element nodechild = this.createElement("membernode");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("type", type);
        nodechild.setAttribute("description", description);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        nodechild.setAttribute("DsLay", layDataset);
        nodechild.setAttribute("MemLay", layMember);
        memberNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public Element addSelection(Element selectionNodeElement, String name) {
        Element nodechild = this.createElement("selectnode");
        nodechild.setAttribute(NAME, name);
        nodechild.setAttribute("UUID", UUID.randomUUID().toString());
        selectionNodeElement.appendChild(nodechild);
        return nodechild;
    }

    public TT_TreeItem findObject(Object object) {
        TT_TreeItem result = null;
        for (TT_TreeItem node : this.datasets) {
            result = node.findValue(object);
            if (result != null) break;
        }
        return result;
    }

    public String getXMLPathName() {
        return this.XMLPathName;
    }

    public int indexOf(TT_TreeItem item) {
        TT_TreeItem parent = item.getParent();
        if (parent == null) {
            return this.datasets.indexOf(item);
        }
        TT_TreeItem[] childs = (TT_TreeItem[])parent.getChildren();
        int i = 0;
        while (i < childs.length) {
            if (childs[i].equals((Object)item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TT_TreeItem removeItem(Object element) {
        TT_TreeItem item = this.findObject(element);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.datasets.size() > 0) {
                return this.datasets.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public TT_TreeItem removeItem(Object element, TT_TreeItem elementParent) {
        TT_TreeItem item = this.findObjectInTree(element, elementParent);
        if (item == null) {
            return null;
        }
        TT_TreeItem parent = item.getParent();
        ITreeWrappedItem value = item.getValue();
        String eventkey = value == null ? item.getClass().getSimpleName() : value.getClass().getSimpleName();
        item.delete();
        if (parent == null) {
            int i = this.indexOf(item);
            if (this.servers.size() > 0) {
                return this.servers.remove(i);
            }
        } else {
            int i = this.indexOf(item) - 1;
            parent.removeChild(item);
            if (i < parent.getChildren().length && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i];
            }
            if (parent.getChildren().length > 0 && i > 0) {
                return (TT_TreeItem)parent.getChildren()[i - 1];
            }
            return parent;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, eventkey, element, null);
        this.firePropertyChange(event);
        return null;
    }

    public TT_TreeItem findObjectInTree(Object object, TT_TreeItem treeItem) {
        TT_TreeItem result = null;
        result = this.findObject(treeItem).findValue(object);
        return result;
    }

    public Element createElement(String name) {
        return this.selectionXML.createElement(name);
    }

    public TT_TreeItem[] getDatasets() {
        return this.datasets.toArray(new TT_TreeItem[this.datasets.size()]);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public TT_TreeItem reposition(Object element, int direction) {
        TT_TreeItem item = this.findObject(element);
        boolean isDataset = item.getParent() == null;
        int index = this.indexOf(item);
        if (isDataset) {
            Element[] selectionDatasets = this.selectionXML.getSelectionDatasets();
            Element top = this.selectionXML.getTop();
            if (direction == 0) {
                top.insertBefore(selectionDatasets[index], selectionDatasets[index - 1]);
                TT_TreeItem temp = this.datasets.get(index - 1);
                this.datasets.set(index - 1, this.datasets.get(index));
                this.datasets.set(index, temp);
            } else if (direction == 1) {
                top.insertBefore(selectionDatasets[index + 1], selectionDatasets[index]);
                TT_TreeItem temp = this.datasets.get(index + 1);
                this.datasets.set(index + 1, this.datasets.get(index));
                this.datasets.set(index, temp);
            }
            this.save();
        } else {
            int parentIndex = this.indexOf(item.getParent());
            Element parentDatasetElement = item.getParent().getElement();
            Element[] layoutMembers = this.selectionXML.getMembers(parentDatasetElement);
            if (direction == 0) {
                parentDatasetElement.insertBefore(layoutMembers[index], layoutMembers[index - 1]);
                TT_TreeItem[] temp = (TT_TreeItem[])this.datasets.get(parentIndex).getChildren();
                this.datasets.get(parentIndex).removeChild(temp[index - 1]);
                this.datasets.get(parentIndex).removeChild(temp[index]);
                this.datasets.get(parentIndex).addChild(temp[index]);
                this.datasets.get(parentIndex).addChild(temp[index - 1]);
                int i = index + 1;
                while (i < temp.length) {
                    this.datasets.get(parentIndex).removeChild(temp[i]);
                    this.datasets.get(parentIndex).addChild(temp[i]);
                    ++i;
                }
            } else if (direction == 1) {
                parentDatasetElement.insertBefore(layoutMembers[index + 1], layoutMembers[index]);
                TT_TreeItem[] temp = (TT_TreeItem[])this.datasets.get(parentIndex).getChildren();
                this.datasets.get(parentIndex).removeChild(temp[index]);
                this.datasets.get(parentIndex).removeChild(temp[index + 1]);
                this.datasets.get(parentIndex).addChild(temp[index + 1]);
                this.datasets.get(parentIndex).addChild(temp[index]);
                int i = index + 2;
                while (i < temp.length) {
                    this.datasets.get(parentIndex).removeChild(temp[i]);
                    this.datasets.get(parentIndex).addChild(temp[i]);
                    ++i;
                }
            }
            this.save();
        }
        return item;
    }

    public Element updateAttributeS(Element datasetNodeElement, FileMasterDataset dataSet) {
        datasetNodeElement.setAttribute(NAME, dataSet.getName());
        datasetNodeElement.setAttribute("UUID", UUID.randomUUID().toString());
        datasetNodeElement.setAttribute("VOLUME", dataSet.getVolume());
        datasetNodeElement.setAttribute("FILETYPE", dataSet.getFileType());
        datasetNodeElement.setAttribute("DSLENGTH", dataSet.getDSLength());
        datasetNodeElement.setAttribute("DSORG", dataSet.getDsOrg());
        datasetNodeElement.setAttribute("DSLENGTH", dataSet.getDSLength());
        datasetNodeElement.setAttribute("DSTYPE", dataSet.getDsType());
        datasetNodeElement.setAttribute("BLKSIZE", dataSet.getBlksize());
        datasetNodeElement.setAttribute("DATECREATED", dataSet.getDateCreated());
        datasetNodeElement.setAttribute("DATEREFERENCED", dataSet.getDateReferenced());
        datasetNodeElement.setAttribute("EXPDTDATE", dataSet.getExpirationDate());
        datasetNodeElement.setAttribute("EXTENTS", dataSet.getExtents());
        datasetNodeElement.setAttribute("LRECL", dataSet.getLrecl());
        datasetNodeElement.setAttribute("RECFM", dataSet.getRecfm());
        datasetNodeElement.setAttribute("TRACKS", dataSet.getTracks());
        datasetNodeElement.setAttribute("SPCUNITS", dataSet.getUnits());
        datasetNodeElement.setAttribute("SPCPRI", dataSet.getPrimaryAlloc());
        datasetNodeElement.setAttribute("SPCSEC", dataSet.getSecondaryAlloc());
        datasetNodeElement.setAttribute("UNITTYPE", dataSet.getUnitType());
        datasetNodeElement.setAttribute("USEDALLOCUnit", dataSet.getUsedAllocUnit());
        datasetNodeElement.setAttribute("USEDALLOCValue", dataSet.getUsedAllocValue());
        datasetNodeElement.setAttribute("ALLOCATEDALOCUnit", dataSet.getAllocatedallocUnit());
        datasetNodeElement.setAttribute("ALLOCATEDALOCValue", dataSet.getAllocatedallocValue());
        datasetNodeElement.setAttribute("EXTENTSAllocated", dataSet.getExtentsAllocated());
        datasetNodeElement.setAttribute("EXTENTSUsed", dataSet.getExtentsUsed());
        datasetNodeElement.setAttribute("DIRCMax", dataSet.getDircMax());
        datasetNodeElement.setAttribute("DIRCUsed", dataSet.getDircUsed());
        datasetNodeElement.setAttribute("NUMMembers", dataSet.getNumMembers());
        if (dataSet instanceof FMPVSAMDataset) {
            datasetNodeElement.setAttribute("KEY_POSITION", ((FMPVSAMDataset)dataSet).getOffset());
            datasetNodeElement.setAttribute("KEY_LENGTH", ((FMPVSAMDataset)dataSet).getLength());
            datasetNodeElement.setAttribute("AVERAGE_RECORD_SIZE", ((FMPVSAMDataset)dataSet).getAverage());
            datasetNodeElement.setAttribute("MAXIMUM_RECORD_SIZE", ((FMPVSAMDataset)dataSet).getMaximum());
            datasetNodeElement.setAttribute("BUFFER_SPACE", ((FMPVSAMDataset)dataSet).getBufferSpace());
        }
        return datasetNodeElement;
    }

    public TT_TreeItem updateModel(TT_TreeItem parent, Element dataset) {
        String name = dataset.getAttribute(NAME);
        name = name.replace("%23", "#");
        name = name.replace("%24", "$");
        name = name.replace("%40", "@");
        String DSLength = dataset.getAttribute("DSLENGTH");
        String DSorg = dataset.getAttribute("DSORG");
        String FileType = dataset.getAttribute("FILETYPE");
        String Volume = dataset.getAttribute("VOLUME");
        String blkSize = dataset.getAttribute("BLKSIZE");
        FileMasterDataset datasetObject = null;
        FMPVSAMDataset vsamDatasetObject = null;
        TT_TreeItem datasetItem = null;
        if (DSorg.equals("VSAM") || FileType.startsWith("VSAM")) {
            vsamDatasetObject = new FMPVSAMDataset(parent);
            datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)vsamDatasetObject);
            datasetItem = this.findObjectInTree((Object)((FMPVSAMDataset)datasetItem.getValue()), parent);
        } else {
            datasetObject = new FileMasterDataset(parent);
            datasetItem = new TT_TreeItem(dataset, (ITreeWrappedItem)datasetObject);
            datasetItem = this.findObjectInTree((Object)((FileMasterDataset)datasetItem.getValue()), parent);
        }
        FileMasterDataset fmDataSet = (FileMasterDataset)((Object)datasetItem.getAdapter(FileMasterDataset.class));
        fmDataSet.setName(name);
        fmDataSet.setFileType(FileType);
        fmDataSet.setVolume(Volume);
        fmDataSet.setDsOrg(DSorg);
        fmDataSet.setDsType(dataset.getAttribute("DSTYPE"));
        fmDataSet.setDSLength(DSLength);
        fmDataSet.setBlksize(blkSize);
        fmDataSet.setLrecl(dataset.getAttribute("LRECL"));
        fmDataSet.setExtents(dataset.getAttribute("EXTENTS"));
        fmDataSet.setDateCreated(dataset.getAttribute("DATECREATED"));
        fmDataSet.setDateReferenced(dataset.getAttribute("DATEREFERENCED"));
        fmDataSet.setExpirationDate(dataset.getAttribute("EXPDTDATE"));
        fmDataSet.setDSLength(dataset.getAttribute("DSLENGTH"));
        fmDataSet.setRecfm(dataset.getAttribute("RECFM"));
        fmDataSet.setTracks(dataset.getAttribute("TRACKS"));
        fmDataSet.setUnits(dataset.getAttribute("SPCUNITS"));
        fmDataSet.setPrimaryAlloc(dataset.getAttribute("SPCPRI"));
        fmDataSet.setSecondaryAlloc(dataset.getAttribute("SPCSEC"));
        fmDataSet.setUnitType(dataset.getAttribute("UNITTYPE"));
        fmDataSet.setUsedAllocUnit(dataset.getAttribute("USEDALLOCUnit"));
        fmDataSet.setUsedAllocValue(dataset.getAttribute("USEDALLOCValue"));
        fmDataSet.setAllocatedallocUnit(dataset.getAttribute("ALLOCATEDALOCUnit"));
        fmDataSet.setAllocatedallocValue(dataset.getAttribute("ALLOCATEDALOCValue"));
        fmDataSet.setExtentsAllocated(dataset.getAttribute("EXTENTSAllocated"));
        fmDataSet.setExtentsUsed(dataset.getAttribute("EXTENTSUsed"));
        fmDataSet.setDircMax(dataset.getAttribute("DIRCMax"));
        fmDataSet.setDircUsed(dataset.getAttribute("DIRCUsed"));
        fmDataSet.setNumMembers(dataset.getAttribute("NUMMembers"));
        if (DSorg.equals("VSAM")) {
            FMPVSAMDataset vsamFMDataSet = (FMPVSAMDataset)((Object)datasetItem.getAdapter(FMPVSAMDataset.class));
            vsamFMDataSet.setLength(dataset.getAttribute("KEY_LENGTH"));
            vsamFMDataSet.setOffset(dataset.getAttribute("KEY_POSITION"));
            vsamFMDataSet.setAverage(dataset.getAttribute("AVERAGE_RECORD_SIZE"));
            vsamFMDataSet.setMaximum(dataset.getAttribute("MAXIMUM_RECORD_SIZE"));
            vsamFMDataSet.setBufferSpace(dataset.getAttribute("BUFFER_SPACE"));
        }
        return datasetItem;
    }

    protected static enum Position {
        first,
        last,
        before,
        after;

    }
}

