/*
 * Decompiled with CFR 0.152.
 */
package com.ca.fmp.ims.operation;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.model.DatasetResponse;
import com.ca.fmp.ims.model.RestoreDataSetRequestType;
import com.ca.fmp.ims.model.generated.CatalogedDataSetType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.MessageType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;

public class RestoreDataSetJob
extends Job {
    private static final String nameOfJob = "Restore Archive Dataset(s)";
    private ArrayList<String> archivedDatasetsThatNeedsToBeRestored = new ArrayList();
    private HashMap<String, String> errorsForEachDataset = new HashMap();
    private FileMasterServer fileMasterServer;
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String RESTORE_SUCCESS_MESSAGE = "* Restore successful *";
    private boolean isJobSuccessful = true;
    private TableViewer tableViewer;
    private TitleAreaDialog titleAreaDialog;
    private String messageHaveBeenRestored = "The restore operation has been completed";

    public RestoreDataSetJob(ArrayList<String> archivedDatasetsThatNeedsToBeRestored, FileMasterServer fileMasterServer, TableViewer tableViewer, TitleAreaDialog titleAreaDialog) {
        super(nameOfJob);
        this.tableViewer = tableViewer;
        this.titleAreaDialog = titleAreaDialog;
        this.archivedDatasetsThatNeedsToBeRestored = archivedDatasetsThatNeedsToBeRestored;
        this.fileMasterServer = fileMasterServer;
        this.setPriority(20);
        this.schedule();
    }

    public boolean isJobSuccessful() {
        return this.isJobSuccessful;
    }

    public HashMap<String, String> getErrorsForEachDataset() {
        return this.errorsForEachDataset;
    }

    protected IStatus run(IProgressMonitor monitor) {
        for (String dataset : this.archivedDatasetsThatNeedsToBeRestored) {
            CatalogedDataSetType restoreDataSetType = new CatalogedDataSetType();
            restoreDataSetType.setDsname(dataset);
            RestoreDataSetRequestType restoreDataSetRequestType = new RestoreDataSetRequestType(this.fileMasterServer, restoreDataSetType);
            restoreDataSetRequestType.createXml();
            try {
                String xDataset = dataset;
                XMLDocument xmlDocument = new XMLDocument(restoreDataSetRequestType.createXml());
                HashMap<String, Object> map = new HashMap<String, Object>();
                SendRequestToMainframe req = new SendRequestToMainframe(this.fileMasterServer, map, "opendb", true, xmlDocument);
                if (req.getResult() == Status.CANCEL_STATUS) {
                    this.log.log(Level.WARNING, "Error when sending mainframe request");
                    this.isJobSuccessful = false;
                    return Status.CANCEL_STATUS;
                }
                GUIResponseType guiResponse = req.getGuiResponseType();
                FileMasterSession.cancelOneSession((FileMasterServer)this.fileMasterServer, (String)guiResponse.getGUIsession());
                String shortText = "";
                String longText = "";
                int i = 0;
                while (i < guiResponse.getMessages().getMessage().size()) {
                    shortText = String.valueOf(shortText) + ((MessageType)guiResponse.getMessages().getMessage().get(i)).getShortText() + "\n";
                    this.log.log(Level.INFO, "shortText: " + shortText);
                    List messageText = ((MessageType)guiResponse.getMessages().getMessage().get(i)).getMessageText();
                    int j = 0;
                    while (j < messageText.size()) {
                        String messageJ = (String)messageText.get(i);
                        longText = String.valueOf(longText) + messageJ + "\n";
                        ++j;
                    }
                    this.log.log(Level.INFO, "longText: " + longText);
                    ++i;
                }
                if (shortText.trim().equals(RESTORE_SUCCESS_MESSAGE)) {
                    this.errorsForEachDataset.put(xDataset, shortText);
                    continue;
                }
                this.errorsForEachDataset.put(xDataset, longText);
                this.isJobSuccessful = false;
            }
            catch (TTException e) {
                this.log.log(Level.WARNING, "received TTEXception");
                this.log.log(Level.WARNING, e.getMessage());
                this.isJobSuccessful = false;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<DatasetResponse> drp = new ArrayList<DatasetResponse>();
                RestoreDataSetJob.this.log.log(Level.INFO, "update table with errors");
                for (Map.Entry next : RestoreDataSetJob.this.errorsForEachDataset.entrySet()) {
                    RestoreDataSetJob.this.log.log(Level.INFO, String.valueOf((String)next.getKey()) + ":" + (String)next.getValue());
                    DatasetResponse d = new DatasetResponse((String)next.getKey(), (String)next.getValue());
                    drp.add(d);
                }
                if (RestoreDataSetJob.this.tableViewer != null && !RestoreDataSetJob.this.tableViewer.getTable().isDisposed()) {
                    RestoreDataSetJob.this.tableViewer.setInput(drp);
                    if (RestoreDataSetJob.this.titleAreaDialog != null) {
                        RestoreDataSetJob.this.titleAreaDialog.setMessage(RestoreDataSetJob.this.messageHaveBeenRestored);
                    }
                }
            }
        });
        return Status.OK_STATUS;
    }
}

