/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterSession;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.FMEditorProfile;
import com.ca.filemaster.editor.RunGetGetRecords;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.SRFField;
import com.ca.filemaster.editor.virtualtableviews.SRFFormatLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.SRFNameLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.SRFPositionLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.SRFValueEditingSupport;
import com.ca.filemaster.editor.virtualtableviews.SRFValueLabelProvider;
import com.ca.filemaster.editor.virtualtableviews.TableFormatMode;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SingleRecordFormatMode
extends TableFormatMode
implements Runnable {
    ArrayList<SRFField> SRFFieldsUsedAsInputByTableViewer;
    public static int PAGE_SIZE = 0;
    public static int GUI_PAGESIZE = 1;
    public static int COUNT = 1;
    private FileMasterServer server;
    private String uuid;
    public static int recordNumber = 1;
    public static int recordLength = 1;
    private List<FileMasterRecord> records;
    private XMLRequest xml;
    private Composite topContainer;
    private Text recordNumberText;
    private Text recordLengthText;
    private Text recordLayoutText;
    private Text errorMessageText;
    private boolean disableBtns = false;
    private Button first;
    private int recIndex;
    private Button previous;
    private Button next;
    private Button last;
    private Composite bottomContainer;
    private int start = 1;
    private int end = COUNT;
    private String hexDisplay;
    private Integer cursor;
    private int firstRec = 0;
    private FileMasterDataset layoutDataSet;
    private FileMasterMember layoutMember;
    private boolean isVariableLengthFile = false;
    private boolean validRecordCount = false;
    private Slider hSlider;
    private Slider vSlider;
    private Composite mainContainer;
    private boolean hscroll = false;
    private Thread t;
    private Runnable runnableObj = this;
    private SRFValueEditingSupport srfValueEditingSupport;
    private Runnable loadHorizontalData = new Runnable(){

        @Override
        public void run() {
            SingleRecordFormatMode.this.updateTableDisplay();
            SingleRecordFormatMode.this.tableViewer.getTable().redraw();
        }
    };
    private String[] columnNames;
    private int[] columnWidths;
    private int[] columnAlignments;
    private int maximumRecFieldLen = 0;
    private boolean controlResized = true;
    private List<String> fieldsWithErrorFromTheStart;
    private String lastFieldEdited;
    @Deprecated
    public static FMPCursor Fmpcursor;
    public static String totalMatch;
    private static Logger logger;

    static {
        totalMatch = "";
        logger = Logger.getLogger(SingleRecordFormatMode.class.getName());
    }

    public SingleRecordFormatMode(Composite parent, EditorView editorView) {
        super(parent, editorView);
        FMEditorProfile profile = editorView.getProfile();
        if (profile.getMinLength() != profile.getMaxLength()) {
            this.isVariableLengthFile = true;
        }
        String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
        this.uuid = editorView.getCurrentSession(secondaryID).getUuid();
        this.server = editorView.getCurrentSession(secondaryID).getServer();
    }

    public Composite getContainer() {
        this.t = new Thread(this.runnableObj, "Scrollable Thread");
        this.mainContainer = new Composite(this.parent, 0);
        this.mainContainer.setLayout((Layout)new GridLayout(2, false));
        this.topContainer = new Composite(this.mainContainer, 0);
        this.topContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.topContainer.setLayout((Layout)new GridLayout(7, false));
        Label recordNumberLabel = new Label(this.topContainer, 0);
        recordNumberLabel.setText("Record number:");
        this.recordNumberText = new Text(this.topContainer, 0);
        GridData textGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        textGridData.widthHint = 60;
        this.recordNumberText.setLayoutData((Object)textGridData);
        this.recordNumberText.setEditable(false);
        this.recordNumberText.setText("1");
        Label recordLengthLabel = new Label(this.topContainer, 0);
        recordLengthLabel.setText("Record length:");
        this.recordLengthText = new Text(this.topContainer, 0);
        this.recordLengthText.setEditable(false);
        this.recordLengthText.setLayoutData((Object)textGridData);
        Label recordLayoutLabel = new Label(this.topContainer, 0);
        recordLayoutLabel.setText("Record layout:");
        this.recordLayoutText = new Text(this.topContainer, 0);
        GridData data = new GridData(4, 0x1000000, false, false, 1, 1);
        data.widthHint = 100;
        this.recordLayoutText.setLayoutData((Object)data);
        this.recordLayoutText.setEditable(false);
        this.errorMessageText = new Text(this.topContainer, 1);
        GridData errordata = new GridData(4, 0x1000000, true, false, 1, 1);
        errordata.widthHint = 300;
        this.errorMessageText.setLayoutData((Object)errordata);
        this.errorMessageText.setEditable(false);
        this.errorMessageText.setForeground(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().getSystemColor(3));
        this.errorMessageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SingleRecordFormatMode.this.disableBtns) {
                    SingleRecordFormatMode.this.first.setEnabled(false);
                    SingleRecordFormatMode.this.previous.setEnabled(false);
                    SingleRecordFormatMode.this.next.setEnabled(false);
                    SingleRecordFormatMode.this.last.setEnabled(false);
                    SingleRecordFormatMode.this.editorView.setDirty(false);
                    EditorView editorView = SingleRecordFormatMode.this.editorView;
                    ((Object)((Object)SingleRecordFormatMode.this.editorView)).getClass();
                    editorView.getToolBarAction("editor.charFormatAction").setEnabled(false);
                    EditorView editorView2 = SingleRecordFormatMode.this.editorView;
                    ((Object)((Object)SingleRecordFormatMode.this.editorView)).getClass();
                    editorView2.getToolBarAction("editor.hexFormatAction").setEnabled(false);
                } else {
                    EditorView editorView = SingleRecordFormatMode.this.editorView;
                    ((Object)((Object)SingleRecordFormatMode.this.editorView)).getClass();
                    editorView.getToolBarAction("editor.charFormatAction").setEnabled(true);
                    EditorView editorView3 = SingleRecordFormatMode.this.editorView;
                    ((Object)((Object)SingleRecordFormatMode.this.editorView)).getClass();
                    editorView3.getToolBarAction("editor.hexFormatAction").setEnabled(true);
                    if (!SingleRecordFormatMode.this.first.isEnabled() && !SingleRecordFormatMode.this.previous.isEnabled() && SingleRecordFormatMode.this.recIndex > 0) {
                        SingleRecordFormatMode.this.first.setEnabled(true);
                        SingleRecordFormatMode.this.previous.setEnabled(true);
                    }
                    if ((SingleRecordFormatMode.this.first.isEnabled() || SingleRecordFormatMode.this.previous.isEnabled()) && SingleRecordFormatMode.this.recIndex == 0) {
                        SingleRecordFormatMode.this.first.setEnabled(false);
                        SingleRecordFormatMode.this.previous.setEnabled(false);
                    }
                    if (SingleRecordFormatMode.this.records != null && ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).isLastRecord()) {
                        SingleRecordFormatMode.this.next.setEnabled(false);
                        SingleRecordFormatMode.this.last.setEnabled(false);
                    }
                    if (!(SingleRecordFormatMode.this.next.isEnabled() || SingleRecordFormatMode.this.last.isEnabled() || SingleRecordFormatMode.this.records == null || ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).isLastRecord())) {
                        SingleRecordFormatMode.this.next.setEnabled(true);
                        SingleRecordFormatMode.this.last.setEnabled(true);
                    }
                }
            }
        });
        new Label(this.mainContainer, 0);
        this.bottomContainer = new Composite(this.mainContainer, 0);
        this.bottomContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout bottomContainerLayout = new GridLayout(4, false);
        bottomContainerLayout.marginTop = -5;
        bottomContainerLayout.marginRight = -5;
        bottomContainerLayout.marginLeft = -5;
        this.bottomContainer.setLayout((Layout)bottomContainerLayout);
        this.createTable(this.bottomContainer, false);
        this.createScrollBars(this.bottomContainer);
        new Label(this.bottomContainer, 0);
        new Label(this.bottomContainer, 0);
        new Label(this.bottomContainer, 0);
        this.first = new Button(this.bottomContainer, 0);
        GridData gridData = new GridData(131072, 0x1000000, true, false, 1, 1);
        this.first.setEnabled(false);
        gridData.widthHint = 76;
        this.first.setLayoutData((Object)gridData);
        this.first.setText("&First");
        this.first.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(false);
                SingleRecordFormatMode.this.recIndex = 0;
                SingleRecordFormatMode.this.getFirstRecordChunk(SingleRecordFormatMode.this.hexDisplay);
                SingleRecordFormatMode.this.setRecordInput((FileMasterRecord)SingleRecordFormatMode.this.records.get(0));
                String recordNumber4Display = SingleRecordFormatMode.this.setRecordNumberDisplay();
                if (!SingleRecordFormatMode.this.tableViewer.getTable().isDisposed()) {
                    SingleRecordFormatMode.this.recordNumberText.setText(recordNumber4Display);
                    recordNumber = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getNumber();
                    recordLength = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength();
                    SingleRecordFormatMode.this.recordLengthText.setText(String.valueOf(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength()));
                    SingleRecordFormatMode.this.recordLayoutText.setText(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLayoutMemberName());
                    FMPCursor fmpCursor = new FMPCursor(recordNumber, ((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getName(), Integer.parseInt(((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getPosition()), 0);
                    SingleRecordFormatMode.this.editorView.setCursor(fmpCursor);
                    SingleRecordFormatMode.this.first.setEnabled(false);
                    SingleRecordFormatMode.this.previous.setEnabled(false);
                    SingleRecordFormatMode.this.next.setEnabled(true);
                    SingleRecordFormatMode.this.last.setEnabled(true);
                    if (SingleRecordFormatMode.this.errorMessageText.getText().contains("CAWA997W")) {
                        SingleRecordFormatMode.this.errorMessageText.setText(SingleRecordFormatMode.this.errorMessageText.getText());
                    } else {
                        SingleRecordFormatMode.this.errorMessageText.setText("");
                    }
                    SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(true);
                }
            }
        });
        this.previous = new Button(this.bottomContainer, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.previous.setEnabled(false);
        gridData.widthHint = 76;
        this.previous.setLayoutData((Object)gridData);
        this.previous.setText("&Previous");
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(false);
                if (SingleRecordFormatMode.this.recIndex > 0) {
                    SingleRecordFormatMode singleRecordFormatMode = SingleRecordFormatMode.this;
                    singleRecordFormatMode.recIndex = singleRecordFormatMode.recIndex - 1;
                }
                if (SingleRecordFormatMode.this.recIndex == 0) {
                    SingleRecordFormatMode.this.first.setEnabled(false);
                    SingleRecordFormatMode.this.previous.setEnabled(false);
                }
                if (!SingleRecordFormatMode.this.next.isEnabled() || !SingleRecordFormatMode.this.last.isEnabled()) {
                    SingleRecordFormatMode.this.next.setEnabled(true);
                    SingleRecordFormatMode.this.last.setEnabled(true);
                }
                SingleRecordFormatMode.this.getPreviousRecordChunk(SingleRecordFormatMode.this.hexDisplay);
                SingleRecordFormatMode.this.setRecordInput((FileMasterRecord)SingleRecordFormatMode.this.records.get(0));
                String recordNumber4Display = SingleRecordFormatMode.this.setRecordNumberDisplay();
                if (!SingleRecordFormatMode.this.tableViewer.getTable().isDisposed()) {
                    SingleRecordFormatMode.this.recordNumberText.setText(recordNumber4Display);
                    recordNumber = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getNumber();
                    recordLength = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength();
                    SingleRecordFormatMode.this.recordLengthText.setText(String.valueOf(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength()));
                    SingleRecordFormatMode.this.recordLayoutText.setText(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLayoutMemberName());
                    FMPCursor fmpCursor = new FMPCursor(recordNumber, ((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getName(), Integer.parseInt(((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getPosition()), 0);
                    SingleRecordFormatMode.this.editorView.setCursor(fmpCursor);
                    if (SingleRecordFormatMode.this.errorMessageText.getText().contains("CAWA997W")) {
                        SingleRecordFormatMode.this.errorMessageText.setText(SingleRecordFormatMode.this.errorMessageText.getText());
                    } else {
                        SingleRecordFormatMode.this.errorMessageText.setText("");
                    }
                    SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(true);
                }
            }
        });
        this.next = new Button(this.bottomContainer, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 76;
        this.next.setLayoutData((Object)gridData);
        this.next.setText("&Next");
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SingleRecordFormatMode.this.recIndex == PAGE_SIZE - 1) {
                    if (((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).isLastRecord()) {
                        return;
                    }
                    SingleRecordFormatMode.this.getNextRecordChunk(SingleRecordFormatMode.this.hexDisplay);
                }
                SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(false);
                if (SingleRecordFormatMode.this.recIndex < PAGE_SIZE - 1) {
                    SingleRecordFormatMode singleRecordFormatMode = SingleRecordFormatMode.this;
                    singleRecordFormatMode.recIndex = singleRecordFormatMode.recIndex + 1;
                }
                if (SingleRecordFormatMode.this.recIndex >= SingleRecordFormatMode.this.records.size()) {
                    SingleRecordFormatMode.this.getNextRecordChunk(SingleRecordFormatMode.this.hexDisplay);
                }
                SingleRecordFormatMode.this.setRecordInput((FileMasterRecord)SingleRecordFormatMode.this.records.get(0));
                String recordNumber4Display = SingleRecordFormatMode.this.setRecordNumberDisplay();
                if (!SingleRecordFormatMode.this.tableViewer.getTable().isDisposed()) {
                    SingleRecordFormatMode.this.recordNumberText.setText(recordNumber4Display);
                    recordNumber = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getNumber();
                    recordLength = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength();
                    SingleRecordFormatMode.this.recordLengthText.setText(String.valueOf(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength()));
                    SingleRecordFormatMode.this.recordLayoutText.setText(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLayoutMemberName());
                    FMPCursor fmpCursor = new FMPCursor(recordNumber, ((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getName(), Integer.parseInt(((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getPosition()), 0);
                    SingleRecordFormatMode.this.editorView.setCursor(fmpCursor);
                    if (((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).isLastRecord()) {
                        SingleRecordFormatMode.this.next.setEnabled(false);
                        SingleRecordFormatMode.this.last.setEnabled(false);
                        PAGE_SIZE = recordNumber;
                        SingleRecordFormatMode.this.validRecordCount = true;
                    }
                    if (!SingleRecordFormatMode.this.first.isEnabled() || !SingleRecordFormatMode.this.previous.isEnabled()) {
                        SingleRecordFormatMode.this.first.setEnabled(true);
                        SingleRecordFormatMode.this.previous.setEnabled(true);
                    }
                    if (SingleRecordFormatMode.this.errorMessageText.getText().contains("CAWA997W")) {
                        SingleRecordFormatMode.this.errorMessageText.setText(SingleRecordFormatMode.this.errorMessageText.getText());
                    } else {
                        SingleRecordFormatMode.this.errorMessageText.setText("");
                    }
                    SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(true);
                }
            }
        });
        this.last = new Button(this.bottomContainer, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 76;
        this.last.setLayoutData((Object)gridData);
        this.last.setText("&Last");
        this.last.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SingleRecordFormatMode.this.recIndex == PAGE_SIZE - 1) {
                    return;
                }
                if (!SingleRecordFormatMode.this.tableViewer.getTable().isDisposed()) {
                    SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(false);
                    SingleRecordFormatMode.this.getLastRecordChunk(SingleRecordFormatMode.this.hexDisplay);
                    SingleRecordFormatMode.this.recIndex = PAGE_SIZE - 1;
                    SingleRecordFormatMode.this.setRecordInput((FileMasterRecord)SingleRecordFormatMode.this.records.get(0));
                    String recordNumber4Display = SingleRecordFormatMode.this.setRecordNumberDisplay();
                    if (!SingleRecordFormatMode.this.tableViewer.getTable().isDisposed()) {
                        SingleRecordFormatMode.this.recordNumberText.setText(recordNumber4Display);
                        recordNumber = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getNumber();
                        recordLength = ((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength();
                        SingleRecordFormatMode.this.recordLengthText.setText(String.valueOf(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLength()));
                        SingleRecordFormatMode.this.recordLayoutText.setText(((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getLayoutMemberName());
                        if (((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).isLastRecord() && PAGE_SIZE != recordNumber) {
                            PAGE_SIZE = recordNumber;
                            SingleRecordFormatMode.this.recIndex = PAGE_SIZE - 1;
                            SingleRecordFormatMode.this.validRecordCount = true;
                            SingleRecordFormatMode.this.next.setEnabled(false);
                            SingleRecordFormatMode.this.last.setEnabled(false);
                        }
                        FMPCursor fmpCursor = new FMPCursor(recordNumber, ((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getName(), Integer.parseInt(((FileMasterRecordField)((FileMasterRecord)SingleRecordFormatMode.this.records.get(0)).getRecordFields().get(0)).getLayoutField().getPosition()), 0);
                        SingleRecordFormatMode.this.editorView.setCursor(fmpCursor);
                        SingleRecordFormatMode.this.first.setEnabled(true);
                        SingleRecordFormatMode.this.previous.setEnabled(true);
                        if (SingleRecordFormatMode.this.errorMessageText.getText().contains("CAWA997W")) {
                            SingleRecordFormatMode.this.errorMessageText.setText(SingleRecordFormatMode.this.errorMessageText.getText());
                        } else {
                            SingleRecordFormatMode.this.errorMessageText.setText("");
                        }
                        SingleRecordFormatMode.this.tableViewer.getTable().setRedraw(true);
                    }
                }
            }
        });
        return this.mainContainer;
    }

    private void getFirstRecordChunk(String hex) {
        this.start = 1;
        this.end = COUNT;
        RunGetGetRecords getRecordsRunner = new RunGetGetRecords(this.server, this.uuid, this.start, this.end, "S", hex);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)getRecordsRunner);
        this.xml = getRecordsRunner.getXml();
        this.buildInputForViewer(this.start, this.end);
        this.updateTableDisplay();
    }

    private void getPreviousRecordChunk(String hex) {
        this.start = this.recIndex - COUNT + 2;
        this.end = COUNT;
        if (this.start <= 0) {
            this.start = 1;
            this.end = this.recIndex + 1;
        }
        RunGetGetRecords getRecordsRunner = new RunGetGetRecords(this.server, this.uuid, this.start, this.end, "S", hex);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)getRecordsRunner);
        this.xml = getRecordsRunner.getXml();
        this.buildInputForViewer(this.start, this.end);
        this.updateTableDisplay();
    }

    private void getNextRecordChunk(String hex) {
        this.start = this.recIndex + 1;
        RunGetGetRecords getRecordsRunner = new RunGetGetRecords(this.server, this.uuid, this.start, COUNT, "S", hex);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)getRecordsRunner);
        this.xml = getRecordsRunner.getXml();
        this.buildInputForViewer();
        this.updateSliderAttr();
        this.updateTableDisplay();
    }

    private void getLastRecordChunk(String hex) {
        if (!this.validRecordCount && this.isVariableLengthFile) {
            this.start = PAGE_SIZE;
            RunGetGetRecords getRecordsRunner = new RunGetGetRecords(this.server, this.uuid, Integer.MAX_VALUE, 1, "S", hex);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)getRecordsRunner);
            this.xml = getRecordsRunner.getXml();
        } else {
            this.start = PAGE_SIZE - COUNT + 1;
            if (this.records.size() >= this.start) {
                this.start = this.start + (this.records.size() - this.start) + 1;
            }
            this.end = PAGE_SIZE;
            RunGetGetRecords getRecordsRunner = new RunGetGetRecords(this.server, this.uuid, this.start, COUNT, "S", hex);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)getRecordsRunner);
            this.xml = getRecordsRunner.getXml();
        }
        this.buildInputForViewer(this.start, this.end);
        this.updateTableDisplay();
    }

    private void createScrollBars(Composite mainContainer2) {
        this.hSlider = new Slider(mainContainer2, 256);
        this.hSlider.setBounds(2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().height + 2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().width - this.getPixelSizeOfCharacter() - 3 * this.tableViewer.getTable().getBorderWidth(), this.getDefaultSizeOfSliders() * 2);
        this.hSlider.setMinimum(0);
        this.hSlider.setMaximum(1);
        this.hSlider.setIncrement(this.getPixelSizeOfCharacter());
        this.hSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!SingleRecordFormatMode.this.t.isAlive()) {
                    SingleRecordFormatMode.this.hscroll = true;
                    logger.info("new Thread started");
                    SingleRecordFormatMode.this.t = new Thread(SingleRecordFormatMode.this.runnableObj, "ScrollThread");
                    SingleRecordFormatMode.this.t.start();
                    SingleRecordFormatMode.this.getSrfValueEditingSupport().focusLost(null);
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.vSlider = new Slider(this.mainContainer, 512);
        this.vSlider.setBounds(this.tableViewer.getTable().getBounds().width, this.tableViewer.getTable().getBounds().y + 3 * this.tableViewer.getTable().getBorderWidth() - this.topContainer.getBounds().height, this.getDefaultSizeOfSliders() * 2, this.tableViewer.getTable().getBounds().height);
        this.vSlider.setMinimum(0);
        this.vSlider.setIncrement(this.getPixelSizeOfCharacter());
        this.vSlider.setPageIncrement(this.getLastIndex());
        this.vSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SingleRecordFormatMode.this.tableViewer.refresh();
                SingleRecordFormatMode.this.tableViewer.getTable().setTopIndex(SingleRecordFormatMode.this.vSlider.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private TableViewer createTable(Composite composite, boolean addHexColumn) {
        this.tableViewer = new TableViewer(composite, 67602);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.tableViewer.getTable().addListener(0x1000003, new Listener(){

            public void handleEvent(Event event) {
                System.out.println("left");
            }
        });
        this.tableViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SRFField field = (SRFField)e.item.getData();
                FMPCursor fmpCursor = new FMPCursor(field.getRecordNumber(), field.getName(), Integer.valueOf(field.getPosition()).intValue(), 0, Integer.valueOf(field.getId()).intValue());
                fmpCursor.setManuallyChanged(true);
                SingleRecordFormatMode.this.editorView.setCursor(fmpCursor);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tableViewer.getTable().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                SingleRecordFormatMode.this.updateSliderAttr();
            }
        });
        this.tableViewer.getTable().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SingleRecordFormatMode.this.updateSliderAttr();
            }
        });
        this.tableViewer.getTable().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                SingleRecordFormatMode.this.updateSliderAttr();
                SingleRecordFormatMode.this.updateTableDisplay();
                SingleRecordFormatMode.this.editorView.setFocus();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000004) {
                    e.doit = false;
                    SingleRecordFormatMode.this.hSlider.setSelection(SingleRecordFormatMode.this.hSlider.getSelection() + SingleRecordFormatMode.this.getPixelSizeOfCharacter());
                    SingleRecordFormatMode.this.updateTableDisplay();
                }
                if (e.keyCode == 0x1000003) {
                    e.doit = false;
                    SingleRecordFormatMode.this.hSlider.setSelection(SingleRecordFormatMode.this.hSlider.getSelection() - SingleRecordFormatMode.this.getPixelSizeOfCharacter());
                    SingleRecordFormatMode.this.updateTableDisplay();
                }
            }
        });
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.columnNames = new String[]{"Field Name", "Position", "Format", "Value"};
        int[] nArray = new int[4];
        nArray[0] = 260;
        nArray[1] = 10 * this.getPixelSizeOfCharacter();
        nArray[2] = 10 * this.getPixelSizeOfCharacter();
        this.columnWidths = nArray;
        this.columnAlignments = new int[]{16384, 16384, 16384, 16384};
        int displayWidth = this.parent.getBounds().width;
        int i = 0;
        while (i < this.columnNames.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, this.columnAlignments[i]);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(this.columnNames[i]);
            tableColumn.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    if (SingleRecordFormatMode.this.controlResized) {
                        if (e.getSource() instanceof TableColumn) {
                            String columnName = ((TableColumn)e.getSource()).getText();
                            if (columnName.equalsIgnoreCase("Field Name")) {
                                ((SingleRecordFormatMode)SingleRecordFormatMode.this).columnWidths[0] = ((TableColumn)e.getSource()).getWidth();
                            } else if (columnName.equalsIgnoreCase("Position")) {
                                ((SingleRecordFormatMode)SingleRecordFormatMode.this).columnWidths[1] = ((TableColumn)e.getSource()).getWidth();
                            } else if (columnName.equalsIgnoreCase("Format")) {
                                ((SingleRecordFormatMode)SingleRecordFormatMode.this).columnWidths[2] = ((TableColumn)e.getSource()).getWidth();
                            }
                        }
                        if (SingleRecordFormatMode.this.tableViewer.getTable().getColumnCount() == 4) {
                            SingleRecordFormatMode.this.tableViewer.getTable().getColumn(SingleRecordFormatMode.this.tableViewer.getTable().getColumnCount() - 1).removeControlListener((ControlListener)this);
                            SingleRecordFormatMode.this.tableViewer.getTable().getColumn(SingleRecordFormatMode.this.tableViewer.getTable().getColumnCount() - 1).setWidth(SingleRecordFormatMode.this.parent.getBounds().width - (SingleRecordFormatMode.this.columnWidths[0] + SingleRecordFormatMode.this.columnWidths[1] + SingleRecordFormatMode.this.columnWidths[2]));
                            SingleRecordFormatMode.this.updateTableDisplay();
                        }
                        SingleRecordFormatMode.this.updateSliderAttr();
                    }
                    SingleRecordFormatMode.this.controlResized = true;
                }

                public void controlMoved(ControlEvent e) {
                }
            });
            this.controlResized = false;
            switch (i) {
                case 0: {
                    tableColumn.setWidth(this.columnWidths[i]);
                    SRFNameLabelProvider srfNameLabelProvider = new SRFNameLabelProvider(this.editorView.font, this);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)srfNameLabelProvider);
                    break;
                }
                case 1: {
                    tableColumn.setWidth(this.columnWidths[i]);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SRFPositionLabelProvider(this.editorView.font, this));
                    break;
                }
                case 2: {
                    tableColumn.setWidth(this.columnWidths[i]);
                    tableViewerColumn.setLabelProvider((CellLabelProvider)new SRFFormatLabelProvider(this.editorView.font, this));
                    break;
                }
                case 3: {
                    this.setMaxRecFieldLen();
                    tableColumn.setText(this.columnNames[this.columnNames.length - 1]);
                    tableColumn.setWidth(displayWidth - (this.columnWidths[0] + this.columnWidths[1] + this.columnWidths[2]));
                    this.setValueColumn(tableViewerColumn, 0, this.maximumRecFieldLen);
                }
            }
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.getTable().setFont(this.editorView.font);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "com.ca.filemaster.virtualtable.viewer");
        this.tableViewer.getControl().setFocus();
        return this.tableViewer;
    }

    private void setValueColumn(TableViewerColumn tableViewerColumn, int startIndex, int endIndex) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new SRFValueLabelProvider(this.editorView.font, this, startIndex, endIndex - 1));
        this.srfValueEditingSupport = new SRFValueEditingSupport(this, this.tableViewer, startIndex, endIndex - 1, this.records == null ? null : this.records.get(0));
        tableViewerColumn.setEditingSupport((EditingSupport)this.srfValueEditingSupport);
    }

    private void buildInputForViewer() {
        this.buildInputForViewer(0, 0);
    }

    private void buildInputForViewer(int buildStart, int buildEnd) {
        this.buildInputForViewer(buildStart, buildEnd, false, true, false);
    }

    private void buildInputForViewer(int buildStart, int buildEnd, boolean isFindChange, boolean displayPopUpDialog, boolean fieldEdited) {
        logger.log(Level.INFO, "start: " + buildStart + "\n" + "end: " + buildEnd + "\n" + "isFindChange: " + isFindChange);
        Element editResponse = this.xml.getRoot();
        NodeList messages = editResponse.getElementsByTagName("Messages");
        Node recordList = editResponse.getElementsByTagName("RecordList").item(0);
        if (recordList != null) {
            NamedNodeMap recordListAtributes = recordList.getAttributes();
            NodeList record = ((Element)recordList).getElementsByTagName("Record");
            if (displayPopUpDialog && messages.getLength() > 0) {
                totalMatch = "";
                totalMatch = this.getTagValue("Message", (Element)messages.item(0));
                if (totalMatch.startsWith("CAWA442I")) {
                    totalMatch.indexOf("found");
                    totalMatch = String.valueOf(totalMatch.substring(totalMatch.indexOf("found") + 6, totalMatch.indexOf("found") + 8)) + " matches found";
                } else if (totalMatch.startsWith("CAWA445I") || record.getLength() == 0) {
                    totalMatch = "";
                    totalMatch = "String not found";
                } else if (totalMatch.startsWith("CAWA160E") || totalMatch.startsWith("CAWA162I")) {
                    totalMatch = "";
                    totalMatch = "String not found in any field name";
                } else if (totalMatch.startsWith("CAWA161E")) {
                    totalMatch = "";
                    totalMatch = "Field is not valid for Change";
                } else if (totalMatch.startsWith("CAWA161E")) {
                    totalMatch = "";
                    totalMatch = "Field is not valid for Change";
                } else if (totalMatch.startsWith("CAWA441I") || totalMatch.startsWith("CAWA163I")) {
                    totalMatch = "";
                    totalMatch = "String found";
                } else if (totalMatch.startsWith("CAWA448I")) {
                    totalMatch = "";
                    totalMatch = "String changed";
                } else if (totalMatch.startsWith("CAWA449I")) {
                    String[] temp = totalMatch.split("'");
                    totalMatch = String.valueOf(totalMatch.substring(totalMatch.indexOf(temp[4]) + 1, totalMatch.indexOf(temp[4]) + 3)) + " matches changed";
                } else if (totalMatch.startsWith("CAWA446I")) {
                    totalMatch = "";
                    totalMatch = "No more matches found";
                } else if (!totalMatch.startsWith("CAWA553I ")) {
                    if (totalMatch.startsWith("CAWA997W")) {
                        this.setErrorMessage(totalMatch);
                    } else if (record.getLength() > 0 && record.item(0).getAttributes().getLength() > 1) {
                        totalMatch = "";
                        MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Information", (String)this.getTagValue("Message", (Element)messages.item(0)));
                    }
                }
            } else {
                this.setErrorMessage("");
            }
            String newHex = this.getAttributeValue("hex", recordListAtributes);
            if (isFindChange) {
                if (this.getTagValue("Message", (Element)messages.item(0)).startsWith("CAWA445I")) {
                    return;
                }
                this.records = new ArrayList<FileMasterRecord>();
            }
            if (!newHex.equals(this.hexDisplay)) {
                this.records = new ArrayList<FileMasterRecord>();
                this.hexDisplay = newHex;
                if (this.end > COUNT) {
                    int x = 0;
                    while (x < COUNT) {
                        this.records.add(null);
                        ++x;
                    }
                }
            }
            int recordCount = 0;
            while (recordCount < record.getLength()) {
                FileMasterRecord fileMasterRecord = new FileMasterRecord();
                Node recordNode = record.item(recordCount);
                NamedNodeMap recordAttributes = recordNode.getAttributes();
                fileMasterRecord.setNumber(Integer.parseInt(this.getAttributeValue("number", recordAttributes)));
                fileMasterRecord.setLength(Integer.parseInt(this.getAttributeValue("length", recordAttributes)));
                fileMasterRecord.setExcluded(!this.getAttributeValue("excluded", recordAttributes).equals("N"));
                boolean eof = this.getAttributeValue("eof", recordAttributes).equals("Y");
                if (eof) {
                    String secondaryID = ((IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite()).getSecondaryId();
                    FileMasterSession fileMasterSession = this.editorView.getCurrentSession(secondaryID);
                    fileMasterSession.setRecordCount(fileMasterRecord.getNumber());
                }
                fileMasterRecord.setLastRecord(eof);
                fileMasterRecord.setRRN(Integer.parseInt(this.getAttributeValue("rrn", recordAttributes)));
                fileMasterRecord.setLayoutDataSetName(this.layoutDataSet.getName());
                fileMasterRecord.setLayoutMemberName(this.layoutMember.getName());
                String fieldName = "";
                Node recordFields = ((Element)recordNode).getElementsByTagName("RecordFields").item(0);
                if (recordFields == null) {
                    return;
                }
                NodeList recordField = ((Element)recordFields).getElementsByTagName("RecordField");
                this.maximumRecFieldLen = 0;
                int i = 0;
                while (i < recordField.getLength()) {
                    FMPCursor fmpCursor;
                    Node protectedList;
                    Node fieldNode = recordField.item(i);
                    FileMasterRecordField fileMasterRecordField = new FileMasterRecordField();
                    NamedNodeMap fieldAttributes = fieldNode.getAttributes();
                    if (fieldAttributes.getNamedItem("maxLengthD") != null) {
                        String fileMasterRecordFieldMaxLengthD = fieldAttributes.getNamedItem("maxLengthD").getNodeValue();
                        fileMasterRecordField.setMaxLengthD(fileMasterRecordFieldMaxLengthD);
                        if (fieldAttributes.getNamedItem(Constants.ATTRIBUTE_ID) != null) {
                            String fileMasterRecordFieldId = fieldAttributes.getNamedItem(Constants.ATTRIBUTE_ID).getNodeValue();
                            fileMasterRecordField.setId(fileMasterRecordFieldId);
                        }
                        if (fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CHARDATAHEX) != null) {
                            String fileMasterRecordFieldCharDataHex = fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CHARDATAHEX).getNodeValue();
                            fileMasterRecordField.setCharDataHex(fileMasterRecordFieldCharDataHex);
                        }
                        String fileMasterRecordFieldMaxLengthP = fieldAttributes.getNamedItem("maxLengthP").getNodeValue();
                        fileMasterRecordField.getLayoutField().setPosition(this.getAttributeValue("position", fieldAttributes));
                        fileMasterRecordField.setMaxLengthP(fileMasterRecordFieldMaxLengthP);
                        fileMasterRecordField.getLayoutField().setId(this.getAttributeValue("id", fieldAttributes));
                        this.cursor = Integer.valueOf(this.getAttributeValue("cursor", fieldAttributes));
                        fileMasterRecordField.setCursor(this.cursor.intValue());
                        fileMasterRecordField.setColorData(this.getAttributeValue("colorData", fieldAttributes).equals("Y"));
                        fileMasterRecordField.setColorFieldName(this.getAttributeValue("colorName", fieldAttributes).equals("Y"));
                        fileMasterRecordField.setDataInputError(this.getAttributeValue("dataInpuError", fieldAttributes).equals("Y"));
                        fileMasterRecordField.getLayoutField().setLevel(this.getTagValue("Level", fieldNode));
                    }
                    if (fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CHARDATAHEX) != null) {
                        String charDataHex = fieldAttributes.getNamedItem(Constants.ATTRIBUTE_CHARDATAHEX).getNodeValue();
                        fileMasterRecordField.setCharDataHex(charDataHex);
                    }
                    fieldName = this.getTagValue("Name", fieldNode);
                    fileMasterRecordField.getLayoutField().setName(fieldName);
                    if (!fileMasterRecord.hasFieldWithErrorAfterEditing() && fileMasterRecordField.isColorData() && fieldEdited && !this.getFieldsWithErrorFromTheStart().contains(fieldName) && this.lastFieldEdited.equals(fieldName)) {
                        fileMasterRecord.setFieldWithErrorAfterEditing(true);
                    } else if (fileMasterRecordField.isColorData() && !fieldEdited) {
                        this.getFieldsWithErrorFromTheStart().add(fieldName);
                    }
                    int fieldNameColLen = (fileMasterRecordField.getLayoutField().getName().length() + (Integer.parseInt(fileMasterRecordField.getLayoutField().getLevel()) + 3)) * this.getPixelSizeOfCharacter();
                    if (fieldNameColLen > this.columnWidths[0]) {
                        this.columnWidths[0] = fieldNameColLen;
                    }
                    fileMasterRecordField.getLayoutField().setFormatChar(this.getTagValue("FormatChar", fieldNode));
                    fileMasterRecordField.getLayoutField().setSigned(this.getTagValue("Signed", fieldNode));
                    fileMasterRecordField.getLayoutField().setIntegerLength(this.getTagValue("IntegerLength", fieldNode));
                    fileMasterRecordField.getLayoutField().setFractionLength(this.getTagValue("FractionLength", fieldNode));
                    fileMasterRecord.addLayoutLevelOrder(fileMasterRecordField.getLayoutField().getLevel(), fileMasterRecordField.getLayoutField().getId());
                    fileMasterRecordField.setCharData(this.getTagValue("CharData", fieldNode));
                    fileMasterRecordField.setGroupField(!this.hasCharData(fieldNode));
                    if (Integer.parseInt(fileMasterRecordField.getLayoutField().getLevel()) > 1 && Math.max(fileMasterRecordField.getCharData().length(), fileMasterRecordField.getMaxLengthP()) > this.maximumRecFieldLen) {
                        this.maximumRecFieldLen = Math.max(fileMasterRecordField.getCharData().length(), fileMasterRecordField.getMaxLengthP());
                    }
                    if ((protectedList = ((Element)fieldNode).getElementsByTagName("ProtectedList").item(0)) != null) {
                        Node range = ((Element)protectedList).getElementsByTagName("Range").item(0);
                        NamedNodeMap rangeValues = range.getAttributes();
                        int start = Integer.parseInt(this.getAttributeValue("start", rangeValues));
                        int end = Integer.parseInt(this.getAttributeValue("end", rangeValues));
                        if (start > 0 && end > 0) {
                            fileMasterRecordField.setProtected(true);
                        }
                        fileMasterRecord.setHasVSAMKey(true);
                    }
                    fileMasterRecord.getRecordFields().add(fileMasterRecordField);
                    if (fileMasterRecord.getNumber() == 1 && Integer.parseInt(fileMasterRecordField.getLayoutField().getId()) == 0) {
                        fmpCursor = new FMPCursor(fileMasterRecord.getNumber(), fileMasterRecordField.getLayoutField().getName(), Integer.parseInt(fileMasterRecordField.getLayoutField().getPosition()), this.cursor.intValue());
                        this.editorView.setCursor(fmpCursor);
                    }
                    if (this.cursor >= 1) {
                        this.cursor = this.cursor - 1;
                        this.recIndex = fileMasterRecord.getNumber() - 1;
                        fmpCursor = new FMPCursor(fileMasterRecord.getNumber(), fileMasterRecordField.getLayoutField().getName(), Integer.parseInt(fileMasterRecordField.getLayoutField().getPosition()), this.cursor.intValue());
                        this.editorView.setCursor(fmpCursor);
                    }
                    ++i;
                }
                if (buildEnd > PAGE_SIZE) {
                    buildEnd = PAGE_SIZE;
                }
                if (this.records.size() > 0) {
                    this.records.set(0, fileMasterRecord);
                } else {
                    this.records.add(fileMasterRecord);
                }
                ++recordCount;
            }
        }
    }

    public void setRecordInput(FileMasterRecord fileMasterRecord) {
        TreeSet<String> fieldLevelSet = new TreeSet<String>();
        ArrayList<SRFField> fields = new ArrayList<SRFField>();
        for (FileMasterRecordField fileMasterRecordField : fileMasterRecord.getRecordFields()) {
            String alignedFormat;
            String signed;
            String format = fileMasterRecordField.getLayoutField().getFormatChar();
            if (format.equals("1") || format.equals("2")) {
                format = "FP";
            }
            if ((signed = fileMasterRecordField.getLayoutField().getSigned()).equals("Y")) {
                format = String.valueOf(format) + "S";
            }
            String formatValue = "";
            int formatLength = -1;
            if (fileMasterRecordField.getLayoutField().getIntegerLength().isEmpty()) {
                formatValue = new Integer(fileMasterRecordField.getMaxLengthP()).toString();
                formatLength = Integer.parseInt(formatValue);
            } else {
                formatValue = fileMasterRecordField.getLayoutField().getIntegerLength();
                if (!fileMasterRecordField.getLayoutField().getFractionLength().isEmpty()) {
                    formatLength = Integer.parseInt(formatValue) + Integer.parseInt(fileMasterRecordField.getLayoutField().getFractionLength());
                    formatValue = String.valueOf(formatValue) + "." + fileMasterRecordField.getLayoutField().getFractionLength();
                } else {
                    formatLength = Integer.parseInt(formatValue);
                }
            }
            int charLength = format.length() + formatValue.length();
            if (charLength <= 7) {
                char[] array = new char[7 - charLength];
                Arrays.fill(array, ' ');
                alignedFormat = String.valueOf(format) + new String(array) + formatValue;
            } else {
                alignedFormat = String.valueOf(format) + " " + formatValue;
            }
            String layoutFieldLevelAndName = String.valueOf(fileMasterRecordField.getLayoutField().getLevel()) + " " + fileMasterRecordField.getLayoutField().getName();
            boolean isCursorEnabled = fileMasterRecordField.isCursorEnabled();
            fields.add(new SRFField(fileMasterRecord.getNumber(), fileMasterRecordField.getLayoutField().getId(), layoutFieldLevelAndName, fileMasterRecordField.getLayoutField().getPosition(), alignedFormat, fileMasterRecordField.getCharData(), fileMasterRecordField.getHexData1(), fileMasterRecordField.getLayoutField().getLevel(), formatLength, fileMasterRecordField.isProtected(), fileMasterRecordField.isColorData(), fileMasterRecordField.isColorFieldName(), fileMasterRecordField.isDataInputError(), isCursorEnabled, fileMasterRecordField.getMaxLengthP(), fileMasterRecordField.getMaxLengthD(), fileMasterRecordField.isGroupField(), fileMasterRecordField.getCharDataHex()));
            fieldLevelSet.add(fileMasterRecordField.getLayoutField().getLevel());
        }
        ArrayList fieldLevels = new ArrayList(fieldLevelSet);
        int i = 0;
        while (i < fields.size()) {
            int indentation = fieldLevels.indexOf(((SRFField)fields.get(i)).getLevel());
            char[] array = new char[indentation * 2];
            Arrays.fill(array, ' ');
            ((SRFField)fields.get(i)).setName(String.valueOf(new String(array)) + ((SRFField)fields.get(i)).getName());
            ++i;
        }
        this.bypassFocusLost = true;
        if (this.getTableViewer().getContentProvider() != null) {
            this.tableViewer.setInput((Object)fields.toArray(new Object[fields.size()]));
        }
        this.bypassFocusLost = false;
        this.updateTableDisplay();
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().redraw();
        }
    }

    private boolean hasCharData(Node node) {
        return ((Element)node).getElementsByTagName("CharData").item(0) != null;
    }

    private String getTagValue(String tagName, Node node) {
        if (((Element)node).getElementsByTagName(tagName).item(0) != null) {
            return ((Element)node).getElementsByTagName(tagName).item(0).getTextContent();
        }
        return "";
    }

    private String getAttributeValue(String attributeName, NamedNodeMap namedNodeMap) {
        if (namedNodeMap.getNamedItem(attributeName) != null) {
            return namedNodeMap.getNamedItem(attributeName).getNodeValue();
        }
        return "0";
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public XMLRequest getXmlResponse() {
        return this.xml;
    }

    public void setXmlResponse(XMLRequest xml) {
        this.setXmlResponse(xml, false, true, false);
    }

    public void setXmlResponse(XMLRequest xml, boolean isFindChange, boolean displayPopUpDialog, boolean fieldEdited) {
        this.getEditorView().getStatusLineRecordNumberRangeInfo().setText("");
        this.editorView.getCursor().setFindChange(isFindChange);
        this.xml = xml;
        int errorLevel = Integer.parseInt(xml.getRoot().getAttribute("errorlevel"));
        String message = xml.getRoot().getAttribute("msg").replace('+', ' ');
        String reason = xml.getRoot().getAttribute("reason").replace('+', ' ');
        if (errorLevel > 0) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)message, (String)reason);
            return;
        }
        this.start = this.firstRec = this.getFirstRecord();
        this.end = this.start + GUI_PAGESIZE - 1;
        this.buildInputForViewer(this.start, this.end, isFindChange, displayPopUpDialog, fieldEdited);
        if (this.records != null) {
            if (this.records.size() == 0 || this.records.get(0) == null) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
                if (!this.layoutMember.getName().isEmpty()) {
                    this.recordLayoutText.setText(this.layoutMember.getName());
                }
                return;
            }
            this.setRecordInput(this.records.get(0));
            String recordNumber4Display = this.setRecordNumberDisplay();
            this.recordNumberText.setText(recordNumber4Display);
            recordNumber = this.records.get(0).getNumber();
            recordLength = this.records.get(0).getLength();
            this.recordLengthText.setText(String.valueOf(this.records.get(0).getLength()));
            this.recordLayoutText.setText(this.records.get(0).getLayoutMemberName());
            if (!this.first.isEnabled() && !this.previous.isEnabled() && this.recIndex > 0) {
                this.first.setEnabled(true);
                this.previous.setEnabled(true);
            }
            if ((this.first.isEnabled() || this.previous.isEnabled()) && this.recIndex == 0) {
                this.first.setEnabled(false);
                this.previous.setEnabled(false);
            }
            if (this.records.get(0).isLastRecord()) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
            }
            if (!(this.next.isEnabled() || this.last.isEnabled() || this.records.get(0).isLastRecord())) {
                this.next.setEnabled(true);
                this.last.setEnabled(true);
            }
        }
        this.parent.setBounds(this.parent.getBounds().x, this.parent.getBounds().y, this.parent.getBounds().width - 1, this.parent.getBounds().height);
        this.parent.setBounds(this.parent.getBounds().x, this.parent.getBounds().y, this.parent.getBounds().width + 1, this.parent.getBounds().height);
    }

    private int getFirstRecord() {
        Element editResponse = this.xml.getRoot();
        Node recordList = editResponse.getElementsByTagName("RecordList").item(0);
        if (recordList != null) {
            NodeList record = ((Element)recordList).getElementsByTagName("Record");
            Node recordNode = record.item(0);
            if (recordNode == null) {
                return 0;
            }
            NamedNodeMap recordAttributes = recordNode.getAttributes();
            return Integer.parseInt(this.getAttributeValue("number", recordAttributes));
        }
        return 0;
    }

    public int getStart() {
        return this.start;
    }

    public String isHexDisplay() {
        if (this.hexDisplay == null) {
            return "";
        }
        return this.hexDisplay;
    }

    public void setCount(int count) {
        this.recIndex = count - 1;
    }

    public void setLayoutDataSet(FileMasterDataset layoutDataSet) {
        this.layoutDataSet = layoutDataSet;
    }

    public void setLayoutMember(FileMasterMember layoutMember) {
        this.layoutMember = layoutMember;
    }

    public int getRecIndex() {
        return this.recIndex;
    }

    public void setRecIndex(int value) {
        this.recIndex = value;
    }

    private String setRecordNumberDisplay() {
        String recordNumberDisplay;
        if (this.records.get(0).getRRN() > 0) {
            recordNumberDisplay = String.valueOf(this.records.get(0).getRRN());
            this.recordNumberText.setText(String.valueOf(this.records.get(0).getRRN()));
        } else {
            if (!this.tableViewer.getTable().isDisposed()) {
                this.recordNumberText.setText(String.valueOf(this.records.get(0).getNumber()));
            }
            recordNumberDisplay = String.valueOf(this.records.get(0).getNumber());
        }
        return recordNumberDisplay;
    }

    private String setRecordNumberDisplay(FileMasterRecord fileMasterRecord) {
        String recordNumberDisplay;
        if (this.records.get(0).getRRN() > 0) {
            recordNumberDisplay = String.valueOf(fileMasterRecord.getRRN());
            this.recordNumberText.setText(String.valueOf(fileMasterRecord.getRRN()));
        } else {
            this.recordNumberText.setText(String.valueOf(fileMasterRecord.getNumber()));
            recordNumberDisplay = String.valueOf(fileMasterRecord.getNumber());
        }
        return recordNumberDisplay;
    }

    public void updateTableBasedOnFindResult(XMLResponseParser xmlResponseParser) {
        int cursor = xmlResponseParser.getCursorPosition();
        int position = xmlResponseParser.getCursorPositionBase();
        int recordNumber = xmlResponseParser.getCursorPositionLineNumber();
        int fieldId = xmlResponseParser.getCursorFieldId();
        String fieldName = xmlResponseParser.getCursorFieldName();
        if (recordNumber != -1) {
            FMPCursor fmpCursor = new FMPCursor(recordNumber, fieldName, position, cursor - 1, fieldId);
            if (this.getEditorView().getCursor().isField()) {
                fmpCursor.setField(true);
            }
            if (xmlResponseParser.isCursorInHexField()) {
                fmpCursor.setCursorInHexField(true);
            } else {
                fmpCursor.setCursorInHexField(false);
            }
            this.editorView.setCursor(fmpCursor);
            this.editorView.setYellowPosition(cursor - 1);
        }
        if (xmlResponseParser.getFileMasterRecords().size() == 0) {
            return;
        }
        FileMasterRecord fileMasterRecord = (FileMasterRecord)xmlResponseParser.getFileMasterRecords().get(0);
        this.setRecordInput(fileMasterRecord);
        this.setRecordNumberDisplay(fileMasterRecord);
        this.start = recordNumber = fileMasterRecord.getNumber();
        this.recIndex = fileMasterRecord.getNumber() - 1;
        if (fieldId > 0) {
            this.tableViewer.getTable().setTopIndex(fieldId);
            this.vSlider.setSelection(fieldId);
        }
        int prevMaximumRecFieldLen = this.maximumRecFieldLen;
        this.maximumRecFieldLen = 0;
        int i = 0;
        while (i < fileMasterRecord.getRecordFields().size()) {
            FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(i);
            if (Integer.parseInt(fileMasterRecordField.getLayoutField().getLevel()) > 1 && Math.max(fileMasterRecordField.getCharData().length(), fileMasterRecordField.getMaxLengthP()) > this.maximumRecFieldLen) {
                this.maximumRecFieldLen = Math.max(fileMasterRecordField.getCharData().length(), fileMasterRecordField.getMaxLengthP()) + 1;
            }
            ++i;
        }
        if (prevMaximumRecFieldLen != this.maximumRecFieldLen) {
            this.updateSliderAttr();
        }
        int visibleWidth = this.tableViewer.getTable().getClientArea().width - this.tableViewer.getTable().getColumn(0).getWidth() - this.tableViewer.getTable().getColumn(1).getWidth() - this.tableViewer.getTable().getColumn(2).getWidth();
        if (cursor - 1 < this.hSlider.getSelection() / this.getPixelSizeOfCharacter() || cursor - 1 > (this.hSlider.getSelection() + visibleWidth) / this.getPixelSizeOfCharacter() || prevMaximumRecFieldLen != this.maximumRecFieldLen) {
            this.HScrollToChar(cursor - 1);
        }
        if (fileMasterRecord.isLastRecord()) {
            this.next.setEnabled(false);
            this.last.setEnabled(false);
        } else {
            this.next.setEnabled(true);
            this.last.setEnabled(true);
        }
        if (this.recIndex == 0) {
            this.first.setEnabled(false);
            this.previous.setEnabled(false);
        } else {
            this.first.setEnabled(true);
            this.previous.setEnabled(true);
        }
    }

    @Override
    public void run() {
        logger.log(Level.INFO, "Executing the thread run method");
        try {
            if (this.hscroll) {
                Thread.sleep(500L);
                Display.getDefault().asyncExec(this.loadHorizontalData);
                return;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void updateTableDisplay() {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().setRedraw(false);
            int displayWidth = this.tableViewer.getTable().getBounds().width == 0 ? this.parent.getBounds().width : this.tableViewer.getTable().getBounds().width;
            int startOfDisplay = this.hSlider != null ? this.hSlider.getSelection() : 0;
            int endOfDisplay = startOfDisplay + (displayWidth - (this.columnWidths[0] + this.columnWidths[1] + this.columnWidths[2]));
            int i = this.tableViewer.getTable().getColumnCount() - 1;
            while (i >= 3) {
                this.tableViewer.getTable().getColumn(i).dispose();
                --i;
            }
            i = 0;
            while (i < this.columnNames.length) {
                switch (i) {
                    case 3: {
                        this.tableViewer.getTable().getColumns()[0].setWidth(this.columnWidths[0]);
                        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, this.columnAlignments[this.columnNames.length - 1]);
                        TableColumn tableColumn = tableViewerColumn.getColumn();
                        tableColumn.addControlListener(new ControlListener(){

                            public void controlResized(ControlEvent e) {
                                if (SingleRecordFormatMode.this.controlResized) {
                                    if (e.getSource() instanceof TableColumn) {
                                        String columnName = ((TableColumn)e.getSource()).getText();
                                        if (columnName.equalsIgnoreCase("Field Name")) {
                                            ((SingleRecordFormatMode)SingleRecordFormatMode.this).columnWidths[0] = ((TableColumn)e.getSource()).getWidth();
                                        } else if (columnName.equalsIgnoreCase("Position")) {
                                            ((SingleRecordFormatMode)SingleRecordFormatMode.this).columnWidths[1] = ((TableColumn)e.getSource()).getWidth();
                                        } else if (columnName.equalsIgnoreCase("Format")) {
                                            ((SingleRecordFormatMode)SingleRecordFormatMode.this).columnWidths[2] = ((TableColumn)e.getSource()).getWidth();
                                        }
                                    }
                                    if (SingleRecordFormatMode.this.tableViewer.getTable().getColumnCount() == 4) {
                                        SingleRecordFormatMode.this.tableViewer.getTable().getColumn(SingleRecordFormatMode.this.tableViewer.getTable().getColumnCount() - 1).removeControlListener((ControlListener)this);
                                        SingleRecordFormatMode.this.tableViewer.getTable().getColumn(SingleRecordFormatMode.this.tableViewer.getTable().getColumnCount() - 1).setWidth(SingleRecordFormatMode.this.parent.getBounds().width - (SingleRecordFormatMode.this.columnWidths[0] + SingleRecordFormatMode.this.columnWidths[1] + SingleRecordFormatMode.this.columnWidths[2]));
                                        SingleRecordFormatMode.this.updateTableDisplay();
                                    }
                                    SingleRecordFormatMode.this.updateSliderAttr();
                                }
                                SingleRecordFormatMode.this.controlResized = true;
                            }

                            public void controlMoved(ControlEvent e) {
                            }
                        });
                        tableColumn.setText(this.columnNames[this.columnNames.length - 1]);
                        this.controlResized = false;
                        tableColumn.setWidth(displayWidth - (this.columnWidths[0] + this.columnWidths[1] + this.columnWidths[2]) + this.getPixelSizeOfCharacter() / 2);
                        this.setValueColumn(tableViewerColumn, startOfDisplay / this.getPixelSizeOfCharacter(), (int)Math.ceil(endOfDisplay / this.getPixelSizeOfCharacter()));
                    }
                }
                ++i;
            }
            this.tableViewer.getTable().setRedraw(true);
            this.updateSliderAttr();
        }
    }

    private void updateSliderAttr() {
        if (this.hSlider != null) {
            this.hSlider.setEnabled(true);
            int displayWidth = this.tableViewer.getTable().getBounds().width;
            this.startOfData_inChar = this.hSlider.getSelection() / this.getPixelSizeOfCharacter() + 1;
            this.endOfData_inChar = this.startOfData_inChar + displayWidth / this.getPixelSizeOfCharacter() - (this.columnWidths[0] + this.columnWidths[1] + this.columnWidths[2]) / this.getPixelSizeOfCharacter();
            this.setMaxRecFieldLen();
            if (!this.tableViewer.getTable().isDisposed() && this.columnWidths != null && this.hSlider != null && this.vSlider != null & this.records != null) {
                this.hSlider.setBounds(2 * this.tableViewer.getTable().getBorderWidth(), this.tableViewer.getTable().getBounds().height + 2 * this.tableViewer.getTable().getBorderWidth(), displayWidth, this.getDefaultSizeOfSliders() * 2);
                this.vSlider.setBounds(this.bottomContainer.getBounds().width + this.tableViewer.getTable().getBorderWidth() * 2, this.tableViewer.getTable().getBounds().y + 4 * this.tableViewer.getTable().getBorderWidth() + this.topContainer.getBounds().height, this.getDefaultSizeOfSliders() * 2, this.tableViewer.getTable().getBounds().height);
                if (this.records.get(0) != null) {
                    this.vSlider.setMaximum(this.records.get(0).getRecordFields().size() - this.getLastIndex() < 0 ? 1 : this.records.get(0).getRecordFields().size() - this.getLastIndex() + 10);
                }
                this.vSlider.setIncrement(1);
                this.vSlider.setPageIncrement(this.getLastIndex());
                this.hSlider.setMaximum(this.maximumRecFieldLen * this.getPixelSizeOfCharacter() - (displayWidth - (this.columnWidths[0] + this.columnWidths[1] + this.columnWidths[2])) + this.getPixelSizeOfCharacter() / 2);
                if (this.endOfData_inChar - this.startOfData_inChar > this.maximumRecFieldLen + 1 && this.startOfData_inChar == 1) {
                    this.hSlider.setEnabled(false);
                }
            }
        }
    }

    private void HScrollToChar(int charPos) {
        this.hSlider.setSelection(charPos * this.getPixelSizeOfCharacter());
        this.hSlider.notifyListeners(13, new Event());
    }

    private void setMaxRecFieldLen() {
        if (this.records != null && this.records.get(0) != null) {
            int i = 0;
            while (i < this.records.get(0).getRecordFields().size()) {
                FileMasterRecordField cfr_ignored_0 = (FileMasterRecordField)this.records.get(0).getRecordFields().get(i);
                ++i;
            }
        }
    }

    public SRFValueEditingSupport getSrfValueEditingSupport() {
        return this.srfValueEditingSupport;
    }

    protected void setVSliderSel(int vSel) {
        if (this.vSlider != null || !this.vSlider.isDisposed()) {
            this.vSlider.setSelection(vSel);
            this.vSlider.notifyListeners(13, new Event());
        }
    }

    protected int getVSliderSel() {
        if (this.vSlider != null && !this.vSlider.isDisposed()) {
            return this.vSlider.getSelection();
        }
        return 0;
    }

    public void setErrorMessage(String errorMessage) {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.errorMessageText.setText(errorMessage);
            this.errorMessageText.setToolTipText(errorMessage);
        }
    }

    public String getErrorMessage() {
        return this.errorMessageText.getText();
    }

    public List<String> getFieldsWithErrorFromTheStart() {
        if (this.fieldsWithErrorFromTheStart == null) {
            this.fieldsWithErrorFromTheStart = new ArrayList<String>();
        }
        return this.fieldsWithErrorFromTheStart;
    }

    public boolean isDisableBtns() {
        return this.disableBtns;
    }

    public void setDisableBtns(boolean disableBtns) {
        this.disableBtns = disableBtns;
    }

    public String getLastFieldEdited() {
        return this.lastFieldEdited;
    }

    public void setLastFieldEdited(String lastFieldEdited) {
        this.lastFieldEdited = lastFieldEdited;
    }
}

