/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPVSAMDataset;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageOne;
import com.ca.filemaster.editor.virtualtableviews.EditingSupportFileMaster;
import com.ca.filemaster.editor.virtualtableviews.SRFField;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import com.ca.filemaster.runners.RunSetODOChange;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SRFValueEditingSupport
extends EditingSupportFileMaster {
    private static Logger log = Logger.getLogger(SRFValueEditingSupport.class.getName());
    private int vsamKeyOffset = this.getVsamKeyOffset();
    private int vsamKeyLength = this.getVsamKeyLength();

    public SRFValueEditingSupport(SingleRecordFormatMode singleRecordFormatMode, TableViewer viewer, int startIndex, int endIndex, FileMasterRecord fileMasterRecord) {
        super(viewer, singleRecordFormatMode, 0, 0, false, startIndex, endIndex);
        this.fileMasterRecord = fileMasterRecord;
    }

    @Override
    protected boolean canEdit(Object element) {
        SRFField srfField = null;
        String[] fieldNameAndLevel = null;
        String fieldName = null;
        if (!(element instanceof SRFField)) {
            log.log(Level.WARNING, "not an instance of SRFField");
            return false;
        }
        srfField = (SRFField)element;
        if (srfField.isGroupField()) {
            return false;
        }
        fieldNameAndLevel = srfField.getName().trim().split("\\s+", 2);
        fieldName = fieldNameAndLevel[fieldNameAndLevel.length - 1];
        if (((SingleRecordFormatMode)this.formatMode).isDisableBtns() && !((SingleRecordFormatMode)this.formatMode).getLastFieldEdited().equals(fieldName)) {
            return false;
        }
        if (this.fileMasterRecord.hasFieldWithErrorAfterEditing() && !srfField.isColorData()) {
            return false;
        }
        if (this.fileMasterRecord.hasFieldWithErrorAfterEditing() && srfField.isColorData() && ((SingleRecordFormatMode)this.formatMode).getFieldsWithErrorFromTheStart().contains(fieldName)) {
            return false;
        }
        if (((SingleRecordFormatMode)this.formatMode).getFieldsWithErrorFromTheStart().contains(fieldName) && !srfField.isColorData()) {
            ((SingleRecordFormatMode)this.formatMode).getFieldsWithErrorFromTheStart().remove(fieldName);
        }
        if (Integer.parseInt(srfField.getPosition()) > SingleRecordFormatMode.recordLength) {
            return false;
        }
        if (this.fileMasterRecord.hasVSAMKey() && this.vsamKeyOffset != -1 && this.vsamKeyLength != -1) {
            int position = Integer.parseInt(srfField.getPosition());
            int length = srfField.getValue().length();
            int lastVsamPosition = this.vsamKeyOffset + this.vsamKeyLength;
            log.log(Level.INFO, "position: " + position + " length: " + length + " vsamKeyOffset: " + this.vsamKeyOffset + " vsamKeyLength: " + this.vsamKeyLength);
            if (position >= this.vsamKeyOffset && position < lastVsamPosition) {
                log.log(Level.INFO, "not editable since this is a vsam key");
                return false;
            }
        }
        if (this.fileMasterRecord.hasVSAMKey() && ((SRFField)element).isProtected()) {
            log.log(Level.INFO, "not editable since this is protected");
            return false;
        }
        ((SingleRecordFormatMode)this.formatMode).setLastFieldEdited(fieldName);
        return true;
    }

    private int getVsamKeyOffset() {
        int offset = -1;
        if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset && !((FMPVSAMDataset)EditorWizardPageOne.dataSet).getOffset().isEmpty()) {
            offset = Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getOffset());
        }
        return offset;
    }

    private int getVsamKeyLength() {
        int length = -1;
        if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset && !((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength().isEmpty()) {
            length = Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength());
        }
        return length;
    }

    @Override
    protected Object getValue(Object element) {
        if (!(element instanceof SRFField)) {
            log.log(Level.WARNING, "element not instance of SRFField, return empty string instead");
            return "";
        }
        SRFField srfField = (SRFField)element;
        String originalSRFFieldValue = srfField.getValue();
        String paddedValue = String.format("%-" + this.getMaxLengthP() + "s", originalSRFFieldValue);
        srfField.setValue(paddedValue);
        log.log(Level.INFO, "just added padding: " + paddedValue.length() + ":" + paddedValue);
        if (paddedValue.length() < this.getSubStringEndIndex()) {
            try {
                return srfField.getValue().substring(this.getSubStringBeginIndex());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                log.log(Level.INFO, "srfField length: " + srfField.getValue().length() + " begin index: " + this.getSubStringBeginIndex() + " srfField value: " + srfField.getValue());
                return "";
            }
        }
        try {
            return srfField.getValue().substring(this.getSubStringBeginIndex(), this.getSubStringEndIndex());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            log.log(Level.INFO, "srfField length: " + srfField.getValue().length() + " begin index: " + this.getSubStringBeginIndex() + " end index:" + this.getSubStringEndIndex() + " srfField value: " + srfField.getValue());
            return "";
        }
    }

    @Override
    protected int getSubStringEndIndex() {
        return this.subStringEndIndex;
    }

    protected void handleDeleteKey(Text text, int currentPositionButNotRowAware) {
    }

    private void handleXMLResponse(XMLRequest xmlResponse, boolean fieldEdited) {
        this.getFormatMode().getEditorView().updateSRFEditViewer(xmlResponse, false, false, fieldEdited);
        this.getFormatMode().getEditorView().setDirty(true);
        Element overTypingResponse = xmlResponse.getRoot();
        String errorMessage = "";
        NodeList messages = overTypingResponse.getElementsByTagName("Message");
        int i = 0;
        while (i < messages.getLength()) {
            Node msgNode = messages.item(i);
            Element msgElement = (Element)msgNode;
            NodeList msgList = msgElement.getChildNodes();
            Node msgValue = msgList.item(0);
            errorMessage = msgValue.getNodeValue();
            ++i;
        }
        if (errorMessage.length() > 0) {
            ((SingleRecordFormatMode)this.getFormatMode()).setDisableBtns(true);
            if (errorMessage.startsWith("CAWA546W")) {
                ((SingleRecordFormatMode)this.getFormatMode()).setDisableBtns(false);
                errorMessage = "Input value has been truncated ";
                ((SingleRecordFormatMode)this.getFormatMode()).setErrorMessage(errorMessage);
            } else {
                if (errorMessage.startsWith("CAWA")) {
                    if (errorMessage.startsWith("CAWA516I") || errorMessage.startsWith("CAWA167W") || errorMessage.startsWith("CAWA997W") || errorMessage.startsWith("CAWA549E") || errorMessage.startsWith("CAWA548E")) {
                        ((SingleRecordFormatMode)this.getFormatMode()).setDisableBtns(false);
                    }
                    errorMessage = errorMessage.substring(8);
                }
                ((SingleRecordFormatMode)this.getFormatMode()).setErrorMessage(errorMessage);
            }
        } else {
            ((SingleRecordFormatMode)this.getFormatMode()).setDisableBtns(false);
            ((SingleRecordFormatMode)this.getFormatMode()).setErrorMessage("");
        }
    }

    private static int getNewODOValue(Element odo) {
        if (odo.hasAttribute("newValue")) {
            String newValue = odo.getAttribute("newValue");
            if (newValue.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(newValue);
        }
        return -1;
    }

    private static int getMaxODOValue(Element odo) {
        if (odo.hasAttribute("maxValue")) {
            String maxValue = odo.getAttribute("maxValue");
            if (maxValue.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(maxValue);
        }
        return -1;
    }

    private static int getNewRecordLength(Element odo) {
        if (odo.hasAttribute("newRecLen")) {
            String newRecLen = odo.getAttribute("newRecLen");
            if (newRecLen.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(newRecLen);
        }
        return -1;
    }

    private static int getMaxRecordLength(Element odo) {
        if (odo.hasAttribute("maxRecLen")) {
            String maxRecLen = odo.getAttribute("maxRecLen");
            if (maxRecLen.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(maxRecLen);
        }
        return -1;
    }

    @Override
    protected void updateView(XMLRequest xmlResponse, boolean fieldEdited) {
        Element root;
        if (xmlResponse != null && (root = xmlResponse.getRoot()).getTagName().equalsIgnoreCase("MFRequest")) {
            XMLRequest updatedXMLResponse = this.getFormatMode().getEditorView().ParsingMFRequest(xmlResponse);
            if (updatedXMLResponse != null) {
                if (this.getFormatMode().getEditorView().isContinueToEdit()) {
                    xmlResponse = updatedXMLResponse;
                } else {
                    IViewPart view;
                    this.getFormatMode().getEditorView().setEditEnd("Y");
                    IViewReference viewRef = this.getFormatMode().getWorkbenchPage().findViewReference("com.ca.filemaster.editor.virtualtableviews.EditorView", this.getFormatMode().getSecondaryId());
                    if (viewRef != null && (view = viewRef.getView(false)) != null) {
                        this.getFormatMode().getWorkbenchPage().hideView(view);
                    }
                }
            } else {
                Element firstChild = (Element)root.getFirstChild();
                if (firstChild.getTagName().equalsIgnoreCase("EditODOChange")) {
                    int newODOValue = SRFValueEditingSupport.getNewODOValue(firstChild);
                    int newRecordLength = SRFValueEditingSupport.getNewRecordLength(firstChild);
                    int maxODOValue = SRFValueEditingSupport.getMaxODOValue(firstChild);
                    int maxRecordLength = SRFValueEditingSupport.getMaxRecordLength(firstChild);
                    if (newODOValue > maxODOValue) {
                        MessageDialog.openError((Shell)this.getTableViewer().getControl().getShell(), (String)"Edit Length Modification", (String)("The new value in an occurs depending on field is out of range.\n\nNew ODO value: " + newODOValue + "\n\nMaximum ODO value: " + maxODOValue));
                        RunSetODOChange runner = new RunSetODOChange(this.getFormatMode().getFileMasterServer(), this.getFormatMode().getUUID(), false);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        xmlResponse = runner.getXml();
                    } else if (newRecordLength > maxRecordLength) {
                        MessageDialog.openError((Shell)this.getTableViewer().getControl().getShell(), (String)"Edit Length Modification", (String)("The recalculated record length exceeds the maximum due to a change in an occurs\ndepending on field.\n\nRequired record length: " + newRecordLength + "\n\nMaximum record length: " + maxRecordLength));
                        RunSetODOChange runner = new RunSetODOChange(this.getFormatMode().getFileMasterServer(), this.getFormatMode().getUUID(), false);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        xmlResponse = runner.getXml();
                    } else {
                        boolean ODOChangeConfirm = MessageDialog.openConfirm((Shell)this.getTableViewer().getControl().getShell(), (String)"Edit Length Modification", (String)("The length of the record changes due to a change in an occurs depending on field.\n\nNew record length: " + newRecordLength + "\n\nNew ODO value: " + newODOValue));
                        RunSetODOChange runner = new RunSetODOChange(this.getFormatMode().getFileMasterServer(), this.getFormatMode().getUUID(), ODOChangeConfirm);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        xmlResponse = runner.getXml();
                    }
                }
            }
        }
        this.handleXMLResponse(xmlResponse, fieldEdited);
    }

    @Override
    protected FileMasterRecord setupFileMasterRecordRequestMessage() {
        if (this.srfField == null) {
            log.log(Level.WARNING, "srfField is null");
            return null;
        }
        String valueFromTextCellEditor = this.textCellEditorFileMaster.toString();
        FileMasterRecordField fileMasterRecordField = new FileMasterRecordField();
        fileMasterRecordField.getLayoutField().setId(this.srfField.getId());
        String charData = this.srfField.getValue();
        if (charData.length() < this.getSubStringBeginIndex()) {
            log.log(Level.INFO, "length: " + charData.length() + " charData: " + charData + " beginIndex: " + this.getSubStringBeginIndex() + " endIndex: " + this.getSubStringEndIndex());
            log.log(Level.INFO, "nothing was displayed, not sending");
            return null;
        }
        String preNewValue = charData.substring(0, this.getSubStringBeginIndex());
        String postNewValue = "";
        if (charData.length() >= this.getSubStringEndIndex() + 1) {
            postNewValue = charData.substring(this.getSubStringEndIndex());
        }
        String newValue = String.valueOf(preNewValue) + valueFromTextCellEditor + postNewValue;
        log.log(Level.INFO, "charData: " + charData + " preNewValue: " + preNewValue + " valueFromTextCellEditor: " + valueFromTextCellEditor + " postNewValue: " + postNewValue);
        if (newValue.equals(this.srfField.getValue())) {
            log.log(Level.INFO, "updated value is the same as original value, not sending");
            return null;
        }
        this.srfField.setValue(newValue);
        if (this.srfField.getCharDataHex().equalsIgnoreCase("Y")) {
            fileMasterRecordField.setCharDataHex("Y");
        }
        fileMasterRecordField.setMaxLengthP(String.valueOf(this.getMaxLengthP()));
        fileMasterRecordField.setCharData(newValue);
        FileMasterRecord fileMasterRecord = new FileMasterRecord();
        fileMasterRecord.setNumber(this.srfField.getRecordNumber());
        fileMasterRecord.getRecordFields().add(fileMasterRecordField);
        return fileMasterRecord;
    }

    @Override
    protected int getMaxLengthP() {
        return this.srfField.getMaxLengthP();
    }

    protected ArrayList<Integer> getProtectedList(FileMasterRecord aFileMasterRecord, FileMasterRecordField fmrecordfield, int dataColumnNumber, int maximumNumberOfCharactersPerColumn) {
        log.log(Level.INFO, "single record format mode does not have any protected lists");
        return new ArrayList<Integer>();
    }

    @Override
    protected ArrayList<Integer> getProtectedListInCharData() {
        log.log(Level.INFO, "single record format mode does not have any protected lists");
        return new ArrayList<Integer>();
    }

    @Override
    protected void setCursor(Text fileMasterPlusText) {
        int positionInText = fileMasterPlusText.getCaretPosition() + this.getSubStringBeginIndex();
        FMPCursor fmpCursor = this.getFormatMode().getEditorView().getCursor();
        fmpCursor.setCursorOffset(positionInText);
        fmpCursor.setRecordNumber(this.srfField.getRecordNumber());
        int position = new Integer(this.srfField.getPosition());
        fmpCursor.setFieldPosition(position);
        int fieldId = new Integer(this.srfField.getId());
        fmpCursor.setFieldId(fieldId);
        fmpCursor.setManuallyChanged(true);
        this.getFormatMode().getEditorView().setCursor(fmpCursor);
    }

    @Override
    protected int getLastCursorPositionForDeletion(String source, int caretPosition) {
        return source.length() + 1 + this.getSubStringBeginIndex();
    }

    @Override
    protected String deleteCharacterWhileEditing(String valueOfText, int terminatingCharacterPosition) {
        String firstSubString = valueOfText.substring(0, terminatingCharacterPosition - 2);
        String secondSubString = valueOfText.substring(terminatingCharacterPosition - 1, valueOfText.length());
        valueOfText = String.valueOf(firstSubString) + secondSubString;
        return valueOfText;
    }

    @Override
    protected boolean isInsertable(String text, int caretPosition, int numberOfCharactersToInsert) {
        int beginIndex = this.getSubStringBeginIndex();
        int endIndex = this.getSubStringEndIndex();
        int caretPositionIncludingOffset = beginIndex + this.textCaretPosition;
        this.capacity = endIndex - beginIndex;
        log.log(Level.INFO, "begin index: " + beginIndex + " end index: " + endIndex + " textCaretPosition: " + this.textCaretPosition + " caretPositionIncludingOffset: " + caretPositionIncludingOffset);
        log.log(Level.INFO, "text length: " + text.length() + " capacity: " + this.capacity + " text: " + text);
        boolean testForSelection = false;
        if (this.textFromKeyPressed.getSelectionCount() == 0) {
            testForSelection = text.trim().length() + numberOfCharactersToInsert > this.capacity;
        } else {
            boolean bl = testForSelection = text.trim().length() + numberOfCharactersToInsert - this.textFromKeyPressed.getSelectionCount() > this.capacity;
        }
        if (text.trim().length() > this.capacity || this.textCaretPositionTrue > endIndex || testForSelection) {
            log.log(Level.INFO, "no longer to insert");
            return false;
        }
        return true;
    }

    @Override
    protected void isEndOfRecordField(KeyEvent keyEvent) {
        int beginIndex = this.getSubStringBeginIndex();
        int endIndex = this.getSubStringEndIndex();
        int caretPositionIncludingOffset = beginIndex + this.textCaretPosition;
        log.log(Level.INFO, "begin index: " + beginIndex + " end index: " + endIndex + " textCaretPosition: " + this.textCaretPosition + " caretPositionIncludingOffset: " + caretPositionIncludingOffset);
        if (caretPositionIncludingOffset >= endIndex) {
            log.log(Level.INFO, "forward acting and already at the end of the record field, have reached end of substring, do nothing");
            keyEvent.doit = false;
            return;
        }
    }

    @Override
    protected boolean canPasteOvertypeMode(Object eventObject, Text text, int caretPositionOffset, String clipboardData) {
        int endIndex = this.getSubStringEndIndex();
        int beginIndex = this.getSubStringBeginIndex();
        return beginIndex + caretPositionOffset + clipboardData.length() <= endIndex;
    }

    @Override
    protected void deleteAndInsertToData(Text text, int caretPosition_old, String stringThatWillBePasted) {
        log.log(Level.INFO, "pasteOvertype before --> " + text.getText() + ":" + text.getCaretPosition());
        String valueOfText = new String(text.getText());
        StringBuffer valueOfTextBuffer = new StringBuffer(valueOfText);
        char[] cArray = stringThatWillBePasted.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (valueOfTextBuffer.length() > caretPosition_old) {
                valueOfTextBuffer.deleteCharAt(caretPosition_old);
            }
            valueOfTextBuffer.insert(caretPosition_old, c);
            valueOfText = valueOfTextBuffer.toString();
            String preValueOfText = valueOfText.substring(0, caretPosition_old);
            String postValueOfText = valueOfText.substring(caretPosition_old + 1, valueOfText.length());
            valueOfText = String.valueOf(preValueOfText) + postValueOfText;
            valueOfText = String.valueOf(preValueOfText) + c + valueOfText.substring(caretPosition_old, valueOfText.length());
            text.setText(valueOfText.toString());
            caretPosition_old = this.moveToNextCharacter(text, caretPosition_old);
            ++n2;
        }
        log.log(Level.INFO, "pasteOvertype after --> " + text.getText() + ":" + text.getCaretPosition());
        this.makeEditorDirty();
    }
}

