/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.FMEditorProfile;
import com.ca.filemaster.editor.pricommands.wizards.EditChangeConfirmationDialog;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.runners.RunGetFindExclude;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.verifyDigit;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class WizardPageFind
extends WizardPage {
    private static final int FIND_LENGTH_MAX = 16;
    private static final String TITLE = "Find/Change";
    private static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.find";
    private static final String ERROR_START_COLUMN_GREATER_THEN_END_COLUMN = "End column range should be greater than start column range.";
    private static final String ERROR_MISSING_START_COLUMN_VALUE = "Missing start column value";
    private static final String[] FIND_TYPE = new String[]{"Character", "Case-sensitive", "Hexadecimal", "Packed decimal"};
    private static final String LOCATION_CHAR = "CHAR";
    private static final String LOCATION_WORD = "WORD";
    private static final String LOCATION_PREFIX = "PREFIX";
    private static final String LOCATION_SUFFIX = "SUFFIX";
    private static final String LOCATION_FIELD = "FIELD";
    private static final String OCCURRENCE_NEXT = "NEXT";
    private static final String OCCURRENCE_PREVIOUS = "PREV";
    private static final String OCCURRENCE_FIRST = "FIRST";
    private static final String OCCURRENCE_LAST = "LAST";
    private static final String OCCURRENCE_ALL = "ALL";
    private static final String SEARCH_ALL_LINES = "";
    private static final String SEARCH_EXCLUDED = "X";
    private static final String SEARCH_NON_EXCLUDED = "NX";
    private static final String COMMAND_TYPE_FIND = "Find";
    private static final String COMMAND_TYPE_CHANGE = "Change";
    private static final String COMMAND_TYPE_RFIND = "RFind";
    private ModifyListener mLTxtFind = null;
    private ModifyListener modLisTxtChange = null;
    private ModifyListener modLisTxtstartCol = null;
    private ModifyListener modLisTxtendCol = null;
    private Composite container;
    private Composite parentComposite;
    private Label findLim;
    private Label startCol;
    private Label endCol;
    private Label totalMatch;
    private Combo txtFindString;
    private Spinner txtFindLim;
    private Combo txtstartCol;
    private Combo txtendCol;
    private Combo txtChange;
    private Button nextBtn;
    private Button prevBtn;
    private Button firstBtn;
    private Button lastBtn;
    private Button charBtn;
    private Button wordBtn;
    private Button prefixBtn;
    private Button suffixBtn;
    private Button fieldBtn;
    private Button srchAllBtn;
    private Button excludedBtn;
    private Button nonExcludedBtn;
    private Composite btnComposite;
    private Button findBtn;
    private Button findAllBtn;
    private Button changeBtn;
    private Button changeAllBtn;
    private Combo cmbFindType;
    private Combo cmbChangeType;
    private Text txtFindLength;
    private Text txtChangeLength;
    private Logger log = Logger.getLogger(WizardPageFind.class.getName());
    private String typeofCommand;
    private String padCharacter;
    private String findValue = "";
    private String previousFindValue = "";
    private String findType = FIND_TYPE[0];
    private int findValueLength = 0;
    private int findLength = 0;
    private String changeValue = "";
    private String changeType = FIND_TYPE[0];
    private int changeLength = 0;
    private int changeValueLength = 0;
    private String columnRangeStart = "";
    private String columnRangeEnd = "";
    private EditorView lastEditorView = null;
    private boolean isFindLIMExceedLimitation = false;
    private boolean isFindQueryChanged;
    private boolean isFindCmdByFindCmd;
    private String previousCommandType = "";
    private String occurrence = "NEXT";
    private String occurrence_current = "NEXT";
    private String location = "CHAR";
    private String search = "";
    private int findLimit = 50000;
    private boolean showDialogWhenFindIsShorterThenChangeLength = true;

    public WizardPageFind() {
        super(TITLE);
        this.setTitle(TITLE);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.parentComposite = new Composite(this.container, 0);
        GridLayout gl_parentComposite = new GridLayout(1, false);
        gl_parentComposite.marginWidth = 0;
        gl_parentComposite.marginWidth = 0;
        this.parentComposite.setLayout((Layout)gl_parentComposite);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.createControlFindAndChangeGroup();
        this.createControlColumnRangeGroup();
        this.createControlOccurenceGroup();
        this.createControlLocationGroup();
        this.createControlSearchGroup();
        this.createControlSubmissionButtons();
        this.totalMatch = new Label(this.btnComposite, 64);
        this.totalMatch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.totalMatch.setText("  ");
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setEnabled(false);
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setVisible(false);
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(1).setText("Close");
        FMHistory.intializeComboBoxes((Combo)this.txtFindString, (String)"excludeExcString");
        FMHistory.intializeComboBoxes((Combo)this.txtChange, (String)"changeWithString");
        FMHistory.intializeComboBoxes((Combo)this.txtstartCol, (String)"excludestartCol");
        FMHistory.intializeComboBoxes((Combo)this.txtendCol, (String)"excludeendCol");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
        this.setControl((Control)this.container);
    }

    private void createControlSubmissionButtons() {
        this.btnComposite = new Composite(this.container, 0);
        GridLayout gl_btnComposite = new GridLayout(4, true);
        gl_btnComposite.marginWidth = 0;
        this.btnComposite.setLayout((Layout)gl_btnComposite);
        this.btnComposite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.initializeDialogUnits((Control)this.container);
        this.findBtn = new Button(this.btnComposite, 0);
        this.findBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.occurrence = WizardPageFind.this.occurrence_current;
                WizardPageFind.this.typeofCommand = WizardPageFind.COMMAND_TYPE_FIND;
                if (!WizardPageFind.this.previousCommandType.equalsIgnoreCase(WizardPageFind.this.typeofCommand)) {
                    WizardPageFind.this.previousCommandType = WizardPageFind.this.typeofCommand;
                    WizardPageFind.this.isFindCmdByFindCmd = false;
                } else {
                    WizardPageFind.this.isFindCmdByFindCmd = true;
                }
                if (!WizardPageFind.this.previousFindValue.equalsIgnoreCase(WizardPageFind.this.findValue)) {
                    WizardPageFind.this.previousFindValue = WizardPageFind.this.findValue;
                    WizardPageFind.this.isFindQueryChanged = true;
                } else {
                    WizardPageFind.this.isFindQueryChanged = false;
                }
                WizardPageFind.this.actionsWhenClickingOnAnyOfTheSubmissionButtons();
                WizardPageFind.this.sendRequestToMainframeAndUpdateEditorViewIfNeeded();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.findBtn.setText("&Find");
        this.setButtonLayoutData(this.findBtn);
        this.findAllBtn = new Button(this.btnComposite, 0);
        this.findAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.occurrence = WizardPageFind.OCCURRENCE_ALL;
                WizardPageFind.this.typeofCommand = WizardPageFind.COMMAND_TYPE_FIND;
                WizardPageFind.this.previousFindValue = WizardPageFind.this.findValue;
                WizardPageFind.this.previousCommandType = WizardPageFind.this.typeofCommand;
                WizardPageFind.this.actionsWhenClickingOnAnyOfTheSubmissionButtons();
                WizardPageFind.this.sendRequestToMainframeAndUpdateEditorViewIfNeeded();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.findAllBtn.setText("Find &All");
        this.setButtonLayoutData(this.findAllBtn);
        this.changeBtn = new Button(this.btnComposite, 0);
        this.changeBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.occurrence = WizardPageFind.this.occurrence_current;
                WizardPageFind.this.typeofCommand = WizardPageFind.COMMAND_TYPE_CHANGE;
                WizardPageFind.this.isFindCmdByFindCmd = false;
                WizardPageFind.this.isFindQueryChanged = false;
                boolean responseWithChange = WizardPageFind.this.actionsWhenClickingOnAnyOfTheChangeButtons();
                WizardPageFind.this.actionsWhenClickingOnAnyOfTheSubmissionButtons();
                if (responseWithChange) {
                    WizardPageFind.this.sendRequestToMainframeAndUpdateEditorViewIfNeeded();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.changeBtn.setText("&Change");
        this.setButtonLayoutData(this.changeBtn);
        this.changeAllBtn = new Button(this.btnComposite, 0);
        this.changeAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.occurrence = WizardPageFind.OCCURRENCE_ALL;
                WizardPageFind.this.typeofCommand = WizardPageFind.COMMAND_TYPE_CHANGE;
                boolean responseWithChange = WizardPageFind.this.actionsWhenClickingOnAnyOfTheChangeButtons();
                WizardPageFind.this.actionsWhenClickingOnAnyOfTheSubmissionButtons();
                if (responseWithChange) {
                    WizardPageFind.this.sendRequestToMainframeAndUpdateEditorViewIfNeeded();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.changeAllBtn.setText("Chan&ge All");
        this.setButtonLayoutData(this.changeAllBtn);
    }

    private void createControlColumnRangeGroup() {
        Composite composite = new Composite(this.container, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Group colRange = new Group(composite, 0);
        colRange.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        colRange.setLayout((Layout)new GridLayout(3, false));
        colRange.setText("Column range");
        this.startCol = new Label((Composite)colRange, 0);
        this.startCol.setText("&Start:");
        this.txtstartCol = new Combo((Composite)colRange, 2048);
        this.txtstartCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.modLisTxtstartCol = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtstartCol modifyText");
                WizardPageFind.this.columnRangeStart = WizardPageFind.this.txtstartCol.getText();
                WizardPageFind.this.controlModifiedAny();
            }
        };
        this.txtstartCol.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtstartCol.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtstartCol keyReleased");
                WizardPageFind.this.columnRangeStart = WizardPageFind.this.txtstartCol.getText();
                WizardPageFind.this.controlModifiedAny();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.endCol = new Label((Composite)colRange, 0);
        this.endCol.setText("&End:");
        this.txtendCol = new Combo((Composite)colRange, 2048);
        this.txtendCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.modLisTxtendCol = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtendCol modifyText");
                WizardPageFind.this.columnRangeEnd = WizardPageFind.this.txtendCol.getText();
                WizardPageFind.this.controlModifiedAny();
            }
        };
        this.txtendCol.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtendCol.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtendCol keyReleased");
                WizardPageFind.this.columnRangeEnd = WizardPageFind.this.txtendCol.getText();
                WizardPageFind.this.controlModifiedAny();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
    }

    private void createControlFindAndChangeGroup() {
        Composite composite1 = new Composite(this.parentComposite, 0);
        GridLayout gl_comp = new GridLayout(3, false);
        gl_comp.marginHeight = 0;
        gl_comp.marginWidth = 0;
        composite1.setLayout((Layout)gl_comp);
        composite1.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite firstColumnFind = new Composite(composite1, 0);
        GridLayout gl_firstColumnFind = new GridLayout(1, false);
        gl_firstColumnFind.marginHeight = 0;
        gl_firstColumnFind.marginWidth = 0;
        firstColumnFind.setLayout((Layout)gl_firstColumnFind);
        firstColumnFind.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblFind = new Label(firstColumnFind, 0);
        lblFind.setText("F&ind:");
        this.txtFindString = new Combo(firstColumnFind, 2048);
        this.txtFindString.setFocus();
        this.txtFindString.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mLTxtFind = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtFindString modifyText");
                WizardPageFind.this.findValue = WizardPageFind.this.txtFindString.getText();
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }
        };
        this.txtFindString.addModifyListener(this.mLTxtFind);
        Composite SecondColumnFind = new Composite(composite1, 0);
        GridLayout gl_SecondColumnFind = new GridLayout(1, false);
        gl_SecondColumnFind.marginHeight = 0;
        gl_SecondColumnFind.marginWidth = 0;
        SecondColumnFind.setLayout((Layout)gl_SecondColumnFind);
        SecondColumnFind.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        Label lblFindType = new Label(SecondColumnFind, 0);
        lblFindType.setText("T&ype:");
        this.cmbFindType = new Combo(SecondColumnFind, 8);
        this.cmbFindType.setItems(FIND_TYPE);
        this.cmbFindType.setText(FIND_TYPE[0]);
        this.cmbFindType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WizardPageFind.this.log.log(Level.INFO, "cmbFindType widgetSelected");
                if (WizardPageFind.this.cmbFindType.getSelectionIndex() == 3) {
                    WizardPageFind.this.txtFindLength.setEnabled(true);
                } else {
                    WizardPageFind.this.txtFindLength.setEnabled(false);
                }
                if (WizardPageFind.this.cmbFindType.getSelectionIndex() == 2 || WizardPageFind.this.cmbFindType.getSelectionIndex() == 3) {
                    WizardPageFind.this.fieldBtn.setEnabled(false);
                    if (WizardPageFind.this.fieldBtn.getSelection()) {
                        WizardPageFind.this.fieldBtn.setSelection(false);
                        WizardPageFind.this.charBtn.setSelection(true);
                    }
                } else {
                    WizardPageFind.this.fieldBtn.setEnabled(true);
                }
                WizardPageFind.this.findType = WizardPageFind.this.cmbFindType.getText();
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.cmbFindType.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "cmbFindType keyReleased");
                if (WizardPageFind.this.cmbFindType.getSelectionIndex() == 3) {
                    WizardPageFind.this.txtFindLength.setEnabled(true);
                } else {
                    WizardPageFind.this.txtFindLength.setEnabled(false);
                }
                WizardPageFind.this.findType = WizardPageFind.this.cmbFindType.getText();
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        Composite ThirdColumnFind = new Composite(composite1, 0);
        GridLayout gl_ThirdColumnFind = new GridLayout(1, true);
        gl_ThirdColumnFind.marginHeight = 0;
        gl_ThirdColumnFind.marginWidth = 0;
        ThirdColumnFind.setLayout((Layout)gl_ThirdColumnFind);
        Label lblLength = new Label(ThirdColumnFind, 0);
        lblLength.setText("&Length:");
        this.txtFindLength = new Text(ThirdColumnFind, 2048);
        this.txtFindLength.setEnabled(false);
        this.txtFindLength.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtFindLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtFindLength modifyText");
                String txtFindLengthValue = WizardPageFind.this.txtFindLength.getText();
                if (txtFindLengthValue == null || txtFindLengthValue.length() == 0) {
                    txtFindLengthValue = "0";
                }
                WizardPageFind.this.findLength = Integer.parseInt(txtFindLengthValue);
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }
        });
        Composite firstColumnChange = new Composite(composite1, 0);
        GridLayout gl_firstColumnChange = new GridLayout(1, false);
        gl_firstColumnChange.marginHeight = 0;
        gl_firstColumnChange.marginWidth = 0;
        firstColumnChange.setLayout((Layout)gl_firstColumnChange);
        firstColumnChange.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblChange = new Label(firstColumnChange, 0);
        lblChange.setText("C&hange to:");
        this.txtChange = new Combo(firstColumnChange, 2048);
        this.txtChange.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.modLisTxtChange = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtChange modify Text");
                WizardPageFind.this.changeValue = WizardPageFind.this.txtChange.getText();
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }
        };
        this.txtChange.addModifyListener(this.modLisTxtChange);
        Composite SecondColumnChange = new Composite(composite1, 0);
        GridLayout gl_SecondColumnChange = new GridLayout(1, false);
        gl_SecondColumnChange.marginHeight = 0;
        gl_SecondColumnChange.marginWidth = 0;
        SecondColumnChange.setLayout((Layout)gl_SecondColumnChange);
        SecondColumnChange.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        Label lblChangeType = new Label(SecondColumnChange, 0);
        lblChangeType.setText("Ty&pe:");
        this.cmbChangeType = new Combo(SecondColumnChange, 8);
        this.cmbChangeType.setItems(FIND_TYPE);
        this.cmbChangeType.setText(FIND_TYPE[0]);
        this.cmbChangeType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardPageFind.this.cmbChangeType.getSelectionIndex() == 3) {
                    WizardPageFind.this.txtChangeLength.setEnabled(true);
                } else {
                    WizardPageFind.this.txtChangeLength.setEnabled(false);
                }
                WizardPageFind.this.changeType = WizardPageFind.this.cmbChangeType.getText();
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.cmbChangeType.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "cmbChangeType keyReleased");
                if (WizardPageFind.this.cmbChangeType.getSelectionIndex() == 3) {
                    WizardPageFind.this.txtChangeLength.setEnabled(true);
                } else {
                    WizardPageFind.this.txtChangeLength.setEnabled(false);
                }
                WizardPageFind.this.changeType = WizardPageFind.this.cmbChangeType.getText();
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        Composite ThirdColumnChange = new Composite(composite1, 0);
        GridLayout gl_ThirdColumnChange = new GridLayout(1, true);
        gl_ThirdColumnChange.marginHeight = 0;
        gl_ThirdColumnChange.marginWidth = 0;
        ThirdColumnChange.setLayout((Layout)gl_ThirdColumnChange);
        Label lblChangeLength = new Label(ThirdColumnChange, 0);
        lblChangeLength.setText("Le&ngth:");
        this.txtChangeLength = new Text(ThirdColumnChange, 2048);
        this.txtChangeLength.setEnabled(false);
        this.txtChangeLength.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtChangeLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtChangeLength modifyText: " + WizardPageFind.this.txtChangeLength.getText());
                String txtChangeLengthValue = WizardPageFind.this.txtChangeLength.getText();
                if (txtChangeLengthValue == null || txtChangeLengthValue.length() == 0) {
                    txtChangeLengthValue = "0";
                }
                WizardPageFind.this.changeLength = Integer.parseInt(txtChangeLengthValue);
                WizardPageFind.this.controlModifiedFindChangeGroup();
                WizardPageFind.this.controlModifiedAny();
            }
        });
    }

    private void createControlSearchGroup() {
        Group searchGrp = new Group(this.container, 0);
        searchGrp.setLayout((Layout)new GridLayout(3, false));
        searchGrp.setSize(searchGrp.computeSize(-1, -1));
        searchGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        searchGrp.setText("Search");
        this.srchAllBtn = new Button((Composite)searchGrp, 16);
        this.srchAllBtn.setText("All l&ines");
        this.srchAllBtn.setSelection(true);
        this.srchAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "srchAllBtn widget selected");
                WizardPageFind.this.search = WizardPageFind.SEARCH_ALL_LINES;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.excludedBtn = new Button((Composite)searchGrp, 16);
        this.excludedBtn.setText("E&xcluded");
        this.excludedBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "excludedBtn widget selected");
                WizardPageFind.this.search = WizardPageFind.SEARCH_EXCLUDED;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.nonExcludedBtn = new Button((Composite)searchGrp, 16);
        this.nonExcludedBtn.setText("N&onexcluded lines");
        this.nonExcludedBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "nonExcludedBtn widget selected");
                WizardPageFind.this.search = WizardPageFind.SEARCH_NON_EXCLUDED;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.findLim = new Label((Composite)searchGrp, 0);
        this.findLim.setText("Find li&mit:");
        this.txtFindLim = new Spinner((Composite)searchGrp, 2048);
        EditorView editorView = this.getEditorView();
        if (editorView == null) {
            this.log.log(Level.WARNING, "editorView is null");
            return;
        }
        this.findLimit = Integer.parseInt(editorView.getProfile().getFindlim());
        this.txtFindLim.setValues(this.findLimit, 0, 99999999, 0, 1, 1);
        this.txtFindLim.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtFindLimit modified");
                WizardPageFind.this.findLimit = WizardPageFind.this.txtFindLim.getSelection();
                FMEditorProfile.findlim = Integer.toString(WizardPageFind.this.findLimit);
            }
        });
        this.txtFindLim.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "txtFindLimit keyReleased");
                WizardPageFind.this.findLimit = WizardPageFind.this.txtFindLim.getSelection();
                FMEditorProfile.findlim = Integer.toString(WizardPageFind.this.findLimit);
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
    }

    private void createControlOccurenceGroup() {
        Group occurenceGrp = new Group(this.container, 0);
        occurenceGrp.setLayout((Layout)new GridLayout(5, false));
        occurenceGrp.setSize(occurenceGrp.computeSize(-1, -1));
        occurenceGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        occurenceGrp.setText("Occurrences");
        this.setControl((Control)this.container);
        this.nextBtn = new Button((Composite)occurenceGrp, 16);
        this.nextBtn.setText("&Next");
        this.nextBtn.setSelection(true);
        this.nextBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "nextBtn widget selected");
                WizardPageFind.this.occurrence = WizardPageFind.OCCURRENCE_NEXT;
                WizardPageFind.this.occurrence_current = WizardPageFind.OCCURRENCE_NEXT;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.prevBtn = new Button((Composite)occurenceGrp, 16);
        this.prevBtn.setText("Pre&vious");
        this.prevBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "prevBtn widget selected");
                WizardPageFind.this.occurrence = WizardPageFind.OCCURRENCE_PREVIOUS;
                WizardPageFind.this.occurrence_current = WizardPageFind.OCCURRENCE_PREVIOUS;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.firstBtn = new Button((Composite)occurenceGrp, 16);
        this.firstBtn.setText("Firs&t");
        this.firstBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "firstBtn widget selected");
                WizardPageFind.this.occurrence = WizardPageFind.OCCURRENCE_FIRST;
                WizardPageFind.this.occurrence_current = WizardPageFind.OCCURRENCE_FIRST;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.lastBtn = new Button((Composite)occurenceGrp, 16);
        this.lastBtn.setText("&Last");
        this.lastBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "lastBtn widget selected");
                WizardPageFind.this.occurrence = WizardPageFind.OCCURRENCE_LAST;
                WizardPageFind.this.occurrence_current = WizardPageFind.OCCURRENCE_LAST;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void createControlLocationGroup() {
        Group locatnGrp = new Group(this.container, 0);
        locatnGrp.setLayout((Layout)new GridLayout(5, false));
        locatnGrp.setSize(locatnGrp.computeSize(-1, -1));
        locatnGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        locatnGrp.setText("Location");
        this.charBtn = new Button((Composite)locatnGrp, 16);
        this.charBtn.setText("Characte&r");
        this.charBtn.setSelection(true);
        this.charBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "charBtn widget selected");
                WizardPageFind.this.location = WizardPageFind.LOCATION_CHAR;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.wordBtn = new Button((Composite)locatnGrp, 16);
        this.wordBtn.setText("&Word");
        this.wordBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "wordBtn widget selected");
                WizardPageFind.this.location = WizardPageFind.LOCATION_WORD;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.prefixBtn = new Button((Composite)locatnGrp, 16);
        this.prefixBtn.setText("Prefi&x");
        this.prefixBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "prefixBtn widget selected");
                WizardPageFind.this.location = WizardPageFind.LOCATION_PREFIX;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.suffixBtn = new Button((Composite)locatnGrp, 16);
        this.suffixBtn.setText("S&uffix");
        this.suffixBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "suffixBtn widget selected");
                WizardPageFind.this.location = WizardPageFind.LOCATION_SUFFIX;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.fieldBtn = new Button((Composite)locatnGrp, 16);
        this.fieldBtn.setText("Fi&eld");
        this.fieldBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardPageFind.this.log.log(Level.INFO, "fieldBtn widget selected");
                WizardPageFind.this.location = WizardPageFind.LOCATION_FIELD;
                WizardPageFind.this.controlModifiedAny();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void sendRequestToMainframeAndUpdateEditorViewIfNeeded() {
        XMLRequest XML;
        String adjustedFindString = this.adjustFindString();
        String adjustedChangeString = this.adjustChangeString();
        FMPCursor adjustedCursorPosition = this.adjustCursorPosition();
        FMPRange columnRange = new FMPRange(this.columnRangeStart.trim(), this.columnRangeEnd.trim());
        EditorView editorView = this.getEditorView();
        if (editorView == null) {
            this.log.log(Level.WARNING, "editorView is null, can't send request to mainframe");
            return;
        }
        String displayMode = this.getDisplayModeOfActiveView();
        if (displayMode == null || editorView.getActiveUUID() == null) {
            this.log.log(Level.WARNING, "displayMode is null, can't send request to mainframe");
            return;
        }
        this.log.log(Level.INFO, "typeOfCommand: " + this.typeofCommand + "\n" + "fileMasterServer: " + editorView.getActiveServer() + "\n" + "uuid: " + editorView.getActiveUUID() + "\n" + "displayMode: " + displayMode + "\n" + "hexMode: " + this.getHexModeOfActiveView() + "\n" + "findLimit: " + this.findLimit + "\n" + "findString: " + adjustedFindString + "\n" + "changeString: " + adjustedChangeString + "\n" + "padCharacter: " + this.padCharacter + "\n" + "cursorPosition: " + adjustedCursorPosition.toString() + "\n" + "columnRange: " + columnRange.toString() + "\n" + "occurrence: " + this.occurrence + "\n" + "location: " + this.location + "\n" + "search: " + this.search);
        if (this.isFindLIMExceedLimitation) {
            this.typeofCommand = COMMAND_TYPE_RFIND;
        }
        RunGetFindExclude runGetFindExclude = new RunGetFindExclude(this.typeofCommand, editorView.getActiveServer(), editorView.getActiveUUID(), displayMode, this.getHexModeOfActiveView(), this.findLimit, adjustedFindString, adjustedChangeString, this.padCharacter, adjustedCursorPosition, columnRange, this.occurrence, this.location, this.search);
        Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
        BusyIndicator.showWhile((Display)display, (Runnable)runGetFindExclude);
        XMLRequest xmlResponse = runGetFindExclude.getXml();
        if (xmlResponse == null) {
            this.log.log(Level.WARNING, "xmlResponse is null");
            return;
        }
        if (xmlResponse.getRoot().getNodeName().equals(Constants.ELEMENT_GUI_RESPONSE)) {
            XMLResponseParser xmlResponseParser = this.parsingXmlRespond(editorView, xmlResponse);
            if (this.typeofCommand.equals(COMMAND_TYPE_CHANGE)) {
                editorView.setDirty(true);
            }
            editorView.updateTableBasedOnFindResult(xmlResponseParser);
        } else if (xmlResponse.getRoot().getNodeName().equals(Constants.ELEMENT_MF_REQUEST) && (XML = editorView.ParsingMFRequest(xmlResponse)) != null) {
            XMLResponseParser xmlResponseParser = this.parsingXmlRespond(editorView, XML);
            editorView.updateTableBasedOnFindResult(xmlResponseParser);
        }
    }

    private XMLResponseParser parsingXmlRespond(EditorView editorView, XMLRequest xmlResponse) {
        Element reqElement = xmlResponse.getRoot();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        EditorView view = (EditorView)page.getActivePart();
        IWorkbenchPart workbenchPart = page.getActivePart();
        IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
        String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
        XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
        if (xmlResponseParser.getReturnCode() > 4 || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("32") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("16") || reqElement.getAttribute("errorlevel").equalsIgnoreCase("32")) {
            view.handleMissingSession(reqElement, page, secondaryId);
            return null;
        }
        this.isFindLIMExceedLimitation = xmlResponseParser.getDisplayMessage().contains("CAWA185W");
        if (xmlResponseParser.getDisplayMode() != null && xmlResponseParser.getDisplayMode().equals("S") && xmlResponseParser.getCursorFieldName().isEmpty() && xmlResponseParser.getDisplayMessage().contains("CAWA3020E")) {
            this.totalMatch.setText("String not found");
        } else {
            this.totalMatch.setText(xmlResponseParser.getDisplayMessage());
            if (xmlResponseParser.getMoreMessagesForDisplay() != null && !xmlResponseParser.getMoreMessagesForDisplay().isEmpty()) {
                int size = xmlResponseParser.getMoreMessagesForDisplay().size();
                int i = 0;
                while (i < size) {
                    if (((String)xmlResponseParser.getMoreMessagesForDisplay().get(i)).contains("CAWA168W") && xmlResponseParser.getDisplayMode().equals("S")) {
                        editorView.getSingleRecordFormatMode().setErrorMessage((String)xmlResponseParser.getMoreMessagesForDisplay().get(i));
                        break;
                    }
                    MessageDialog.openInformation(null, (String)"Infomation", (String)((String)xmlResponseParser.getMoreMessagesForDisplay().get(i)));
                    ++i;
                }
            } else if (xmlResponseParser.getDisplayMode() != null && xmlResponseParser.getDisplayMode().equals("S")) {
                editorView.getSingleRecordFormatMode().setErrorMessage(SEARCH_ALL_LINES);
            }
        }
        return xmlResponseParser;
    }

    private FMPCursor adjustCursorPosition() {
        FMPCursor originalCursorPosition = null;
        EditorView editorView = this.getEditorView();
        originalCursorPosition = editorView == null ? new FMPCursor(0, SEARCH_ALL_LINES, 1, 0) : editorView.getCursor();
        if (originalCursorPosition.getRecordNumber() < 0) {
            originalCursorPosition.setRecordNumber(1);
        }
        FMPCursor adjustedCursorPosition = new FMPCursor(originalCursorPosition.getRecordNumber(), originalCursorPosition.getFieldName(), originalCursorPosition.getFieldPosition(), originalCursorPosition.getCursorOffset() + 1, originalCursorPosition.getFieldId());
        if (this.getEditorView() != null) {
            this.getEditorView().getCursor().setField(this.fieldBtn.getSelection());
        }
        if (this.occurrence == OCCURRENCE_NEXT && this.isFindCmdByFindCmd && !this.isFindQueryChanged && !originalCursorPosition.isManuallyChanged()) {
            int originalCursorOffset = adjustedCursorPosition.getCursorOffset();
            if (originalCursorPosition.isCursorInHexField()) {
                adjustedCursorPosition.setCursorOffset(originalCursorOffset + 2);
            } else {
                adjustedCursorPosition.setCursorOffset(originalCursorOffset + 1);
            }
        } else if (this.occurrence == OCCURRENCE_PREVIOUS && this.isFindCmdByFindCmd && !this.isFindQueryChanged && !originalCursorPosition.isManuallyChanged()) {
            int originalCursorOffset = adjustedCursorPosition.getCursorOffset();
            int newCursorOffset = originalCursorOffset - 1;
            if (newCursorOffset < 0) {
                newCursorOffset = 0;
            }
            adjustedCursorPosition.setCursorOffset(newCursorOffset);
        }
        return adjustedCursorPosition;
    }

    private String adjustChangeString() {
        String adjustedChangeString = this.changeValue;
        adjustedChangeString = this.changeType.equals(FIND_TYPE[0]) ? "T'" + this.changeValue + "'" : (this.changeType.equals(FIND_TYPE[1]) ? "C'" + this.changeValue + "'" : (this.changeType.equals(FIND_TYPE[2]) ? "X'" + this.changeValue + "'" : (this.txtChangeLength.getText().length() > 0 ? "PL" + this.txtChangeLength.getText() + "'" + this.changeValue + "'" : "P'" + this.changeValue + "'")));
        return adjustedChangeString;
    }

    private String adjustFindString() {
        String adjustedFindString = this.findValue;
        adjustedFindString = this.findType.equals(FIND_TYPE[0]) ? "T'" + this.findValue + "'" : (this.findType.equals(FIND_TYPE[1]) ? "C'" + this.findValue + "'" : (this.findType.equals(FIND_TYPE[2]) ? "X'" + this.findValue + "'" : (this.findValue.isEmpty() && this.txtFindLength.getText().length() > 0 ? "PL" + this.txtFindLength.getText() : (!this.findValue.isEmpty() && this.txtFindLength.getText().length() > 0 ? "PL" + this.txtFindLength.getText() + "'" + this.findValue + "'" : "P'" + this.findValue + "'"))));
        return adjustedFindString;
    }

    private int byteCalculator(int index, String targetString) {
        int length = 0;
        if (index == 0) {
            length = targetString.length();
        } else if (index == 1) {
            length = targetString.length();
        } else if (index == 2) {
            length = targetString.length() / 2;
        } else if (index == 3) {
            int quotient;
            if (targetString.contains("+") || targetString.contains("-")) {
                quotient = targetString.length() % 2;
                length = targetString.length() / 2;
            } else {
                quotient = (targetString.length() + 1) % 2;
                length = (targetString.length() + 1) / 2;
            }
            if (quotient != 0) {
                ++length;
            }
        }
        return length;
    }

    private void controlModifiedFindChangeGroup() {
        this.showDialogWhenFindIsShorterThenChangeLength = true;
        EditChangeConfirmationDialog.chgConfirmDialogVisited = false;
    }

    private void controlModifiedAny() {
        this.isFindLIMExceedLimitation = false;
        this.determineIfFindButtonsShouldBeEnabledOrDisabled();
        this.determineIfChangeButtonsShouldBeEnabledOrDisabled();
        this.determineIfThereAreErrorsWithTheQuery();
    }

    private void determineIfThereAreErrorsWithTheQuery() {
        String errorMessage;
        int end;
        int start;
        String errorMessage2;
        this.setErrorMessage(null);
        if (this.cmbFindType.getSelectionIndex() == 3) {
            if (this.findLength > 16) {
                this.disableSubmissionButtonsBecauseOfErrorInQuery("Find Length cannot be more than 16");
                return;
            }
            if (this.changeLength > 16) {
                this.disableSubmissionButtonsBecauseOfErrorInQuery("Change Length cannot be more than 16");
                return;
            }
        }
        if (this.txtFindString.getText().isEmpty() && this.cmbFindType.getSelectionIndex() == 3 && this.txtFindLength.getText().trim().isEmpty()) {
            this.disableSubmissionButtonsBecauseOfErrorInQuery("Specify Find value or Length value in packed decimal type.");
            return;
        }
        if (!this.txtFindString.getText().isEmpty()) {
            if (this.cmbFindType.getSelectionIndex() == 2) {
                errorMessage2 = Validator.errorMsg[Validator.HexadecimalLength((String)this.txtFindString.getText(), (boolean)false)];
                if (errorMessage2 != null && errorMessage2.length() > 0) {
                    this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage2);
                    return;
                }
            } else if (this.cmbFindType.getSelectionIndex() == 3 && (errorMessage2 = Validator.errorMsg[Validator.PackedDecimalLength((String)this.txtFindString.getText(), (boolean)false)]) != null && errorMessage2.length() > 0) {
                this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage2);
                return;
            }
            if (this.txtFindLength.isEnabled() && !this.txtFindLength.getText().isEmpty()) {
                try {
                    this.findLength = Integer.parseInt(this.txtFindLength.getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.findValueLength = this.byteCalculator(this.cmbFindType.getSelectionIndex(), this.txtFindString.getText());
            }
        }
        if (!this.changeValue.isEmpty()) {
            if (this.changeType.equals(FIND_TYPE[2])) {
                errorMessage2 = Validator.errorMsg[Validator.HexadecimalLength((String)this.changeValue, (boolean)false)];
                if (errorMessage2 != null && errorMessage2.length() > 0) {
                    this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage2);
                    return;
                }
            } else if (this.changeType.equals(FIND_TYPE[3]) && (errorMessage2 = Validator.errorMsg[Validator.PackedDecimalLength((String)this.changeValue, (boolean)false)]) != null && errorMessage2.length() > 0) {
                this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage2);
                return;
            }
            if (this.txtChangeLength.isEnabled() && !this.txtChangeLength.getText().isEmpty()) {
                try {
                    this.changeLength = Integer.parseInt(this.txtChangeLength.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.log(Level.WARNING, "number format exception");
                }
            } else {
                this.changeValueLength = this.byteCalculator(this.cmbChangeType.getSelectionIndex(), this.txtChange.getText());
            }
        }
        if (this.txtFindString.getText().isEmpty() && (!this.txtFindLength.isEnabled() || this.txtFindLength.getText().trim().length() <= 0 || Validator.length((String)this.txtFindLength.getText(), (boolean)false) != 0)) {
            this.disableSubmissionButtonsBecauseOfErrorInQuery(null);
            return;
        }
        if (!this.columnRangeStart.isEmpty() && !this.columnRangeEnd.isEmpty() && (start = Integer.parseInt(this.columnRangeStart)) > (end = Integer.parseInt(this.columnRangeEnd))) {
            this.disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_START_COLUMN_GREATER_THEN_END_COLUMN);
            return;
        }
        if (this.columnRangeStart.isEmpty() && !this.columnRangeEnd.isEmpty()) {
            this.disableSubmissionButtonsBecauseOfErrorInQuery(ERROR_MISSING_START_COLUMN_VALUE);
            return;
        }
        if (this.txtFindLength.isEnabled() && !this.txtFindLength.getText().isEmpty() && (errorMessage = Validator.errorMsg[Validator.length((String)this.txtFindLength.getText(), (boolean)false)]) != null && errorMessage.length() > 0) {
            this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
            return;
        }
        if (this.txtChangeLength.isEnabled() && !this.txtChangeLength.getText().isEmpty() && (errorMessage = Validator.errorMsg[Validator.length((String)this.txtChangeLength.getText(), (boolean)false)]) != null && errorMessage.length() > 0) {
            this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage);
            return;
        }
        String displayMode = this.getDisplayModeOfActiveView();
        if (displayMode == null) {
            this.log.log(Level.WARNING, "displayMode is null");
            return;
        }
        if (displayMode.equals("C") && this.location.equals(LOCATION_FIELD)) {
            String errorMessage3 = "Find Field is only valid in formatted mode";
            this.disableSubmissionButtonsBecauseOfErrorInQuery(errorMessage3);
            return;
        }
    }

    private void disableSubmissionButtonsBecauseOfErrorInQuery(String errorMessage) {
        if (errorMessage != null && errorMessage.length() > 0) {
            this.setErrorMessage(errorMessage);
            this.findBtn.setEnabled(false);
            this.findAllBtn.setEnabled(false);
            this.changeBtn.setEnabled(false);
            this.changeAllBtn.setEnabled(false);
        } else {
            this.setErrorMessage(null);
        }
    }

    private void determineIfFindButtonsShouldBeEnabledOrDisabled() {
        if (this.findType.equals(FIND_TYPE[3]) && (this.findValue.isEmpty() || this.findValue == null) && this.txtFindLength.getText().isEmpty()) {
            this.findBtn.setEnabled(false);
            this.findAllBtn.setEnabled(false);
            return;
        }
        if (this.findValue == null || this.findValue.length() == 0 && !this.findType.equals(FIND_TYPE[3])) {
            this.findBtn.setEnabled(false);
            this.findAllBtn.setEnabled(false);
            return;
        }
        this.findBtn.setEnabled(true);
        this.findAllBtn.setEnabled(true);
    }

    private void determineIfChangeButtonsShouldBeEnabledOrDisabled() {
        if (this.findValue != null && this.findValue.length() > 0 && this.changeValue != null && this.changeValue.length() > 0 && !this.fieldBtn.getSelection()) {
            this.changeBtn.setEnabled(true);
            this.changeAllBtn.setEnabled(true);
            return;
        }
        this.changeBtn.setEnabled(false);
        this.changeAllBtn.setEnabled(false);
    }

    private String getDisplayModeOfActiveView() {
        EditorView editorView;
        String displayMode = null;
        IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (!(workbenchPart instanceof EditorView)) {
            this.log.log(Level.WARNING, "workbenchPart is not instance of EditorView");
            editorView = this.lastEditorView;
        } else {
            this.lastEditorView = editorView = (EditorView)workbenchPart;
        }
        String secondaryId = ((IViewSite)editorView.getSite()).getSecondaryId();
        displayMode = editorView.getCurrentSession(secondaryId).getDisplayMode();
        return displayMode;
    }

    private String getHexModeOfActiveView() {
        EditorView editorView;
        String hexMode = null;
        IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (!(workbenchPart instanceof EditorView)) {
            this.log.log(Level.WARNING, "workbenchPart is not instance of EditorView");
            editorView = this.lastEditorView;
        } else {
            this.lastEditorView = editorView = (EditorView)workbenchPart;
        }
        String secondaryId = ((IViewSite)editorView.getSite()).getSecondaryId();
        hexMode = editorView.getCurrentSession(secondaryId).getHexMode();
        return hexMode;
    }

    private void actionsWhenClickingOnAnyOfTheSubmissionButtons() {
        FMHistory.insertHistory((Combo)this.txtFindString, (String)"excludeExcString");
        FMHistory.insertHistory((Combo)this.txtChange, (String)"changeWithString");
        FMHistory.insertHistory((Combo)this.txtstartCol, (String)"excludestartCol");
        FMHistory.insertHistory((Combo)this.txtendCol, (String)"excludeendCol");
        this.txtFindString.removeModifyListener(this.mLTxtFind);
        String text = this.txtFindString.getText();
        FMHistory.intializeComboBoxes((Combo)this.txtFindString, (String)"excludeExcString");
        this.txtFindString.setText(text);
        this.txtFindString.addModifyListener(this.mLTxtFind);
        this.txtChange.removeModifyListener(this.modLisTxtChange);
        text = this.txtChange.getText();
        FMHistory.intializeComboBoxes((Combo)this.txtChange, (String)"changeWithString");
        this.txtChange.setText(text);
        this.txtChange.addModifyListener(this.modLisTxtChange);
        this.txtstartCol.removeModifyListener(this.modLisTxtstartCol);
        text = this.txtstartCol.getText();
        FMHistory.intializeComboBoxes((Combo)this.txtstartCol, (String)"excludestartCol");
        this.txtstartCol.setText(text);
        this.txtstartCol.addModifyListener(this.modLisTxtstartCol);
        this.txtendCol.removeModifyListener(this.modLisTxtendCol);
        text = this.txtendCol.getText();
        FMHistory.intializeComboBoxes((Combo)this.txtendCol, (String)"excludeendCol");
        this.txtendCol.setText(text);
        this.txtendCol.addModifyListener(this.modLisTxtendCol);
    }

    private boolean actionsWhenClickingOnAnyOfTheChangeButtons() {
        return this.checkLengthOfFindAndChangeText();
    }

    private boolean checkLengthOfFindAndChangeText() {
        String dialogTitle = "Edit Change Confirmation";
        String dialogMessage = SEARCH_ALL_LINES;
        int result = 0;
        if (this.cmbFindType.getSelectionIndex() == 3 && this.txtFindLength.getText().length() > 0) {
            this.findValueLength = Integer.parseInt(this.txtFindLength.getText());
        }
        if (this.cmbChangeType.getSelectionIndex() == 3 && this.txtChangeLength.getText().length() > 0) {
            this.changeValueLength = Integer.parseInt(this.txtChangeLength.getText());
        }
        if (this.findValueLength > this.changeValueLength) {
            if (!EditChangeConfirmationDialog.chgConfirmDialogVisited) {
                String lengthOfbytes = SEARCH_ALL_LINES;
                lengthOfbytes = this.findValueLength - this.changeValueLength == 1 ? " byte" : " bytes";
                dialogMessage = "The \u201cChange to\u201d string is " + (this.findValueLength - this.changeValueLength) + lengthOfbytes + " shorter than the \u201cFind\u201d string.\n Bytes to the right of the \u201cFind\u201d string will be shifted left,\n and " + (this.findValueLength - this.changeValueLength) + " fill pad characters will be added to the end of the bounded area.";
                EditChangeConfirmationDialog dialog = new EditChangeConfirmationDialog(new Shell(), dialogMessage.trim());
                int Result = dialog.open();
                if (Result == 0) {
                    this.padCharacter = EditChangeConfirmationDialog.pad;
                } else if (Result == 1) {
                    return false;
                }
            }
        } else if (this.findValueLength < this.changeValueLength) {
            String lengthOfbytes = SEARCH_ALL_LINES;
            lengthOfbytes = this.changeValueLength - this.findValueLength == 1 ? " byte" : " bytes";
            if (this.showDialogWhenFindIsShorterThenChangeLength) {
                this.showDialogWhenFindIsShorterThenChangeLength = false;
                dialogMessage = "The \u201cChange to\u201d string is " + (this.changeValueLength - this.findValueLength) + lengthOfbytes + " longer than the \u201cFind\u201d string. Data to the right of the \u201cChange to\u201d string will be shifted right, and excess characters at the end of the bounded area will be truncated.";
                MessageDialog warningDialog = new MessageDialog(null, dialogTitle, null, dialogMessage, 4, new String[]{"OK", "Cancel"}, 0);
                result = warningDialog.open();
                if (result == 1) {
                    return false;
                }
            }
        }
        return true;
    }

    private EditorView getEditorView() {
        EditorView editorView;
        IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (!(workbenchPart instanceof EditorView)) {
            this.log.log(Level.WARNING, "workbenchPart is not instance of EditorView");
            this.totalMatch.setText("Click on the editor to perform the Find/Change action.");
            editorView = null;
        } else {
            this.lastEditorView = editorView = (EditorView)workbenchPart;
        }
        return editorView;
    }
}

