/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.ui.verifyDigit;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocateDialog
extends TitleAreaDialog
implements ModifyListener,
SelectionListener {
    protected static final String LINE_NUMBER_ERROR_MESSAGE = "Please insert a line number";
    protected static final String LABEL_ERROR_MESSAGE = "Please insert a label";
    protected static final String KEY_VALUE_ERROR_MESSAGE = "Please insert a key value";
    protected static final String KEYWORD_ERROR_MESSAGE = "Please choose a keyword";
    private Text lineNumberText;
    private Text labelText;
    private Text keyValueText;
    private Button okButton;
    private FileMasterServer server;
    private String uuid;
    private String displayMode;
    private String hexMode;
    private String errorMessage;
    private Text text;
    private Button radioButton;
    private Button lineNumberRadioButton;
    private Button labelRadioButton;
    private Button keyValueRadioButton;
    private Button keywordRadioButton;
    private Group keywordsGroup;
    private Composite composite;
    private Group optionsGroup;

    public LocateDialog(Shell parentShell, FileMasterServer server, String uuid, String displayMode, String hexMode) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.server = server;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Locate");
        this.setMessage("");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gd_container = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_container.widthHint = 332;
        container.setLayoutData((Object)gd_container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.composite = new Composite(container, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.lineNumberRadioButton = new Button(this.composite, 16);
        this.lineNumberRadioButton.setText("&Line number");
        this.lineNumberRadioButton.addSelectionListener((SelectionListener)this);
        this.lineNumberText = new Text(this.composite, 2048);
        this.lineNumberText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lineNumberText.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.lineNumberText.addModifyListener((ModifyListener)this);
        this.labelRadioButton = new Button(this.composite, 16);
        this.labelRadioButton.setText("L&abel");
        this.labelRadioButton.addSelectionListener((SelectionListener)this);
        this.labelText = new Text(this.composite, 2048);
        this.labelText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.labelText.addModifyListener((ModifyListener)this);
        this.keyValueRadioButton = new Button(this.composite, 16);
        this.keyValueRadioButton.setText("Key &value");
        this.keyValueRadioButton.addSelectionListener((SelectionListener)this);
        this.keyValueText = new Text(this.composite, 2048);
        this.keyValueText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.keyValueText.addModifyListener((ModifyListener)this);
        this.keywordRadioButton = new Button(this.composite, 16);
        this.keywordRadioButton.setText("&Keyword ");
        new Label(this.composite, 0);
        this.keywordRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LocateDialog.this.keywordRadioButton.getSelection()) {
                    LocateDialog.this.lineNumberText.setEnabled(false);
                    LocateDialog.this.labelText.setEnabled(false);
                    LocateDialog.this.keyValueText.setEnabled(false);
                    boolean keywordSelected = false;
                    int x = 0;
                    while (x < LocateDialog.this.keywordsGroup.getChildren().length) {
                        LocateDialog.this.keywordsGroup.getChildren()[x].setEnabled(true);
                        if (!keywordSelected && ((Button)LocateDialog.this.keywordsGroup.getChildren()[x]).getSelection()) {
                            LocateDialog.this.setErrorMessage(null);
                            keywordSelected = true;
                        }
                        ++x;
                    }
                    x = 0;
                    while (x < LocateDialog.this.optionsGroup.getChildren().length) {
                        LocateDialog.this.optionsGroup.getChildren()[x].setEnabled(true);
                        ++x;
                    }
                } else {
                    int x = 0;
                    while (x < LocateDialog.this.keywordsGroup.getChildren().length) {
                        LocateDialog.this.keywordsGroup.getChildren()[x].setEnabled(false);
                        ++x;
                    }
                    x = 0;
                    while (x < LocateDialog.this.optionsGroup.getChildren().length) {
                        LocateDialog.this.optionsGroup.getChildren()[x].setEnabled(false);
                        ++x;
                    }
                }
            }
        });
        this.keywordsGroup = new Group(container, 0);
        GridLayout keywordsGroupLayout = new GridLayout(3, true);
        keywordsGroupLayout.horizontalSpacing = 50;
        this.keywordsGroup.setLayout((Layout)keywordsGroupLayout);
        this.keywordsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keywordsGroup.setText("Keywords");
        Button changeCheckButton = new Button((Composite)this.keywordsGroup, 32);
        changeCheckButton.setText("&Change");
        changeCheckButton.addSelectionListener((SelectionListener)this);
        Button duplicateCheckButton = new Button((Composite)this.keywordsGroup, 32);
        duplicateCheckButton.setText("&Duplicate");
        duplicateCheckButton.addSelectionListener((SelectionListener)this);
        Button labelCheckButton = new Button((Composite)this.keywordsGroup, 32);
        labelCheckButton.setText("La&bel");
        labelCheckButton.addSelectionListener((SelectionListener)this);
        Button commandCheckButton = new Button((Composite)this.keywordsGroup, 32);
        commandCheckButton.setText("C&ommand");
        commandCheckButton.addSelectionListener((SelectionListener)this);
        Button sequenceCheckButton = new Button((Composite)this.keywordsGroup, 32);
        sequenceCheckButton.setText("&Sequence");
        sequenceCheckButton.addSelectionListener((SelectionListener)this);
        Button errorCheckButton = new Button((Composite)this.keywordsGroup, 32);
        errorCheckButton.setText("&Error ");
        errorCheckButton.addSelectionListener((SelectionListener)this);
        this.optionsGroup = new Group(container, 0);
        this.optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.optionsGroup.setText("Options");
        GridLayout optionsGroupLayout = new GridLayout(4, true);
        optionsGroupLayout.horizontalSpacing = 15;
        this.optionsGroup.setLayout((Layout)optionsGroupLayout);
        Button firstRadioButton = new Button((Composite)this.optionsGroup, 16);
        firstRadioButton.setText("&First");
        Button lastRadioButton = new Button((Composite)this.optionsGroup, 16);
        lastRadioButton.setText("Las&t");
        Button nextRadioButton = new Button((Composite)this.optionsGroup, 16);
        nextRadioButton.setText("&Next");
        nextRadioButton.setSelection(true);
        Button previousRadioButton = new Button((Composite)this.optionsGroup, 16);
        previousRadioButton.setText("&Previous");
        int x = 0;
        while (x < this.keywordsGroup.getChildren().length) {
            this.keywordsGroup.getChildren()[x].setEnabled(false);
            ++x;
        }
        x = 0;
        while (x < this.optionsGroup.getChildren().length) {
            this.optionsGroup.getChildren()[x].setEnabled(false);
            ++x;
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(334, 394);
    }

    protected void okPressed() {
        this.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Locate");
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    private void setVariables() {
        if (this.lineNumberRadioButton.getSelection()) {
            this.errorMessage = LINE_NUMBER_ERROR_MESSAGE;
            this.text = this.lineNumberText;
            this.radioButton = this.lineNumberRadioButton;
        } else if (this.labelRadioButton.getSelection()) {
            this.errorMessage = LABEL_ERROR_MESSAGE;
            this.text = this.labelText;
            this.radioButton = this.labelRadioButton;
        } else if (this.keyValueRadioButton.getSelection()) {
            this.errorMessage = KEY_VALUE_ERROR_MESSAGE;
            this.text = this.keyValueText;
            this.radioButton = this.keyValueRadioButton;
        } else if (this.keywordRadioButton.getSelection()) {
            this.errorMessage = KEYWORD_ERROR_MESSAGE;
            this.radioButton = this.keywordRadioButton;
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setVariables();
        if (this.text.getText().isEmpty()) {
            this.setErrorMessage(this.errorMessage);
            this.okButton.setEnabled(false);
        } else {
            this.setErrorMessage(null);
            this.okButton.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.getStyle() - 0x2004000 == 32) {
            boolean keywordSelected = false;
            int x = 0;
            while (x < this.keywordsGroup.getChildren().length) {
                this.keywordsGroup.getChildren()[x].setEnabled(true);
                if (!keywordSelected && ((Button)this.keywordsGroup.getChildren()[x]).getSelection()) {
                    this.setErrorMessage(null);
                    keywordSelected = true;
                } else if (!keywordSelected) {
                    this.setErrorMessage(KEYWORD_ERROR_MESSAGE);
                }
                ++x;
            }
        } else {
            int count = 0;
            while (count < this.composite.getChildren().length) {
                if (this.composite.getChildren()[count] instanceof Text) {
                    this.composite.getChildren()[count].setEnabled(false);
                }
                ++count;
            }
            this.setVariables();
            if (this.radioButton.getSelection()) {
                this.text.setEnabled(true);
                this.text.setFocus();
                if (this.text.getText().isEmpty()) {
                    this.setErrorMessage(this.errorMessage);
                } else {
                    this.setErrorMessage(null);
                }
            }
        }
        if (this.getErrorMessage() == null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

