/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMPCursor;
import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.common.XMLResponseParser;
import com.ca.filemaster.editor.pricommands.wizards.EditChangeConfirmationDialog;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordFormatMode;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import com.ca.filemaster.runners.RunGetFindExclude;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.verifyDigit;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FindChangePrimaryCommandWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener,
KeyListener {
    private CharFormatMode charFormatMode;
    private MultiRecordFormatMode multiRecFormatMode;
    protected Composite container;
    private Composite parentComposite;
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.find";
    private Label findLim;
    private Label startCol;
    private Label endCol;
    private Label totalMatch;
    protected Combo txtFindString;
    protected Spinner txtFindLim;
    protected Combo txtstartCol;
    protected Combo txtendCol;
    protected Combo txtChange;
    private Button nextBtn;
    private Button prevBtn;
    private Button firstBtn;
    private Button lastBtn;
    private Button charBtn;
    private Button wordBtn;
    private Button prefixBtn;
    private Button suffixBtn;
    private Button fieldBtn;
    protected String hexMode;
    private Button srchAllBtn;
    private Button excludedBtn;
    private Button nonExcludedBtn;
    private Composite btnComposite;
    private Button findBtn;
    private Button findAllBtn;
    private Button changeBtn;
    private Button changeAllBtn;
    private Combo cmbFindType;
    private Combo cmbChangeType;
    private Text txtFindLength;
    private Text txtChangeLength;
    private int findlimit;
    private FMPCursor fmpCursor;
    private String typeofCommand;
    private String padCharacter;
    private boolean findAgain;
    private boolean unevenString = false;
    private int findLenght;
    private int changeLenght;
    private static boolean modified = true;
    private int highlightLineNumber = -1;
    private int highlightRangeIndex = -1;
    private int highlightRangeStart = -1;
    private int highlightRangeEnd = -1;
    Logger log = Logger.getLogger(FindChangePrimaryCommandWizardPage.class.getName());
    protected static String[] types = new String[]{"Character", "Case-sensitive", "Hexadecimal", "Packed decimal"};

    public FindChangePrimaryCommandWizardPage(String pageName, FileMasterServer server, String uuid, String displayMode, String hexMode, FMPCursor cursorRange) {
        super(pageName);
        this.setTitle("Find/Change");
        this.hexMode = hexMode;
        this.fmpCursor = cursorRange;
        this.log.log(Level.INFO, "uuid: " + uuid + " initial record number: " + cursorRange.getRecordNumber() + " cursorOffset: " + cursorRange.getCursorOffset());
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.parentComposite = new Composite(this.container, 0);
        GridLayout gl_parentComposite = new GridLayout(3, false);
        gl_parentComposite.marginWidth = 0;
        this.parentComposite.setLayout((Layout)gl_parentComposite);
        this.parentComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblFind = new Label(this.parentComposite, 0);
        lblFind.setText("F&ind:");
        Label lblFindType = new Label(this.parentComposite, 0);
        lblFindType.setText("T&ype:");
        Label lblLength = new Label(this.parentComposite, 0);
        lblLength.setText("&Length:");
        this.txtFindString = new Combo(this.parentComposite, 2048);
        this.txtFindString.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFindString.addModifyListener((ModifyListener)this);
        this.txtFindString.addKeyListener((KeyListener)this);
        this.cmbFindType = new Combo(this.parentComposite, 8);
        this.cmbFindType.setItems(types);
        this.cmbFindType.setText(types[0]);
        this.cmbFindType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindChangePrimaryCommandWizardPage.this.cmbFindType.getSelectionIndex() == 3) {
                    FindChangePrimaryCommandWizardPage.this.txtFindLength.setEnabled(true);
                } else {
                    FindChangePrimaryCommandWizardPage.this.txtFindLength.setEnabled(false);
                }
                FindChangePrimaryCommandWizardPage.setModified(true);
                FindChangePrimaryCommandWizardPage.this.isPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbFindType.addKeyListener((KeyListener)this);
        this.txtFindLength = new Text(this.parentComposite, 2048);
        this.txtFindLength.setEnabled(false);
        this.txtFindLength.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtFindLength.addModifyListener((ModifyListener)this);
        this.txtFindLength.addKeyListener((KeyListener)this);
        Label lblChange = new Label(this.parentComposite, 0);
        lblChange.setText("C&hange to:");
        Label lblChangeType = new Label(this.parentComposite, 0);
        lblChangeType.setText("Ty&pe:");
        Label lblChangeLength = new Label(this.parentComposite, 0);
        lblChangeLength.setText("Le&ngth:");
        this.txtChange = new Combo(this.parentComposite, 2048);
        this.txtChange.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtChange.addModifyListener((ModifyListener)this);
        this.txtChange.addKeyListener((KeyListener)this);
        this.cmbChangeType = new Combo(this.parentComposite, 8);
        this.cmbChangeType.setItems(types);
        this.cmbChangeType.setText(types[0]);
        this.cmbChangeType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindChangePrimaryCommandWizardPage.this.cmbChangeType.getSelectionIndex() == 3) {
                    FindChangePrimaryCommandWizardPage.this.txtChangeLength.setEnabled(true);
                } else {
                    FindChangePrimaryCommandWizardPage.this.txtChangeLength.setEnabled(false);
                }
                FindChangePrimaryCommandWizardPage.setModified(true);
                FindChangePrimaryCommandWizardPage.this.isPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbChangeType.addKeyListener((KeyListener)this);
        this.txtChangeLength = new Text(this.parentComposite, 2048);
        this.txtChangeLength.setEnabled(false);
        this.txtChangeLength.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtChangeLength.addModifyListener((ModifyListener)this);
        this.txtChangeLength.addKeyListener((KeyListener)this);
        Composite composite = new Composite(this.container, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Group colRange = new Group(composite, 0);
        colRange.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        colRange.setLayout((Layout)new GridLayout(3, false));
        colRange.setText("Column range");
        this.startCol = new Label((Composite)colRange, 0);
        this.startCol.setText("&Start:");
        this.txtstartCol = new Combo((Composite)colRange, 2048);
        this.txtstartCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtstartCol.addModifyListener((ModifyListener)this);
        this.txtstartCol.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtstartCol.addKeyListener((KeyListener)this);
        this.endCol = new Label((Composite)colRange, 0);
        this.endCol.setText("&End:");
        this.txtendCol = new Combo((Composite)colRange, 2048);
        this.txtendCol.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtendCol.addModifyListener((ModifyListener)this);
        this.txtendCol.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.txtendCol.addKeyListener((KeyListener)this);
        Group occurenceGrp = new Group(this.container, 0);
        occurenceGrp.setLayout((Layout)new GridLayout(5, false));
        occurenceGrp.setSize(occurenceGrp.computeSize(-1, -1));
        occurenceGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        occurenceGrp.setText("Occurrences");
        this.setControl((Control)this.container);
        this.nextBtn = new Button((Composite)occurenceGrp, 16);
        this.nextBtn.setText("&Next");
        this.nextBtn.setSelection(true);
        this.nextBtn.addKeyListener((KeyListener)this);
        this.prevBtn = new Button((Composite)occurenceGrp, 16);
        this.prevBtn.setText("Pre&vious");
        this.prevBtn.addKeyListener((KeyListener)this);
        this.firstBtn = new Button((Composite)occurenceGrp, 16);
        this.firstBtn.setText("Firs&t");
        this.firstBtn.addSelectionListener((SelectionListener)this);
        this.firstBtn.addKeyListener((KeyListener)this);
        this.lastBtn = new Button((Composite)occurenceGrp, 16);
        this.lastBtn.setText("&Last");
        this.lastBtn.addSelectionListener((SelectionListener)this);
        this.lastBtn.addKeyListener((KeyListener)this);
        Group locatnGrp = new Group(this.container, 0);
        locatnGrp.setLayout((Layout)new GridLayout(5, false));
        locatnGrp.setSize(locatnGrp.computeSize(-1, -1));
        locatnGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        locatnGrp.setText("Location");
        this.charBtn = new Button((Composite)locatnGrp, 16);
        this.charBtn.setText("Characte&r");
        this.charBtn.setSelection(true);
        this.charBtn.addSelectionListener((SelectionListener)this);
        this.charBtn.addKeyListener((KeyListener)this);
        this.wordBtn = new Button((Composite)locatnGrp, 16);
        this.wordBtn.setText("&Word");
        this.wordBtn.addSelectionListener((SelectionListener)this);
        this.wordBtn.addKeyListener((KeyListener)this);
        this.prefixBtn = new Button((Composite)locatnGrp, 16);
        this.prefixBtn.setText("Prefi&x");
        this.prefixBtn.addSelectionListener((SelectionListener)this);
        this.prefixBtn.addKeyListener((KeyListener)this);
        this.suffixBtn = new Button((Composite)locatnGrp, 16);
        this.suffixBtn.setText("S&uffix");
        this.suffixBtn.addSelectionListener((SelectionListener)this);
        this.suffixBtn.addKeyListener((KeyListener)this);
        this.fieldBtn = new Button((Composite)locatnGrp, 16);
        this.fieldBtn.setText("Fi&eld");
        this.fieldBtn.addSelectionListener((SelectionListener)this);
        this.fieldBtn.addKeyListener((KeyListener)this);
        Group searchGrp = new Group(this.container, 0);
        searchGrp.setLayout((Layout)new GridLayout(3, false));
        searchGrp.setSize(searchGrp.computeSize(-1, -1));
        searchGrp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        searchGrp.setText("Search");
        this.srchAllBtn = new Button((Composite)searchGrp, 16);
        this.srchAllBtn.setText("All l&ines");
        this.srchAllBtn.setSelection(true);
        this.srchAllBtn.addSelectionListener((SelectionListener)this);
        this.srchAllBtn.addKeyListener((KeyListener)this);
        this.excludedBtn = new Button((Composite)searchGrp, 16);
        this.excludedBtn.setText("E&xcluded");
        this.excludedBtn.addSelectionListener((SelectionListener)this);
        this.excludedBtn.addKeyListener((KeyListener)this);
        this.nonExcludedBtn = new Button((Composite)searchGrp, 16);
        this.nonExcludedBtn.setText("N&onexcluded lines");
        this.nonExcludedBtn.addSelectionListener((SelectionListener)this);
        this.nonExcludedBtn.addKeyListener((KeyListener)this);
        this.findLim = new Label((Composite)searchGrp, 0);
        this.findLim.setText("Find li&mit:");
        this.txtFindLim = new Spinner((Composite)searchGrp, 2048);
        this.txtFindLim.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtFindLim.setMinimum(0);
        this.txtFindLim.setMaximum(99999999);
        this.txtFindLim.getSelection();
        this.txtFindLim.addModifyListener((ModifyListener)this);
        this.txtFindLim.addKeyListener((KeyListener)this);
        this.btnComposite = new Composite(this.container, 0);
        GridLayout gl_btnComposite = new GridLayout(4, false);
        gl_btnComposite.marginWidth = 0;
        this.btnComposite.setLayout((Layout)gl_btnComposite);
        this.btnComposite.setLayoutData((Object)new GridData(131072, 1024, false, true, 1, 1));
        this.initializeDialogUnits((Control)parent);
        this.findBtn = new Button(this.btnComposite, 0);
        this.findBtn.addSelectionListener((SelectionListener)this);
        this.findBtn.setText("&Find");
        this.setButtonLayoutData(this.findBtn);
        this.findAllBtn = new Button(this.btnComposite, 0);
        this.findAllBtn.addSelectionListener((SelectionListener)this);
        this.findAllBtn.setText("Find &All");
        this.setButtonLayoutData(this.findAllBtn);
        this.changeBtn = new Button(this.btnComposite, 0);
        this.changeBtn.addSelectionListener((SelectionListener)this);
        this.changeBtn.setText("&Change");
        this.setButtonLayoutData(this.changeBtn);
        this.changeAllBtn = new Button(this.btnComposite, 0);
        this.changeAllBtn.addSelectionListener((SelectionListener)this);
        this.changeAllBtn.setText("Chan&ge All");
        this.setButtonLayoutData(this.changeAllBtn);
        this.totalMatch = new Label(this.btnComposite, 0);
        this.totalMatch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.totalMatch.setText("  ");
        CharFormatMode.totalMatch = "";
        SingleRecordFormatMode.totalMatch = "";
        MultiRecordFormatMode.totalMatch = "";
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setEnabled(false);
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(16).setVisible(false);
        ((TestingToolsWizardDialog)this.getWizard().getContainer()).getButton(1).setText("Close");
        FMHistory.intializeComboBoxes((Combo)this.txtFindString, (String)"excludeExcString");
        FMHistory.intializeComboBoxes((Combo)this.txtChange, (String)"changeWithString");
        FMHistory.intializeComboBoxes((Combo)this.txtstartCol, (String)"excludestartCol");
        FMHistory.intializeComboBoxes((Combo)this.txtendCol, (String)"excludeendCol");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        EditorView view = (EditorView)page.getActivePart();
        this.txtFindLim.setSelection(Integer.valueOf(view.getProfile().getFindlim()).intValue());
        this.txtFindString.setFocus();
        Point size = this.getShell().computeSize(400, 610);
        this.getShell().setSize(size);
        this.setControl((Control)this.container);
    }

    private String getExcludeOption() {
        if (this.excludedBtn.getSelection()) {
            return "X";
        }
        if (this.nonExcludedBtn.getSelection()) {
            return "NX";
        }
        return "";
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.isPageComplete());
        FindChangePrimaryCommandWizardPage.setModified(true);
    }

    public boolean isPageComplete() {
        String error = "";
        boolean returnVal = true;
        this.unevenString = true;
        if (!CharFormatMode.totalMatch.trim().isEmpty()) {
            this.totalMatch.setText(CharFormatMode.totalMatch);
        } else if (!SingleRecordFormatMode.totalMatch.trim().isEmpty()) {
            this.totalMatch.setText(SingleRecordFormatMode.totalMatch);
        } else if (!MultiRecordFormatMode.totalMatch.trim().isEmpty()) {
            this.totalMatch.setText(MultiRecordFormatMode.totalMatch);
        }
        EditChangeConfirmationDialog.chgConfirmDialogVisited = false;
        if (!this.txtstartCol.getText().isEmpty() && !this.txtendCol.getText().isEmpty() && Integer.parseInt(this.txtstartCol.getText()) > Integer.parseInt(this.txtendCol.getText())) {
            error = "End column range should be greater than start column range.";
        }
        if (this.txtstartCol.getText().isEmpty() && !this.txtendCol.getText().isEmpty()) {
            error = "Missing start column value";
        }
        if (this.txtFindString.getText().isEmpty() && (!this.txtFindLength.isEnabled() || this.txtFindLength.getText().trim().length() <= 0 || Validator.length((String)this.txtFindLength.getText(), (boolean)false) != 0)) {
            returnVal = false;
        }
        if (!this.txtFindString.getText().isEmpty()) {
            if (this.cmbFindType.getSelectionIndex() == 2) {
                error = Validator.errorMsg[Validator.HexadecimalLength((String)this.txtFindString.getText(), (boolean)false)];
            } else if (this.cmbFindType.getSelectionIndex() == 3) {
                error = Validator.errorMsg[Validator.PackedDecimalLength((String)this.txtFindString.getText(), (boolean)false)];
            }
            if (this.txtFindLength.isEnabled() && !this.txtFindLength.getText().isEmpty()) {
                try {
                    this.findLenght = Integer.parseInt(this.txtFindLength.getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.findLenght = this.byteCalculator(this.cmbFindType.getSelectionIndex(), this.txtFindString.getText());
            }
        }
        if (!this.txtChange.getText().isEmpty()) {
            if (this.cmbChangeType.getSelectionIndex() == 2) {
                error = Validator.errorMsg[Validator.HexadecimalLength((String)this.txtChange.getText(), (boolean)false)];
            } else if (this.cmbChangeType.getSelectionIndex() == 3) {
                error = Validator.errorMsg[Validator.PackedDecimalLength((String)this.txtChange.getText(), (boolean)false)];
            }
            if (this.txtChangeLength.isEnabled() && !this.txtChangeLength.getText().isEmpty()) {
                try {
                    this.changeLenght = Integer.parseInt(this.txtChangeLength.getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.changeLenght = this.byteCalculator(this.cmbChangeType.getSelectionIndex(), this.txtChange.getText());
            }
        }
        if (this.txtFindLength.isEnabled() && !this.txtFindLength.getText().isEmpty()) {
            error = Validator.errorMsg[Validator.length((String)this.txtFindLength.getText(), (boolean)false)];
        }
        if (this.txtChangeLength.isEnabled() && !this.txtChangeLength.getText().isEmpty()) {
            error = Validator.errorMsg[Validator.length((String)this.txtChangeLength.getText(), (boolean)false)];
        }
        if (error.length() > 0) {
            this.setErrorMessage(error);
            returnVal = false;
        } else {
            this.setErrorMessage(null);
        }
        this.findBtn.setEnabled(returnVal);
        this.findAllBtn.setEnabled(returnVal);
        this.changeBtn.setEnabled(returnVal && !this.txtChange.getText().isEmpty() && !this.txtFindString.getText().isEmpty());
        this.changeAllBtn.setEnabled(returnVal && !this.txtChange.getText().isEmpty() && !this.txtFindString.getText().isEmpty());
        return returnVal;
    }

    protected String getOccurrence() {
        if (this.nextBtn.getSelection()) {
            return "NEXT";
        }
        if (this.prevBtn.getSelection()) {
            return "PREV";
        }
        if (this.firstBtn.getSelection()) {
            return "FIRST";
        }
        if (this.lastBtn.getSelection()) {
            return "LAST";
        }
        return "";
    }

    protected String getLocation() {
        if (this.charBtn.getSelection()) {
            return "CHAR";
        }
        if (this.wordBtn.getSelection()) {
            return "WORD";
        }
        if (this.prefixBtn.getSelection()) {
            return "PREFIX";
        }
        if (this.suffixBtn.getSelection()) {
            return "SUFFIX";
        }
        if (this.fieldBtn.getSelection()) {
            return "FIELD";
        }
        return "";
    }

    public boolean doFinish() {
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        String occurence;
        int newCursorOffset;
        FMPRange labelPair = new FMPRange("", "");
        FMPCursor cursor = this.getCursor();
        if (e.getSource().equals(this.firstBtn) || e.getSource().equals(this.lastBtn) || e.getSource().equals(this.charBtn) || e.getSource().equals(this.wordBtn) || e.getSource().equals(this.prefixBtn) || e.getSource().equals(this.suffixBtn) || e.getSource().equals(this.fieldBtn) || e.getSource().equals(this.srchAllBtn) || e.getSource().equals(this.excludedBtn) || e.getSource().equals(this.nonExcludedBtn)) {
            FindChangePrimaryCommandWizardPage.setModified(true);
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof EditorView)) {
            return;
        }
        EditorView view = (EditorView)page.getActivePart();
        this.charFormatMode = view.getCharMode();
        this.multiRecFormatMode = view.getMultiRecordFormatMode();
        if (e.getSource().equals(this.findBtn) || e.getSource().equals(this.findAllBtn) || e.getSource().equals(this.changeBtn) || e.getSource().equals(this.changeAllBtn)) {
            FMHistory.insertHistory((Combo)this.txtFindString, (String)"excludeExcString");
            FMHistory.insertHistory((Combo)this.txtChange, (String)"changeWithString");
            FMHistory.insertHistory((Combo)this.txtstartCol, (String)"excludestartCol");
            FMHistory.insertHistory((Combo)this.txtendCol, (String)"excludeendCol");
        }
        if (e.getSource().equals(this.findBtn) || e.getSource().equals(this.findAllBtn)) {
            this.unevenString = false;
            this.typeofCommand = "Find";
        } else {
            this.typeofCommand = "Change";
            view.setDirty(true);
            FindChangePrimaryCommandWizardPage.setModified(true);
        }
        this.findlimit = this.txtFindLim.getSelection();
        String findString = this.txtFindString.getText();
        this.log.log(Level.INFO, "findString: " + findString);
        String changeString = this.txtChange.getText();
        String displayMode = this.getDisplayModeOfActiveView();
        if (displayMode.equalsIgnoreCase("C")) {
            newCursorOffset = this.charFormatMode.getTableViewer().getTable().getSelectionIndex() != -1 ? cursor.getCursorOffset() : 0;
            cursor.setCursorOffset(newCursorOffset);
            this.setCursor(cursor);
            this.log.log(Level.INFO, "recordNumber:cursorOffset --> " + cursor.getRecordNumber() + ":" + newCursorOffset);
        } else if (displayMode.equalsIgnoreCase("M")) {
            cursor.setField(this.fieldBtn.getSelection());
            if (this.fieldBtn.getSelection()) {
                cursor.setRecordNumber(1);
            }
            if (this.findAgain) {
                newCursorOffset = this.getOccurrence().equalsIgnoreCase("PREV") ? this.getCursor().getCursorOffset() : this.txtFindString.getText().length() + this.getCursor().getCursorOffset();
                cursor.setCursorOffset(newCursorOffset);
            }
            this.setCursor(cursor);
            this.fmpCursor = this.getCursor();
        } else if (displayMode.equalsIgnoreCase("S")) {
            SingleRecordFormatMode.Fmpcursor.setField(this.fieldBtn.getSelection());
            if (this.findAgain) {
                newCursorOffset = this.txtFindString.getText().length() + SingleRecordFormatMode.Fmpcursor.getCursorOffset();
                SingleRecordFormatMode.Fmpcursor.setCursorOffset(newCursorOffset);
            }
            this.fmpCursor = SingleRecordFormatMode.Fmpcursor;
        }
        FMPRange colsRange = new FMPRange(this.txtstartCol.getText().trim(), this.txtendCol.getText().trim());
        if (e.getSource().equals(this.findAllBtn)) {
            cursor.setRecordNumber(1);
            this.setCursor(cursor);
            occurence = "ALL";
            this.charFormatMode.hiliteAllHits = true;
        } else if (e.getSource().equals(this.changeAllBtn)) {
            cursor.setRecordNumber(1);
            this.setCursor(cursor);
            occurence = "ALL";
            this.charFormatMode.hiliteAllHits = false;
        } else if (e.getSource().equals(this.changeBtn)) {
            occurence = this.getOccurrence();
            this.charFormatMode.hiliteAllHits = true;
        } else {
            occurence = this.getOccurrence();
            this.charFormatMode.hiliteAllHits = false;
        }
        String location = this.getLocation();
        String excludeOption = this.getExcludeOption();
        String dialogTitle = "Edit Change Confirmation";
        String dialogMessage = "";
        int result = 0;
        if (e.getSource().equals(this.changeBtn) || e.getSource().equals(this.changeAllBtn)) {
            if (this.findLenght > this.changeLenght && !EditChangeConfirmationDialog.chgConfirmDialogVisited) {
                this.unevenString = true;
                dialogMessage = "The \u201cChange to \u201d string is " + (this.findLenght - this.changeLenght) + " bytes shorter than the \u201cFind\u201d string.\n Bytes to the right of the \u201cFind\u201d string will be shifted left,\n and " + (this.findLenght - this.changeLenght) + " fill pad characters will be added to the end of the bounded area.";
                EditChangeConfirmationDialog dialog = new EditChangeConfirmationDialog(new Shell(), dialogMessage.trim());
                int Result = dialog.open();
                if (Result == 0) {
                    this.unevenString = false;
                    this.padCharacter = EditChangeConfirmationDialog.pad;
                } else if (Result == 1) {
                    this.unevenString = true;
                }
            } else if (this.findLenght < this.changeLenght && this.unevenString) {
                this.unevenString = true;
                dialogMessage = "The \u201cChange to \u201d string is " + (this.changeLenght - this.findLenght) + " bytes longer than the \u201cFind\u201d string. Data to the right of the \u201cChange to\u201d string will be shifted right, and excess characters at the end of the bounded area will be truncated.";
                MessageDialog warningDialog = new MessageDialog(null, dialogTitle, null, dialogMessage, 4, new String[]{"OK", "Cancel"}, 0);
                result = warningDialog.open();
                this.unevenString = result == 1;
            } else {
                this.unevenString = false;
            }
        }
        String secondaryId = ((IViewSite)window.getActivePage().getActivePart().getSite()).getSecondaryId();
        this.hexMode = ((EditorView)window.getActivePage().getActivePart()).getHexMode(secondaryId);
        if (!this.unevenString) {
            if (FindChangePrimaryCommandWizardPage.isModified()) {
                this.widgetSelectedAndModified(e, view, findString, changeString, colsRange, occurence, location, labelPair, excludeOption);
            } else {
                this.widgetSelectedAndNotModified(e, view, findString, changeString, colsRange, occurence, location, labelPair, excludeOption);
            }
            if (displayMode.equalsIgnoreCase("C")) {
                this.totalMatch.setText(CharFormatMode.totalMatch);
            } else if (displayMode.equalsIgnoreCase("S")) {
                this.totalMatch.setText(SingleRecordFormatMode.totalMatch);
            } else if (displayMode.equalsIgnoreCase("M")) {
                this.totalMatch.setText(MultiRecordFormatMode.totalMatch);
            }
        }
        this.findAgain = true;
    }

    private void widgetSelectedAndNotModified(SelectionEvent e, EditorView view, String findString, String changeString, FMPRange colsRange, String occurence, String location, FMPRange labelPair, String excludeOption) {
        this.fmpCursor = this.getCursor();
        this.log.log(Level.INFO, "modified is false");
        String displayMode = this.getDisplayModeOfActiveView();
        if (displayMode.equalsIgnoreCase("C")) {
            if (occurence.equals("NEXT")) {
                this.fmpCursor.setCursorOffset(this.highlightRangeEnd + 1);
                this.setCursor(this.fmpCursor);
            } else if (occurence.equals("PREV")) {
                this.fmpCursor.setCursorOffset(this.highlightRangeStart - 1);
                this.setCursor(this.fmpCursor);
            } else if (!(occurence.equals("FIRST") || occurence.equals("LAST") || occurence.equals("ALL"))) {
                this.log.log(Level.WARNING, "unknown occurrence value: " + occurence);
                return;
            }
            RunGetFindExclude runner = this.callRunner(this.typeofCommand, displayMode, this.hexMode, this.findlimit, findString, changeString, this.padCharacter, this.fmpCursor, colsRange, occurence, location, labelPair, excludeOption);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xmlResponse = runner.getXml();
            view.getCharMode().updateDisplay = true;
            view.getCharMode().setCallMF(false);
            view.getCharMode().setFind(true);
            XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
            if (e.getSource().equals(this.findBtn)) {
                this.findNotModified(xmlResponseParser, view);
            } else if (e.getSource().equals(this.findAllBtn) || e.getSource().equals(this.changeBtn)) {
                this.findAllNotModified(xmlResponseParser);
            }
        } else if (displayMode.equalsIgnoreCase("M")) {
            RunGetFindExclude runner = this.callRunner(this.typeofCommand, displayMode, this.hexMode, this.findlimit, findString, changeString, this.padCharacter, this.fmpCursor, colsRange, occurence, location, labelPair, excludeOption);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xmlResponse = runner.getXml();
            int findSelectionLength = this.txtFindString.getText().length();
            int changeSelectionLength = this.txtChange.getText().length();
            XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
            if (xmlResponseParser.getMessageCode().equals("CAWA446I")) {
                MultiRecordFormatMode.totalMatch = "String not found";
                this.fmpCursor.setSelectionEnd(0);
                return;
            }
            view.updateMRFEditViewer(xmlResponse);
            if (this.cmbFindType.getText().equals(types[2])) {
                findSelectionLength /= 2;
                changeSelectionLength /= 2;
            }
            int cursorOffset = this.getCursor().getCursorOffset();
            if (this.typeofCommand.equals("Change")) {
                this.fmpCursor.setCursorOffset(cursorOffset -= this.txtChange.getText().length());
                this.fmpCursor.setSelectionEnd(changeSelectionLength - 1);
            }
            this.fmpCursor.setSelectionEnd(findSelectionLength - 1);
            this.setCursor(this.fmpCursor);
            view.getMultiRecordFormatMode().setUpdateCurrentDisplay(true);
            view.getMultiRecordFormatMode().setFind(true);
            if (e.getSource().equals(this.findBtn)) {
                this.findNotModified(xmlResponseParser, view);
            } else if (e.getSource().equals(this.findAllBtn) || e.getSource().equals(this.changeBtn)) {
                this.findAllNotModified(xmlResponseParser);
            }
        } else if (displayMode.equalsIgnoreCase("S")) {
            RunGetFindExclude runner = this.callRunner(this.typeofCommand, displayMode, this.hexMode, this.findlimit, findString, changeString, this.padCharacter, this.fmpCursor, colsRange, occurence, location, labelPair, excludeOption);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xmlResponse = runner.getXml();
            int findSelectionLength = this.txtFindString.getText().length();
            int changeSelectionLength = this.txtChange.getText().length();
            view.updateSRFEditViewer(xmlResponse, true, true);
            int cursorOffset = SingleRecordFormatMode.Fmpcursor.getCursorOffset();
            if (this.typeofCommand.equals("Change")) {
                SingleRecordFormatMode.Fmpcursor.setCursorOffset(cursorOffset -= this.txtChange.getText().length());
                SingleRecordFormatMode.Fmpcursor.setSelectionEnd(cursorOffset + changeSelectionLength - 1);
            }
            SingleRecordFormatMode.Fmpcursor.setSelectionEnd(cursorOffset + findSelectionLength - 1);
        }
    }

    private void findNotModified(XMLResponseParser xmlResponseParser, EditorView view) {
        String messageCode = xmlResponseParser.getMessageCode();
        if (messageCode.equals("CAWA445I") || messageCode.equals("CAWA446I") || messageCode.equals("CAWA447I")) {
            String displayMode = this.getDisplayModeOfActiveView();
            if (displayMode.equalsIgnoreCase("C")) {
                CharFormatMode.totalMatch = "String not found";
            } else if (displayMode.equalsIgnoreCase("M")) {
                MultiRecordFormatMode.totalMatch = "String not found";
            }
        } else {
            this.singleHightlightFromXMLResponse(xmlResponseParser, view);
        }
    }

    private void findAllNotModified(XMLResponseParser xmlResponseParser) {
        String messageCode = xmlResponseParser.getMessageCode();
        String displayMode = this.getDisplayModeOfActiveView();
        if (messageCode.equals("CAWA442I")) {
            if (displayMode.equalsIgnoreCase("C")) {
                CharFormatMode.totalMatch = "Found " + xmlResponseParser.getMessage()[5] + " times";
            } else if (displayMode.equalsIgnoreCase("M")) {
                MultiRecordFormatMode.totalMatch = "Found " + xmlResponseParser.getMessage()[5] + " times";
            }
        } else if (messageCode.equals("CAWA445I")) {
            if (displayMode.equalsIgnoreCase("C")) {
                CharFormatMode.totalMatch = "String not found";
            } else if (displayMode.equalsIgnoreCase("M")) {
                MultiRecordFormatMode.totalMatch = "String not found";
            }
        }
        this.charFormatMode.setHightlightAll(xmlResponseParser.getCursorPositionLineNumber());
    }

    private void singleHightlightFromXMLResponse(XMLResponseParser xmlResponseParser, EditorView view) {
        String displayMode = this.getDisplayModeOfActiveView();
        this.fmpCursor = this.getCursor();
        int cursorPositionLineNumber = xmlResponseParser.getCursorPositionLineNumber();
        ArrayList rangeLineNumberList = xmlResponseParser.getRangeLineNumber();
        ArrayList rangeEndList = xmlResponseParser.getRangeEnd();
        ArrayList rangeBeginList = xmlResponseParser.getRangeBegin();
        ArrayList rangeIndexList = xmlResponseParser.getRangeIndex();
        int x = 0;
        while (x < rangeBeginList.size()) {
            this.highlightLineNumber = (Integer)rangeLineNumberList.get(x);
            this.highlightRangeIndex = (Integer)rangeIndexList.get(x);
            this.highlightRangeStart = (Integer)rangeBeginList.get(x);
            this.highlightRangeEnd = (Integer)rangeEndList.get(x);
            if (this.highlightLineNumber == cursorPositionLineNumber) {
                this.log.log(Level.INFO, "need to hightlight -->" + this.highlightLineNumber + ":" + this.highlightRangeIndex + ":" + this.highlightRangeStart + ":" + this.highlightRangeEnd);
                if (displayMode.equalsIgnoreCase("C")) {
                    if (this.charFormatMode.getTableViewer().getTable().getTopIndex() > this.highlightLineNumber) {
                        view.updateCharEditViewer(xmlResponseParser.getXmlRequest());
                    } else {
                        view.getCharMode().setCallMF(true);
                    }
                    this.charFormatMode.setHighlight(this.highlightLineNumber, this.highlightRangeIndex);
                    this.log.log(Level.INFO, "setting cursor offset to the beginning letter of the found word: " + this.highlightRangeStart);
                    this.fmpCursor.setCursorOffset(this.highlightRangeStart);
                    this.setCursor(this.fmpCursor);
                    CharFormatMode.totalMatch = "String found";
                }
                if (displayMode.equalsIgnoreCase("M")) {
                    if (this.multiRecFormatMode.getTableViewer().getTable().getTopIndex() > this.highlightLineNumber) {
                        view.updateMRFEditViewer(xmlResponseParser.getXmlRequest());
                    } else {
                        view.getMultiRecordFormatMode().callMF = true;
                    }
                    this.multiRecFormatMode.setHighlight(this.highlightLineNumber, this.highlightRangeIndex);
                    this.log.log(Level.INFO, "setting cursor offset to the beginning letter of the found word: " + this.highlightRangeStart);
                    this.fmpCursor.setCursorOffset(this.highlightRangeStart);
                    this.setCursor(this.fmpCursor);
                    MultiRecordFormatMode.totalMatch = "String found";
                }
            }
            ++x;
        }
    }

    private void widgetSelectedAndModified(SelectionEvent e, EditorView view, String findString, String changeString, FMPRange colsRange, String occurence, String location, FMPRange labelPair, String excludeOption) {
        String displayMode = this.getDisplayModeOfActiveView();
        this.fmpCursor = this.getCursor();
        this.log.log(Level.INFO, "\nmodified is true: \nrecordNumber: " + this.fmpCursor.getRecordNumber() + "\n" + "cursorOffset: " + this.fmpCursor.getCursorOffset());
        FindChangePrimaryCommandWizardPage.setModified(false);
        findString = findString.replace("'", "''");
        RunGetFindExclude runner = this.callRunner(this.typeofCommand, displayMode, this.hexMode, this.findlimit, findString, changeString, this.padCharacter, this.fmpCursor, colsRange, occurence, location, labelPair, excludeOption);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        if (displayMode.equalsIgnoreCase("C")) {
            view.getCharMode().updateDisplay = true;
            view.getCharMode().setCallMF(false);
            view.getCharMode().setFind(true);
            XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
            String messageCode = xmlResponseParser.getMessageCode();
            if (e.getSource().equals(this.findBtn)) {
                if (messageCode.equals("CAWA445I") || messageCode.equals("CAWA446I") || messageCode.equals("CAWA447I")) {
                    CharFormatMode.totalMatch = "String not found";
                } else {
                    this.singleHightlightFromXMLResponse(xmlResponseParser, view);
                }
            } else if (e.getSource().equals(this.findAllBtn)) {
                this.charFormatMode.clearHits();
                this.charFormatMode.getTableViewer().refresh();
                if (messageCode.equals("CAWA445I") || messageCode.equals("CAWA446I") || messageCode.equals("CAWA447I")) {
                    CharFormatMode.totalMatch = "String not found";
                }
            } else if (e.getSource().equals(this.changeBtn) || e.getSource().equals(this.changeAllBtn)) {
                this.charFormatMode.clearHits();
                String result = view.updateCharEditViewer(xmlResponse);
                if (!result.equalsIgnoreCase("cancel")) {
                    int[] selection = this.charFormatMode.getTableViewer().getTable().getSelectionIndices();
                    this.charFormatMode.getTableViewer().refresh();
                    this.charFormatMode.getTableViewer().getTable().select(selection);
                }
                FindChangePrimaryCommandWizardPage.setModified(true);
            }
        }
        int findSelectionLength = this.txtFindString.getText().length();
        int changeSelectionLength = this.txtChange.getText().length();
        if (this.cmbFindType.getText().equals(types[2])) {
            findSelectionLength /= 2;
            changeSelectionLength /= 2;
        }
        if (displayMode.equalsIgnoreCase("M")) {
            int cursorOffset = this.getCursor().getCursorOffset();
            XMLResponseParser xmlResponseParser = new XMLResponseParser(xmlResponse);
            String messageCode = xmlResponseParser.getMessageCode();
            if (e.getSource().equals(this.findBtn)) {
                if (messageCode.equals("CAWA445I") || messageCode.equals("CAWA446I") || messageCode.equals("CAWA447I")) {
                    MultiRecordFormatMode.totalMatch = "String not found";
                } else {
                    this.singleHightlightFromXMLResponse(xmlResponseParser, view);
                }
            } else if (e.getSource().equals(this.findAllBtn)) {
                this.multiRecFormatMode.clearHits();
                this.multiRecFormatMode.getTableViewer().refresh();
                if (messageCode.equals("CAWA445I") || messageCode.equals("CAWA446I") || messageCode.equals("CAWA447I")) {
                    MultiRecordFormatMode.totalMatch = "String not found";
                }
            }
            if (this.typeofCommand.equals("Change")) {
                this.fmpCursor.setCursorOffset(cursorOffset -= this.txtChange.getText().length());
                this.fmpCursor.setSelectionEnd(cursorOffset + changeSelectionLength - 1);
            }
            this.fmpCursor.setSelectionEnd(findSelectionLength - 1);
            this.setCursor(this.fmpCursor);
            view.getMultiRecordFormatMode().setUpdateCurrentDisplay(true);
            view.getMultiRecordFormatMode().setFind(true);
            view.updateMRFEditViewer(xmlResponse);
        }
        if (displayMode.equalsIgnoreCase("S")) {
            view.updateSRFEditViewer(xmlResponse, true, true);
            int cursorOffset = SingleRecordFormatMode.Fmpcursor.getCursorOffset();
            if (this.typeofCommand.equals("Change")) {
                SingleRecordFormatMode.Fmpcursor.setCursorOffset(cursorOffset -= this.txtChange.getText().length());
                SingleRecordFormatMode.Fmpcursor.setSelectionEnd(cursorOffset + changeSelectionLength - 1);
            }
            SingleRecordFormatMode.Fmpcursor.setSelectionEnd(cursorOffset + findSelectionLength - 1);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private RunGetFindExclude callRunner(String commandType, String displayMode, String hexMode, int findlim, String findString, String changeString, String padCharecter, FMPCursor cursorRange, FMPRange colsRange, String occurence, String location, FMPRange labelPair, String excludeOption) {
        switch (this.cmbFindType.getSelectionIndex()) {
            case 0: {
                findString = "T'" + findString + "'";
                break;
            }
            case 1: {
                findString = "C'" + findString + "'";
                break;
            }
            case 2: {
                findString = "X'" + findString + "'";
                break;
            }
            case 3: {
                findString = findString.isEmpty() && this.txtFindLength.getText().length() > 0 ? "PL" + this.txtFindLength.getText() : (!findString.isEmpty() && this.txtFindLength.getText().length() > 0 ? "PL" + this.txtFindLength.getText() + "'" + findString + "'" : "P'" + findString + "'");
            }
        }
        switch (this.cmbChangeType.getSelectionIndex()) {
            case 0: {
                changeString = "T'" + changeString + "'";
                break;
            }
            case 1: {
                changeString = "C'" + changeString + "'";
                break;
            }
            case 2: {
                changeString = "X'" + changeString + "'";
                break;
            }
            case 3: {
                changeString = this.txtChangeLength.getText().length() > 0 ? "PL" + this.txtChangeLength.getText() + "'" + changeString + "'" : "P'" + changeString + "'";
            }
        }
        EditorView.setActiveServerAndUuidOfActiveEditorView();
        return new RunGetFindExclude(this.typeofCommand, EditorView.ACTIVE_SERVER, EditorView.ACTIVE_UUID, displayMode, hexMode, this.findlimit, findString, changeString, this.padCharacter, cursorRange, colsRange, occurence, location, excludeOption);
    }

    private int byteCalculator(int index, String targetString) {
        int length = 0;
        if (index == 0) {
            length = targetString.length();
        } else if (index == 1) {
            length = targetString.length();
        } else if (index == 2) {
            length = targetString.length() / 2;
        } else if (index == 3) {
            int quotient;
            if (targetString.contains("+") || targetString.contains("-")) {
                quotient = targetString.length() % 2;
                length = targetString.length() / 2;
            } else {
                quotient = (targetString.length() + 1) % 2;
                length = (targetString.length() + 1) / 2;
            }
            if (quotient != 0) {
                ++length;
            }
        }
        return length;
    }

    public static void setModified(boolean modifyFlag) {
        modified = modifyFlag;
    }

    public static boolean isModified() {
        return modified;
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\r') {
            this.findBtn.notifyListeners(13, new Event());
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private FMPCursor getCursor() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page.getActivePart() instanceof EditorView) {
            EditorView view = (EditorView)page.getActivePart();
            String secondaryId = ((IViewSite)view.getSite()).getSecondaryId();
            return view.getCursor(secondaryId);
        }
        return new FMPCursor(0, "", 1, 0);
    }

    private void setCursor(FMPCursor cursor) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page.getActivePart() instanceof EditorView) {
            EditorView view = (EditorView)page.getActivePart();
            view.setCursor(cursor);
        }
    }

    private String getDisplayModeOfActiveView() {
        String displayMode = null;
        IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (!(workbenchPart instanceof EditorView)) {
            this.log.log(Level.WARNING, "workbenchPart is not instance of EditorView");
            return null;
        }
        EditorView editorView = (EditorView)workbenchPart;
        String secondaryId = ((IViewSite)editorView.getSite()).getSecondaryId();
        displayMode = editorView.getCurrentSession(secondaryId).getDisplayMode();
        return displayMode;
    }
}

