/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.handlers;

import com.ca.filemaster.common.ModelessWizardDialog;
import com.ca.filemaster.editor.pricommands.wizards.FindPrimaryCommandWizard;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class FindCommandHandler
extends AbstractHandler
implements IElementUpdater,
Runnable {
    static final String cacopyright = "Copyright (c) 2016 CA";
    Logger logger = Logger.getLogger(FindCommandHandler.class.getName());
    private Shell shell;
    private FindPrimaryCommandWizard wizard;
    private IWorkbenchWindow window;
    private String secondaryId;
    private EditorView view;

    public boolean isEnabled() {
        this.logger.log(Level.FINE, "isEnabled being invoked");
        int count = FindPrimaryCommandWizard.getFindPrimaryCommandWizardCount();
        return count <= 0;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof EditorView)) {
            return null;
        }
        this.view = (EditorView)page.getActivePart();
        this.view.find();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    @Override
    public void run() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelessWizardDialog dialog = new ModelessWizardDialog(FindCommandHandler.this.shell, (IWizard)FindCommandHandler.this.wizard);
                dialog.setSecondaryId(FindCommandHandler.this.secondaryId);
                dialog.create();
                dialog.open();
                try {
                    IWorkbenchPage page = FindCommandHandler.this.window.getActivePage();
                    if (page == null) {
                        FindCommandHandler.this.logger.log(Level.INFO, "page is null");
                        return;
                    }
                    IWorkbenchPart workbenchPartTwo = page.getActivePart();
                    if (workbenchPartTwo == null) {
                        FindCommandHandler.this.logger.log(Level.INFO, "workbenchPart is null");
                        return;
                    }
                    IViewSite workbenchPartSite = (IViewSite)workbenchPartTwo.getSite();
                    if (workbenchPartSite == null) {
                        FindCommandHandler.this.logger.log(Level.INFO, "workbenchPartSite is null");
                        return;
                    }
                    String viewId = workbenchPartSite.getSecondaryId();
                    if (viewId == null) {
                        FindCommandHandler.this.logger.log(Level.INFO, "viewId is null");
                        return;
                    }
                    IViewPart view = page.showView(viewId);
                    if (view == null) {
                        FindCommandHandler.this.logger.log(Level.INFO, "view is null");
                        return;
                    }
                    view.setFocus();
                }
                catch (PartInitException e) {
                    FindCommandHandler.this.logger.log(Level.SEVERE, e.getMessage());
                }
            }
        });
    }
}

