/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.utils.DateTimeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class TimeValidator
implements IInputValidator,
ICellEditorValidator {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(TimeValidator.class);
    private String format;
    private Pattern pattern;

    public TimeValidator(ColumnModel columnModel, DataType dataType, String format) {
        this.format = format;
        this.pattern = DateTimeUtil.getTimePatternInstance(format);
    }

    public String isValid(String value) {
        if (!value.isEmpty()) {
            return this.isValidTimeFormat(value);
        }
        return null;
    }

    public String isValid(Object value) {
        return value != null ? this.isValid(value.toString().trim()) : null;
    }

    private String isValidTimeFormat(String s) {
        try {
            Matcher matcher = this.pattern.matcher(s);
            if (!matcher.matches()) {
                return DWBundle.bind((String)DWBundle.ERR_INVALID_TIME_FORMAT, (Object)this.getErrMsg());
            }
            return this.validateRanges(matcher);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String validateRanges(Matcher matcher) {
        try {
            boolean isNoonFormat = DateTimeUtil.isUSAformat(this.format);
            int hours = Integer.parseInt(matcher.group(1));
            int minutes = 0;
            int seconds = 0;
            if (isNoonFormat) {
                if (matcher.group(2) != null) {
                    minutes = Integer.parseInt(matcher.group(3));
                }
                String noon = matcher.group(5);
                if (hours == 0 && (noon.equalsIgnoreCase("PM") || minutes > 0)) {
                    return DWBundle.ERR_INVALID_TIME_00_PM;
                }
            } else {
                minutes = Integer.parseInt(matcher.group(2));
                if (matcher.group(3) != null) {
                    seconds = Integer.parseInt(matcher.group(3).substring(1));
                }
            }
            return DateTimeUtil.validateRangesForTime(isNoonFormat, hours, minutes, seconds);
        }
        catch (Exception e) {
            logger.error((Object)("Exception occured while validating ranges for time : " + matcher.group()), (Throwable)e);
            return DWBundle.ERR_INVALID_TIME;
        }
    }

    private String getErrMsg() {
        String pattern = DateTimeUtil.getTimePatternMsg(this.format);
        return pattern != null ? String.valueOf(this.format) + " (" + pattern + ")" : this.format;
    }
}

