/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.i18n.CMBundle;
import com.ca.db2.editor.ui.utils.CMColumnModel;
import com.ca.db2.editor.ui.utils.CMLabelProvider;
import com.ca.db2.editor.ui.widgets.ChangeManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;

public class CMColumnsHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    ChangeManager changeManager;
    TreeViewer viewer;
    List<CMColumnModel> columnModels;

    public CMColumnsHandler(ChangeManager changeManager) {
        this.changeManager = changeManager;
        this.viewer = changeManager.getViewer();
        this.columnModels = new ArrayList<CMColumnModel>();
    }

    public void createColumns() {
        List<CMColumnModel> columnModels = this.getColumnModels();
        for (CMColumnModel model : columnModels) {
            TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
            viewerColumn.getColumn().setMoveable(true);
            viewerColumn.getColumn().setResizable(true);
            viewerColumn.getColumn().setText(model.getName());
            viewerColumn.getColumn().setToolTipText(model.getTooltip());
            viewerColumn.getColumn().setWidth(model.getWidth() == 0 ? 350 : model.getWidth());
            viewerColumn.setLabelProvider((CellLabelProvider)new CMLabelProvider());
        }
    }

    private List<CMColumnModel> getColumnModels() {
        CMColumnModel object = new CMColumnModel(CMBundle.OBJECT_NAME, CMBundle.TOOLTIP_OBJECT_NAME, false);
        this.columnModels.add(object);
        CMColumnModel column = new CMColumnModel(CMBundle.COLUMN, CMBundle.TOOLTIP_COLUMN, false);
        this.columnModels.add(column);
        CMColumnModel originalValue = new CMColumnModel(CMBundle.ORIGINAL_VALUE, CMBundle.TOOLTIP_ORIGINAL_VALUE, false);
        this.columnModels.add(originalValue);
        CMColumnModel modifiedValue = new CMColumnModel(CMBundle.MODIFIED_VALUE, CMBundle.TOOLTIP_MODIFIED_VALUE, false);
        this.columnModels.add(modifiedValue);
        return this.columnModels;
    }
}

