/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.actions.Dialog;
import com.ca.db2.editor.ui.actions.LabelProvider;
import com.ca.db2.editor.ui.actions.StructuredContentProvider;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DSEContextMenu;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.BusyIndicator;

class DSEAddSubsystemsAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static Logger logger = Logger.getLogger(DSEAddSubsystemsAction.class);
    private DataSourceExplorer explorer;
    private Dialog listSelectionDialog;
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();

    public DSEAddSubsystemsAction(DataSourceExplorer explorer) {
        super(DSEBundle.ADD_SUBSYSTEMS);
        this.explorer = explorer;
        this.setImageDescriptor(Images.LOAD_OBJECTS);
        this.setId(DSEContextMenu.ACTION.ADD_SUBSYSTEMS.toString());
        this.contentProvider = new StructuredContentProvider();
        this.labelProvider = new LabelProvider();
        this.setAccelerator(13);
    }

    @Override
    public void execute() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LparNode lparNode = (LparNode)DSEAddSubsystemsAction.this.explorer.getSelectedObject();
                    List<SubsystemNode> subsystems = DSEAddSubsystemsAction.this.dataSourceHandler.getSubsystems(lparNode, true);
                    if (!subsystems.isEmpty()) {
                        subsystems.removeAll(lparNode.getChildren());
                    }
                    if (subsystems.isEmpty()) {
                        logger.info((Object)DSEBundle.NO_ACTIVE_SSIDS_FOUND);
                        MsgDialog.showInfoDialog(null, DSEBundle.INFORMATION_DIALOG_TTILE, DSEBundle.NO_ACTIVE_SSIDS_FOUND);
                    } else {
                        Collections.sort(subsystems);
                        DSEAddSubsystemsAction.this.listSelectionDialog = new Dialog(null, subsystems, DSEAddSubsystemsAction.this.contentProvider, DSEAddSubsystemsAction.this.labelProvider, DSEBundle.ADD_SSIDS_DIALOG_MSG);
                        DSEAddSubsystemsAction.this.listSelectionDialog.setTitle(DSEBundle.ADD_SSIDS_DIALOG_TITLE);
                        DSEAddSubsystemsAction.this.listSelectionDialog.setHelpAvailable(false);
                        DSEAddSubsystemsAction.this.listSelectionDialog.open();
                        if (DSEAddSubsystemsAction.this.listSelectionDialog.getReturnCode() == 0) {
                            Object[] elements;
                            Object[] objectArray = elements = DSEAddSubsystemsAction.this.listSelectionDialog.getSelectedItems();
                            int n = elements.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                lparNode.addChild((ITreeNode)o);
                                ++n2;
                            }
                            Collections.sort(lparNode.getChildren());
                            DSEAddSubsystemsAction.this.explorer.refresh();
                            logger.info((Object)"Subsytem(s) added successfully.");
                        }
                    }
                }
                catch (FMDB2Exception e) {
                    MsgDialog.showErrorDialog(null, "Loading Subsystems", e.getMessage());
                }
            }
        });
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.explorer.getSelectedObject() instanceof LparNode);
    }
}

