/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor;

import com.ca.db2.editor.LogListener;
import com.ca.db2.editor.ui.utils.LoginLogoutUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ca.db2.editor";
    private static Activator plugin;
    private static final Logger logger;
    private final List<LogListener> pluginLogHooks = new ArrayList<LogListener>();
    private MessageConsole fmdb2Console = new MessageConsole("", null);
    private MessageConsoleStream msgConsoleStream;
    private final PrintStream printStream;

    static {
        logger = Logger.getLogger(Activator.class);
    }

    public Activator() {
        this.fmdb2Console.clearConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.fmdb2Console});
        this.msgConsoleStream = this.fmdb2Console.newMessageStream();
        this.printStream = new PrintStream((OutputStream)this.msgConsoleStream);
        System.setOut(this.printStream);
        System.setErr(this.printStream);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.configureLogging(context);
        this.hookExitHandler();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.releaseResources();
        }
        catch (Exception e) {
            logger.error((Object)"Problem while releasing resources:", (Throwable)e);
        }
        plugin = null;
        super.stop(context);
    }

    private void releaseResources() throws IOException {
        this.printStream.flush();
        this.msgConsoleStream.flush();
        if (!this.msgConsoleStream.isClosed()) {
            this.msgConsoleStream.close();
        }
        this.printStream.close();
        this.fmdb2Console.destroy();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void configureLogging(BundleContext context) {
        try {
            URL propsURL = this.getBundle().getEntry("log4j.properties");
            PropertyConfigurator.configure((URL)propsURL);
            this.hookPluginLoggers(context);
            logger.debug((Object)"FMDB2 Logger initialized");
        }
        catch (Exception e) {
            String message = "Error while initializing log properties." + e.getMessage();
            Status status = new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, message, (Throwable)e);
            this.getLog().log((IStatus)status);
            throw new RuntimeException("Error while initializing log properties.", e);
        }
    }

    private void hookPluginLoggers(BundleContext context) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            ILog pluginLogger = Platform.getLog((Bundle)bundle);
            this.pluginLogHooks.add(new LogListener(pluginLogger, Logger.getLogger((String)bundle.getSymbolicName())));
            ++n2;
        }
    }

    public void hookExitHandler() {
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                boolean exit = LoginLogoutUtils.onLogout();
                return exit;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }
}

