/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.common.table;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableFilter;
import com.ca.mat.common.table.MATTableFilterWidget;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableModelListener;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.common.table.MATTableViewerListener;
import com.ca.mat.common.table.SimpleMATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.utils.TextUtil;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;

public class MATTableViewer
extends TableViewer
implements IMATTableViewer {
    static final String cacopyright = "Copyright \u00a9 2014 CA";
    static final boolean trace = Boolean.getBoolean("com.ca.mat.trace");
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String MEMENTO_COLUMN_NAME = "columnProperties";
    private static final int MINIMAL_COLUMN_WIDTH = 10;
    private static final Image filterIcon = Activator.plugin.getImageRegistry().get("com.ca.mat.filter");
    private final boolean CREATE_TOTALS = false;
    private int[] columnOrder;
    private int sortColumn = 0;
    private int defaultSortColumn = 0;
    private int sortDirection = 128;
    private int defaultSortDirection = 128;
    private boolean textOnly;
    private MATTableFilterWidget filterWidget;
    protected Map<TableColumn, ColumnMetadata> columnMap;
    protected List<ColumnMetadata> columnList;
    private MATTableModel data;
    private Map<MATTableViewerListener, Object> viewerListeners = new WeakHashMap<MATTableViewerListener, Object>();
    private Map<Integer, List<TableColumn>> secondarySortColumns = new HashMap<Integer, List<TableColumn>>();
    private Map<Integer, List<Integer>> secondarySortDirections = new HashMap<Integer, List<Integer>>();
    private ArrayList<Integer> visibleSortedColumnList = new ArrayList();

    public MATTableViewer(Composite parent) {
        this(parent, 66308);
    }

    public MATTableViewer(Composite parent, Integer style) {
        super(parent, style.intValue());
        this.columnMap = new HashMap<TableColumn, ColumnMetadata>();
        this.columnList = new ArrayList<ColumnMetadata>();
        Table table = this.getTable();
        final MATTableViewer instance = this;
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gdata = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gdata);
        this.setComparator(new MATTableItemComparator(this));
        this.setContentProvider((IContentProvider)new MATContentProvider());
        table.setSortDirection(1024);
        table.setFont(JFaceResources.getTextFont());
        this.reloadTempVars();
        this.textOnly = Singletons.getUserPreferenceManager().getStoreForUserId().getBoolean("textOnlyTables");
        Singletons.getUserPreferenceManager().getStoreForUserId().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("textOnlyTables") && !MATTableViewer.this.getTable().isDisposed()) {
                    MATTableViewer.this.textOnly = Singletons.getUserPreferenceManager().getStoreForUserId().getBoolean("textOnlyTables");
                    for (ColumnMetadata meta : MATTableViewer.this.columnList) {
                        if (meta.type != 9) continue;
                        meta.tableViewerColumn.getColumn().setAlignment(MATTableViewer.this.textOnly ? 131072 : 16384);
                        int columnIndex = MATTableViewer.this.getTable().indexOf(meta.tableViewerColumn.getColumn());
                        meta.tableViewerColumn.setLabelProvider((CellLabelProvider)new MATColumnLabelProvider(columnIndex, instance));
                    }
                    MATTableViewer.this.refresh();
                }
            }
        });
        table.addListener(3, (Listener)this);
        table.addListener(42, (Listener)this);
        table.addListener(12, (Listener)this);
    }

    public void handleEvent(Event event) {
        Table table = this.getTable();
        Display display = table.getDisplay();
        switch (event.type) {
            case 13: 
            case 14: {
                if (!(event.widget instanceof TableColumn)) break;
                TableColumn column = (TableColumn)event.widget;
                if (column.equals(table.getSortColumn())) {
                    this.sortDirection = table.getSortDirection();
                    switch (this.sortDirection) {
                        case 1024: {
                            this.setSortDirection(128);
                            break;
                        }
                        default: {
                            this.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    this.setSortColumn(this.getTable().indexOf(column));
                }
                this.refresh();
                break;
            }
            case 3: {
                Point pt = new Point(event.x, event.y);
                TableItem item = table.getItem(pt);
                if (item == null) {
                    return;
                }
                int i = 0;
                while (i < this.columnMap.size()) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        table.indexOf(item);
                    }
                    ++i;
                }
                break;
            }
            case 42: {
                if (this.textOnly) break;
                TableColumn tableCol = table.getColumn(event.index);
                ColumnMetadata colData = this.columnMap.get(tableCol);
                if (event.index <= 0 || colData.type != 9) break;
                GC gc = event.gc;
                TableItem item = (TableItem)event.item;
                MATTableRow row = (MATTableRow)item.getData();
                try {
                    Double percent = (Double)row.getObject(event.index);
                    if (percent == null) {
                        percent = 0.0;
                    }
                    NumberFormat form = NumberFormat.getInstance();
                    form.setMinimumFractionDigits(2);
                    form.setMaximumFractionDigits(2);
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    gc.setForeground(display.getSystemColor(5));
                    gc.setBackground(display.getSystemColor(8));
                    int width = (int)((double)(tableCol.getWidth() - 1) * percent / 100.0);
                    if (percent > 0.0 && width == 0) {
                        width = 1;
                    }
                    gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
                    Rectangle rect2 = new Rectangle(event.x, event.y, width - 1, event.height - 1);
                    gc.drawRectangle(rect2);
                    gc.setForeground(display.getSystemColor(24));
                    String text = form.format(percent);
                    Point size = event.gc.textExtent(text);
                    int offsetx = tableCol.getWidth() - size.x - 4;
                    int offsety = Math.max(0, (event.height - size.y) / 2);
                    gc.drawText(text, event.x + offsetx, event.y + offsety, true);
                    gc.setForeground(background);
                    gc.setBackground(foreground);
                }
                catch (ClassCastException classCastException) {}
                break;
            }
            case 12: {
                this.data = null;
                this.viewerListeners.clear();
                this.secondarySortColumns = null;
                this.secondarySortDirections = null;
            }
        }
    }

    private int getWidthForSize(int size, String header) {
        int chars = 0;
        switch (size) {
            case 1: {
                chars = 1;
                break;
            }
            case 4: {
                chars = 5;
                break;
            }
            case 2: {
                chars = 2;
                break;
            }
            case 3: {
                chars = 4;
                break;
            }
            case 5: {
                chars = 8;
                break;
            }
            case 6: {
                chars = 46;
                break;
            }
            case 7: {
                chars = 20;
                break;
            }
            case 8: {
                chars = 35;
                break;
            }
            case 9: {
                chars = 60;
                break;
            }
            case 10: {
                chars = 100;
            }
        }
        if (header.length() > chars) {
            chars = header.length();
        }
        return TextUtil.calculateWidth((Control)this.getTable(), (int)(chars + 2));
    }

    public MATTableFilter addColumnFilter(List<Integer> filteredColumns, String expression, boolean internal, boolean isQuickFilter) {
        MATTableFilter filter;
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter item = viewerFilterArray[n2];
            if (item instanceof MATTableFilter && (filter = (MATTableFilter)item).isInternal() == internal) {
                if (!filter.isQuickFilter() && filter.isFilteredBySameColumns(filteredColumns)) {
                    this.removeFilter((ViewerFilter)filter);
                } else if (isQuickFilter && filter.isQuickFilter()) {
                    this.removeFilter((ViewerFilter)filter);
                }
            }
            ++n2;
        }
        filter = new MATTableFilter((IMATTableViewer)this, filteredColumns, expression, internal, isQuickFilter);
        if (filter.getoperatorType() == 0) {
            return null;
        }
        if (!filter.isFilterValidForTheColumnList()) {
            return filter;
        }
        if (!filter.isInternal()) {
            try {
                if (!filter.isQuickFilter()) {
                    TableColumn viewColumn = this.getTable().getColumn(filteredColumns.get(0).intValue());
                    viewColumn.setImage(filterIcon);
                    String originalTooltip = this.columnMap.get((Object)viewColumn).tooltip;
                    viewColumn.setToolTipText(String.valueOf(originalTooltip) + filter.getToolTip());
                }
            }
            catch (Exception exception) {}
        }
        this.addFilter((ViewerFilter)filter);
        for (MATTableViewerListener listener : this.viewerListeners.keySet()) {
            listener.filterAdded(filter);
        }
        return filter;
    }

    public MATTableFilter getColumnFilter(List<Integer> filteredColumns, boolean internal) {
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter item = viewerFilterArray[n2];
            if (item instanceof MATTableFilter) {
                MATTableFilter filter = (MATTableFilter)item;
                if (filter.isInternal() == internal && filter.isFilteredBySameColumns(filteredColumns)) {
                    return filter;
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public void removeFilter(ViewerFilter filter) {
        if (filter instanceof MATTableFilter) {
            try {
                MATTableFilter caFilter = (MATTableFilter)filter;
                if (!caFilter.isInternal() && !caFilter.isQuickFilter()) {
                    int i = 0;
                    while (i < caFilter.getFilteredColumns().size()) {
                        int ix = (Integer)caFilter.getFilteredColumns().get(i);
                        TableColumn viewColumn = this.getTable().getColumn(ix);
                        viewColumn.setImage(null);
                        String originalTooltip = this.columnMap.get((Object)viewColumn).tooltip;
                        viewColumn.setToolTipText(originalTooltip);
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        super.removeFilter(filter);
        if (filter instanceof MATTableFilter) {
            for (MATTableViewerListener listener : this.viewerListeners.keySet()) {
                listener.filterRemoved((MATTableFilter)filter);
            }
        }
    }

    public void removeAllFilters() {
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            this.removeFilter(filter);
            ++n2;
        }
    }

    public MATTableModel getCATableModel() {
        if (this.data == null) {
            this.data = new MATTableModel();
            this.data.addCATableModelListener((MATTableModelListener)this);
            this.setInput(this.data);
        }
        return this.data;
    }

    public MATTableRow[] getSelectedRows() {
        TableItem[] selection = this.getTable().getSelection();
        MATTableRow[] result = new MATTableRow[selection.length];
        int i = 0;
        while (i < selection.length) {
            result[i] = (MATTableRow)selection[i].getData();
            ++i;
        }
        return result;
    }

    public int[] getColumnOrder() {
        return this.columnOrder;
    }

    public void setColumnOrder(final int[] order) {
        if (!this.getTable().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (order != null && order.length == MATTableViewer.this.getTable().getColumnCount()) {
                        MATTableViewer.this.columnOrder = order;
                        MATTableViewer.this.getTable().setColumnOrder(order);
                    }
                }
            });
        }
    }

    public void resetColumnOrder() {
        if (!this.getTable().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int count = MATTableViewer.this.getTable().getColumnCount();
                    int[] order = new int[count];
                    int i = 0;
                    while (i < count) {
                        order[i] = i;
                        ++i;
                    }
                    MATTableViewer.this.columnOrder = order;
                    MATTableViewer.this.getTable().setColumnOrder(order);
                }
            });
        }
    }

    public void setColumnWidth(final int pos, final int width) {
        if (!this.getTable().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (MATTableViewer.this.columnList.size() > pos) {
                        ColumnMetadata meta = MATTableViewer.this.columnList.get(pos);
                        if (meta != null) {
                            if (meta.visible) {
                                meta.width = width;
                            }
                            meta.tableViewerColumn.getColumn().setWidth(width);
                        }
                    } else {
                        MATTableViewer.this.log.warning("attempting to set size of nonexistent column " + pos);
                    }
                }
            });
        }
    }

    public void syncWith(IMATTableViewer reference) {
        if (this.columnList.size() == ((MATTableViewer)reference).columnList.size()) {
            this.setColumnOrder(reference.getColumnOrder());
            this.setSortColumn(reference.getSortColumn());
            this.setSortDirection(reference.getSortDirection());
            int i = 0;
            for (ColumnMetadata meta : ((MATTableViewer)reference).columnList) {
                ColumnMetadata localMeta = this.columnList.get(i);
                localMeta.visible = meta.visible;
                localMeta.empty = meta.empty;
                localMeta.width = meta.width;
                if (!localMeta.tableViewerColumn.getColumn().isDisposed()) {
                    localMeta.tableViewerColumn.getColumn().setWidth(!meta.empty && meta.visible ? meta.width : 0);
                }
                ++i;
            }
            this.refresh();
        } else {
            this.log.warning("Attempting to synchronize tables with different column count");
        }
    }

    public void createTotal() {
        MATTableModel model = this.getCATableModel();
        if (model != null && model.getTotal() == null) {
            Object[] totals = new Number[this.columnList.size()];
            MATTableRow[] mATTableRowArray = model.getRows(false);
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                int i = 0;
                for (ColumnMetadata columnMeta : this.columnList) {
                    Number num;
                    if (columnMeta.type == 2) {
                        if (row.getObject(i) instanceof Integer) {
                            num = (Integer)row.getObject(i);
                            totals[i] = totals[i] == null ? (Number)num : (Number)(((Number)totals[i]).intValue() + (Integer)num);
                        }
                        if (row.getObject(i) instanceof Long) {
                            num = (Long)row.getObject(i);
                            totals[i] = totals[i] == null ? (Number)num : (Number)(((Number)totals[i]).longValue() + (Long)num);
                        }
                    }
                    if (columnMeta.type == 8 || columnMeta.type == 11 || columnMeta.type == 3 || columnMeta.type == 9) {
                        num = ((Number)row.getObject(i)).doubleValue();
                        totals[i] = totals[i] == null ? (Number)num : (Number)(((Number)totals[i]).doubleValue() + (Double)num);
                    }
                    ++i;
                }
                ++n2;
            }
            SimpleMATTableRow totalRow = new SimpleMATTableRow(totals, model);
            model.setTotal((MATTableRow)totalRow);
            this.refresh();
        }
    }

    public void resetColumns() {
        if (!this.getTable().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    for (ColumnMetadata meta : MATTableViewer.this.columnList) {
                        meta.width = meta.defaultWidth;
                        meta.visible = meta.defaultVisibility;
                        meta.tableViewerColumn.getColumn().setWidth(meta.visible & !meta.empty ? meta.defaultWidth : 0);
                    }
                }
            });
        }
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int index) {
        this.setSortColumn(index, true);
    }

    public void setSortColumn(int index, boolean notify) {
        this.sortColumn = index;
        Table table = this.getTable();
        if (!this.getTable().isDisposed()) {
            try {
                if (this.getTable().getSortColumn() != table.getColumn(this.sortColumn)) {
                    TableColumn tableColumn = table.getColumn(this.sortColumn);
                    table.setSortColumn(tableColumn);
                    if (notify) {
                        for (MATTableViewerListener listener : this.viewerListeners.keySet()) {
                            listener.sortChanged((IMATTableViewer)this, this.getSortColumn(), this.getSortDirection());
                        }
                    }
                    this.refresh();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.sortColumn = -1;
                table.setSortColumn(null);
            }
        }
    }

    public void setDefaultSortColumn(int index) {
        this.defaultSortColumn = index;
        this.resetSortColumn();
    }

    public void resetSortColumn() {
        this.setSortColumn(this.defaultSortColumn);
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int direction) {
        this.setSortDirection(direction, true);
    }

    public void setSortDirection(int direction, boolean notify) {
        if (!this.getTable().isDisposed() && this.getTable().getSortDirection() != direction) {
            this.sortDirection = direction;
            this.getTable().setSortDirection(direction);
            if (notify) {
                for (MATTableViewerListener listener : this.viewerListeners.keySet()) {
                    listener.sortChanged((IMATTableViewer)this, this.getSortColumn(), this.getSortDirection());
                }
            }
            this.refresh();
        }
    }

    public void setDefaultSortDirection(int direction) {
        this.defaultSortDirection = direction;
        this.resetSortDirection();
    }

    public void resetSortDirection() {
        this.setSortDirection(this.defaultSortDirection);
    }

    public void setSecondarySortColumn(int primary, int secondary) {
        this.setSecondarySortColumns(primary, new int[]{secondary});
    }

    public void setSecondarySortColumns(int primary, int[] secondary) {
        Table table = this.getTable();
        ArrayList<TableColumn> secTableColumns = new ArrayList<TableColumn>();
        int[] nArray = secondary;
        int n = secondary.length;
        int n2 = 0;
        while (n2 < n) {
            int col = nArray[n2];
            secTableColumns.add(table.getColumn(col));
            ++n2;
        }
        this.secondarySortColumns.put(primary, secTableColumns);
    }

    public void setSecondarySortDirection(int primary, int direction) {
        this.setSecondarySortDirections(primary, new int[]{direction});
    }

    public void setSecondarySortDirections(int primary, int[] directions) {
        ArrayList<Integer> secSortDirections = new ArrayList<Integer>();
        int[] nArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            int direction = nArray[n2];
            secSortDirections.add(direction);
            ++n2;
        }
        this.secondarySortDirections.put(primary, secSortDirections);
    }

    public Integer getColumnType(int columnIndex) {
        if (!this.getTable().isDisposed()) {
            TableColumn col = this.getTable().getColumn(columnIndex);
            return this.columnMap.get((Object)col).type;
        }
        return null;
    }

    public String[] getColumnNames() {
        String[] result = new String[this.getTable().getColumnCount()];
        int i = 0;
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            result[i] = column.getText();
            ++i;
            ++n2;
        }
        return result;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    public String getColumnName(int col) {
        return this.columnList.get((int)col).name;
    }

    public int getColumnWidth(int col) {
        return this.columnList.get((int)col).width;
    }

    public int getDefaultColumnWidth(int col) {
        return this.columnList.get((int)col).defaultWidth;
    }

    public boolean getColumnVisibile(int col) {
        return this.columnList.get((int)col).visible;
    }

    public boolean getColumnCustomizable(int col) {
        return this.columnList.get((int)col).customizable;
    }

    public boolean getColumnEmpty(int col) {
        return this.columnList.get((int)col).empty;
    }

    public void setColumnVisible(int i, boolean visible) {
        ColumnMetadata meta = this.columnList.get(i);
        if (meta != null && !meta.customizable) {
            this.log.warning("Attempt to set visibility on a non-customizable column " + i + " to " + visible);
            return;
        }
        if (!this.getTable().isDisposed()) {
            try {
                if (this.columnList.size() > i) {
                    TableColumn tableColumn = meta.tableViewerColumn.getColumn();
                    if (meta.visible != visible) {
                        meta.visible = visible;
                        meta.width = visible ? meta.defaultWidth : 0;
                        tableColumn.setWidth(visible ? meta.defaultWidth : 0);
                        tableColumn.setResizable(visible);
                        if (meta.customizable) {
                            for (MATTableViewerListener listener : this.viewerListeners.keySet()) {
                                listener.columnShownOrHidden((IMATTableViewer)this, i, visible);
                            }
                        }
                    }
                } else {
                    this.log.warning("attempting to set visibility of nonexistent column " + i);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void setColumnEmpty(int i) {
        this.setColumnEmpty(i, true);
    }

    public void setColumnEmpty(int i, boolean empty) {
        ColumnMetadata meta = this.columnList.get(i);
        if (!this.getTable().isDisposed()) {
            try {
                if (this.columnList.size() > i) {
                    TableColumn tableColumn = meta.tableViewerColumn.getColumn();
                    meta.empty = empty;
                    if (empty) {
                        tableColumn.setWidth(0);
                    } else {
                        tableColumn.setWidth(meta.width);
                    }
                } else {
                    this.log.warning("attempting to set visibility of nonexistent column " + i);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void reloadTempVars() {
        this.columnOrder = this.getTable().getColumnOrder();
        this.sortColumn = this.getTable().getSortColumn() == null ? -1 : this.getTable().indexOf(this.getTable().getSortColumn());
        this.sortDirection = this.getTable().getSortDirection();
    }

    public void addViewerListener(MATTableViewerListener listener) {
        if (!this.viewerListeners.containsKey(listener)) {
            this.viewerListeners.put(listener, new Object());
        }
    }

    public void removeViewerListener(MATTableViewerListener listener) {
        if (this.viewerListeners.containsKey(listener)) {
            this.viewerListeners.remove(listener);
        }
    }

    public void setCATableModel(MATTableModel data) {
        if (data == null) {
            data = new MATTableModel();
        }
        if (this.data == null) {
            this.data = this.getCATableModel();
        }
        if (this.data != data) {
            this.data.removeCATableModelListener((MATTableModelListener)this);
            data.addCATableModelListener((MATTableModelListener)this);
            this.data = data;
            if (this.getContentProvider() == null) {
                this.setContentProvider((IContentProvider)new MATContentProvider());
            }
            if (!this.getTable().isDisposed()) {
                this.setInput(data);
            }
        }
    }

    public void loadPropsFromMemento(IMemento tableMemento) {
        if (tableMemento != null) {
            IMemento[] columns;
            if (tableMemento.getInteger("sortColumn") != null) {
                this.setSortColumn(tableMemento.getInteger("sortColumn"));
            }
            if (tableMemento.getInteger("sortDirection") != null) {
                this.setSortDirection(tableMemento.getInteger("sortDirection"));
            }
            if ((columns = tableMemento.getChildren(MEMENTO_COLUMN_NAME)).length == this.columnList.size()) {
                int[] newColumnOrder = new int[columns.length];
                int i = 0;
                IMemento[] iMementoArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento columnMem = iMementoArray[n2];
                    newColumnOrder[i] = columnMem.getInteger("order");
                    this.setColumnWidth(i, columnMem.getInteger("width"));
                    if (this.columnList.get((int)i).customizable) {
                        this.setColumnVisible(i, columnMem.getBoolean("visible"));
                    }
                    ++i;
                    ++n2;
                }
                this.setColumnOrder(newColumnOrder);
            } else if (columns.length != 0) {
                this.log.warning("Corrupt or invalid persisted properties for table " + tableMemento.getID());
            }
            this.refresh();
        }
    }

    public void savePropsToMemento(IMemento tableMemento) {
        if (tableMemento == null) {
            return;
        }
        int i = 0;
        tableMemento.putInteger("sortColumn", this.getSortColumn());
        tableMemento.putInteger("sortDirection", this.getSortDirection());
        for (ColumnMetadata meta : this.columnList) {
            IMemento columnMem = tableMemento.createChild(MEMENTO_COLUMN_NAME);
            columnMem.putInteger("width", meta.width);
            columnMem.putInteger("order", this.getColumnOrder()[i]);
            columnMem.putBoolean("visible", meta.visible);
            ++i;
        }
    }

    public void addColumn(String header, int size, String tooltip, int type) {
        this.addColumn(header, size, tooltip, type, true, true);
    }

    public void addColumn(String header, int size, String tooltip, int type, boolean visible, boolean customizable) {
        this.addColumn(header, size, tooltip, type, visible, customizable, true, true);
    }

    public void addColumn(String header, int size, String tooltip, int type, boolean visible, boolean customizable, boolean moveable, boolean sortable) {
        int width = this.getWidthForSize(size, header);
        int alignment = 131072;
        boolean textOnlyTables = Singletons.getUserPreferenceManager().getStoreForUserId().getBoolean("textOnlyTables");
        if (type == 1 || type == 9 && !textOnlyTables) {
            alignment = 16384;
        }
        TableViewerColumn viewerColumn = this.addColumnToTable(header, visible ? width : 0, tooltip, moveable, alignment);
        ColumnMetadata meta = new ColumnMetadata();
        meta.type = type;
        meta.name = header;
        meta.sortable = sortable;
        meta.defaultWidth = width;
        meta.width = visible ? width : 0;
        meta.tableViewerColumn = viewerColumn;
        meta.defaultVisibility = visible;
        meta.visible = visible;
        meta.customizable = customizable;
        meta.tooltip = tooltip;
        this.columnMap.put(viewerColumn.getColumn(), meta);
        this.columnList.add(meta);
    }

    private TableViewerColumn addColumnToTable(String header, int width, String tooltip, boolean moveable, int alignment) {
        final MATTableViewer inst = this;
        TableViewerColumn columnViewer = new TableViewerColumn((TableViewer)this, 0);
        int columnIndex = this.getTable().indexOf(columnViewer.getColumn());
        columnViewer.getColumn().setText(header);
        columnViewer.getColumn().setWidth(width);
        columnViewer.getColumn().setResizable(true);
        columnViewer.getColumn().addListener(13, (Listener)this);
        columnViewer.getColumn().addListener(14, (Listener)this);
        columnViewer.getColumn().setToolTipText(tooltip == null ? tooltip : tooltip.trim());
        columnViewer.getColumn().setMoveable(moveable);
        columnViewer.setLabelProvider((CellLabelProvider)new MATColumnLabelProvider(columnIndex, this));
        columnViewer.getColumn().setAlignment(alignment);
        this.columnMap.put(columnViewer.getColumn(), new ColumnMetadata());
        columnViewer.getColumn().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                TableColumn sourceCol = (TableColumn)e.getSource();
                boolean textOnlyTables = Singletons.getUserPreferenceManager().getStoreForUserId().getBoolean("textOnlyTables");
                int sourceIndex = 0;
                int sourceOrder = 0;
                MATTableViewer.this.columnOrder = MATTableViewer.this.getTable().getColumnOrder();
                if (MATTableViewer.this.columnOrder.length > 0) {
                    int i = 0;
                    while (i < MATTableViewer.this.columnOrder.length) {
                        TableColumn col = MATTableViewer.this.getTable().getColumn(i);
                        if (i == 0) {
                            col.setAlignment(16384);
                        } else if (MATTableViewer.this.columnMap.get((Object)col).type == 1 || MATTableViewer.this.columnMap.get((Object)col).type == 9 && !textOnlyTables) {
                            col.setAlignment(16384);
                        } else {
                            col.setAlignment(131072);
                        }
                        if (sourceCol.equals(col)) {
                            sourceIndex = i;
                            sourceOrder = MATTableViewer.this.columnOrder[i];
                        }
                        ++i;
                    }
                }
                for (MATTableViewerListener listener : MATTableViewer.this.viewerListeners.keySet()) {
                    listener.columnMoved(inst, sourceIndex, sourceOrder);
                }
            }

            public void controlResized(ControlEvent e) {
                TableColumn sourceCol = (TableColumn)e.getSource();
                ColumnMetadata meta = MATTableViewer.this.columnMap.get(sourceCol);
                int sourceWidth = 0;
                if (!meta.visible) {
                    sourceCol.setWidth(0);
                    return;
                }
                if (meta.empty) {
                    sourceCol.setWidth(0);
                    return;
                }
                if (sourceCol.getWidth() < 10 && MATTableViewer.this.columnMap.get((Object)sourceCol).visible) {
                    sourceCol.setWidth(10);
                }
                meta.width = sourceWidth = sourceCol.getWidth();
                int index = MATTableViewer.this.columnList.indexOf(meta);
                for (MATTableViewerListener listener : MATTableViewer.this.viewerListeners.keySet()) {
                    listener.columnResized(inst, index, sourceWidth);
                }
            }
        });
        this.reloadTempVars();
        return columnViewer;
    }

    public void contentChanged(MATTableModel newContent) {
        this.inputChanged(newContent, null);
    }

    public void removeAllColumns() {
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                Table table = MATTableViewer.this.getTable();
                TableColumn[] tableColumnArray = table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn c = tableColumnArray[n2];
                    c.dispose();
                    ++n2;
                }
                table.removeAll();
                MATTableViewer.this.columnMap.clear();
                tableColumnArray = MATTableViewer.this.getFilters();
                n = tableColumnArray.length;
                n2 = 0;
                while (n2 < n) {
                    TableColumn f = tableColumnArray[n2];
                    MATTableViewer.this.removeFilter((ViewerFilter)f);
                    ++n2;
                }
                tableColumnArray = table.getListeners(42);
                n = tableColumnArray.length;
                n2 = 0;
                while (n2 < n) {
                    TableColumn l = tableColumnArray[n2];
                    table.removeListener(42, (Listener)l);
                    ++n2;
                }
            }
        });
    }

    public List<Integer> getVisibleSortedColumnList() {
        ArrayList<Integer> visibleSortedColumnList = new ArrayList<Integer>();
        int[] columnOrder = this.getColumnOrder();
        int i = 0;
        while (i < columnOrder.length) {
            if (this.getColumnVisibile(columnOrder[i])) {
                visibleSortedColumnList.add(columnOrder[i]);
            }
            ++i;
        }
        return visibleSortedColumnList;
    }

    public MATTableFilterWidget getFilterWidget() {
        return this.filterWidget;
    }

    public void setFilterWidget(MATTableFilterWidget filterWidget) {
        this.filterWidget = filterWidget;
    }

    public void setFocus() {
        this.getTable().setFocus();
    }

    protected class ColumnMetadata {
        boolean visible = true;
        boolean empty = false;
        boolean defaultVisibility = true;
        boolean customizable = true;
        String tooltip;
        String name;
        String text;
        Image icon;
        int type;
        int width;
        int defaultWidth;
        boolean sortable;
        TableViewerColumn tableViewerColumn;

        protected ColumnMetadata() {
        }
    }

    class MATColumnLabelProvider
    extends ColumnLabelProvider {
        MATTableViewer viewer;
        final int columnIndex;
        DateFormat dateFormat;
        DateFormat dateTimeFormat;
        DateFormat timeFormat;
        boolean textOnlyTables;

        public MATColumnLabelProvider(int columnIndex, MATTableViewer viewer) {
            this.viewer = viewer;
            this.columnIndex = columnIndex;
            this.dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            this.dateTimeFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            this.timeFormat = new SimpleDateFormat("HH:mm:ss");
            this.textOnlyTables = Singletons.getUserPreferenceManager().getStoreForUserId().getBoolean("textOnlyTables");
        }

        public String getToolTipText(Object object) {
            Table table = this.viewer.getTable();
            TableColumn[] columns = table.getColumns();
            int[] order = table.getColumnOrder();
            if (table.getColumnCount() > this.columnIndex) {
                int x = 0;
                while (x < order.length) {
                    if (columns[order[x]].getWidth() > 0) {
                        if (order[x] != this.columnIndex) break;
                        StringBuilder sb = new StringBuilder();
                        int maxLength = 3;
                        String[] stringArray = MATTableViewer.this.getColumnNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            if (name.length() > maxLength) {
                                maxLength = name.length();
                            }
                            ++n2;
                        }
                        int i = 0;
                        while (i < this.viewer.getColumnCount()) {
                            if (i != 0) {
                                sb.append("\n");
                            }
                            String name = this.viewer.getColumnNames()[i];
                            String value = this.getText(object, i);
                            sb.append(name);
                            int j = maxLength + 2;
                            while (j > name.length()) {
                                sb.append(" ");
                                --j;
                            }
                            sb.append(value);
                            ++i;
                        }
                        return sb.toString();
                    }
                    ++x;
                }
            }
            return null;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return -1;
        }

        public Font getToolTipFont(Object object) {
            return JFaceResources.getTextFont();
        }

        public void update(ViewerCell cell) {
            super.update(cell);
        }

        public String getText(Object object) {
            Table table = this.viewer.getTable();
            ColumnMetadata meta = this.viewer.columnMap.get(table.getColumn(this.columnIndex));
            if (meta.type == 9 && !this.textOnlyTables) {
                return null;
            }
            return this.getText(object, this.columnIndex);
        }

        public Color getBackground(Object element) {
            MATTableRow row = (MATTableRow)element;
            if (row != null && row.equals(this.viewer.getCATableModel().getTotal())) {
                return Display.getDefault().getSystemColor(26);
            }
            return null;
        }

        public String getText(Object object, int index) {
            Table table = this.viewer.getTable();
            MATTableRow row = (MATTableRow)object;
            if (table.getColumnCount() > index) {
                ColumnMetadata meta = this.viewer.columnMap.get(table.getColumn(index));
                if (meta.type == 7) {
                    return "";
                }
                Object obj = row.getObject(index);
                if (obj instanceof Date) {
                    if (meta.type == 4) {
                        return this.dateFormat.format((Date)obj);
                    }
                    if (meta.type == 5) {
                        return this.dateTimeFormat.format((Date)obj);
                    }
                    if (meta.type == 6) {
                        return this.timeFormat.format((Date)obj);
                    }
                } else {
                    if (meta.type == 3) {
                        if (obj == null) {
                            obj = 0.0;
                        }
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMinimumFractionDigits(2);
                        form.setMaximumFractionDigits(2);
                        try {
                            return form.format(obj);
                        }
                        catch (Exception exception) {
                            MATTableViewer.this.log.log(Level.FINER, "formatting error {0}", obj);
                            return String.valueOf(obj);
                        }
                    }
                    if (meta.type == 12) {
                        if (obj == null) {
                            obj = 0;
                        }
                        NumberFormat form = NumberFormat.getInstance();
                        form.setGroupingUsed(false);
                        try {
                            return form.format(obj);
                        }
                        catch (Exception exception) {
                            MATTableViewer.this.log.log(Level.FINER, "formatting error {0}", obj);
                            return String.valueOf(obj);
                        }
                    }
                    if (meta.type == 9) {
                        if (obj == null) {
                            obj = 0.0;
                        }
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMinimumFractionDigits(2);
                        form.setMaximumFractionDigits(2);
                        try {
                            return form.format(obj);
                        }
                        catch (Exception exception) {
                            MATTableViewer.this.log.log(Level.FINER, "formatting error {0}", obj);
                            return String.valueOf(obj);
                        }
                    }
                    if (meta.type == 8) {
                        if (obj == null) {
                            obj = 0.0;
                        }
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMinimumFractionDigits(6);
                        form.setMaximumFractionDigits(6);
                        try {
                            return form.format(obj);
                        }
                        catch (Exception exception) {
                            MATTableViewer.this.log.log(Level.FINER, "formatting error {0}", obj);
                            return String.valueOf(obj);
                        }
                    }
                    if (meta.type == 11) {
                        if (obj == null) {
                            obj = 0.0;
                        }
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMinimumFractionDigits(6);
                        form.setMaximumFractionDigits(6);
                        try {
                            return form.format(obj);
                        }
                        catch (Exception exception) {
                            MATTableViewer.this.log.log(Level.FINER, "formatting error {0}", obj);
                            return String.valueOf(obj);
                        }
                    }
                    if (obj instanceof Number) {
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMaximumFractionDigits(6);
                        try {
                            return form.format(obj);
                        }
                        catch (Exception exception) {
                            MATTableViewer.this.log.log(Level.FINER, "formatting error {0}", obj);
                            return String.valueOf(obj);
                        }
                    }
                    return row.getText(index);
                }
            }
            return "";
        }

        public Image getImage(Object object) {
            Table table = this.viewer.getTable();
            MATTableRow row = (MATTableRow)object;
            if (table.getColumnCount() > this.columnIndex) {
                Object obj;
                ColumnMetadata meta = this.viewer.columnMap.get(table.getColumn(this.columnIndex));
                if (meta.type == 7 && (obj = row.getObject(this.columnIndex)) instanceof Image) {
                    return (Image)obj;
                }
            }
            return null;
        }
    }

    class MATContentProvider
    implements IStructuredContentProvider {
        MATContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MATTableModel) {
                MATTableModel data = (MATTableModel)inputElement;
                return data.getRows(true);
            }
            return null;
        }
    }

    private class MATTableItemComparator
    extends ViewerComparator {
        int sortColumn = -1;
        int sortDirection = 0;
        Comparator primaryComparator;
        List<Comparator> secondaryComparators = new ArrayList<Comparator>();
        MATTableViewer caViewer;
        Table table;

        public MATTableItemComparator(MATTableViewer viewer) {
            this.caViewer = viewer;
            this.table = this.caViewer.getTable();
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.caViewer.getSortColumn() != this.sortColumn || this.caViewer.getSortDirection() != this.sortDirection) {
                this.updateState();
            }
            if (e1 instanceof MATTableRow && e2 instanceof MATTableRow && this.table.getSortColumn() != null) {
                MATTableRow row1 = (MATTableRow)e1;
                MATTableRow row2 = (MATTableRow)e2;
                return this.compareRows(this.caViewer, this.table, row1, row2);
            }
            return 0;
        }

        private void updateState() {
            this.sortColumn = this.caViewer.getSortColumn();
            this.sortDirection = this.caViewer.getSortDirection();
            int dataType = 0;
            ColumnMetadata meta = this.caViewer.columnMap.get(this.table.getColumn(this.sortColumn));
            dataType = meta.type;
            this.primaryComparator = this.getComparatorForType(dataType, this.sortDirection);
            this.secondaryComparators.clear();
            if (MATTableViewer.this.secondarySortColumns != null && MATTableViewer.this.secondarySortColumns.size() > 0) {
                int i = 0;
                if (MATTableViewer.this.secondarySortColumns.get(this.sortColumn) == null) {
                    MATTableViewer.this.secondarySortColumns.put(this.sortColumn, new ArrayList());
                }
                if (MATTableViewer.this.secondarySortDirections.get(this.sortColumn) == null) {
                    MATTableViewer.this.secondarySortDirections.put(this.sortColumn, new ArrayList());
                }
                for (TableColumn col : (List)MATTableViewer.this.secondarySortColumns.get(this.sortColumn)) {
                    dataType = this.caViewer.columnMap.get((Object)col).type;
                    int secondarySortDirection = 128;
                    if (MATTableViewer.this.secondarySortDirections.containsKey(this.sortColumn) && ((List)MATTableViewer.this.secondarySortDirections.get(this.sortColumn)).size() > i) {
                        secondarySortDirection = (Integer)((List)MATTableViewer.this.secondarySortDirections.get(this.sortColumn)).get(i);
                    }
                    this.secondaryComparators.add(this.getComparatorForType(dataType, secondarySortDirection));
                    ++i;
                }
            }
        }

        private Comparator getComparatorForType(int dataType, int direction) {
            int signum;
            int n = signum = direction == 128 ? 1 : -1;
            if (dataType == 2 || dataType == 12) {
                return new Comparator(){

                    public int compare(Object num1, Object num2) {
                        Double l2;
                        Double l1;
                        if (num1 instanceof Integer || num2 instanceof Integer) {
                            if (num1 == null) {
                                num1 = 0;
                            }
                            if (num2 == null) {
                                num2 = 0;
                            }
                            Integer i1 = (Integer)num1;
                            Integer i2 = (Integer)num2;
                            return i1.compareTo(i2) * signum;
                        }
                        if (num1 == null) {
                            num1 = 0L;
                        }
                        if (num2 == null) {
                            num2 = 0L;
                        }
                        try {
                            l1 = Double.valueOf(num1.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            l1 = 0.0;
                        }
                        try {
                            l2 = Double.valueOf(num2.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            l2 = 0.0;
                        }
                        return l1.compareTo(l2) * signum;
                    }
                };
            }
            if (dataType == 3 || dataType == 8 || dataType == 9 || dataType == 11) {
                return new Comparator(){

                    public int compare(Object num1, Object num2) {
                        Double d2;
                        Double d1;
                        if (num1 == null) {
                            num1 = 0.0;
                        }
                        if (num2 == null) {
                            num2 = 0.0;
                        }
                        if (num1 instanceof Double) {
                            d1 = (Double)num1;
                        } else {
                            try {
                                d1 = Double.valueOf((String)num1);
                            }
                            catch (NumberFormatException numberFormatException) {
                                d1 = null;
                            }
                        }
                        if (num2 instanceof Double) {
                            d2 = (Double)num2;
                        } else {
                            try {
                                d2 = Double.valueOf((String)num2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                d2 = null;
                            }
                        }
                        if (d1 != null && d2 != null) {
                            return d1.compareTo(d2) * signum;
                        }
                        return num1.toString().compareTo(num2.toString()) * signum;
                    }
                };
            }
            if (dataType == 1 || dataType == 0) {
                return new Comparator(){

                    public int compare(Object str1, Object str2) {
                        if (str1 == null) {
                            str1 = "";
                        }
                        if (str2 == null) {
                            str2 = "";
                        }
                        String s1 = str1.toString();
                        String s2 = str2.toString();
                        return s1.compareTo(s2) * signum;
                    }
                };
            }
            if (dataType == 4 || dataType == 5 || dataType == 6) {
                return new Comparator(){

                    public int compare(Object date1, Object date2) {
                        if (date1 instanceof Date || date2 instanceof Date) {
                            if (date1 == null) {
                                return date2 == null ? 0 : -1 * signum;
                            }
                            if (date2 == null) {
                                return 1 * signum;
                            }
                            return ((Date)date1).compareTo((Date)date2) * signum;
                        }
                        if (date1 == null) {
                            date1 = "";
                        }
                        if (date2 == null) {
                            date2 = "";
                        }
                        String s1 = date1.toString();
                        String s2 = date2.toString();
                        return s1.compareTo(s2) * signum;
                    }
                };
            }
            if (dataType == 10) {
                return new Comparator(){

                    public int compare(Object str1, Object str2) {
                        if (str1 == null) {
                            str1 = "";
                        }
                        if (str2 == null) {
                            str2 = "";
                        }
                        Long l1 = Long.valueOf((String)str1, 16);
                        Long l2 = Long.valueOf((String)str2, 16);
                        return l1.compareTo(l2) * signum;
                    }
                };
            }
            if (dataType == 7) {
                return new Comparator(){

                    public int compare(Object str1, Object str2) {
                        return 0;
                    }
                };
            }
            try {
                throw new MATException("Unknown column data type : " + dataType);
            }
            catch (MATException e) {
                MATTableViewer.this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                return new Comparator(){

                    public int compare(Object str1, Object str2) {
                        return 0;
                    }
                };
            }
        }

        private int compareRows(IMATTableViewer viewer, Table table, MATTableRow row1, MATTableRow row2) {
            int result = 0;
            if (viewer.getCATableModel().getTotal() != null) {
                MATTableRow total = viewer.getCATableModel().getTotal();
                if (total.equals(row1)) {
                    return 1;
                }
                if (total.equals(row2)) {
                    return -1;
                }
            }
            TableColumn sortColumn = table.getSortColumn();
            result = this.compareRows(row1, row2, this.primaryComparator);
            if (result == 0 && MATTableViewer.this.secondarySortColumns.get(sortColumn) != null) {
                int i = 0;
                while (i < ((List)MATTableViewer.this.secondarySortColumns.get(sortColumn)).size()) {
                    result = this.compareRows(row1, row2, this.secondaryComparators.get(i));
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                    ++i;
                }
            }
            return result;
        }

        private int compareRows(MATTableRow row1, MATTableRow row2, Comparator comparator) {
            Object compare1 = row1.getObject(this.sortColumn);
            Object compare2 = row2.getObject(this.sortColumn);
            try {
                return comparator.compare(compare1, compare2);
            }
            catch (Exception e) {
                MATTableViewer.this.log.log(Level.WARNING, "Exception in compare of rows " + row1.getClass().getName(), e);
                return 0;
            }
        }
    }
}

