/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.ITreeType;
import com.ca.testingtools.core.IWatchData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;

public class Data
implements IWatchData,
IAdaptable {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    private static final String sourceClass = Data.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    protected ByteBuffer data = ByteBuffer.allocate(0);
    protected MFAddress address;
    protected long offset = 0L;
    protected int owner;
    protected int stride = 0;
    protected DataType dataType = DataType.Unknown;
    protected String tooltipText = null;
    protected String title;
    protected ITreeType parent = null;
    protected boolean formatted = false;
    protected String property = null;
    protected HashMap<String, Object> objectMap = null;
    protected ArrayList<Data> children = new ArrayList();
    protected IMemoryManager manager;

    public Data(byte[] bytes, MFAddress address, String title) {
        this(bytes, address, title, null);
    }

    public Data(byte[] bytes, MFAddress address, String title, DataType dataType) {
        this(ByteBuffer.wrap(bytes), address, title, dataType);
    }

    public Data(String title) {
        this(new byte[0], MFAddress.ZERO_ADDR, title, null);
    }

    public Data(ByteBuffer data, MFAddress address, String title, DataType dataType) {
        this.data = data;
        this.address = address;
        this.title = title;
        this.dataType = dataType == null ? DataType.Memory : dataType;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public MFAddress getAddress() {
        return this.address;
    }

    public Data[] getChildren() {
        if (!this.formatted) {
            this.reformat();
        }
        return this.children.toArray(new Data[this.children.size()]);
    }

    public synchronized byte[] getData(int offset, int length) {
        int size = this.getLength();
        if (offset < size) {
            int len = Math.min(length, size - offset);
            int pos = this.data.position();
            byte[] bytes = new byte[len];
            this.data.position(pos + offset);
            this.data.get(bytes);
            this.data.position(pos);
            return bytes;
        }
        return new byte[0];
    }

    public byte[] getData() {
        return this.getData(0, this.getLength());
    }

    @Override
    public int getLength() {
        return this.data == null ? 0 : this.data.limit() - this.data.position();
    }

    @Override
    public String getHexText() {
        return HexUtil.toHex((byte[])this.getData());
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public String getProperties() {
        String value = this.property == null ? "" : this.property;
        int length = this.data.limit() - this.data.position();
        if (MFAddress.ZERO_ADDR.equals((Object)this.address) && length == 0) {
            return value;
        }
        if (length == 0) {
            return String.format("%s %s", value, this.address.getText(false));
        }
        return String.format("%s %s,%04X", value, this.address.getText(false), length).trim();
    }

    public int getStride() {
        return this.stride;
    }

    public String getText() {
        return HexUtil.toString((byte[])this.getData(), (boolean)true, (boolean)true);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean hasChildren() {
        if (!this.formatted) {
            this.reformat();
        }
        return this.children.size() > 0;
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }

    public void setData(byte[] data) {
        ByteBuffer newBuff = ByteBuffer.wrap(data);
        if (!newBuff.equals(this.data)) {
            this.data = newBuff;
            this.formatted = false;
            this.reformat();
        }
    }

    private void reformat() {
        this.formatted = true;
        Iterator<Data> it = this.children.iterator();
        while (it.hasNext()) {
            Data child = it.next();
            if (child.dataType != DataType.displayOnly) continue;
            child.removeChildren();
            it.remove();
        }
        int datawidth = this.data.limit() - this.data.position();
        if (this.stride > 0 && this.stride < datawidth) {
            byte[] buffer = this.data.array();
            MFAddress addr = this.address;
            int ix = this.data.position();
            while (ix < this.data.limit()) {
                int span = ix + this.stride;
                if (span > this.data.limit()) {
                    span = this.data.limit();
                }
                ByteBuffer childBuffer = null;
                try {
                    int size = Math.min(this.stride, this.data.limit() - ix);
                    childBuffer = ByteBuffer.wrap(buffer, ix, size);
                    String newTitle = String.format("+%04X", ix);
                    Data child = new Data(childBuffer, addr, newTitle, DataType.displayOnly);
                    this.addChild(child);
                    child.setStride(size);
                }
                catch (Exception e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
                catch (Error e) {
                    this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
                addr = addr.add((long)this.stride);
                ix += this.stride;
            }
        }
    }

    private void removeChildren() {
        Iterator<Data> it = this.children.iterator();
        while (it.hasNext()) {
            Data child = it.next();
            child.removeChildren();
            it.remove();
        }
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setParent(IWatchData parent) {
        this.parent = parent;
    }

    public void setStride(int stride) {
        if (this.stride != stride) {
            this.stride = stride;
            this.reformat();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addChild(Data child) {
        if (child != null) {
            child.setParent(this);
            this.children.add(child);
        }
    }

    public void addChildren(ArrayList<Data> children) {
        for (Data child : children) {
            this.addChild(child);
        }
    }

    public String toString() {
        int pos = this.data.position();
        byte[] bytes = new byte[Math.min(32, this.data.limit())];
        this.data.position(0);
        this.data.get(bytes);
        this.data.position(pos);
        String string = String.format("%s %s len=%d [%s...]", this.title, this.address.toString(), this.getLength(), HexUtil.toHex((byte[])bytes).substring(0, Math.min(10, this.getLength())));
        return string;
    }

    @Override
    public boolean isEmpty() {
        return this.getLength() == 0 && this.children.size() == 0;
    }

    public String getTooltipText() {
        return this.tooltipText == null ? this.getTitle() : this.tooltipText;
    }

    @Override
    public String getPropertiesTooltipText() {
        switch (this.dataType) {
            default: 
        }
        int length = this.data.limit() - this.data.position();
        if (MFAddress.ZERO_ADDR.equals((Object)this.address) && length == 0) {
            return "";
        }
        if (length == 0) {
            return String.format("Address=%s", this.address.getText(false));
        }
        return String.format("Address=%s Length=%04X", this.address.getText(false), length);
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    @Override
    public String getHexTextTooltipText() {
        return this.getHexText();
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public String getValueTooltipText() {
        return this.getText();
    }

    @Override
    public String getTitleTooltipText() {
        if (this.parent == null) {
            return this.getTooltipText();
        }
        return String.format("%s %s", ((Data)this.parent).getTitleTooltipText(), this.getTooltipText()).trim();
    }

    @Override
    public IMemoryManager getMemoryManager() {
        Data root = (Data)this.getRoot();
        return root.manager;
    }

    @Override
    public void setMemoryManager(IMemoryManager manager) {
        Data root = (Data)this.getRoot();
        root.manager = manager;
    }

    @Override
    public ITreeType getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Data)) {
            return false;
        }
        if (this.address == null) {
            return false;
        }
        Data other = (Data)obj;
        return this.address.equals((Object)other.address) && this.getLength() == other.getLength();
    }

    @Override
    public Object getObject(String key) {
        return this.objectMap == null ? null : this.objectMap.get(key);
    }

    @Override
    public void setObject(String key, Object value) {
        if (this.objectMap == null) {
            if (value == null) {
                return;
            }
            this.objectMap = new HashMap();
        }
        if (value == null) {
            this.objectMap.remove(key);
        } else {
            this.objectMap.put(key, value);
        }
    }

    @Override
    public <T> T getRoot(Class<T> classModel) {
        return null;
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(int owner) {
        this.owner = owner;
        for (Data child : this.children) {
            child.setOwner(owner);
        }
    }

    @Override
    public void setPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        if (this.dataType == DataType.displayOnly) {
            return;
        }
        if (this.title.startsWith(prefix)) {
            return;
        }
        this.title = String.format("%s %s", prefix, this.title);
        for (Data child : this.children) {
            if (child.dataType == DataType.displayOnly) {
                return;
            }
            child.setPrefix(prefix);
        }
    }

    public static enum DataType {
        Unknown,
        Structured,
        Memory,
        registerMemory,
        displayOnly;

    }
}

