/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.TreeBuild;
import com.ca.symdump.batch.SymBatDumpTreeNode;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.core.ValidateCredentials;
import com.ca.testingtools.protsym.ProtsymDataset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class SymBatTreeBuild
extends TreeBuild {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String FORMAT = "%s:%s %s %s";

    public DumpTreeNode buildTree(Abend abend) throws TTException {
        TTServer server = abend.getServer();
        ServerConnect connection = new ServerConnect(server, "symdump/server");
        SymBatDumpTreeNode treeNode = null;
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("indx", abend.getDsn());
        map.put("symd", abend.getSysd());
        XMLRequest xml = null;
        String ndvrsym = "N";
        String ndvrleasm = "N";
        String enqueue = null;
        try {
            xml = connection.connect("in1t", map, true);
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            throw e;
        }
        this.errorLevel = xml.getErrorLevel();
        if (this.errorLevel != 0) {
            this.errorMessage = String.format("ErrorLevel=%d Text=", this.errorLevel, xml.getErrorMessage());
            this.log.info(this.errorMessage);
            this.log.log(Level.FINE, "", xml);
            throw new TTException(this.errorMessage);
        }
        Element element = xml.getCommand();
        abend.setUuid(XMLFile.getSessionID((Element)element));
        map.clear();
        map.put("uuid", abend.getUuid());
        map.put("jobname", abend.getColumn("JobName"));
        map.put("stepname", abend.getColumn("Step/Tsk"));
        map.put("program", abend.getColumn("Program"));
        map.put("offset", abend.getColumn("Offset"));
        map.put("comp", abend.getColumn("Comp"));
        map.put("date", abend.getColumn("Date"));
        map.put("time", abend.getColumn("Time"));
        map.put("userid", abend.getColumn("UserId"));
        ArrayList protsyms = abend.getDataset().getParent().getParent(Profile.class).getAllChildren(ProtsymDataset.class);
        ArrayList<ProtsymDataset> datasets = new ArrayList<ProtsymDataset>();
        if (protsyms.size() != 0) {
            int ix = 0;
            while (ix < protsyms.size()) {
                ITreeWrappedItem obj = ((TT_TreeItem)protsyms.get(ix)).getValue();
                if (obj instanceof ProtsymDataset) {
                    if (((ProtsymDataset)obj).isNdvrsym()) {
                        ndvrsym = "Y";
                        enqueue = "ndvrenq";
                        datasets.add(0, (ProtsymDataset)obj);
                    } else {
                        datasets.add((ProtsymDataset)obj);
                    }
                }
                if (((ProtsymDataset)obj).isRefreshleasm()) {
                    ndvrleasm = "Y";
                }
                ++ix;
            }
            ValidateCredentials validate = new ValidateCredentials(server, datasets.toArray(new Dataset[datasets.size()]));
            validate.run(false);
            ArrayList<String> names = new ArrayList<String>(datasets.size());
            Iterator it = datasets.iterator();
            while (it.hasNext()) {
                Dataset dataset = (Dataset)it.next();
                if (dataset.isFileNotfound()) {
                    it.remove();
                    continue;
                }
                names.add(dataset.getName());
            }
            map.put("protsym", names);
            map.put("ndvrsym", ndvrsym);
            map.put("ndvrleasm", ndvrleasm);
            map.put("enqu", enqueue);
        }
        xml = connection.connect("open", map, false);
        this.errorLevel = xml.getErrorLevel();
        if (this.errorLevel != 0) {
            this.errorMessage = xml.getErrorMessage();
            String msg = String.format("ErrorLevel=%d Text=%s", this.errorLevel, this.errorMessage);
            this.log.info(msg);
            this.log.log(Level.FINE, msg, xml);
            throw new TTException(this.errorMessage);
        }
        treeNode = (SymBatDumpTreeNode)this.buildTree(xml);
        if (treeNode != null) {
            abend.setProtsyms(datasets);
            treeNode.setObject(Abend.class.getName(), abend);
            String system = abend.getColumn(8);
            String abendcode = abend.getColumn(3);
            String date = abend.getColumn(4);
            String time = abend.getColumn(5);
            String format = FORMAT;
            treeNode.setMiscData(String.format(format, system, abendcode, date, time));
            SymBatDumpTreeNode lastnode = treeNode;
            for (SymBatDumpTreeNode node : this.getChain(treeNode)) {
                int endline = Integer.decode(node.getObjectAddr());
                node.setStartLine(endline);
                lastnode.setEndLine(endline);
                lastnode = node;
            }
            treeNode.getRoot().setStartLine(0);
        }
        return treeNode;
    }

    private ArrayList<SymBatDumpTreeNode> getChain(SymBatDumpTreeNode treeNode) {
        DumpTreeNode[] children = treeNode.getChildren();
        ArrayList<SymBatDumpTreeNode> list = new ArrayList<SymBatDumpTreeNode>(children.length + 1);
        list.add(treeNode);
        DumpTreeNode[] dumpTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            DumpTreeNode child = dumpTreeNodeArray[n2];
            list.addAll(this.getChain((SymBatDumpTreeNode)child));
            ++n2;
        }
        return list;
    }

    protected DumpTreeNode buildNode(String objectAddr, String string, String miscdata) {
        return new SymBatDumpTreeNode(objectAddr, string, miscdata);
    }
}

