/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.dialogs.JclEditDialog;
import com.ca.intertest.server.CICSServer;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.views.server.ServerView;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ServerWizardPage
extends WizardPage
implements ModifyListener {
    static String cacopyright = "Copyright (c) 2016 CA";
    private Text name;
    private Text host;
    private Text port;
    private Button savepswd;
    private Button defaultServerCheckbox;
    private Button blank;
    private Button CICSserver;
    private Button CICSsecurity;
    private Text UserID;
    private Button ResetJCL;
    private Button EditJCL;
    private String JCL;
    private ServerElement server = null;
    private ServerList serverlist;
    private Label useridlabel;
    private boolean newserver = true;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.intertest.serverWizardPageNew";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.intertest.serverWizardPageOld";
    private static final boolean admin;

    static {
        IntertestPlugin plugin = IntertestPlugin.getDefault();
        admin = plugin.isAdmin() && plugin.isOldAdmin();
    }

    public ServerWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages.ServerWizardPage_description);
    }

    public void SetServer(ServerElement server) {
        this.server = server;
        this.newserver = server == null;
    }

    public void createControl(Composite parent) {
        this.serverlist = ServerList.getInstance();
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.intertest");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(two_col, 0);
        label.setText(Messages.ServerWizardPage_name);
        label.setAlignment(131072);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        label.setLayoutData((Object)data);
        this.name = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.name.setLayoutData((Object)data);
        label = new Label(two_col, 0);
        label.setText(Messages.ServerWizardPage_host);
        label.setAlignment(131072);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        label.setLayoutData((Object)data);
        this.host = new Text(two_col, 2048);
        data = new GridData(768);
        GC gc = new GC((Drawable)this.host);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.host.setLayoutData((Object)data);
        label = new Label(two_col, 0);
        label.setText(Messages.ServerWizardPage_port);
        label.setAlignment(131072);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        label.setLayoutData((Object)data);
        this.port = new Text(two_col, 2048);
        this.port.setTextLimit(5);
        this.port.setToolTipText(String.format(Messages.ServerWizardPage_4, 65535));
        data = new GridData(768);
        gc = new GC((Drawable)this.port);
        try {
            Point extent = gc.textExtent("0");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.port.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.port.setLayoutData((Object)data);
        this.port.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ServerWizardPage.this.port.setSelection(0, ServerWizardPage.this.port.getText().length());
            }

            public void focusLost(FocusEvent e) {
            }
        });
        if (this.newserver) {
            new Label(two_col, 0);
            Composite CICSStuff = new Composite(two_col, 0);
            GridLayout cicsStuffLayout = new GridLayout(2, false);
            cicsStuffLayout.marginWidth = 0;
            CICSStuff.setLayout((Layout)cicsStuffLayout);
            this.CICSserver = new Button(CICSStuff, 32);
            this.CICSserver.setText(Messages.ServerWizardPage_CICS_Server);
            this.CICSserver.setSelection(false);
            this.CICSsecurity = new Button(CICSStuff, 32);
            this.CICSsecurity.setSelection(false);
            this.CICSsecurity.setVisible(false);
            this.CICSserver.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ServerWizardPage.this.setSecurity();
                }
            });
        } else if (this.server.isCICS_server()) {
            new Label(two_col, 0);
            this.CICSsecurity = new Button(two_col, 32);
            this.CICSsecurity.setSelection(((CICSServer)this.server).isSecurityEnabled());
            this.CICSsecurity.setVisible(true);
        }
        if (this.CICSsecurity != null) {
            this.CICSsecurity.setText(Messages.ServerWizardPage_3);
            this.CICSsecurity.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ServerWizardPage.this.setUserID();
                }
            });
        }
        new Label(two_col, 0);
        this.defaultServerCheckbox = new Button(two_col, 32);
        this.defaultServerCheckbox.setText(Messages.ServerWizardPage_defaultServer);
        new Label(two_col, 0);
        this.blank = new Button(two_col, 32);
        this.blank.setVisible(false);
        this.useridlabel = new Label(two_col, 0);
        this.useridlabel.setText(Messages.ServerWizardPage_UserID);
        this.useridlabel.setAlignment(131072);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        this.useridlabel.setLayoutData((Object)data);
        this.UserID = new Text(two_col, 2048);
        this.UserID.addVerifyListener((VerifyListener)new verifytoUpperCase());
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.UserID.setLayoutData((Object)data);
        new Label(two_col, 0);
        this.savepswd = new Button(two_col, 32);
        this.savepswd.setText(Messages.ServerWizardPage_Save_Password);
        if (!this.newserver) {
            Button clearpassword = new Button(top, 8);
            clearpassword.setText(Messages.ServerWizardPage_2);
            clearpassword.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ServerWizardPage.this.server.resetUserDialog();
                }
            });
        }
        Group JCL_Group = new Group(top, 0);
        data = new GridData();
        data.exclude = false;
        JCL_Group.setLayoutData((Object)data);
        JCL_Group.setLayout((Layout)new GridLayout(2, false));
        JCL_Group.setText(Messages.ServerWizardPage_JCL_Settings);
        this.ResetJCL = new Button((Composite)JCL_Group, 8);
        this.ResetJCL.setText(Messages.ServerWizardPage_Default_JCL);
        this.ResetJCL.setToolTipText(Messages.ServerWizardPage_JCL_tooltip);
        this.ResetJCL.setAlignment(131072);
        this.ResetJCL.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ScopedPreferenceStore store = (ScopedPreferenceStore)IntertestPlugin.getConfigurationPreferences();
                ServerWizardPage.this.JCL = store.getString("JCL_stream");
            }
        });
        this.EditJCL = new Button((Composite)JCL_Group, 8);
        this.EditJCL.setText(Messages.ServerWizardPage_Edit_JCL);
        this.EditJCL.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JclEditDialog dialog = new JclEditDialog(ServerWizardPage.this.getShell(), ServerWizardPage.this.JCL);
                int ok = dialog.open();
                if (ok == 0) {
                    ServerWizardPage.this.JCL = dialog.getJclStream();
                }
            }
        });
        if (this.newserver || this.server.isCICS_server() || !admin) {
            JCL_Group.setVisible(false);
        }
        if (this.newserver) {
            this.name.setText(Messages.ServerWizardPage_8);
            this.host.setText(Messages.ServerWizardPage_9);
            this.port.setText(store.getString("DEFAULT_SERVER_PORT"));
            this.defaultServerCheckbox.setSelection(false);
            this.savepswd.setSelection(store.getBoolean("DEFAULT_SERVER_SAVE_PASSWD"));
            String userid = System.getenv("USERNAME");
            this.UserID.setText(userid == null ? "" : userid.toUpperCase());
            this.JCL = store.getString("JCL_stream");
        } else {
            this.name.setText(this.server.getName());
            this.host.setText(this.server.getHostname());
            this.port.setText(Integer.toString(this.server.getPort()));
            this.defaultServerCheckbox.setSelection(this.server.isDefaultserver());
            this.savepswd.setSelection(this.server.isSavepassword());
            this.UserID.setText(this.server.getUser());
            if (!this.server.isCICS_server()) {
                FileServer fileserver = (FileServer)this.server;
                this.JCL = fileserver.getJCL_stream();
            } else {
                this.defaultServerCheckbox.setVisible(false);
                this.defaultServerCheckbox.setSelection(false);
            }
        }
        if (this.CICSserver != null) {
            this.setSecurity();
        } else if (this.CICSsecurity != null) {
            this.setUserID();
        }
        this.name.addModifyListener((ModifyListener)this);
        this.port.addModifyListener((ModifyListener)this);
        this.host.addModifyListener((ModifyListener)this);
        this.UserID.addModifyListener((ModifyListener)this);
        TextUtil.setWidth(this.name, 30);
        TextUtil.setWidth(this.host, 20);
        TextUtil.setWidth(this.UserID, 8);
        if (this.newserver) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.serverWizardPageNew");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.serverWizardPageOld");
        }
        this.setControl((Control)top);
    }

    public void modifyText(ModifyEvent event) {
        this.getWizard().getContainer().updateButtons();
    }

    public boolean performUpdate() {
        if (this.newserver) {
            if (this.CICSserver.getSelection()) {
                this.server = new CICSServer(this.name.getText(), this.host.getText(), Integer.parseInt(this.port.getText()));
                ((CICSServer)this.server).setSecurityEnabled(this.CICSsecurity.getSelection());
            } else {
                this.server = new FileServer(this.name.getText(), this.host.getText(), Integer.parseInt(this.port.getText()));
                ((FileServer)this.server).setJCL_stream(this.JCL);
            }
            try {
                this.serverlist.addServerElement(this.server);
            }
            catch (ITException e) {
                this.server = null;
                Logger.loggit(e);
            }
        } else {
            this.server.setName(this.name.getText());
            this.server.setPort(Integer.parseInt(this.port.getText()));
            this.server.setHostname(this.host.getText());
            if (this.server.isCICS_server()) {
                ((CICSServer)this.server).setSecurityEnabled(this.CICSsecurity.getSelection());
            } else {
                ((FileServer)this.server).setJCL_stream(this.JCL);
            }
        }
        if (this.server == null) {
            return false;
        }
        this.setDefaultServer(this.defaultServerCheckbox.getSelection(), this.server.isCICS_server());
        this.server.setSavepassword(this.savepswd.getSelection());
        this.server.setUser(this.UserID.getText());
        this.server.checkStatus(0L);
        ServerList.save();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        try {
            TableViewer viewer;
            IWorkbenchPage page = window.getActivePage();
            IViewPart view = page.showView("com.ca.intertest.ui.views.serverview");
            if (view instanceof ServerView && (viewer = ((ServerView)view).getViewer()) != null) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)this.server), true);
            }
        }
        catch (PartInitException partInitException) {}
        return true;
    }

    public boolean isNewserver() {
        return this.newserver;
    }

    public void setNewserver(boolean newserver) {
        this.newserver = newserver;
    }

    private void setDefaultServer(boolean isDefault, boolean isCICS) {
        this.server.setDefaultserver(isDefault);
        if (!isDefault) {
            return;
        }
        for (ServerElement item : this.serverlist.getServerElements()) {
            if (this.server.getName().equalsIgnoreCase(item.getName()) || item.isCICS_server() != isCICS) continue;
            item.setDefaultserver(false);
        }
    }

    private void setUserID() {
        if (this.CICSsecurity.getSelection()) {
            this.savepswd.setEnabled(true);
            this.UserID.setEnabled(true);
            this.useridlabel.setEnabled(true);
        } else {
            this.savepswd.setEnabled(false);
            this.UserID.setEnabled(false);
            this.useridlabel.setEnabled(false);
        }
    }

    private void setSecurity() {
        if (this.CICSserver.getSelection()) {
            this.CICSsecurity.setVisible(true);
            this.defaultServerCheckbox.setVisible(false);
            this.defaultServerCheckbox.setSelection(false);
            this.setUserID();
        } else {
            this.CICSsecurity.setVisible(false);
            this.savepswd.setEnabled(true);
            this.UserID.setEnabled(true);
            this.useridlabel.setEnabled(true);
            this.defaultServerCheckbox.setVisible(true);
        }
    }

    public boolean isPageComplete() {
        String connection = this.name.getText().trim();
        if (connection.length() == 0) {
            this.setErrorMessage(Messages.ServerWizardPage_1);
            return false;
        }
        if (this.host.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.ServerWizardPage_0);
            return false;
        }
        String portStr = this.port.getText().trim();
        if (portStr.length() == 0) {
            this.setErrorMessage(Messages.ServerWizardPage_10);
            return false;
        }
        try {
            int port = Integer.parseInt(portStr);
            if (port < 0 || port > 65535) {
                this.setErrorMessage(String.format(Messages.ServerWizardPage_11, 65535));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(Messages.ServerWizard_porterror);
            return false;
        }
        if (this.isNewserver() && ServerList.getInstance().getServer(connection) != null) {
            this.setErrorMessage(Messages.ServerWizardPage_12);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

